<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/host_project_registration_service.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Host project registration refers to the registration of a Google cloud
 * project with Api Hub as a host project. This is the project where Api Hub is
 * provisioned. It acts as the consumer project for the Api Hub instance
 * provisioned. Multiple runtime projects can be attached to the host project
 * and these attachments define the scope of Api Hub.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.HostProjectRegistration</code>
 */
class HostProjectRegistration extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the host project registration.
     * Format:
     * "projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Immutable. Google cloud project name in the format:
     * "projects/abc" or "projects/123". As input, project name with either
     * project id or number are accepted. As output, this field will contain
     * project number.
     *
     * Generated from protobuf field <code>string gcp_project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $gcp_project = '';
    /**
     * Output only. The time at which the host project registration was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the host project registration.
     *           Format:
     *           "projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}".
     *     @type string $gcp_project
     *           Required. Immutable. Google cloud project name in the format:
     *           "projects/abc" or "projects/123". As input, project name with either
     *           project id or number are accepted. As output, this field will contain
     *           project number.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time at which the host project registration was created.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\HostProjectRegistrationService::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the host project registration.
     * Format:
     * "projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the host project registration.
     * Format:
     * "projects/{project}/locations/{location}/hostProjectRegistrations/{host_project_registration}".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Immutable. Google cloud project name in the format:
     * "projects/abc" or "projects/123". As input, project name with either
     * project id or number are accepted. As output, this field will contain
     * project number.
     *
     * Generated from protobuf field <code>string gcp_project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getGcpProject()
    {
        return $this->gcp_project;
    }

    /**
     * Required. Immutable. Google cloud project name in the format:
     * "projects/abc" or "projects/123". As input, project name with either
     * project id or number are accepted. As output, this field will contain
     * project number.
     *
     * Generated from protobuf field <code>string gcp_project = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setGcpProject($var)
    {
        GPBUtil::checkString($var, True);
        $this->gcp_project = $var;

        return $this;
    }

    /**
     * Output only. The time at which the host project registration was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time at which the host project registration was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

}

