<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1/service.proto

namespace Google\Cloud\AlloyDb\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Import cluster request.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1.ImportClusterRequest</code>
 */
class ImportClusterRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the cluster.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $name = '';
    /**
     * Required. The path to the file in Google Cloud Storage where the source
     * file for import will be stored. The URI is in the form
     * `gs://bucketName/fileName`.
     *
     * Generated from protobuf field <code>string gcs_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $gcs_uri = '';
    /**
     * Optional. Name of the database to which the import will be done.
     * For import from SQL file, this is required only if the file does not
     * specify a database.
     * Note - Value provided should be the same as expected from `SELECT
     * current_database();` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string database = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $database = '';
    /**
     * Optional. Database user to be used for importing the data.
     * Note - Value provided should be the same as expected from
     * `SELECT current_user;` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string user = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $user = '';
    protected $import_options;

    /**
     * @param string $name     Required. The resource name of the cluster. Please see
     *                         {@see AlloyDBAdminClient::clusterName()} for help formatting this field.
     * @param string $gcsUri   Required. The path to the file in Google Cloud Storage where the source
     *                         file for import will be stored. The URI is in the form
     *                         `gs://bucketName/fileName`.
     * @param string $database Optional. Name of the database to which the import will be done.
     *                         For import from SQL file, this is required only if the file does not
     *                         specify a database.
     *                         Note - Value provided should be the same as expected from `SELECT
     *                         current_database();` and NOT as a resource reference.
     * @param string $user     Optional. Database user to be used for importing the data.
     *                         Note - Value provided should be the same as expected from
     *                         `SELECT current_user;` and NOT as a resource reference.
     *
     * @return \Google\Cloud\AlloyDb\V1\ImportClusterRequest
     *
     * @experimental
     */
    public static function build(string $name, string $gcsUri, string $database, string $user): self
    {
        return (new self())
            ->setName($name)
            ->setGcsUri($gcsUri)
            ->setDatabase($database)
            ->setUser($user);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AlloyDb\V1\ImportClusterRequest\SqlImportOptions $sql_import_options
     *           Options for importing data in SQL format.
     *     @type \Google\Cloud\AlloyDb\V1\ImportClusterRequest\CsvImportOptions $csv_import_options
     *           Options for importing data in CSV format.
     *     @type string $name
     *           Required. The resource name of the cluster.
     *     @type string $gcs_uri
     *           Required. The path to the file in Google Cloud Storage where the source
     *           file for import will be stored. The URI is in the form
     *           `gs://bucketName/fileName`.
     *     @type string $database
     *           Optional. Name of the database to which the import will be done.
     *           For import from SQL file, this is required only if the file does not
     *           specify a database.
     *           Note - Value provided should be the same as expected from `SELECT
     *           current_database();` and NOT as a resource reference.
     *     @type string $user
     *           Optional. Database user to be used for importing the data.
     *           Note - Value provided should be the same as expected from
     *           `SELECT current_user;` and NOT as a resource reference.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Options for importing data in SQL format.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ImportClusterRequest.SqlImportOptions sql_import_options = 4;</code>
     * @return \Google\Cloud\AlloyDb\V1\ImportClusterRequest\SqlImportOptions|null
     */
    public function getSqlImportOptions()
    {
        return $this->readOneof(4);
    }

    public function hasSqlImportOptions()
    {
        return $this->hasOneof(4);
    }

    /**
     * Options for importing data in SQL format.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ImportClusterRequest.SqlImportOptions sql_import_options = 4;</code>
     * @param \Google\Cloud\AlloyDb\V1\ImportClusterRequest\SqlImportOptions $var
     * @return $this
     */
    public function setSqlImportOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\ImportClusterRequest\SqlImportOptions::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Options for importing data in CSV format.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ImportClusterRequest.CsvImportOptions csv_import_options = 7;</code>
     * @return \Google\Cloud\AlloyDb\V1\ImportClusterRequest\CsvImportOptions|null
     */
    public function getCsvImportOptions()
    {
        return $this->readOneof(7);
    }

    public function hasCsvImportOptions()
    {
        return $this->hasOneof(7);
    }

    /**
     * Options for importing data in CSV format.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.ImportClusterRequest.CsvImportOptions csv_import_options = 7;</code>
     * @param \Google\Cloud\AlloyDb\V1\ImportClusterRequest\CsvImportOptions $var
     * @return $this
     */
    public function setCsvImportOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\ImportClusterRequest\CsvImportOptions::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Required. The resource name of the cluster.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. The resource name of the cluster.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The path to the file in Google Cloud Storage where the source
     * file for import will be stored. The URI is in the form
     * `gs://bucketName/fileName`.
     *
     * Generated from protobuf field <code>string gcs_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getGcsUri()
    {
        return $this->gcs_uri;
    }

    /**
     * Required. The path to the file in Google Cloud Storage where the source
     * file for import will be stored. The URI is in the form
     * `gs://bucketName/fileName`.
     *
     * Generated from protobuf field <code>string gcs_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setGcsUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->gcs_uri = $var;

        return $this;
    }

    /**
     * Optional. Name of the database to which the import will be done.
     * For import from SQL file, this is required only if the file does not
     * specify a database.
     * Note - Value provided should be the same as expected from `SELECT
     * current_database();` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string database = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Optional. Name of the database to which the import will be done.
     * For import from SQL file, this is required only if the file does not
     * specify a database.
     * Note - Value provided should be the same as expected from `SELECT
     * current_database();` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string database = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * Optional. Database user to be used for importing the data.
     * Note - Value provided should be the same as expected from
     * `SELECT current_user;` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string user = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Optional. Database user to be used for importing the data.
     * Note - Value provided should be the same as expected from
     * `SELECT current_user;` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string user = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setUser($var)
    {
        GPBUtil::checkString($var, True);
        $this->user = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getImportOptions()
    {
        return $this->whichOneof("import_options");
    }

}

