<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1/service.proto

namespace Google\Cloud\AlloyDb\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request for ExecuteSql rpc.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1.ExecuteSqlRequest</code>
 */
class ExecuteSqlRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The instance where the SQL will be executed. For the required
     * format, see the comment on the Instance.name field.
     *
     * Generated from protobuf field <code>string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $instance = '';
    /**
     * Required. Name of the database where the query will be executed.
     * Note - Value provided should be the same as expected from `SELECT
     * current_database();` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $database = '';
    /**
     * Required. Database user to be used for executing the SQL.
     * Note - Value provided should be the same as expected from
     * `SELECT current_user;` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string user = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $user = '';
    /**
     * Required. SQL statement to execute on database. Any valid statement is
     * permitted, including DDL, DML, DQL statements.
     *
     * Generated from protobuf field <code>string sql_statement = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $sql_statement = '';
    /**
     * Optional. If set, validates the sql statement by performing
     * syntax and semantic validation and doesn't execute the query.
     *
     * Generated from protobuf field <code>bool validate_only = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $validate_only = false;
    protected $user_credential;

    /**
     * @param string $instance     Required. The instance where the SQL will be executed. For the required
     *                             format, see the comment on the Instance.name field. Please see
     *                             {@see AlloyDBAdminClient::instanceName()} for help formatting this field.
     * @param string $database     Required. Name of the database where the query will be executed.
     *                             Note - Value provided should be the same as expected from `SELECT
     *                             current_database();` and NOT as a resource reference.
     * @param string $user         Required. Database user to be used for executing the SQL.
     *                             Note - Value provided should be the same as expected from
     *                             `SELECT current_user;` and NOT as a resource reference.
     * @param string $sqlStatement Required. SQL statement to execute on database. Any valid statement is
     *                             permitted, including DDL, DML, DQL statements.
     * @param string $password     Optional. The database native user’s password.
     *
     * @return \Google\Cloud\AlloyDb\V1\ExecuteSqlRequest
     *
     * @experimental
     */
    public static function build(string $instance, string $database, string $user, string $sqlStatement, string $password): self
    {
        return (new self())
            ->setInstance($instance)
            ->setDatabase($database)
            ->setUser($user)
            ->setSqlStatement($sqlStatement)
            ->setPassword($password);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $password
     *           Optional. The database native user’s password.
     *     @type string $instance
     *           Required. The instance where the SQL will be executed. For the required
     *           format, see the comment on the Instance.name field.
     *     @type string $database
     *           Required. Name of the database where the query will be executed.
     *           Note - Value provided should be the same as expected from `SELECT
     *           current_database();` and NOT as a resource reference.
     *     @type string $user
     *           Required. Database user to be used for executing the SQL.
     *           Note - Value provided should be the same as expected from
     *           `SELECT current_user;` and NOT as a resource reference.
     *     @type string $sql_statement
     *           Required. SQL statement to execute on database. Any valid statement is
     *           permitted, including DDL, DML, DQL statements.
     *     @type bool $validate_only
     *           Optional. If set, validates the sql statement by performing
     *           syntax and semantic validation and doesn't execute the query.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. The database native user’s password.
     *
     * Generated from protobuf field <code>string password = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPassword()
    {
        return $this->readOneof(5);
    }

    public function hasPassword()
    {
        return $this->hasOneof(5);
    }

    /**
     * Optional. The database native user’s password.
     *
     * Generated from protobuf field <code>string password = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPassword($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Required. The instance where the SQL will be executed. For the required
     * format, see the comment on the Instance.name field.
     *
     * Generated from protobuf field <code>string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getInstance()
    {
        return $this->instance;
    }

    /**
     * Required. The instance where the SQL will be executed. For the required
     * format, see the comment on the Instance.name field.
     *
     * Generated from protobuf field <code>string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setInstance($var)
    {
        GPBUtil::checkString($var, True);
        $this->instance = $var;

        return $this;
    }

    /**
     * Required. Name of the database where the query will be executed.
     * Note - Value provided should be the same as expected from `SELECT
     * current_database();` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDatabase()
    {
        return $this->database;
    }

    /**
     * Required. Name of the database where the query will be executed.
     * Note - Value provided should be the same as expected from `SELECT
     * current_database();` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string database = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDatabase($var)
    {
        GPBUtil::checkString($var, True);
        $this->database = $var;

        return $this;
    }

    /**
     * Required. Database user to be used for executing the SQL.
     * Note - Value provided should be the same as expected from
     * `SELECT current_user;` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string user = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Required. Database user to be used for executing the SQL.
     * Note - Value provided should be the same as expected from
     * `SELECT current_user;` and NOT as a resource reference.
     *
     * Generated from protobuf field <code>string user = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setUser($var)
    {
        GPBUtil::checkString($var, True);
        $this->user = $var;

        return $this;
    }

    /**
     * Required. SQL statement to execute on database. Any valid statement is
     * permitted, including DDL, DML, DQL statements.
     *
     * Generated from protobuf field <code>string sql_statement = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getSqlStatement()
    {
        return $this->sql_statement;
    }

    /**
     * Required. SQL statement to execute on database. Any valid statement is
     * permitted, including DDL, DML, DQL statements.
     *
     * Generated from protobuf field <code>string sql_statement = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setSqlStatement($var)
    {
        GPBUtil::checkString($var, True);
        $this->sql_statement = $var;

        return $this;
    }

    /**
     * Optional. If set, validates the sql statement by performing
     * syntax and semantic validation and doesn't execute the query.
     *
     * Generated from protobuf field <code>bool validate_only = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getValidateOnly()
    {
        return $this->validate_only;
    }

    /**
     * Optional. If set, validates the sql statement by performing
     * syntax and semantic validation and doesn't execute the query.
     *
     * Generated from protobuf field <code>bool validate_only = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setValidateOnly($var)
    {
        GPBUtil::checkBool($var);
        $this->validate_only = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserCredential()
    {
        return $this->whichOneof("user_credential");
    }

}

