<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/reports/v1beta/reports.proto

namespace Google\Shopping\Merchant\Reports\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Fields available for query in `product_view` table.
 * Products in the current inventory. Products in this table are the same as in
 * Products sub-API but not all product attributes from Products sub-API are
 * available for query in this table. In contrast to Products sub-API, this
 * table allows to filter the returned list of products by product attributes.
 * To retrieve a single product by `id` or list all products, Products sub-API
 * should be used.
 * Values are only set for fields requested explicitly in the request's search
 * query.
 *
 * Generated from protobuf message <code>google.shopping.merchant.reports.v1beta.ProductView</code>
 */
class ProductView extends \Google\Protobuf\Internal\Message
{
    /**
     * REST ID of the product, in the form of
     * `channel~languageCode~feedLabel~offerId`. Merchant API methods that operate
     * on products take this as their `name` parameter.
     * Required in the `SELECT` clause.
     *
     * Generated from protobuf field <code>optional string id = 1;</code>
     */
    protected $id = null;
    /**
     * Channel of the product. Can be `ONLINE` or `LOCAL`.
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Channel.ChannelEnum channel = 28;</code>
     */
    protected $channel = null;
    /**
     * Language code of the product in BCP 47 format.
     *
     * Generated from protobuf field <code>optional string language_code = 2;</code>
     */
    protected $language_code = null;
    /**
     * Feed label of the product.
     *
     * Generated from protobuf field <code>optional string feed_label = 3;</code>
     */
    protected $feed_label = null;
    /**
     * Merchant-provided id of the product.
     *
     * Generated from protobuf field <code>optional string offer_id = 4;</code>
     */
    protected $offer_id = null;
    /**
     * Title of the product.
     *
     * Generated from protobuf field <code>optional string title = 5;</code>
     */
    protected $title = null;
    /**
     * Brand of the product.
     *
     * Generated from protobuf field <code>optional string brand = 6;</code>
     */
    protected $brand = null;
    /**
     * Product category (1st level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l1 = 7;</code>
     */
    protected $category_l1 = null;
    /**
     * Product category (2nd level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l2 = 8;</code>
     */
    protected $category_l2 = null;
    /**
     * Product category (3rd level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l3 = 9;</code>
     */
    protected $category_l3 = null;
    /**
     * Product category (4th level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l4 = 10;</code>
     */
    protected $category_l4 = null;
    /**
     * Product category (5th level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l5 = 11;</code>
     */
    protected $category_l5 = null;
    /**
     * Product type (1st level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l1 = 12;</code>
     */
    protected $product_type_l1 = null;
    /**
     * Product type (2nd level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l2 = 13;</code>
     */
    protected $product_type_l2 = null;
    /**
     * Product type (3rd level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l3 = 14;</code>
     */
    protected $product_type_l3 = null;
    /**
     * Product type (4th level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l4 = 15;</code>
     */
    protected $product_type_l4 = null;
    /**
     * Product type (5th level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l5 = 16;</code>
     */
    protected $product_type_l5 = null;
    /**
     * Product price. Absent if the information about the price of the product is
     * not available.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 17;</code>
     */
    protected $price = null;
    /**
     * [Condition](https://support.google.com/merchants/answer/6324469) of the
     * product.
     *
     * Generated from protobuf field <code>optional string condition = 18;</code>
     */
    protected $condition = null;
    /**
     * [Availability](https://support.google.com/merchants/answer/6324448) of the
     * product.
     *
     * Generated from protobuf field <code>optional string availability = 19;</code>
     */
    protected $availability = null;
    /**
     * Normalized [shipping
     * label](https://support.google.com/merchants/answer/6324504) specified in
     * the feed.
     *
     * Generated from protobuf field <code>optional string shipping_label = 20;</code>
     */
    protected $shipping_label = null;
    /**
     * List of Global Trade Item Numbers (GTINs) of the product.
     *
     * Generated from protobuf field <code>repeated string gtin = 21;</code>
     */
    private $gtin;
    /**
     * Item group id provided by the merchant for grouping variants together.
     *
     * Generated from protobuf field <code>optional string item_group_id = 22;</code>
     */
    protected $item_group_id = null;
    /**
     * Link to the processed image of the product, hosted on the Google
     * infrastructure.
     *
     * Generated from protobuf field <code>optional string thumbnail_link = 23;</code>
     */
    protected $thumbnail_link = null;
    /**
     * The time the merchant created the product in timestamp seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 24;</code>
     */
    protected $creation_time = null;
    /**
     * Expiration date for the product, specified on insertion.
     *
     * Generated from protobuf field <code>.google.type.Date expiration_date = 25;</code>
     */
    protected $expiration_date = null;
    /**
     * Aggregated status.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.ProductView.AggregatedReportingContextStatus aggregated_reporting_context_status = 26;</code>
     */
    protected $aggregated_reporting_context_status = null;
    /**
     * List of item issues for the product.
     * **This field cannot be used for sorting the results.**
     * **Only selected attributes of this field (for example,
     * `item_issues.severity.aggregated_severity`) can be used for filtering the
     * results.**
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.reports.v1beta.ProductView.ItemIssue item_issues = 27;</code>
     */
    private $item_issues;
    /**
     * Estimated performance potential compared to highest performing products of
     * the merchant.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reports.v1beta.ProductView.ClickPotential click_potential = 29;</code>
     */
    protected $click_potential = 0;
    /**
     * Rank of the product based on its click potential. A product with
     * `click_potential_rank` 1 has the highest click potential among the
     * merchant's products that fulfill the search query conditions.
     *
     * Generated from protobuf field <code>optional int64 click_potential_rank = 30;</code>
     */
    protected $click_potential_rank = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           REST ID of the product, in the form of
     *           `channel~languageCode~feedLabel~offerId`. Merchant API methods that operate
     *           on products take this as their `name` parameter.
     *           Required in the `SELECT` clause.
     *     @type int $channel
     *           Channel of the product. Can be `ONLINE` or `LOCAL`.
     *     @type string $language_code
     *           Language code of the product in BCP 47 format.
     *     @type string $feed_label
     *           Feed label of the product.
     *     @type string $offer_id
     *           Merchant-provided id of the product.
     *     @type string $title
     *           Title of the product.
     *     @type string $brand
     *           Brand of the product.
     *     @type string $category_l1
     *           Product category (1st level) in [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $category_l2
     *           Product category (2nd level) in [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $category_l3
     *           Product category (3rd level) in [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $category_l4
     *           Product category (4th level) in [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $category_l5
     *           Product category (5th level) in [Google's product
     *           taxonomy](https://support.google.com/merchants/answer/6324436).
     *     @type string $product_type_l1
     *           Product type (1st level) in merchant's own [product
     *           taxonomy](https://support.google.com/merchants/answer/6324406).
     *     @type string $product_type_l2
     *           Product type (2nd level) in merchant's own [product
     *           taxonomy](https://support.google.com/merchants/answer/6324406).
     *     @type string $product_type_l3
     *           Product type (3rd level) in merchant's own [product
     *           taxonomy](https://support.google.com/merchants/answer/6324406).
     *     @type string $product_type_l4
     *           Product type (4th level) in merchant's own [product
     *           taxonomy](https://support.google.com/merchants/answer/6324406).
     *     @type string $product_type_l5
     *           Product type (5th level) in merchant's own [product
     *           taxonomy](https://support.google.com/merchants/answer/6324406).
     *     @type \Google\Shopping\Type\Price $price
     *           Product price. Absent if the information about the price of the product is
     *           not available.
     *     @type string $condition
     *           [Condition](https://support.google.com/merchants/answer/6324469) of the
     *           product.
     *     @type string $availability
     *           [Availability](https://support.google.com/merchants/answer/6324448) of the
     *           product.
     *     @type string $shipping_label
     *           Normalized [shipping
     *           label](https://support.google.com/merchants/answer/6324504) specified in
     *           the feed.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $gtin
     *           List of Global Trade Item Numbers (GTINs) of the product.
     *     @type string $item_group_id
     *           Item group id provided by the merchant for grouping variants together.
     *     @type string $thumbnail_link
     *           Link to the processed image of the product, hosted on the Google
     *           infrastructure.
     *     @type \Google\Protobuf\Timestamp $creation_time
     *           The time the merchant created the product in timestamp seconds.
     *     @type \Google\Type\Date $expiration_date
     *           Expiration date for the product, specified on insertion.
     *     @type int $aggregated_reporting_context_status
     *           Aggregated status.
     *     @type array<\Google\Shopping\Merchant\Reports\V1beta\ProductView\ItemIssue>|\Google\Protobuf\Internal\RepeatedField $item_issues
     *           List of item issues for the product.
     *           **This field cannot be used for sorting the results.**
     *           **Only selected attributes of this field (for example,
     *           `item_issues.severity.aggregated_severity`) can be used for filtering the
     *           results.**
     *     @type int $click_potential
     *           Estimated performance potential compared to highest performing products of
     *           the merchant.
     *     @type int|string $click_potential_rank
     *           Rank of the product based on its click potential. A product with
     *           `click_potential_rank` 1 has the highest click potential among the
     *           merchant's products that fulfill the search query conditions.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Reports\V1Beta\Reports::initOnce();
        parent::__construct($data);
    }

    /**
     * REST ID of the product, in the form of
     * `channel~languageCode~feedLabel~offerId`. Merchant API methods that operate
     * on products take this as their `name` parameter.
     * Required in the `SELECT` clause.
     *
     * Generated from protobuf field <code>optional string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : '';
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * REST ID of the product, in the form of
     * `channel~languageCode~feedLabel~offerId`. Merchant API methods that operate
     * on products take this as their `name` parameter.
     * Required in the `SELECT` clause.
     *
     * Generated from protobuf field <code>optional string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Channel of the product. Can be `ONLINE` or `LOCAL`.
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Channel.ChannelEnum channel = 28;</code>
     * @return int
     */
    public function getChannel()
    {
        return isset($this->channel) ? $this->channel : 0;
    }

    public function hasChannel()
    {
        return isset($this->channel);
    }

    public function clearChannel()
    {
        unset($this->channel);
    }

    /**
     * Channel of the product. Can be `ONLINE` or `LOCAL`.
     *
     * Generated from protobuf field <code>optional .google.shopping.type.Channel.ChannelEnum channel = 28;</code>
     * @param int $var
     * @return $this
     */
    public function setChannel($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Type\Channel\ChannelEnum::class);
        $this->channel = $var;

        return $this;
    }

    /**
     * Language code of the product in BCP 47 format.
     *
     * Generated from protobuf field <code>optional string language_code = 2;</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return isset($this->language_code) ? $this->language_code : '';
    }

    public function hasLanguageCode()
    {
        return isset($this->language_code);
    }

    public function clearLanguageCode()
    {
        unset($this->language_code);
    }

    /**
     * Language code of the product in BCP 47 format.
     *
     * Generated from protobuf field <code>optional string language_code = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

    /**
     * Feed label of the product.
     *
     * Generated from protobuf field <code>optional string feed_label = 3;</code>
     * @return string
     */
    public function getFeedLabel()
    {
        return isset($this->feed_label) ? $this->feed_label : '';
    }

    public function hasFeedLabel()
    {
        return isset($this->feed_label);
    }

    public function clearFeedLabel()
    {
        unset($this->feed_label);
    }

    /**
     * Feed label of the product.
     *
     * Generated from protobuf field <code>optional string feed_label = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setFeedLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->feed_label = $var;

        return $this;
    }

    /**
     * Merchant-provided id of the product.
     *
     * Generated from protobuf field <code>optional string offer_id = 4;</code>
     * @return string
     */
    public function getOfferId()
    {
        return isset($this->offer_id) ? $this->offer_id : '';
    }

    public function hasOfferId()
    {
        return isset($this->offer_id);
    }

    public function clearOfferId()
    {
        unset($this->offer_id);
    }

    /**
     * Merchant-provided id of the product.
     *
     * Generated from protobuf field <code>optional string offer_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setOfferId($var)
    {
        GPBUtil::checkString($var, True);
        $this->offer_id = $var;

        return $this;
    }

    /**
     * Title of the product.
     *
     * Generated from protobuf field <code>optional string title = 5;</code>
     * @return string
     */
    public function getTitle()
    {
        return isset($this->title) ? $this->title : '';
    }

    public function hasTitle()
    {
        return isset($this->title);
    }

    public function clearTitle()
    {
        unset($this->title);
    }

    /**
     * Title of the product.
     *
     * Generated from protobuf field <code>optional string title = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * Brand of the product.
     *
     * Generated from protobuf field <code>optional string brand = 6;</code>
     * @return string
     */
    public function getBrand()
    {
        return isset($this->brand) ? $this->brand : '';
    }

    public function hasBrand()
    {
        return isset($this->brand);
    }

    public function clearBrand()
    {
        unset($this->brand);
    }

    /**
     * Brand of the product.
     *
     * Generated from protobuf field <code>optional string brand = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setBrand($var)
    {
        GPBUtil::checkString($var, True);
        $this->brand = $var;

        return $this;
    }

    /**
     * Product category (1st level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l1 = 7;</code>
     * @return string
     */
    public function getCategoryL1()
    {
        return isset($this->category_l1) ? $this->category_l1 : '';
    }

    public function hasCategoryL1()
    {
        return isset($this->category_l1);
    }

    public function clearCategoryL1()
    {
        unset($this->category_l1);
    }

    /**
     * Product category (1st level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l1 = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL1($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l1 = $var;

        return $this;
    }

    /**
     * Product category (2nd level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l2 = 8;</code>
     * @return string
     */
    public function getCategoryL2()
    {
        return isset($this->category_l2) ? $this->category_l2 : '';
    }

    public function hasCategoryL2()
    {
        return isset($this->category_l2);
    }

    public function clearCategoryL2()
    {
        unset($this->category_l2);
    }

    /**
     * Product category (2nd level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l2 = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL2($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l2 = $var;

        return $this;
    }

    /**
     * Product category (3rd level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l3 = 9;</code>
     * @return string
     */
    public function getCategoryL3()
    {
        return isset($this->category_l3) ? $this->category_l3 : '';
    }

    public function hasCategoryL3()
    {
        return isset($this->category_l3);
    }

    public function clearCategoryL3()
    {
        unset($this->category_l3);
    }

    /**
     * Product category (3rd level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l3 = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL3($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l3 = $var;

        return $this;
    }

    /**
     * Product category (4th level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l4 = 10;</code>
     * @return string
     */
    public function getCategoryL4()
    {
        return isset($this->category_l4) ? $this->category_l4 : '';
    }

    public function hasCategoryL4()
    {
        return isset($this->category_l4);
    }

    public function clearCategoryL4()
    {
        unset($this->category_l4);
    }

    /**
     * Product category (4th level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l4 = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL4($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l4 = $var;

        return $this;
    }

    /**
     * Product category (5th level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l5 = 11;</code>
     * @return string
     */
    public function getCategoryL5()
    {
        return isset($this->category_l5) ? $this->category_l5 : '';
    }

    public function hasCategoryL5()
    {
        return isset($this->category_l5);
    }

    public function clearCategoryL5()
    {
        unset($this->category_l5);
    }

    /**
     * Product category (5th level) in [Google's product
     * taxonomy](https://support.google.com/merchants/answer/6324436).
     *
     * Generated from protobuf field <code>optional string category_l5 = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setCategoryL5($var)
    {
        GPBUtil::checkString($var, True);
        $this->category_l5 = $var;

        return $this;
    }

    /**
     * Product type (1st level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l1 = 12;</code>
     * @return string
     */
    public function getProductTypeL1()
    {
        return isset($this->product_type_l1) ? $this->product_type_l1 : '';
    }

    public function hasProductTypeL1()
    {
        return isset($this->product_type_l1);
    }

    public function clearProductTypeL1()
    {
        unset($this->product_type_l1);
    }

    /**
     * Product type (1st level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l1 = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeL1($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_l1 = $var;

        return $this;
    }

    /**
     * Product type (2nd level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l2 = 13;</code>
     * @return string
     */
    public function getProductTypeL2()
    {
        return isset($this->product_type_l2) ? $this->product_type_l2 : '';
    }

    public function hasProductTypeL2()
    {
        return isset($this->product_type_l2);
    }

    public function clearProductTypeL2()
    {
        unset($this->product_type_l2);
    }

    /**
     * Product type (2nd level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l2 = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeL2($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_l2 = $var;

        return $this;
    }

    /**
     * Product type (3rd level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l3 = 14;</code>
     * @return string
     */
    public function getProductTypeL3()
    {
        return isset($this->product_type_l3) ? $this->product_type_l3 : '';
    }

    public function hasProductTypeL3()
    {
        return isset($this->product_type_l3);
    }

    public function clearProductTypeL3()
    {
        unset($this->product_type_l3);
    }

    /**
     * Product type (3rd level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l3 = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeL3($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_l3 = $var;

        return $this;
    }

    /**
     * Product type (4th level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l4 = 15;</code>
     * @return string
     */
    public function getProductTypeL4()
    {
        return isset($this->product_type_l4) ? $this->product_type_l4 : '';
    }

    public function hasProductTypeL4()
    {
        return isset($this->product_type_l4);
    }

    public function clearProductTypeL4()
    {
        unset($this->product_type_l4);
    }

    /**
     * Product type (4th level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l4 = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeL4($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_l4 = $var;

        return $this;
    }

    /**
     * Product type (5th level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l5 = 16;</code>
     * @return string
     */
    public function getProductTypeL5()
    {
        return isset($this->product_type_l5) ? $this->product_type_l5 : '';
    }

    public function hasProductTypeL5()
    {
        return isset($this->product_type_l5);
    }

    public function clearProductTypeL5()
    {
        unset($this->product_type_l5);
    }

    /**
     * Product type (5th level) in merchant's own [product
     * taxonomy](https://support.google.com/merchants/answer/6324406).
     *
     * Generated from protobuf field <code>optional string product_type_l5 = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setProductTypeL5($var)
    {
        GPBUtil::checkString($var, True);
        $this->product_type_l5 = $var;

        return $this;
    }

    /**
     * Product price. Absent if the information about the price of the product is
     * not available.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 17;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getPrice()
    {
        return $this->price;
    }

    public function hasPrice()
    {
        return isset($this->price);
    }

    public function clearPrice()
    {
        unset($this->price);
    }

    /**
     * Product price. Absent if the information about the price of the product is
     * not available.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price price = 17;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->price = $var;

        return $this;
    }

    /**
     * [Condition](https://support.google.com/merchants/answer/6324469) of the
     * product.
     *
     * Generated from protobuf field <code>optional string condition = 18;</code>
     * @return string
     */
    public function getCondition()
    {
        return isset($this->condition) ? $this->condition : '';
    }

    public function hasCondition()
    {
        return isset($this->condition);
    }

    public function clearCondition()
    {
        unset($this->condition);
    }

    /**
     * [Condition](https://support.google.com/merchants/answer/6324469) of the
     * product.
     *
     * Generated from protobuf field <code>optional string condition = 18;</code>
     * @param string $var
     * @return $this
     */
    public function setCondition($var)
    {
        GPBUtil::checkString($var, True);
        $this->condition = $var;

        return $this;
    }

    /**
     * [Availability](https://support.google.com/merchants/answer/6324448) of the
     * product.
     *
     * Generated from protobuf field <code>optional string availability = 19;</code>
     * @return string
     */
    public function getAvailability()
    {
        return isset($this->availability) ? $this->availability : '';
    }

    public function hasAvailability()
    {
        return isset($this->availability);
    }

    public function clearAvailability()
    {
        unset($this->availability);
    }

    /**
     * [Availability](https://support.google.com/merchants/answer/6324448) of the
     * product.
     *
     * Generated from protobuf field <code>optional string availability = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setAvailability($var)
    {
        GPBUtil::checkString($var, True);
        $this->availability = $var;

        return $this;
    }

    /**
     * Normalized [shipping
     * label](https://support.google.com/merchants/answer/6324504) specified in
     * the feed.
     *
     * Generated from protobuf field <code>optional string shipping_label = 20;</code>
     * @return string
     */
    public function getShippingLabel()
    {
        return isset($this->shipping_label) ? $this->shipping_label : '';
    }

    public function hasShippingLabel()
    {
        return isset($this->shipping_label);
    }

    public function clearShippingLabel()
    {
        unset($this->shipping_label);
    }

    /**
     * Normalized [shipping
     * label](https://support.google.com/merchants/answer/6324504) specified in
     * the feed.
     *
     * Generated from protobuf field <code>optional string shipping_label = 20;</code>
     * @param string $var
     * @return $this
     */
    public function setShippingLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->shipping_label = $var;

        return $this;
    }

    /**
     * List of Global Trade Item Numbers (GTINs) of the product.
     *
     * Generated from protobuf field <code>repeated string gtin = 21;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGtin()
    {
        return $this->gtin;
    }

    /**
     * List of Global Trade Item Numbers (GTINs) of the product.
     *
     * Generated from protobuf field <code>repeated string gtin = 21;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGtin($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->gtin = $arr;

        return $this;
    }

    /**
     * Item group id provided by the merchant for grouping variants together.
     *
     * Generated from protobuf field <code>optional string item_group_id = 22;</code>
     * @return string
     */
    public function getItemGroupId()
    {
        return isset($this->item_group_id) ? $this->item_group_id : '';
    }

    public function hasItemGroupId()
    {
        return isset($this->item_group_id);
    }

    public function clearItemGroupId()
    {
        unset($this->item_group_id);
    }

    /**
     * Item group id provided by the merchant for grouping variants together.
     *
     * Generated from protobuf field <code>optional string item_group_id = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setItemGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->item_group_id = $var;

        return $this;
    }

    /**
     * Link to the processed image of the product, hosted on the Google
     * infrastructure.
     *
     * Generated from protobuf field <code>optional string thumbnail_link = 23;</code>
     * @return string
     */
    public function getThumbnailLink()
    {
        return isset($this->thumbnail_link) ? $this->thumbnail_link : '';
    }

    public function hasThumbnailLink()
    {
        return isset($this->thumbnail_link);
    }

    public function clearThumbnailLink()
    {
        unset($this->thumbnail_link);
    }

    /**
     * Link to the processed image of the product, hosted on the Google
     * infrastructure.
     *
     * Generated from protobuf field <code>optional string thumbnail_link = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setThumbnailLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->thumbnail_link = $var;

        return $this;
    }

    /**
     * The time the merchant created the product in timestamp seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 24;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreationTime()
    {
        return $this->creation_time;
    }

    public function hasCreationTime()
    {
        return isset($this->creation_time);
    }

    public function clearCreationTime()
    {
        unset($this->creation_time);
    }

    /**
     * The time the merchant created the product in timestamp seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp creation_time = 24;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->creation_time = $var;

        return $this;
    }

    /**
     * Expiration date for the product, specified on insertion.
     *
     * Generated from protobuf field <code>.google.type.Date expiration_date = 25;</code>
     * @return \Google\Type\Date|null
     */
    public function getExpirationDate()
    {
        return $this->expiration_date;
    }

    public function hasExpirationDate()
    {
        return isset($this->expiration_date);
    }

    public function clearExpirationDate()
    {
        unset($this->expiration_date);
    }

    /**
     * Expiration date for the product, specified on insertion.
     *
     * Generated from protobuf field <code>.google.type.Date expiration_date = 25;</code>
     * @param \Google\Type\Date $var
     * @return $this
     */
    public function setExpirationDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Date::class);
        $this->expiration_date = $var;

        return $this;
    }

    /**
     * Aggregated status.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.ProductView.AggregatedReportingContextStatus aggregated_reporting_context_status = 26;</code>
     * @return int
     */
    public function getAggregatedReportingContextStatus()
    {
        return isset($this->aggregated_reporting_context_status) ? $this->aggregated_reporting_context_status : 0;
    }

    public function hasAggregatedReportingContextStatus()
    {
        return isset($this->aggregated_reporting_context_status);
    }

    public function clearAggregatedReportingContextStatus()
    {
        unset($this->aggregated_reporting_context_status);
    }

    /**
     * Aggregated status.
     *
     * Generated from protobuf field <code>optional .google.shopping.merchant.reports.v1beta.ProductView.AggregatedReportingContextStatus aggregated_reporting_context_status = 26;</code>
     * @param int $var
     * @return $this
     */
    public function setAggregatedReportingContextStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reports\V1beta\ProductView\AggregatedReportingContextStatus::class);
        $this->aggregated_reporting_context_status = $var;

        return $this;
    }

    /**
     * List of item issues for the product.
     * **This field cannot be used for sorting the results.**
     * **Only selected attributes of this field (for example,
     * `item_issues.severity.aggregated_severity`) can be used for filtering the
     * results.**
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.reports.v1beta.ProductView.ItemIssue item_issues = 27;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getItemIssues()
    {
        return $this->item_issues;
    }

    /**
     * List of item issues for the product.
     * **This field cannot be used for sorting the results.**
     * **Only selected attributes of this field (for example,
     * `item_issues.severity.aggregated_severity`) can be used for filtering the
     * results.**
     *
     * Generated from protobuf field <code>repeated .google.shopping.merchant.reports.v1beta.ProductView.ItemIssue item_issues = 27;</code>
     * @param array<\Google\Shopping\Merchant\Reports\V1beta\ProductView\ItemIssue>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setItemIssues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Merchant\Reports\V1beta\ProductView\ItemIssue::class);
        $this->item_issues = $arr;

        return $this;
    }

    /**
     * Estimated performance potential compared to highest performing products of
     * the merchant.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reports.v1beta.ProductView.ClickPotential click_potential = 29;</code>
     * @return int
     */
    public function getClickPotential()
    {
        return $this->click_potential;
    }

    /**
     * Estimated performance potential compared to highest performing products of
     * the merchant.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.reports.v1beta.ProductView.ClickPotential click_potential = 29;</code>
     * @param int $var
     * @return $this
     */
    public function setClickPotential($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Reports\V1beta\ProductView\ClickPotential::class);
        $this->click_potential = $var;

        return $this;
    }

    /**
     * Rank of the product based on its click potential. A product with
     * `click_potential_rank` 1 has the highest click potential among the
     * merchant's products that fulfill the search query conditions.
     *
     * Generated from protobuf field <code>optional int64 click_potential_rank = 30;</code>
     * @return int|string
     */
    public function getClickPotentialRank()
    {
        return isset($this->click_potential_rank) ? $this->click_potential_rank : 0;
    }

    public function hasClickPotentialRank()
    {
        return isset($this->click_potential_rank);
    }

    public function clearClickPotentialRank()
    {
        unset($this->click_potential_rank);
    }

    /**
     * Rank of the product based on its click potential. A product with
     * `click_potential_rank` 1 has the highest click potential among the
     * merchant's products that fulfill the search query conditions.
     *
     * Generated from protobuf field <code>optional int64 click_potential_rank = 30;</code>
     * @param int|string $var
     * @return $this
     */
    public function setClickPotentialRank($var)
    {
        GPBUtil::checkInt64($var);
        $this->click_potential_rank = $var;

        return $this;
    }

}

