<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/datastream/v1/datastream.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Datastream\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Datastream\V1\ConnectionProfile;
use Google\Cloud\Datastream\V1\CreateConnectionProfileRequest;
use Google\Cloud\Datastream\V1\CreatePrivateConnectionRequest;
use Google\Cloud\Datastream\V1\CreateRouteRequest;
use Google\Cloud\Datastream\V1\CreateStreamRequest;
use Google\Cloud\Datastream\V1\DeleteConnectionProfileRequest;
use Google\Cloud\Datastream\V1\DeletePrivateConnectionRequest;
use Google\Cloud\Datastream\V1\DeleteRouteRequest;
use Google\Cloud\Datastream\V1\DeleteStreamRequest;
use Google\Cloud\Datastream\V1\DiscoverConnectionProfileRequest;
use Google\Cloud\Datastream\V1\DiscoverConnectionProfileResponse;
use Google\Cloud\Datastream\V1\FetchStaticIpsRequest;
use Google\Cloud\Datastream\V1\GetConnectionProfileRequest;
use Google\Cloud\Datastream\V1\GetPrivateConnectionRequest;
use Google\Cloud\Datastream\V1\GetRouteRequest;
use Google\Cloud\Datastream\V1\GetStreamObjectRequest;
use Google\Cloud\Datastream\V1\GetStreamRequest;
use Google\Cloud\Datastream\V1\ListConnectionProfilesRequest;
use Google\Cloud\Datastream\V1\ListPrivateConnectionsRequest;
use Google\Cloud\Datastream\V1\ListRoutesRequest;
use Google\Cloud\Datastream\V1\ListStreamObjectsRequest;
use Google\Cloud\Datastream\V1\ListStreamsRequest;
use Google\Cloud\Datastream\V1\LookupStreamObjectRequest;
use Google\Cloud\Datastream\V1\PrivateConnection;
use Google\Cloud\Datastream\V1\Route;
use Google\Cloud\Datastream\V1\StartBackfillJobRequest;
use Google\Cloud\Datastream\V1\StartBackfillJobResponse;
use Google\Cloud\Datastream\V1\StopBackfillJobRequest;
use Google\Cloud\Datastream\V1\StopBackfillJobResponse;
use Google\Cloud\Datastream\V1\Stream;
use Google\Cloud\Datastream\V1\StreamObject;
use Google\Cloud\Datastream\V1\UpdateConnectionProfileRequest;
use Google\Cloud\Datastream\V1\UpdateStreamRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Datastream service
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createConnectionProfileAsync(CreateConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPrivateConnectionAsync(CreatePrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRouteAsync(CreateRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createStreamAsync(CreateStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteConnectionProfileAsync(DeleteConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePrivateConnectionAsync(DeletePrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteRouteAsync(DeleteRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteStreamAsync(DeleteStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface discoverConnectionProfileAsync(DiscoverConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface fetchStaticIpsAsync(FetchStaticIpsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConnectionProfileAsync(GetConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPrivateConnectionAsync(GetPrivateConnectionRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRouteAsync(GetRouteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getStreamAsync(GetStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getStreamObjectAsync(GetStreamObjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listConnectionProfilesAsync(ListConnectionProfilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPrivateConnectionsAsync(ListPrivateConnectionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRoutesAsync(ListRoutesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listStreamObjectsAsync(ListStreamObjectsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listStreamsAsync(ListStreamsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface lookupStreamObjectAsync(LookupStreamObjectRequest $request, array $optionalArgs = [])
 * @method PromiseInterface startBackfillJobAsync(StartBackfillJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface stopBackfillJobAsync(StopBackfillJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateConnectionProfileAsync(UpdateConnectionProfileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateStreamAsync(UpdateStreamRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class DatastreamClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.datastream.v1.Datastream';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'datastream.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'datastream.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/datastream_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/datastream_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/datastream_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/datastream_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * connection_profile resource.
     *
     * @param string $project
     * @param string $location
     * @param string $connectionProfile
     *
     * @return string The formatted connection_profile resource.
     */
    public static function connectionProfileName(string $project, string $location, string $connectionProfile): string
    {
        return self::getPathTemplate('connectionProfile')->render([
            'project' => $project,
            'location' => $location,
            'connection_profile' => $connectionProfile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a networks
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted networks resource.
     */
    public static function networksName(string $project, string $network): string
    {
        return self::getPathTemplate('networks')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * private_connection resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateConnection
     *
     * @return string The formatted private_connection resource.
     */
    public static function privateConnectionName(string $project, string $location, string $privateConnection): string
    {
        return self::getPathTemplate('privateConnection')->render([
            'project' => $project,
            'location' => $location,
            'private_connection' => $privateConnection,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a route
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $privateConnection
     * @param string $route
     *
     * @return string The formatted route resource.
     */
    public static function routeName(string $project, string $location, string $privateConnection, string $route): string
    {
        return self::getPathTemplate('route')->render([
            'project' => $project,
            'location' => $location,
            'private_connection' => $privateConnection,
            'route' => $route,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a stream
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $stream
     *
     * @return string The formatted stream resource.
     */
    public static function streamName(string $project, string $location, string $stream): string
    {
        return self::getPathTemplate('stream')->render([
            'project' => $project,
            'location' => $location,
            'stream' => $stream,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * stream_object resource.
     *
     * @param string $project
     * @param string $location
     * @param string $stream
     * @param string $object
     *
     * @return string The formatted stream_object resource.
     */
    public static function streamObjectName(string $project, string $location, string $stream, string $object): string
    {
        return self::getPathTemplate('streamObject')->render([
            'project' => $project,
            'location' => $location,
            'stream' => $stream,
            'object' => $object,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - connectionProfile: projects/{project}/locations/{location}/connectionProfiles/{connection_profile}
     * - location: projects/{project}/locations/{location}
     * - networks: projects/{project}/global/networks/{network}
     * - privateConnection: projects/{project}/locations/{location}/privateConnections/{private_connection}
     * - route: projects/{project}/locations/{location}/privateConnections/{private_connection}/routes/{route}
     * - stream: projects/{project}/locations/{location}/streams/{stream}
     * - streamObject: projects/{project}/locations/{location}/streams/{stream}/objects/{object}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datastream.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Use this method to create a connection profile in a project and location.
     *
     * The async variant is {@see DatastreamClient::createConnectionProfileAsync()} .
     *
     * @example samples/V1/DatastreamClient/create_connection_profile.php
     *
     * @param CreateConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createConnectionProfile(CreateConnectionProfileRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * Use this method to create a private connectivity configuration.
     *
     * The async variant is {@see DatastreamClient::createPrivateConnectionAsync()} .
     *
     * @example samples/V1/DatastreamClient/create_private_connection.php
     *
     * @param CreatePrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPrivateConnection(CreatePrivateConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Use this method to create a route for a private connectivity configuration
     * in a project and location.
     *
     * The async variant is {@see DatastreamClient::createRouteAsync()} .
     *
     * @example samples/V1/DatastreamClient/create_route.php
     *
     * @param CreateRouteRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRoute(CreateRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRoute', $request, $callOptions)->wait();
    }

    /**
     * Use this method to create a stream.
     *
     * The async variant is {@see DatastreamClient::createStreamAsync()} .
     *
     * @example samples/V1/DatastreamClient/create_stream.php
     *
     * @param CreateStreamRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createStream(CreateStreamRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateStream', $request, $callOptions)->wait();
    }

    /**
     * Use this method to delete a connection profile.
     *
     * The async variant is {@see DatastreamClient::deleteConnectionProfileAsync()} .
     *
     * @example samples/V1/DatastreamClient/delete_connection_profile.php
     *
     * @param DeleteConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteConnectionProfile(DeleteConnectionProfileRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * Use this method to delete a private connectivity configuration.
     *
     * The async variant is {@see DatastreamClient::deletePrivateConnectionAsync()} .
     *
     * @example samples/V1/DatastreamClient/delete_private_connection.php
     *
     * @param DeletePrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePrivateConnection(DeletePrivateConnectionRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Use this method to delete a route.
     *
     * The async variant is {@see DatastreamClient::deleteRouteAsync()} .
     *
     * @example samples/V1/DatastreamClient/delete_route.php
     *
     * @param DeleteRouteRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRoute(DeleteRouteRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRoute', $request, $callOptions)->wait();
    }

    /**
     * Use this method to delete a stream.
     *
     * The async variant is {@see DatastreamClient::deleteStreamAsync()} .
     *
     * @example samples/V1/DatastreamClient/delete_stream.php
     *
     * @param DeleteStreamRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteStream(DeleteStreamRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteStream', $request, $callOptions)->wait();
    }

    /**
     * Use this method to discover a connection profile.
     * The discover API call exposes the data objects and metadata belonging to
     * the profile. Typically, a request returns children data objects of a
     * parent data object that's optionally supplied in the request.
     *
     * The async variant is {@see DatastreamClient::discoverConnectionProfileAsync()} .
     *
     * @example samples/V1/DatastreamClient/discover_connection_profile.php
     *
     * @param DiscoverConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DiscoverConnectionProfileResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function discoverConnectionProfile(DiscoverConnectionProfileRequest $request, array $callOptions = []): DiscoverConnectionProfileResponse
    {
        return $this->startApiCall('DiscoverConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * The FetchStaticIps API call exposes the static IP addresses used by
     * Datastream.
     *
     * The async variant is {@see DatastreamClient::fetchStaticIpsAsync()} .
     *
     * @example samples/V1/DatastreamClient/fetch_static_ips.php
     *
     * @param FetchStaticIpsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function fetchStaticIps(FetchStaticIpsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('FetchStaticIps', $request, $callOptions);
    }

    /**
     * Use this method to get details about a connection profile.
     *
     * The async variant is {@see DatastreamClient::getConnectionProfileAsync()} .
     *
     * @example samples/V1/DatastreamClient/get_connection_profile.php
     *
     * @param GetConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConnectionProfile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConnectionProfile(GetConnectionProfileRequest $request, array $callOptions = []): ConnectionProfile
    {
        return $this->startApiCall('GetConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * Use this method to get details about a private connectivity configuration.
     *
     * The async variant is {@see DatastreamClient::getPrivateConnectionAsync()} .
     *
     * @example samples/V1/DatastreamClient/get_private_connection.php
     *
     * @param GetPrivateConnectionRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PrivateConnection
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPrivateConnection(GetPrivateConnectionRequest $request, array $callOptions = []): PrivateConnection
    {
        return $this->startApiCall('GetPrivateConnection', $request, $callOptions)->wait();
    }

    /**
     * Use this method to get details about a route.
     *
     * The async variant is {@see DatastreamClient::getRouteAsync()} .
     *
     * @example samples/V1/DatastreamClient/get_route.php
     *
     * @param GetRouteRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Route
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRoute(GetRouteRequest $request, array $callOptions = []): Route
    {
        return $this->startApiCall('GetRoute', $request, $callOptions)->wait();
    }

    /**
     * Use this method to get details about a stream.
     *
     * The async variant is {@see DatastreamClient::getStreamAsync()} .
     *
     * @example samples/V1/DatastreamClient/get_stream.php
     *
     * @param GetStreamRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Stream
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getStream(GetStreamRequest $request, array $callOptions = []): Stream
    {
        return $this->startApiCall('GetStream', $request, $callOptions)->wait();
    }

    /**
     * Use this method to get details about a stream object.
     *
     * The async variant is {@see DatastreamClient::getStreamObjectAsync()} .
     *
     * @example samples/V1/DatastreamClient/get_stream_object.php
     *
     * @param GetStreamObjectRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StreamObject
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getStreamObject(GetStreamObjectRequest $request, array $callOptions = []): StreamObject
    {
        return $this->startApiCall('GetStreamObject', $request, $callOptions)->wait();
    }

    /**
     * Use this method to list connection profiles created in a project and
     * location.
     *
     * The async variant is {@see DatastreamClient::listConnectionProfilesAsync()} .
     *
     * @example samples/V1/DatastreamClient/list_connection_profiles.php
     *
     * @param ListConnectionProfilesRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listConnectionProfiles(ListConnectionProfilesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListConnectionProfiles', $request, $callOptions);
    }

    /**
     * Use this method to list private connectivity configurations in a project
     * and location.
     *
     * The async variant is {@see DatastreamClient::listPrivateConnectionsAsync()} .
     *
     * @example samples/V1/DatastreamClient/list_private_connections.php
     *
     * @param ListPrivateConnectionsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPrivateConnections(ListPrivateConnectionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPrivateConnections', $request, $callOptions);
    }

    /**
     * Use this method to list routes created for a private connectivity
     * configuration in a project and location.
     *
     * The async variant is {@see DatastreamClient::listRoutesAsync()} .
     *
     * @example samples/V1/DatastreamClient/list_routes.php
     *
     * @param ListRoutesRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRoutes(ListRoutesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRoutes', $request, $callOptions);
    }

    /**
     * Use this method to list the objects of a specific stream.
     *
     * The async variant is {@see DatastreamClient::listStreamObjectsAsync()} .
     *
     * @example samples/V1/DatastreamClient/list_stream_objects.php
     *
     * @param ListStreamObjectsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listStreamObjects(ListStreamObjectsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListStreamObjects', $request, $callOptions);
    }

    /**
     * Use this method to list streams in a project and location.
     *
     * The async variant is {@see DatastreamClient::listStreamsAsync()} .
     *
     * @example samples/V1/DatastreamClient/list_streams.php
     *
     * @param ListStreamsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listStreams(ListStreamsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListStreams', $request, $callOptions);
    }

    /**
     * Use this method to look up a stream object by its source object identifier.
     *
     * The async variant is {@see DatastreamClient::lookupStreamObjectAsync()} .
     *
     * @example samples/V1/DatastreamClient/lookup_stream_object.php
     *
     * @param LookupStreamObjectRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StreamObject
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function lookupStreamObject(LookupStreamObjectRequest $request, array $callOptions = []): StreamObject
    {
        return $this->startApiCall('LookupStreamObject', $request, $callOptions)->wait();
    }

    /**
     * Use this method to start a backfill job for the specified stream object.
     *
     * The async variant is {@see DatastreamClient::startBackfillJobAsync()} .
     *
     * @example samples/V1/DatastreamClient/start_backfill_job.php
     *
     * @param StartBackfillJobRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StartBackfillJobResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startBackfillJob(StartBackfillJobRequest $request, array $callOptions = []): StartBackfillJobResponse
    {
        return $this->startApiCall('StartBackfillJob', $request, $callOptions)->wait();
    }

    /**
     * Use this method to stop a backfill job for the specified stream object.
     *
     * The async variant is {@see DatastreamClient::stopBackfillJobAsync()} .
     *
     * @example samples/V1/DatastreamClient/stop_backfill_job.php
     *
     * @param StopBackfillJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StopBackfillJobResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopBackfillJob(StopBackfillJobRequest $request, array $callOptions = []): StopBackfillJobResponse
    {
        return $this->startApiCall('StopBackfillJob', $request, $callOptions)->wait();
    }

    /**
     * Use this method to update the parameters of a connection profile.
     *
     * The async variant is {@see DatastreamClient::updateConnectionProfileAsync()} .
     *
     * @example samples/V1/DatastreamClient/update_connection_profile.php
     *
     * @param UpdateConnectionProfileRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateConnectionProfile(UpdateConnectionProfileRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateConnectionProfile', $request, $callOptions)->wait();
    }

    /**
     * Use this method to update the configuration of a stream.
     *
     * The async variant is {@see DatastreamClient::updateStreamAsync()} .
     *
     * @example samples/V1/DatastreamClient/update_stream.php
     *
     * @param UpdateStreamRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateStream(UpdateStreamRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateStream', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see DatastreamClient::getLocationAsync()} .
     *
     * @example samples/V1/DatastreamClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see DatastreamClient::listLocationsAsync()} .
     *
     * @example samples/V1/DatastreamClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
