<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/space_setup.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request to create a space and add specified users to it.
 *
 * Generated from protobuf message <code>google.chat.v1.SetUpSpaceRequest</code>
 */
class SetUpSpaceRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The `Space.spaceType` field is required.
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $space = null;
    /**
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     *
     * Generated from protobuf field <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $request_id = '';
    /**
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     * The set currently allows up to 20 memberships (in addition to the caller).
     * For human membership, the `Membership.member` field must contain a `user`
     * with `name` populated (format: `users/{user}`) and `type` set to
     * `User.Type.HUMAN`. You can only add human users when setting up a space
     * (adding Chat apps is only supported for direct message setup with the
     * calling app). You can also add members using the user's email as an alias
     * for {user}. For example, the `user.name` can be `users/example&#64;gmail.com`.
     * To invite Gmail users or users from external Google Workspace domains,
     * user's email must be used for `{user}`.
     * Optional when setting `Space.spaceType` to `SPACE`.
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $memberships;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Apps\Chat\V1\Space $space
     *           Required. The `Space.spaceType` field is required.
     *           To create a space, set `Space.spaceType` to `SPACE` and set
     *           `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     *           setting up a space, try a different `displayName`. An existing space
     *           within the Google Workspace organization might already use this display
     *           name.
     *           To create a group chat, set `Space.spaceType` to
     *           `GROUP_CHAT`. Don't set `Space.displayName`.
     *           To create a 1:1 conversation between humans,
     *           set `Space.spaceType` to `DIRECT_MESSAGE` and set
     *           `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     *           `Space.spaceDetails`.
     *           To create an 1:1 conversation between a human and the calling Chat app, set
     *           `Space.spaceType` to `DIRECT_MESSAGE` and
     *           `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     *           `Space.spaceDetails`.
     *           If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     *           of creating a new space.
     *     @type string $request_id
     *           Optional. A unique identifier for this request.
     *           A random UUID is recommended.
     *           Specifying an existing request ID returns the space created with that ID
     *           instead of creating a new space.
     *           Specifying an existing request ID from the same Chat app with a different
     *           authenticated user returns an error.
     *     @type array<\Google\Apps\Chat\V1\Membership>|\Google\Protobuf\Internal\RepeatedField $memberships
     *           Optional. The Google Chat users to invite to join the space. Omit the
     *           calling user, as they are added automatically.
     *           The set currently allows up to 20 memberships (in addition to the caller).
     *           For human membership, the `Membership.member` field must contain a `user`
     *           with `name` populated (format: `users/{user}`) and `type` set to
     *           `User.Type.HUMAN`. You can only add human users when setting up a space
     *           (adding Chat apps is only supported for direct message setup with the
     *           calling app). You can also add members using the user's email as an alias
     *           for {user}. For example, the `user.name` can be `users/example&#64;gmail.com`.
     *           To invite Gmail users or users from external Google Workspace domains,
     *           user's email must be used for `{user}`.
     *           Optional when setting `Space.spaceType` to `SPACE`.
     *           Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     *           least two memberships.
     *           Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     *           user, along with exactly one membership.
     *           Must be empty when creating a 1:1 conversation between a human and the
     *           calling Chat app (when setting `Space.spaceType` to
     *           `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\SpaceSetup::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The `Space.spaceType` field is required.
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Apps\Chat\V1\Space|null
     */
    public function getSpace()
    {
        return $this->space;
    }

    public function hasSpace()
    {
        return isset($this->space);
    }

    public function clearSpace()
    {
        unset($this->space);
    }

    /**
     * Required. The `Space.spaceType` field is required.
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Apps\Chat\V1\Space $var
     * @return $this
     */
    public function setSpace($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space::class);
        $this->space = $var;

        return $this;
    }

    /**
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     *
     * Generated from protobuf field <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     *
     * Generated from protobuf field <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

    /**
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     * The set currently allows up to 20 memberships (in addition to the caller).
     * For human membership, the `Membership.member` field must contain a `user`
     * with `name` populated (format: `users/{user}`) and `type` set to
     * `User.Type.HUMAN`. You can only add human users when setting up a space
     * (adding Chat apps is only supported for direct message setup with the
     * calling app). You can also add members using the user's email as an alias
     * for {user}. For example, the `user.name` can be `users/example&#64;gmail.com`.
     * To invite Gmail users or users from external Google Workspace domains,
     * user's email must be used for `{user}`.
     * Optional when setting `Space.spaceType` to `SPACE`.
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMemberships()
    {
        return $this->memberships;
    }

    /**
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     * The set currently allows up to 20 memberships (in addition to the caller).
     * For human membership, the `Membership.member` field must contain a `user`
     * with `name` populated (format: `users/{user}`) and `type` set to
     * `User.Type.HUMAN`. You can only add human users when setting up a space
     * (adding Chat apps is only supported for direct message setup with the
     * calling app). You can also add members using the user's email as an alias
     * for {user}. For example, the `user.name` can be `users/example&#64;gmail.com`.
     * To invite Gmail users or users from external Google Workspace domains,
     * user's email must be used for `{user}`.
     * Optional when setting `Space.spaceType` to `SPACE`.
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     *
     * Generated from protobuf field <code>repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Apps\Chat\V1\Membership>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMemberships($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Apps\Chat\V1\Membership::class);
        $this->memberships = $arr;

        return $this;
    }

}

