<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/products/v1beta/productinputs.proto

namespace Google\Shopping\Merchant\Products\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * This resource represents input data you submit for a product, not the
 * processed product that you see in Merchant Center, in Shopping ads, or across
 * Google surfaces. Product inputs, rules and supplemental data source data are
 * combined to create the processed
 * [product][google.shopping.content.bundles.Products.Product].
 * Required product input attributes to pass data validation checks are
 * primarily defined in the [Products Data
 * Specification](https://support.google.com/merchants/answer/188494).
 * The following attributes are required:
 * [feedLabel][google.shopping.content.bundles.Products.feed_label],
 * [contentLanguage][google.shopping.content.bundles.Products.content_language]
 * and [offerId][google.shopping.content.bundles.Products.offer_id].
 * After inserting, updating, or deleting a product input, it may take several
 * minutes before the processed product can be retrieved.
 * All fields in the product input and its sub-messages match the English name
 * of their corresponding attribute in the vertical spec with [some
 * exceptions](https://support.google.com/merchants/answer/7052112).
 *
 * Generated from protobuf message <code>google.shopping.merchant.products.v1beta.ProductInput</code>
 */
class ProductInput extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the product input.
     * Format:
     * `"{productinput.name=accounts/{account}/productInputs/{productinput}}"`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The name of the processed product.
     * Format:
     * `"{product.name=accounts/{account}/products/{product}}"`
     *
     * Generated from protobuf field <code>string product = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $product = '';
    /**
     * Required. Immutable. The
     * [channel](https://support.google.com/merchants/answer/7361332) of the
     * product.
     *
     * Generated from protobuf field <code>.google.shopping.type.Channel.ChannelEnum channel = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $channel = 0;
    /**
     * Required. Immutable. Your unique identifier for the product. This is the
     * same for the product input and processed product. Leading and trailing
     * whitespaces are stripped and multiple whitespaces are replaced by a single
     * whitespace upon submission. See the [products data
     * specification](https://support.google.com/merchants/answer/188494#id) for
     * details.
     *
     * Generated from protobuf field <code>string offer_id = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $offer_id = '';
    /**
     * Required. Immutable. The two-letter [ISO
     * 639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
     * product.
     *
     * Generated from protobuf field <code>string content_language = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $content_language = '';
    /**
     * Required. Immutable. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the product.
     *
     * Generated from protobuf field <code>string feed_label = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $feed_label = '';
    /**
     * Optional. Represents the existing version (freshness) of the product, which
     * can be used to preserve the right order when multiple updates are done at
     * the same time.
     * If set, the insertion is prevented when version number is lower than
     * the current version number of the existing product. Re-insertion (for
     * example, product refresh after 30 days) can be performed with the current
     * `version_number`.
     * Only supported for insertions into primary data sources.
     * If the operation is prevented, the aborted exception will be
     * thrown.
     *
     * Generated from protobuf field <code>optional int64 version_number = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $version_number = null;
    /**
     * Optional. A list of product attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1beta.Attributes attributes = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $attributes = null;
    /**
     * Optional. A list of custom (merchant-provided) attributes. It can also be
     * used for submitting any attribute of the data specification in its generic
     * form (for example,
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as additional attributes used for Buy on Google.
     * Maximum allowed number of characters for each
     * custom attribute is 10240 (represents sum of characters for name and
     * value). Maximum 2500 custom attributes can be set per product, with total
     * size of 102.4kB. Underscores in custom attribute names are replaced by
     * spaces upon insertion.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $custom_attributes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the product input.
     *           Format:
     *           `"{productinput.name=accounts/{account}/productInputs/{productinput}}"`
     *     @type string $product
     *           Output only. The name of the processed product.
     *           Format:
     *           `"{product.name=accounts/{account}/products/{product}}"`
     *     @type int $channel
     *           Required. Immutable. The
     *           [channel](https://support.google.com/merchants/answer/7361332) of the
     *           product.
     *     @type string $offer_id
     *           Required. Immutable. Your unique identifier for the product. This is the
     *           same for the product input and processed product. Leading and trailing
     *           whitespaces are stripped and multiple whitespaces are replaced by a single
     *           whitespace upon submission. See the [products data
     *           specification](https://support.google.com/merchants/answer/188494#id) for
     *           details.
     *     @type string $content_language
     *           Required. Immutable. The two-letter [ISO
     *           639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
     *           product.
     *     @type string $feed_label
     *           Required. Immutable. The [feed
     *           label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     *           for the product.
     *     @type int|string $version_number
     *           Optional. Represents the existing version (freshness) of the product, which
     *           can be used to preserve the right order when multiple updates are done at
     *           the same time.
     *           If set, the insertion is prevented when version number is lower than
     *           the current version number of the existing product. Re-insertion (for
     *           example, product refresh after 30 days) can be performed with the current
     *           `version_number`.
     *           Only supported for insertions into primary data sources.
     *           If the operation is prevented, the aborted exception will be
     *           thrown.
     *     @type \Google\Shopping\Merchant\Products\V1beta\Attributes $attributes
     *           Optional. A list of product attributes.
     *     @type array<\Google\Shopping\Type\CustomAttribute>|\Google\Protobuf\Internal\RepeatedField $custom_attributes
     *           Optional. A list of custom (merchant-provided) attributes. It can also be
     *           used for submitting any attribute of the data specification in its generic
     *           form (for example,
     *           `{ "name": "size type", "value": "regular" }`).
     *           This is useful for submitting attributes not explicitly exposed by the
     *           API, such as additional attributes used for Buy on Google.
     *           Maximum allowed number of characters for each
     *           custom attribute is 10240 (represents sum of characters for name and
     *           value). Maximum 2500 custom attributes can be set per product, with total
     *           size of 102.4kB. Underscores in custom attribute names are replaced by
     *           spaces upon insertion.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Products\V1Beta\Productinputs::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the product input.
     * Format:
     * `"{productinput.name=accounts/{account}/productInputs/{productinput}}"`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the product input.
     * Format:
     * `"{productinput.name=accounts/{account}/productInputs/{productinput}}"`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The name of the processed product.
     * Format:
     * `"{product.name=accounts/{account}/products/{product}}"`
     *
     * Generated from protobuf field <code>string product = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Output only. The name of the processed product.
     * Format:
     * `"{product.name=accounts/{account}/products/{product}}"`
     *
     * Generated from protobuf field <code>string product = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setProduct($var)
    {
        GPBUtil::checkString($var, True);
        $this->product = $var;

        return $this;
    }

    /**
     * Required. Immutable. The
     * [channel](https://support.google.com/merchants/answer/7361332) of the
     * product.
     *
     * Generated from protobuf field <code>.google.shopping.type.Channel.ChannelEnum channel = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * Required. Immutable. The
     * [channel](https://support.google.com/merchants/answer/7361332) of the
     * product.
     *
     * Generated from protobuf field <code>.google.shopping.type.Channel.ChannelEnum channel = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setChannel($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Type\Channel\ChannelEnum::class);
        $this->channel = $var;

        return $this;
    }

    /**
     * Required. Immutable. Your unique identifier for the product. This is the
     * same for the product input and processed product. Leading and trailing
     * whitespaces are stripped and multiple whitespaces are replaced by a single
     * whitespace upon submission. See the [products data
     * specification](https://support.google.com/merchants/answer/188494#id) for
     * details.
     *
     * Generated from protobuf field <code>string offer_id = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getOfferId()
    {
        return $this->offer_id;
    }

    /**
     * Required. Immutable. Your unique identifier for the product. This is the
     * same for the product input and processed product. Leading and trailing
     * whitespaces are stripped and multiple whitespaces are replaced by a single
     * whitespace upon submission. See the [products data
     * specification](https://support.google.com/merchants/answer/188494#id) for
     * details.
     *
     * Generated from protobuf field <code>string offer_id = 4 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setOfferId($var)
    {
        GPBUtil::checkString($var, True);
        $this->offer_id = $var;

        return $this;
    }

    /**
     * Required. Immutable. The two-letter [ISO
     * 639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
     * product.
     *
     * Generated from protobuf field <code>string content_language = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getContentLanguage()
    {
        return $this->content_language;
    }

    /**
     * Required. Immutable. The two-letter [ISO
     * 639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
     * product.
     *
     * Generated from protobuf field <code>string content_language = 5 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setContentLanguage($var)
    {
        GPBUtil::checkString($var, True);
        $this->content_language = $var;

        return $this;
    }

    /**
     * Required. Immutable. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the product.
     *
     * Generated from protobuf field <code>string feed_label = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getFeedLabel()
    {
        return $this->feed_label;
    }

    /**
     * Required. Immutable. The [feed
     * label](https://developers.google.com/shopping-content/guides/products/feed-labels)
     * for the product.
     *
     * Generated from protobuf field <code>string feed_label = 6 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setFeedLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->feed_label = $var;

        return $this;
    }

    /**
     * Optional. Represents the existing version (freshness) of the product, which
     * can be used to preserve the right order when multiple updates are done at
     * the same time.
     * If set, the insertion is prevented when version number is lower than
     * the current version number of the existing product. Re-insertion (for
     * example, product refresh after 30 days) can be performed with the current
     * `version_number`.
     * Only supported for insertions into primary data sources.
     * If the operation is prevented, the aborted exception will be
     * thrown.
     *
     * Generated from protobuf field <code>optional int64 version_number = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getVersionNumber()
    {
        return isset($this->version_number) ? $this->version_number : 0;
    }

    public function hasVersionNumber()
    {
        return isset($this->version_number);
    }

    public function clearVersionNumber()
    {
        unset($this->version_number);
    }

    /**
     * Optional. Represents the existing version (freshness) of the product, which
     * can be used to preserve the right order when multiple updates are done at
     * the same time.
     * If set, the insertion is prevented when version number is lower than
     * the current version number of the existing product. Re-insertion (for
     * example, product refresh after 30 days) can be performed with the current
     * `version_number`.
     * Only supported for insertions into primary data sources.
     * If the operation is prevented, the aborted exception will be
     * thrown.
     *
     * Generated from protobuf field <code>optional int64 version_number = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setVersionNumber($var)
    {
        GPBUtil::checkInt64($var);
        $this->version_number = $var;

        return $this;
    }

    /**
     * Optional. A list of product attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1beta.Attributes attributes = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Shopping\Merchant\Products\V1beta\Attributes|null
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    public function hasAttributes()
    {
        return isset($this->attributes);
    }

    public function clearAttributes()
    {
        unset($this->attributes);
    }

    /**
     * Optional. A list of product attributes.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.products.v1beta.Attributes attributes = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Shopping\Merchant\Products\V1beta\Attributes $var
     * @return $this
     */
    public function setAttributes($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Products\V1beta\Attributes::class);
        $this->attributes = $var;

        return $this;
    }

    /**
     * Optional. A list of custom (merchant-provided) attributes. It can also be
     * used for submitting any attribute of the data specification in its generic
     * form (for example,
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as additional attributes used for Buy on Google.
     * Maximum allowed number of characters for each
     * custom attribute is 10240 (represents sum of characters for name and
     * value). Maximum 2500 custom attributes can be set per product, with total
     * size of 102.4kB. Underscores in custom attribute names are replaced by
     * spaces upon insertion.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCustomAttributes()
    {
        return $this->custom_attributes;
    }

    /**
     * Optional. A list of custom (merchant-provided) attributes. It can also be
     * used for submitting any attribute of the data specification in its generic
     * form (for example,
     * `{ "name": "size type", "value": "regular" }`).
     * This is useful for submitting attributes not explicitly exposed by the
     * API, such as additional attributes used for Buy on Google.
     * Maximum allowed number of characters for each
     * custom attribute is 10240 (represents sum of characters for name and
     * value). Maximum 2500 custom attributes can be set per product, with total
     * size of 102.4kB. Underscores in custom attribute names are replaced by
     * spaces upon insertion.
     *
     * Generated from protobuf field <code>repeated .google.shopping.type.CustomAttribute custom_attributes = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Shopping\Type\CustomAttribute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCustomAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Type\CustomAttribute::class);
        $this->custom_attributes = $arr;

        return $this;
    }

}

