<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/securesourcemanager/v1/secure_source_manager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\SecureSourceManager\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\SecureSourceManager\V1\BranchRule;
use Google\Cloud\SecureSourceManager\V1\CreateBranchRuleRequest;
use Google\Cloud\SecureSourceManager\V1\CreateInstanceRequest;
use Google\Cloud\SecureSourceManager\V1\CreateRepositoryRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteBranchRuleRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteInstanceRequest;
use Google\Cloud\SecureSourceManager\V1\DeleteRepositoryRequest;
use Google\Cloud\SecureSourceManager\V1\GetBranchRuleRequest;
use Google\Cloud\SecureSourceManager\V1\GetInstanceRequest;
use Google\Cloud\SecureSourceManager\V1\GetRepositoryRequest;
use Google\Cloud\SecureSourceManager\V1\Instance;
use Google\Cloud\SecureSourceManager\V1\ListBranchRulesRequest;
use Google\Cloud\SecureSourceManager\V1\ListInstancesRequest;
use Google\Cloud\SecureSourceManager\V1\ListRepositoriesRequest;
use Google\Cloud\SecureSourceManager\V1\Repository;
use Google\Cloud\SecureSourceManager\V1\UpdateBranchRuleRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Secure Source Manager API
 *
 * Access Secure Source Manager instances, resources, and repositories.
 *
 * This API is split across two servers: the Control Plane and the Data Plane.
 *
 * Data Plane endpoints are hosted directly by your Secure Source Manager
 * instance, so you must connect to your instance's API hostname to access
 * them. The API hostname looks like the following:
 *
 * https://[instance-id]-[project-number]-api.[location].sourcemanager.dev
 *
 * For example,
 *
 * https://my-instance-702770452863-api.us-central1.sourcemanager.dev
 *
 * Data Plane endpoints are denoted with **Host: Data Plane**.
 *
 * All other endpoints are found in the normal Cloud API location, namely,
 * `securcesourcemanager.googleapis.com`.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface createBranchRuleAsync(CreateBranchRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createInstanceAsync(CreateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createRepositoryAsync(CreateRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBranchRuleAsync(DeleteBranchRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteInstanceAsync(DeleteInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteRepositoryAsync(DeleteRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBranchRuleAsync(GetBranchRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyRepoAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getInstanceAsync(GetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getRepositoryAsync(GetRepositoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBranchRulesAsync(ListBranchRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listInstancesAsync(ListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listRepositoriesAsync(ListRepositoriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyRepoAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsRepoAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBranchRuleAsync(UpdateBranchRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class SecureSourceManagerClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.securesourcemanager.v1.SecureSourceManager';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'securesourcemanager.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'securesourcemanager.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/secure_source_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/secure_source_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/secure_source_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/secure_source_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a branch_rule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     * @param string $branchRule
     *
     * @return string The formatted branch_rule resource.
     */
    public static function branchRuleName(
        string $project,
        string $location,
        string $repository,
        string $branchRule
    ): string {
        return self::getPathTemplate('branchRule')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
            'branch_rule' => $branchRule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a ca_pool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $caPool
     *
     * @return string The formatted ca_pool resource.
     */
    public static function caPoolName(string $project, string $location, string $caPool): string
    {
        return self::getPathTemplate('caPool')->render([
            'project' => $project,
            'location' => $location,
            'ca_pool' => $caPool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $location, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a repository
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $repository
     *
     * @return string The formatted repository resource.
     */
    public static function repositoryName(string $project, string $location, string $repository): string
    {
        return self::getPathTemplate('repository')->render([
            'project' => $project,
            'location' => $location,
            'repository' => $repository,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_attachment resource.
     *
     * @param string $project
     * @param string $region
     * @param string $serviceAttachment
     *
     * @return string The formatted service_attachment resource.
     */
    public static function serviceAttachmentName(string $project, string $region, string $serviceAttachment): string
    {
        return self::getPathTemplate('serviceAttachment')->render([
            'project' => $project,
            'region' => $region,
            'service_attachment' => $serviceAttachment,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - branchRule: projects/{project}/locations/{location}/repositories/{repository}/branchRules/{branch_rule}
     * - caPool: projects/{project}/locations/{location}/caPools/{ca_pool}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     * - location: projects/{project}/locations/{location}
     * - repository: projects/{project}/locations/{location}/repositories/{repository}
     * - serviceAttachment: projects/{project}/regions/{region}/serviceAttachments/{service_attachment}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'securesourcemanager.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * CreateBranchRule creates a branch rule in a given repository.
     *
     * The async variant is {@see SecureSourceManagerClient::createBranchRuleAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_branch_rule.php
     *
     * @param CreateBranchRuleRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBranchRule(CreateBranchRuleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBranchRule', $request, $callOptions)->wait();
    }

    /**
     * Creates a new instance in a given project and location.
     *
     * The async variant is {@see SecureSourceManagerClient::createInstanceAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_instance.php
     *
     * @param CreateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInstance(CreateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates a new repository in a given project and location.
     *
     * **Host: Data Plane**
     *
     * The async variant is {@see SecureSourceManagerClient::createRepositoryAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/create_repository.php
     *
     * @param CreateRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRepository(CreateRepositoryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRepository', $request, $callOptions)->wait();
    }

    /**
     * DeleteBranchRule deletes a branch rule.
     *
     * The async variant is {@see SecureSourceManagerClient::deleteBranchRuleAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_branch_rule.php
     *
     * @param DeleteBranchRuleRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBranchRule(DeleteBranchRuleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBranchRule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single instance.
     *
     * The async variant is {@see SecureSourceManagerClient::deleteInstanceAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_instance.php
     *
     * @param DeleteInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInstance(DeleteInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteInstance', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Repository.
     *
     * **Host: Data Plane**
     *
     * The async variant is {@see SecureSourceManagerClient::deleteRepositoryAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/delete_repository.php
     *
     * @param DeleteRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRepository(DeleteRepositoryRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteRepository', $request, $callOptions)->wait();
    }

    /**
     * GetBranchRule gets a branch rule.
     *
     * The async variant is {@see SecureSourceManagerClient::getBranchRuleAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_branch_rule.php
     *
     * @param GetBranchRuleRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BranchRule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBranchRule(GetBranchRuleRequest $request, array $callOptions = []): BranchRule
    {
        return $this->startApiCall('GetBranchRule', $request, $callOptions)->wait();
    }

    /**
     * Get IAM policy for a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::getIamPolicyRepoAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_iam_policy_repo.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicyRepo(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicyRepo', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single instance.
     *
     * The async variant is {@see SecureSourceManagerClient::getInstanceAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_instance.php
     *
     * @param GetInstanceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInstance(GetInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('GetInstance', $request, $callOptions)->wait();
    }

    /**
     * Gets metadata of a repository.
     *
     * **Host: Data Plane**
     *
     * The async variant is {@see SecureSourceManagerClient::getRepositoryAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_repository.php
     *
     * @param GetRepositoryRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Repository
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRepository(GetRepositoryRequest $request, array $callOptions = []): Repository
    {
        return $this->startApiCall('GetRepository', $request, $callOptions)->wait();
    }

    /**
     * ListBranchRules lists branch rules in a given repository.
     *
     * The async variant is {@see SecureSourceManagerClient::listBranchRulesAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_branch_rules.php
     *
     * @param ListBranchRulesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBranchRules(ListBranchRulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBranchRules', $request, $callOptions);
    }

    /**
     * Lists Instances in a given project and location.
     *
     * The async variant is {@see SecureSourceManagerClient::listInstancesAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_instances.php
     *
     * @param ListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInstances(ListInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInstances', $request, $callOptions);
    }

    /**
     * Lists Repositories in a given project and location.
     *
     * **Host: Data Plane**
     *
     * The async variant is {@see SecureSourceManagerClient::listRepositoriesAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_repositories.php
     *
     * @param ListRepositoriesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRepositories(ListRepositoriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRepositories', $request, $callOptions);
    }

    /**
     * Set IAM policy on a repository.
     *
     * The async variant is {@see SecureSourceManagerClient::setIamPolicyRepoAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/set_iam_policy_repo.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicyRepo(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicyRepo', $request, $callOptions)->wait();
    }

    /**
     * Test IAM permissions on a repository.
     * IAM permission checks are not required on this method.
     *
     * The async variant is
     * {@see SecureSourceManagerClient::testIamPermissionsRepoAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/test_iam_permissions_repo.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissionsRepo(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissionsRepo', $request, $callOptions)->wait();
    }

    /**
     * UpdateBranchRule updates a branch rule.
     *
     * The async variant is {@see SecureSourceManagerClient::updateBranchRuleAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/update_branch_rule.php
     *
     * @param UpdateBranchRuleRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBranchRule(UpdateBranchRuleRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBranchRule', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see SecureSourceManagerClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see SecureSourceManagerClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see SecureSourceManagerClient::testIamPermissionsAsync()}
     * .
     *
     * @example samples/V1/SecureSourceManagerClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see SecureSourceManagerClient::getLocationAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see SecureSourceManagerClient::listLocationsAsync()} .
     *
     * @example samples/V1/SecureSourceManagerClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
