<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/v2/conversation_profile.proto

namespace Google\Cloud\Dialogflow\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines the Automated Agent to connect to a conversation.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.v2.AutomatedAgentConfig</code>
 */
class AutomatedAgentConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. ID of the Dialogflow agent environment to use.
     * This project needs to either be the same project as the conversation or you
     * need to grant `service-<Conversation Project
     * Number>&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     * Service Agent` role in this project.
     * - For ES agents, use format: `projects/<Project ID>/locations/<Location
     * ID>/agent/environments/<Environment ID or '-'>`. If environment is not
     * specified, the default `draft` environment is used. Refer to
     * [DetectIntentRequest](https://cloud.google.com/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     * for more details.
     * - For CX agents, use format `projects/<Project ID>/locations/<Location
     * ID>/agents/<Agent ID>/environments/<Environment ID
     * or '-'>`. If environment is not specified, the default `draft` environment
     * is used.
     *
     * Generated from protobuf field <code>string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $agent = '';
    /**
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $session_ttl = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $agent
     *           Required. ID of the Dialogflow agent environment to use.
     *           This project needs to either be the same project as the conversation or you
     *           need to grant `service-<Conversation Project
     *           Number>&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     *           Service Agent` role in this project.
     *           - For ES agents, use format: `projects/<Project ID>/locations/<Location
     *           ID>/agent/environments/<Environment ID or '-'>`. If environment is not
     *           specified, the default `draft` environment is used. Refer to
     *           [DetectIntentRequest](https://cloud.google.com/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     *           for more details.
     *           - For CX agents, use format `projects/<Project ID>/locations/<Location
     *           ID>/agents/<Agent ID>/environments/<Environment ID
     *           or '-'>`. If environment is not specified, the default `draft` environment
     *           is used.
     *     @type \Google\Protobuf\Duration $session_ttl
     *           Optional. Configure lifetime of the Dialogflow session.
     *           By default, a Dialogflow CX session remains active and its data is stored
     *           for 30 minutes after the last request is sent for the session.
     *           This value should be no longer than 1 day.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\V2\ConversationProfile::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. ID of the Dialogflow agent environment to use.
     * This project needs to either be the same project as the conversation or you
     * need to grant `service-<Conversation Project
     * Number>&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     * Service Agent` role in this project.
     * - For ES agents, use format: `projects/<Project ID>/locations/<Location
     * ID>/agent/environments/<Environment ID or '-'>`. If environment is not
     * specified, the default `draft` environment is used. Refer to
     * [DetectIntentRequest](https://cloud.google.com/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     * for more details.
     * - For CX agents, use format `projects/<Project ID>/locations/<Location
     * ID>/agents/<Agent ID>/environments/<Environment ID
     * or '-'>`. If environment is not specified, the default `draft` environment
     * is used.
     *
     * Generated from protobuf field <code>string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAgent()
    {
        return $this->agent;
    }

    /**
     * Required. ID of the Dialogflow agent environment to use.
     * This project needs to either be the same project as the conversation or you
     * need to grant `service-<Conversation Project
     * Number>&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     * Service Agent` role in this project.
     * - For ES agents, use format: `projects/<Project ID>/locations/<Location
     * ID>/agent/environments/<Environment ID or '-'>`. If environment is not
     * specified, the default `draft` environment is used. Refer to
     * [DetectIntentRequest](https://cloud.google.com/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     * for more details.
     * - For CX agents, use format `projects/<Project ID>/locations/<Location
     * ID>/agents/<Agent ID>/environments/<Environment ID
     * or '-'>`. If environment is not specified, the default `draft` environment
     * is used.
     *
     * Generated from protobuf field <code>string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAgent($var)
    {
        GPBUtil::checkString($var, True);
        $this->agent = $var;

        return $this;
    }

    /**
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getSessionTtl()
    {
        return $this->session_ttl;
    }

    public function hasSessionTtl()
    {
        return isset($this->session_ttl);
    }

    public function clearSessionTtl()
    {
        unset($this->session_ttl);
    }

    /**
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setSessionTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->session_ttl = $var;

        return $this;
    }

}

