<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/chat/v1/space.proto

namespace Google\Apps\Chat\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to update a single space.
 *
 * Generated from protobuf message <code>google.chat.v1.UpdateSpaceRequest</code>
 */
class UpdateSpaceRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $space = null;
    /**
     * Required. The updated field paths, comma separated if there are
     * multiple.
     * You can update the following fields for a space:
     * `space_details`: Updates the space's description. Supports up to 150
     * characters.
     * `display_name`: Only supports updating the display name for spaces where
     * `spaceType` field is `SPACE`.
     *  If you receive the error message `ALREADY_EXISTS`, try a different
     *  value. An existing space within the
     * Google Workspace organization might already use this display name.
     * `space_type`: Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together
     * with `space_type` in the update mask and ensure that the specified space
     * has a non-empty display name and the `SPACE` space type. Including the
     * `space_type` mask and the `SPACE` type in the specified space when updating
     * the display name is optional if the existing space already has the `SPACE`
     * type. Trying to update the space type in other ways results in an invalid
     * argument error.
     * `space_type` is not supported with `useAdminAccess`.
     * `space_history_state`: Updates [space history
     * settings](https://support.google.com/chat/answer/7664687) by turning
     * history on or off for the space. Only supported if history settings are
     * enabled for the Google Workspace organization. To update the
     * space history state, you must omit all other field masks in your request.
     * `space_history_state` is not supported with `useAdminAccess`.
     * `access_settings.audience`: Updates the [access
     * setting](https://support.google.com/chat/answer/11971020) of who can
     * discover the space, join the space, and preview the messages in named space
     * where `spaceType` field is `SPACE`. If the existing space has a
     * target audience, you can remove the audience and restrict space access by
     * omitting a value for this field mask. To update access settings for a
     * space, the authenticating user must be a space manager and omit all other
     * field masks in your request. You can't update this field if the space is in
     * [import
     * mode](https://developers.google.com/workspace/chat/import-data-overview).
     * To learn more, see [Make a space discoverable to specific
     * users](https://developers.google.com/workspace/chat/space-target-audience).
     * `access_settings.audience` is not supported with `useAdminAccess`.
     * `permission_settings`: Supports changing the
     * [permission settings](https://support.google.com/chat/answer/13340792)
     * of a space.
     * When updating permission settings, you can only specify
     * `permissionSettings` field masks; you cannot update other field masks
     * at the same time. `permissionSettings` is not supported with
     * `useAdminAccess`.
     * The supported field masks include:
     * - `permission_settings.manageMembersAndGroups`
     * - `permission_settings.modifySpaceDetails`
     * - `permission_settings.toggleHistory`
     * - `permission_settings.useAtMentionAll`
     * - `permission_settings.manageApps`
     * - `permission_settings.manageWebhooks`
     * - `permission_settings.replyMessages`
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    protected $update_mask = null;
    /**
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires the `chat.admin.spaces` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * Some `FieldMask` values are not supported using admin access. For details,
     * see the description of `update_mask`.
     *
     * Generated from protobuf field <code>bool use_admin_access = 3;</code>
     */
    protected $use_admin_access = false;

    /**
     * @param \Google\Apps\Chat\V1\Space $space      Required. Space with fields to be updated. `Space.name` must be
     *                                               populated in the form of `spaces/{space}`. Only fields
     *                                               specified by `update_mask` are updated.
     * @param \Google\Protobuf\FieldMask $updateMask Required. The updated field paths, comma separated if there are
     *                                               multiple.
     *
     *                                               You can update the following fields for a space:
     *
     *                                               `space_details`: Updates the space's description. Supports up to 150
     *                                               characters.
     *
     *                                               `display_name`: Only supports updating the display name for spaces where
     *                                               `spaceType` field is `SPACE`.
     *                                               If you receive the error message `ALREADY_EXISTS`, try a different
     *                                               value. An existing space within the
     *                                               Google Workspace organization might already use this display name.
     *
     *                                               `space_type`: Only supports changing a `GROUP_CHAT` space type to
     *                                               `SPACE`. Include `display_name` together
     *                                               with `space_type` in the update mask and ensure that the specified space
     *                                               has a non-empty display name and the `SPACE` space type. Including the
     *                                               `space_type` mask and the `SPACE` type in the specified space when updating
     *                                               the display name is optional if the existing space already has the `SPACE`
     *                                               type. Trying to update the space type in other ways results in an invalid
     *                                               argument error.
     *                                               `space_type` is not supported with `useAdminAccess`.
     *
     *                                               `space_history_state`: Updates [space history
     *                                               settings](https://support.google.com/chat/answer/7664687) by turning
     *                                               history on or off for the space. Only supported if history settings are
     *                                               enabled for the Google Workspace organization. To update the
     *                                               space history state, you must omit all other field masks in your request.
     *                                               `space_history_state` is not supported with `useAdminAccess`.
     *
     *                                               `access_settings.audience`: Updates the [access
     *                                               setting](https://support.google.com/chat/answer/11971020) of who can
     *                                               discover the space, join the space, and preview the messages in named space
     *                                               where `spaceType` field is `SPACE`. If the existing space has a
     *                                               target audience, you can remove the audience and restrict space access by
     *                                               omitting a value for this field mask. To update access settings for a
     *                                               space, the authenticating user must be a space manager and omit all other
     *                                               field masks in your request. You can't update this field if the space is in
     *                                               [import
     *                                               mode](https://developers.google.com/workspace/chat/import-data-overview).
     *                                               To learn more, see [Make a space discoverable to specific
     *                                               users](https://developers.google.com/workspace/chat/space-target-audience).
     *                                               `access_settings.audience` is not supported with `useAdminAccess`.
     *
     *                                               `permission_settings`: Supports changing the
     *                                               [permission settings](https://support.google.com/chat/answer/13340792)
     *                                               of a space.
     *                                               When updating permission settings, you can only specify
     *                                               `permissionSettings` field masks; you cannot update other field masks
     *                                               at the same time. `permissionSettings` is not supported with
     *                                               `useAdminAccess`.
     *                                               The supported field masks include:
     *
     *                                               - `permission_settings.manageMembersAndGroups`
     *                                               - `permission_settings.modifySpaceDetails`
     *                                               - `permission_settings.toggleHistory`
     *                                               - `permission_settings.useAtMentionAll`
     *                                               - `permission_settings.manageApps`
     *                                               - `permission_settings.manageWebhooks`
     *                                               - `permission_settings.replyMessages`
     *
     * @return \Google\Apps\Chat\V1\UpdateSpaceRequest
     *
     * @experimental
     */
    public static function build(\Google\Apps\Chat\V1\Space $space, \Google\Protobuf\FieldMask $updateMask): self
    {
        return (new self())
            ->setSpace($space)
            ->setUpdateMask($updateMask);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Apps\Chat\V1\Space $space
     *           Required. Space with fields to be updated. `Space.name` must be
     *           populated in the form of `spaces/{space}`. Only fields
     *           specified by `update_mask` are updated.
     *     @type \Google\Protobuf\FieldMask $update_mask
     *           Required. The updated field paths, comma separated if there are
     *           multiple.
     *           You can update the following fields for a space:
     *           `space_details`: Updates the space's description. Supports up to 150
     *           characters.
     *           `display_name`: Only supports updating the display name for spaces where
     *           `spaceType` field is `SPACE`.
     *            If you receive the error message `ALREADY_EXISTS`, try a different
     *            value. An existing space within the
     *           Google Workspace organization might already use this display name.
     *           `space_type`: Only supports changing a `GROUP_CHAT` space type to
     *           `SPACE`. Include `display_name` together
     *           with `space_type` in the update mask and ensure that the specified space
     *           has a non-empty display name and the `SPACE` space type. Including the
     *           `space_type` mask and the `SPACE` type in the specified space when updating
     *           the display name is optional if the existing space already has the `SPACE`
     *           type. Trying to update the space type in other ways results in an invalid
     *           argument error.
     *           `space_type` is not supported with `useAdminAccess`.
     *           `space_history_state`: Updates [space history
     *           settings](https://support.google.com/chat/answer/7664687) by turning
     *           history on or off for the space. Only supported if history settings are
     *           enabled for the Google Workspace organization. To update the
     *           space history state, you must omit all other field masks in your request.
     *           `space_history_state` is not supported with `useAdminAccess`.
     *           `access_settings.audience`: Updates the [access
     *           setting](https://support.google.com/chat/answer/11971020) of who can
     *           discover the space, join the space, and preview the messages in named space
     *           where `spaceType` field is `SPACE`. If the existing space has a
     *           target audience, you can remove the audience and restrict space access by
     *           omitting a value for this field mask. To update access settings for a
     *           space, the authenticating user must be a space manager and omit all other
     *           field masks in your request. You can't update this field if the space is in
     *           [import
     *           mode](https://developers.google.com/workspace/chat/import-data-overview).
     *           To learn more, see [Make a space discoverable to specific
     *           users](https://developers.google.com/workspace/chat/space-target-audience).
     *           `access_settings.audience` is not supported with `useAdminAccess`.
     *           `permission_settings`: Supports changing the
     *           [permission settings](https://support.google.com/chat/answer/13340792)
     *           of a space.
     *           When updating permission settings, you can only specify
     *           `permissionSettings` field masks; you cannot update other field masks
     *           at the same time. `permissionSettings` is not supported with
     *           `useAdminAccess`.
     *           The supported field masks include:
     *           - `permission_settings.manageMembersAndGroups`
     *           - `permission_settings.modifySpaceDetails`
     *           - `permission_settings.toggleHistory`
     *           - `permission_settings.useAtMentionAll`
     *           - `permission_settings.manageApps`
     *           - `permission_settings.manageWebhooks`
     *           - `permission_settings.replyMessages`
     *     @type bool $use_admin_access
     *           When `true`, the method runs using the user's Google Workspace
     *           administrator privileges.
     *           The calling user must be a Google Workspace administrator with the
     *           [manage chat and spaces conversations
     *           privilege](https://support.google.com/a/answer/13369245).
     *           Requires the `chat.admin.spaces` [OAuth 2.0
     *           scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     *           Some `FieldMask` values are not supported using admin access. For details,
     *           see the description of `update_mask`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Chat\V1\Space::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Apps\Chat\V1\Space|null
     */
    public function getSpace()
    {
        return $this->space;
    }

    public function hasSpace()
    {
        return isset($this->space);
    }

    public function clearSpace()
    {
        unset($this->space);
    }

    /**
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     *
     * Generated from protobuf field <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Apps\Chat\V1\Space $var
     * @return $this
     */
    public function setSpace($var)
    {
        GPBUtil::checkMessage($var, \Google\Apps\Chat\V1\Space::class);
        $this->space = $var;

        return $this;
    }

    /**
     * Required. The updated field paths, comma separated if there are
     * multiple.
     * You can update the following fields for a space:
     * `space_details`: Updates the space's description. Supports up to 150
     * characters.
     * `display_name`: Only supports updating the display name for spaces where
     * `spaceType` field is `SPACE`.
     *  If you receive the error message `ALREADY_EXISTS`, try a different
     *  value. An existing space within the
     * Google Workspace organization might already use this display name.
     * `space_type`: Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together
     * with `space_type` in the update mask and ensure that the specified space
     * has a non-empty display name and the `SPACE` space type. Including the
     * `space_type` mask and the `SPACE` type in the specified space when updating
     * the display name is optional if the existing space already has the `SPACE`
     * type. Trying to update the space type in other ways results in an invalid
     * argument error.
     * `space_type` is not supported with `useAdminAccess`.
     * `space_history_state`: Updates [space history
     * settings](https://support.google.com/chat/answer/7664687) by turning
     * history on or off for the space. Only supported if history settings are
     * enabled for the Google Workspace organization. To update the
     * space history state, you must omit all other field masks in your request.
     * `space_history_state` is not supported with `useAdminAccess`.
     * `access_settings.audience`: Updates the [access
     * setting](https://support.google.com/chat/answer/11971020) of who can
     * discover the space, join the space, and preview the messages in named space
     * where `spaceType` field is `SPACE`. If the existing space has a
     * target audience, you can remove the audience and restrict space access by
     * omitting a value for this field mask. To update access settings for a
     * space, the authenticating user must be a space manager and omit all other
     * field masks in your request. You can't update this field if the space is in
     * [import
     * mode](https://developers.google.com/workspace/chat/import-data-overview).
     * To learn more, see [Make a space discoverable to specific
     * users](https://developers.google.com/workspace/chat/space-target-audience).
     * `access_settings.audience` is not supported with `useAdminAccess`.
     * `permission_settings`: Supports changing the
     * [permission settings](https://support.google.com/chat/answer/13340792)
     * of a space.
     * When updating permission settings, you can only specify
     * `permissionSettings` field masks; you cannot update other field masks
     * at the same time. `permissionSettings` is not supported with
     * `useAdminAccess`.
     * The supported field masks include:
     * - `permission_settings.manageMembersAndGroups`
     * - `permission_settings.modifySpaceDetails`
     * - `permission_settings.toggleHistory`
     * - `permission_settings.useAtMentionAll`
     * - `permission_settings.manageApps`
     * - `permission_settings.manageWebhooks`
     * - `permission_settings.replyMessages`
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 2;</code>
     * @return \Google\Protobuf\FieldMask|null
     */
    public function getUpdateMask()
    {
        return $this->update_mask;
    }

    public function hasUpdateMask()
    {
        return isset($this->update_mask);
    }

    public function clearUpdateMask()
    {
        unset($this->update_mask);
    }

    /**
     * Required. The updated field paths, comma separated if there are
     * multiple.
     * You can update the following fields for a space:
     * `space_details`: Updates the space's description. Supports up to 150
     * characters.
     * `display_name`: Only supports updating the display name for spaces where
     * `spaceType` field is `SPACE`.
     *  If you receive the error message `ALREADY_EXISTS`, try a different
     *  value. An existing space within the
     * Google Workspace organization might already use this display name.
     * `space_type`: Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together
     * with `space_type` in the update mask and ensure that the specified space
     * has a non-empty display name and the `SPACE` space type. Including the
     * `space_type` mask and the `SPACE` type in the specified space when updating
     * the display name is optional if the existing space already has the `SPACE`
     * type. Trying to update the space type in other ways results in an invalid
     * argument error.
     * `space_type` is not supported with `useAdminAccess`.
     * `space_history_state`: Updates [space history
     * settings](https://support.google.com/chat/answer/7664687) by turning
     * history on or off for the space. Only supported if history settings are
     * enabled for the Google Workspace organization. To update the
     * space history state, you must omit all other field masks in your request.
     * `space_history_state` is not supported with `useAdminAccess`.
     * `access_settings.audience`: Updates the [access
     * setting](https://support.google.com/chat/answer/11971020) of who can
     * discover the space, join the space, and preview the messages in named space
     * where `spaceType` field is `SPACE`. If the existing space has a
     * target audience, you can remove the audience and restrict space access by
     * omitting a value for this field mask. To update access settings for a
     * space, the authenticating user must be a space manager and omit all other
     * field masks in your request. You can't update this field if the space is in
     * [import
     * mode](https://developers.google.com/workspace/chat/import-data-overview).
     * To learn more, see [Make a space discoverable to specific
     * users](https://developers.google.com/workspace/chat/space-target-audience).
     * `access_settings.audience` is not supported with `useAdminAccess`.
     * `permission_settings`: Supports changing the
     * [permission settings](https://support.google.com/chat/answer/13340792)
     * of a space.
     * When updating permission settings, you can only specify
     * `permissionSettings` field masks; you cannot update other field masks
     * at the same time. `permissionSettings` is not supported with
     * `useAdminAccess`.
     * The supported field masks include:
     * - `permission_settings.manageMembersAndGroups`
     * - `permission_settings.modifySpaceDetails`
     * - `permission_settings.toggleHistory`
     * - `permission_settings.useAtMentionAll`
     * - `permission_settings.manageApps`
     * - `permission_settings.manageWebhooks`
     * - `permission_settings.replyMessages`
     *
     * Generated from protobuf field <code>.google.protobuf.FieldMask update_mask = 2;</code>
     * @param \Google\Protobuf\FieldMask $var
     * @return $this
     */
    public function setUpdateMask($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\FieldMask::class);
        $this->update_mask = $var;

        return $this;
    }

    /**
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires the `chat.admin.spaces` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * Some `FieldMask` values are not supported using admin access. For details,
     * see the description of `update_mask`.
     *
     * Generated from protobuf field <code>bool use_admin_access = 3;</code>
     * @return bool
     */
    public function getUseAdminAccess()
    {
        return $this->use_admin_access;
    }

    /**
     * When `true`, the method runs using the user's Google Workspace
     * administrator privileges.
     * The calling user must be a Google Workspace administrator with the
     * [manage chat and spaces conversations
     * privilege](https://support.google.com/a/answer/13369245).
     * Requires the `chat.admin.spaces` [OAuth 2.0
     * scope](https://developers.google.com/workspace/chat/authenticate-authorize#chat-api-scopes).
     * Some `FieldMask` values are not supported using admin access. For details,
     * see the description of `update_mask`.
     *
     * Generated from protobuf field <code>bool use_admin_access = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseAdminAccess($var)
    {
        GPBUtil::checkBool($var);
        $this->use_admin_access = $var;

        return $this;
    }

}

