<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/alloydb/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AlloyDb\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AlloyDb\V1\Backup;
use Google\Cloud\AlloyDb\V1\BatchCreateInstancesRequest;
use Google\Cloud\AlloyDb\V1\Cluster;
use Google\Cloud\AlloyDb\V1\ConnectionInfo;
use Google\Cloud\AlloyDb\V1\CreateBackupRequest;
use Google\Cloud\AlloyDb\V1\CreateClusterRequest;
use Google\Cloud\AlloyDb\V1\CreateInstanceRequest;
use Google\Cloud\AlloyDb\V1\CreateSecondaryClusterRequest;
use Google\Cloud\AlloyDb\V1\CreateSecondaryInstanceRequest;
use Google\Cloud\AlloyDb\V1\CreateUserRequest;
use Google\Cloud\AlloyDb\V1\DeleteBackupRequest;
use Google\Cloud\AlloyDb\V1\DeleteClusterRequest;
use Google\Cloud\AlloyDb\V1\DeleteInstanceRequest;
use Google\Cloud\AlloyDb\V1\DeleteUserRequest;
use Google\Cloud\AlloyDb\V1\ExecuteSqlRequest;
use Google\Cloud\AlloyDb\V1\ExecuteSqlResponse;
use Google\Cloud\AlloyDb\V1\FailoverInstanceRequest;
use Google\Cloud\AlloyDb\V1\GenerateClientCertificateRequest;
use Google\Cloud\AlloyDb\V1\GenerateClientCertificateResponse;
use Google\Cloud\AlloyDb\V1\GetBackupRequest;
use Google\Cloud\AlloyDb\V1\GetClusterRequest;
use Google\Cloud\AlloyDb\V1\GetConnectionInfoRequest;
use Google\Cloud\AlloyDb\V1\GetInstanceRequest;
use Google\Cloud\AlloyDb\V1\GetUserRequest;
use Google\Cloud\AlloyDb\V1\InjectFaultRequest;
use Google\Cloud\AlloyDb\V1\Instance;
use Google\Cloud\AlloyDb\V1\ListBackupsRequest;
use Google\Cloud\AlloyDb\V1\ListClustersRequest;
use Google\Cloud\AlloyDb\V1\ListDatabasesRequest;
use Google\Cloud\AlloyDb\V1\ListInstancesRequest;
use Google\Cloud\AlloyDb\V1\ListSupportedDatabaseFlagsRequest;
use Google\Cloud\AlloyDb\V1\ListUsersRequest;
use Google\Cloud\AlloyDb\V1\PromoteClusterRequest;
use Google\Cloud\AlloyDb\V1\RestartInstanceRequest;
use Google\Cloud\AlloyDb\V1\RestoreClusterRequest;
use Google\Cloud\AlloyDb\V1\SwitchoverClusterRequest;
use Google\Cloud\AlloyDb\V1\UpdateBackupRequest;
use Google\Cloud\AlloyDb\V1\UpdateClusterRequest;
use Google\Cloud\AlloyDb\V1\UpdateInstanceRequest;
use Google\Cloud\AlloyDb\V1\UpdateUserRequest;
use Google\Cloud\AlloyDb\V1\User;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service describing handlers for resources
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface batchCreateInstancesAsync(BatchCreateInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBackupAsync(CreateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createClusterAsync(CreateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createInstanceAsync(CreateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSecondaryClusterAsync(CreateSecondaryClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSecondaryInstanceAsync(CreateSecondaryInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createUserAsync(CreateUserRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBackupAsync(DeleteBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteClusterAsync(DeleteClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteInstanceAsync(DeleteInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteUserAsync(DeleteUserRequest $request, array $optionalArgs = [])
 * @method PromiseInterface executeSqlAsync(ExecuteSqlRequest $request, array $optionalArgs = [])
 * @method PromiseInterface failoverInstanceAsync(FailoverInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface generateClientCertificateAsync(GenerateClientCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBackupAsync(GetBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getClusterAsync(GetClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getConnectionInfoAsync(GetConnectionInfoRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getInstanceAsync(GetInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getUserAsync(GetUserRequest $request, array $optionalArgs = [])
 * @method PromiseInterface injectFaultAsync(InjectFaultRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBackupsAsync(ListBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listClustersAsync(ListClustersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDatabasesAsync(ListDatabasesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listInstancesAsync(ListInstancesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSupportedDatabaseFlagsAsync(ListSupportedDatabaseFlagsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listUsersAsync(ListUsersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface promoteClusterAsync(PromoteClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface restartInstanceAsync(RestartInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface restoreClusterAsync(RestoreClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface switchoverClusterAsync(SwitchoverClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBackupAsync(UpdateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateClusterAsync(UpdateClusterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateInstanceAsync(UpdateInstanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateUserAsync(UpdateUserRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class AlloyDBAdminClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.alloydb.v1.AlloyDBAdmin';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'alloydb.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'alloydb.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/alloy_db_admin_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/alloy_db_admin_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/alloy_db_admin_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/alloy_db_admin_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName(string $project, string $location, string $backup): string
    {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'location' => $location,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a cluster
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     *
     * @return string The formatted cluster resource.
     */
    public static function clusterName(string $project, string $location, string $cluster): string
    {
        return self::getPathTemplate('cluster')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * crypto_key_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     * @param string $cryptoKeyVersion
     *
     * @return string The formatted crypto_key_version resource.
     */
    public static function cryptoKeyVersionName(
        string $project,
        string $location,
        string $keyRing,
        string $cryptoKey,
        string $cryptoKeyVersion
    ): string {
        return self::getPathTemplate('cryptoKeyVersion')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
            'crypto_key_version' => $cryptoKeyVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $location, string $cluster, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a user
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $cluster
     * @param string $user
     *
     * @return string The formatted user resource.
     */
    public static function userName(string $project, string $location, string $cluster, string $user): string
    {
        return self::getPathTemplate('user')->render([
            'project' => $project,
            'location' => $location,
            'cluster' => $cluster,
            'user' => $user,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/locations/{location}/backups/{backup}
     * - cluster: projects/{project}/locations/{location}/clusters/{cluster}
     * - cryptoKeyVersion: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}
     * - instance: projects/{project}/locations/{location}/clusters/{cluster}/instances/{instance}
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{network}
     * - user: projects/{project}/locations/{location}/clusters/{cluster}/users/{user}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'alloydb.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates new instances under the given project, location and cluster.
     * There can be only one primary instance in a cluster. If the primary
     * instance exists in the cluster as well as this request, then API will
     * throw an error.
     * The primary instance should exist before any read pool instance is
     * created. If the primary instance is a part of the request payload, then
     * the API will take care of creating instances in the correct order.
     * This method is here to support Google-internal use cases, and is not meant
     * for external customers to consume. Please do not start relying on it; its
     * behavior is subject to change without notice.
     *
     * The async variant is {@see AlloyDBAdminClient::batchCreateInstancesAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/batch_create_instances.php
     *
     * @param BatchCreateInstancesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchCreateInstances(
        BatchCreateInstancesRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('BatchCreateInstances', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Backup in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::createBackupAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/create_backup.php
     *
     * @param CreateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackup(CreateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackup', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Cluster in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::createClusterAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/create_cluster.php
     *
     * @param CreateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createCluster(CreateClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateCluster', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Instance in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::createInstanceAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/create_instance.php
     *
     * @param CreateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createInstance(CreateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates a cluster of type SECONDARY in the given location using
     * the primary cluster as the source.
     *
     * The async variant is {@see AlloyDBAdminClient::createSecondaryClusterAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/create_secondary_cluster.php
     *
     * @param CreateSecondaryClusterRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSecondaryCluster(
        CreateSecondaryClusterRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateSecondaryCluster', $request, $callOptions)->wait();
    }

    /**
     * Creates a new SECONDARY Instance in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::createSecondaryInstanceAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/create_secondary_instance.php
     *
     * @param CreateSecondaryInstanceRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSecondaryInstance(
        CreateSecondaryInstanceRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateSecondaryInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates a new User in a given project, location, and cluster.
     *
     * The async variant is {@see AlloyDBAdminClient::createUserAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/create_user.php
     *
     * @param CreateUserRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return User
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createUser(CreateUserRequest $request, array $callOptions = []): User
    {
        return $this->startApiCall('CreateUser', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Backup.
     *
     * The async variant is {@see AlloyDBAdminClient::deleteBackupAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/delete_backup.php
     *
     * @param DeleteBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackup(DeleteBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteBackup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Cluster.
     *
     * The async variant is {@see AlloyDBAdminClient::deleteClusterAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/delete_cluster.php
     *
     * @param DeleteClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteCluster(DeleteClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteCluster', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Instance.
     *
     * The async variant is {@see AlloyDBAdminClient::deleteInstanceAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/delete_instance.php
     *
     * @param DeleteInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteInstance(DeleteInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteInstance', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single User.
     *
     * The async variant is {@see AlloyDBAdminClient::deleteUserAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/delete_user.php
     *
     * @param DeleteUserRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteUser(DeleteUserRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteUser', $request, $callOptions)->wait();
    }

    /**
     * Executes a SQL statement in a database inside an AlloyDB instance.
     *
     * The async variant is {@see AlloyDBAdminClient::executeSqlAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/execute_sql.php
     *
     * @param ExecuteSqlRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExecuteSqlResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function executeSql(ExecuteSqlRequest $request, array $callOptions = []): ExecuteSqlResponse
    {
        return $this->startApiCall('ExecuteSql', $request, $callOptions)->wait();
    }

    /**
     * Forces a Failover for a highly available instance.
     * Failover promotes the HA standby instance as the new primary.
     * Imperative only.
     *
     * The async variant is {@see AlloyDBAdminClient::failoverInstanceAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/failover_instance.php
     *
     * @param FailoverInstanceRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function failoverInstance(FailoverInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('FailoverInstance', $request, $callOptions)->wait();
    }

    /**
     * Generate a client certificate signed by a Cluster CA.
     * The sole purpose of this endpoint is to support AlloyDB connectors and the
     * Auth Proxy client. The endpoint's behavior is subject to change without
     * notice, so do not rely on its behavior remaining constant. Future changes
     * will not break AlloyDB connectors or the Auth Proxy client.
     *
     * The async variant is {@see AlloyDBAdminClient::generateClientCertificateAsync()}
     * .
     *
     * @example samples/V1/AlloyDBAdminClient/generate_client_certificate.php
     *
     * @param GenerateClientCertificateRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GenerateClientCertificateResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateClientCertificate(
        GenerateClientCertificateRequest $request,
        array $callOptions = []
    ): GenerateClientCertificateResponse {
        return $this->startApiCall('GenerateClientCertificate', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Backup.
     *
     * The async variant is {@see AlloyDBAdminClient::getBackupAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/get_backup.php
     *
     * @param GetBackupRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackup(GetBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('GetBackup', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Cluster.
     *
     * The async variant is {@see AlloyDBAdminClient::getClusterAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/get_cluster.php
     *
     * @param GetClusterRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Cluster
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getCluster(GetClusterRequest $request, array $callOptions = []): Cluster
    {
        return $this->startApiCall('GetCluster', $request, $callOptions)->wait();
    }

    /**
     * Get instance metadata used for a connection.
     *
     * The async variant is {@see AlloyDBAdminClient::getConnectionInfoAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/get_connection_info.php
     *
     * @param GetConnectionInfoRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ConnectionInfo
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getConnectionInfo(GetConnectionInfoRequest $request, array $callOptions = []): ConnectionInfo
    {
        return $this->startApiCall('GetConnectionInfo', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Instance.
     *
     * The async variant is {@see AlloyDBAdminClient::getInstanceAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/get_instance.php
     *
     * @param GetInstanceRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Instance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getInstance(GetInstanceRequest $request, array $callOptions = []): Instance
    {
        return $this->startApiCall('GetInstance', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single User.
     *
     * The async variant is {@see AlloyDBAdminClient::getUserAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/get_user.php
     *
     * @param GetUserRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return User
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getUser(GetUserRequest $request, array $callOptions = []): User
    {
        return $this->startApiCall('GetUser', $request, $callOptions)->wait();
    }

    /**
     * Injects fault in an instance.
     * Imperative only.
     *
     * The async variant is {@see AlloyDBAdminClient::injectFaultAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/inject_fault.php
     *
     * @param InjectFaultRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function injectFault(InjectFaultRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('InjectFault', $request, $callOptions)->wait();
    }

    /**
     * Lists Backups in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::listBackupsAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/list_backups.php
     *
     * @param ListBackupsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackups(ListBackupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackups', $request, $callOptions);
    }

    /**
     * Lists Clusters in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::listClustersAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/list_clusters.php
     *
     * @param ListClustersRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listClusters(ListClustersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListClusters', $request, $callOptions);
    }

    /**
     * Lists Databases in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::listDatabasesAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/list_databases.php
     *
     * @param ListDatabasesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatabases(ListDatabasesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDatabases', $request, $callOptions);
    }

    /**
     * Lists Instances in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::listInstancesAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/list_instances.php
     *
     * @param ListInstancesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listInstances(ListInstancesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListInstances', $request, $callOptions);
    }

    /**
     * Lists SupportedDatabaseFlags for a given project and location.
     *
     * The async variant is
     * {@see AlloyDBAdminClient::listSupportedDatabaseFlagsAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/list_supported_database_flags.php
     *
     * @param ListSupportedDatabaseFlagsRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSupportedDatabaseFlags(
        ListSupportedDatabaseFlagsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListSupportedDatabaseFlags', $request, $callOptions);
    }

    /**
     * Lists Users in a given project and location.
     *
     * The async variant is {@see AlloyDBAdminClient::listUsersAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/list_users.php
     *
     * @param ListUsersRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listUsers(ListUsersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListUsers', $request, $callOptions);
    }

    /**
     * Promotes a SECONDARY cluster. This turns down replication
     * from the PRIMARY cluster and promotes a secondary cluster
     * into its own standalone cluster.
     * Imperative only.
     *
     * The async variant is {@see AlloyDBAdminClient::promoteClusterAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/promote_cluster.php
     *
     * @param PromoteClusterRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function promoteCluster(PromoteClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('PromoteCluster', $request, $callOptions)->wait();
    }

    /**
     * Restart an Instance in a cluster.
     * Imperative only.
     *
     * The async variant is {@see AlloyDBAdminClient::restartInstanceAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/restart_instance.php
     *
     * @param RestartInstanceRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restartInstance(RestartInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestartInstance', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Cluster in a given project and location, with a volume
     * restored from the provided source, either a backup ID or a point-in-time
     * and a source cluster.
     *
     * The async variant is {@see AlloyDBAdminClient::restoreClusterAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/restore_cluster.php
     *
     * @param RestoreClusterRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreCluster(RestoreClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreCluster', $request, $callOptions)->wait();
    }

    /**
     * Switches the roles of PRIMARY and SECONDARY clusters without any data loss.
     * This promotes the SECONDARY cluster to PRIMARY and sets up the original
     * PRIMARY cluster to replicate from this newly promoted cluster.
     *
     * The async variant is {@see AlloyDBAdminClient::switchoverClusterAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/switchover_cluster.php
     *
     * @param SwitchoverClusterRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function switchoverCluster(SwitchoverClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('SwitchoverCluster', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Backup.
     *
     * The async variant is {@see AlloyDBAdminClient::updateBackupAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/update_backup.php
     *
     * @param UpdateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackup(UpdateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateBackup', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Cluster.
     *
     * The async variant is {@see AlloyDBAdminClient::updateClusterAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/update_cluster.php
     *
     * @param UpdateClusterRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateCluster(UpdateClusterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateCluster', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single Instance.
     *
     * The async variant is {@see AlloyDBAdminClient::updateInstanceAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/update_instance.php
     *
     * @param UpdateInstanceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateInstance(UpdateInstanceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateInstance', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single User.
     *
     * The async variant is {@see AlloyDBAdminClient::updateUserAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/update_user.php
     *
     * @param UpdateUserRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return User
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateUser(UpdateUserRequest $request, array $callOptions = []): User
    {
        return $this->startApiCall('UpdateUser', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see AlloyDBAdminClient::getLocationAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see AlloyDBAdminClient::listLocationsAsync()} .
     *
     * @example samples/V1/AlloyDBAdminClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
