<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/spanner/admin/database/v1/spanner_database_admin.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Spanner\Admin\Database\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\InsecureCredentialsWrapper;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Spanner\Admin\Database\V1\Backup;
use Google\Cloud\Spanner\Admin\Database\V1\CopyBackupMetadata;
use Google\Cloud\Spanner\Admin\Database\V1\CopyBackupRequest;
use Google\Cloud\Spanner\Admin\Database\V1\CreateBackupMetadata;
use Google\Cloud\Spanner\Admin\Database\V1\CreateBackupRequest;
use Google\Cloud\Spanner\Admin\Database\V1\CreateDatabaseMetadata;
use Google\Cloud\Spanner\Admin\Database\V1\CreateDatabaseRequest;
use Google\Cloud\Spanner\Admin\Database\V1\Database;
use Google\Cloud\Spanner\Admin\Database\V1\DeleteBackupRequest;
use Google\Cloud\Spanner\Admin\Database\V1\DropDatabaseRequest;
use Google\Cloud\Spanner\Admin\Database\V1\GetBackupRequest;
use Google\Cloud\Spanner\Admin\Database\V1\GetDatabaseDdlRequest;
use Google\Cloud\Spanner\Admin\Database\V1\GetDatabaseDdlResponse;
use Google\Cloud\Spanner\Admin\Database\V1\GetDatabaseRequest;
use Google\Cloud\Spanner\Admin\Database\V1\ListBackupOperationsRequest;
use Google\Cloud\Spanner\Admin\Database\V1\ListBackupsRequest;
use Google\Cloud\Spanner\Admin\Database\V1\ListDatabaseOperationsRequest;
use Google\Cloud\Spanner\Admin\Database\V1\ListDatabaseRolesRequest;
use Google\Cloud\Spanner\Admin\Database\V1\ListDatabasesRequest;
use Google\Cloud\Spanner\Admin\Database\V1\RestoreDatabaseMetadata;
use Google\Cloud\Spanner\Admin\Database\V1\RestoreDatabaseRequest;
use Google\Cloud\Spanner\Admin\Database\V1\UpdateBackupRequest;
use Google\Cloud\Spanner\Admin\Database\V1\UpdateDatabaseDdlMetadata;
use Google\Cloud\Spanner\Admin\Database\V1\UpdateDatabaseDdlRequest;
use Google\Cloud\Spanner\Admin\Database\V1\UpdateDatabaseMetadata;
use Google\Cloud\Spanner\Admin\Database\V1\UpdateDatabaseRequest;
use Google\LongRunning\Operation;
use Grpc\ChannelCredentials;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Cloud Spanner Database Admin API
 *
 * The Cloud Spanner Database Admin API can be used to:
 * * create, drop, and list databases
 * * update the schema of pre-existing databases
 * * create, delete, copy and list backups for a database
 * * restore a database from an existing backup
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface copyBackupAsync(CopyBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createBackupAsync(CreateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createDatabaseAsync(CreateDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteBackupAsync(DeleteBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface dropDatabaseAsync(DropDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getBackupAsync(GetBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDatabaseAsync(GetDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getDatabaseDdlAsync(GetDatabaseDdlRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBackupOperationsAsync(ListBackupOperationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listBackupsAsync(ListBackupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDatabaseOperationsAsync(ListDatabaseOperationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDatabaseRolesAsync(ListDatabaseRolesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listDatabasesAsync(ListDatabasesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface restoreDatabaseAsync(RestoreDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateBackupAsync(UpdateBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDatabaseAsync(UpdateDatabaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateDatabaseDdlAsync(UpdateDatabaseDdlRequest $request, array $optionalArgs = [])
 */
final class DatabaseAdminClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.spanner.admin.database.v1.DatabaseAdmin';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'spanner.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'spanner.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/spanner.admin',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/database_admin_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/database_admin_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/database_admin_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/database_admin_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName(string $project, string $instance, string $backup): string
    {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'instance' => $instance,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a crypto_key
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     *
     * @return string The formatted crypto_key resource.
     */
    public static function cryptoKeyName(string $project, string $location, string $keyRing, string $cryptoKey): string
    {
        return self::getPathTemplate('cryptoKey')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * crypto_key_version resource.
     *
     * @param string $project
     * @param string $location
     * @param string $keyRing
     * @param string $cryptoKey
     * @param string $cryptoKeyVersion
     *
     * @return string The formatted crypto_key_version resource.
     */
    public static function cryptoKeyVersionName(string $project, string $location, string $keyRing, string $cryptoKey, string $cryptoKeyVersion): string
    {
        return self::getPathTemplate('cryptoKeyVersion')->render([
            'project' => $project,
            'location' => $location,
            'key_ring' => $keyRing,
            'crypto_key' => $cryptoKey,
            'crypto_key_version' => $cryptoKeyVersion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a database
     * resource.
     *
     * @param string $project
     * @param string $instance
     * @param string $database
     *
     * @return string The formatted database resource.
     */
    public static function databaseName(string $project, string $instance, string $database): string
    {
        return self::getPathTemplate('database')->render([
            'project' => $project,
            'instance' => $instance,
            'database' => $database,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'instance' => $instance,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/instances/{instance}/backups/{backup}
     * - cryptoKey: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}
     * - cryptoKeyVersion: projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}/cryptoKeyVersions/{crypto_key_version}
     * - database: projects/{project}/instances/{instance}/databases/{database}
     * - instance: projects/{project}/instances/{instance}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * Setting the "SPANNER_EMULATOR_HOST" environment variable will automatically set
     * the API Endpoint to the value specified in the variable, as well as ensure that
     * empty credentials are used in the transport layer.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'spanner.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $options = $this->setDefaultEmulatorConfig($options);
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Starts copying a Cloud Spanner Backup.
     * The returned backup [long-running operation][google.longrunning.Operation]
     * will have a name of the format
     * `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
     * and can be used to track copying of the backup. The operation is associated
     * with the destination backup.
     * The [metadata][google.longrunning.Operation.metadata] field type is
     * [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
     * The [response][google.longrunning.Operation.response] field type is
     * [Backup][google.spanner.admin.database.v1.Backup], if successful.
     * Cancelling the returned operation will stop the copying and delete the
     * destination backup. Concurrent CopyBackup requests can run on the same
     * source backup.
     *
     * The async variant is {@see DatabaseAdminClient::copyBackupAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/copy_backup.php
     *
     * @param CopyBackupRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function copyBackup(CopyBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CopyBackup', $request, $callOptions)->wait();
    }

    /**
     * Starts creating a new Cloud Spanner Backup.
     * The returned backup [long-running operation][google.longrunning.Operation]
     * will have a name of the format
     * `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
     * and can be used to track creation of the backup. The
     * [metadata][google.longrunning.Operation.metadata] field type is
     * [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
     * The [response][google.longrunning.Operation.response] field type is
     * [Backup][google.spanner.admin.database.v1.Backup], if successful.
     * Cancelling the returned operation will stop the creation and delete the
     * backup. There can be only one pending backup creation per database. Backup
     * creation of different databases can run concurrently.
     *
     * The async variant is {@see DatabaseAdminClient::createBackupAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/create_backup.php
     *
     * @param CreateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createBackup(CreateBackupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateBackup', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Cloud Spanner database and starts to prepare it for serving.
     * The returned [long-running operation][google.longrunning.Operation] will
     * have a name of the format `<database_name>/operations/<operation_id>` and
     * can be used to track preparation of the database. The
     * [metadata][google.longrunning.Operation.metadata] field type is
     * [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata].
     * The [response][google.longrunning.Operation.response] field type is
     * [Database][google.spanner.admin.database.v1.Database], if successful.
     *
     * The async variant is {@see DatabaseAdminClient::createDatabaseAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/create_database.php
     *
     * @param CreateDatabaseRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDatabase(CreateDatabaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDatabase', $request, $callOptions)->wait();
    }

    /**
     * Deletes a pending or completed
     * [Backup][google.spanner.admin.database.v1.Backup].
     *
     * The async variant is {@see DatabaseAdminClient::deleteBackupAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/delete_backup.php
     *
     * @param DeleteBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteBackup(DeleteBackupRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteBackup', $request, $callOptions)->wait();
    }

    /**
     * Drops (aka deletes) a Cloud Spanner database.
     * Completed backups for the database will be retained according to their
     * `expire_time`.
     * Note: Cloud Spanner might continue to accept requests for a few seconds
     * after the database has been deleted.
     *
     * The async variant is {@see DatabaseAdminClient::dropDatabaseAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/drop_database.php
     *
     * @param DropDatabaseRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function dropDatabase(DropDatabaseRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DropDatabase', $request, $callOptions)->wait();
    }

    /**
     * Gets metadata on a pending or completed
     * [Backup][google.spanner.admin.database.v1.Backup].
     *
     * The async variant is {@see DatabaseAdminClient::getBackupAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/get_backup.php
     *
     * @param GetBackupRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getBackup(GetBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('GetBackup', $request, $callOptions)->wait();
    }

    /**
     * Gets the state of a Cloud Spanner database.
     *
     * The async variant is {@see DatabaseAdminClient::getDatabaseAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/get_database.php
     *
     * @param GetDatabaseRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Database
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDatabase(GetDatabaseRequest $request, array $callOptions = []): Database
    {
        return $this->startApiCall('GetDatabase', $request, $callOptions)->wait();
    }

    /**
     * Returns the schema of a Cloud Spanner database as a list of formatted
     * DDL statements. This method does not show pending schema updates, those may
     * be queried using the [Operations][google.longrunning.Operations] API.
     *
     * The async variant is {@see DatabaseAdminClient::getDatabaseDdlAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/get_database_ddl.php
     *
     * @param GetDatabaseDdlRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GetDatabaseDdlResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDatabaseDdl(GetDatabaseDdlRequest $request, array $callOptions = []): GetDatabaseDdlResponse
    {
        return $this->startApiCall('GetDatabaseDdl', $request, $callOptions)->wait();
    }

    /**
     * Gets the access control policy for a database or backup resource.
     * Returns an empty policy if a database or backup exists but does not have a
     * policy set.
     *
     * Authorization requires `spanner.databases.getIamPolicy` permission on
     * [resource][google.iam.v1.GetIamPolicyRequest.resource].
     * For backups, authorization requires `spanner.backups.getIamPolicy`
     * permission on [resource][google.iam.v1.GetIamPolicyRequest.resource].
     *
     * The async variant is {@see DatabaseAdminClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Lists the backup [long-running operations][google.longrunning.Operation] in
     * the given instance. A backup operation has a name of the form
     * `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation>`.
     * The long-running operation
     * [metadata][google.longrunning.Operation.metadata] field type
     * `metadata.type_url` describes the type of the metadata. Operations returned
     * include those that have completed/failed/canceled within the last 7 days,
     * and pending operations. Operations returned are ordered by
     * `operation.metadata.value.progress.start_time` in descending order starting
     * from the most recently started operation.
     *
     * The async variant is {@see DatabaseAdminClient::listBackupOperationsAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/list_backup_operations.php
     *
     * @param ListBackupOperationsRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackupOperations(ListBackupOperationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackupOperations', $request, $callOptions);
    }

    /**
     * Lists completed and pending backups.
     * Backups returned are ordered by `create_time` in descending order,
     * starting from the most recent `create_time`.
     *
     * The async variant is {@see DatabaseAdminClient::listBackupsAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/list_backups.php
     *
     * @param ListBackupsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listBackups(ListBackupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListBackups', $request, $callOptions);
    }

    /**
     * Lists database [longrunning-operations][google.longrunning.Operation].
     * A database operation has a name of the form
     * `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`.
     * The long-running operation
     * [metadata][google.longrunning.Operation.metadata] field type
     * `metadata.type_url` describes the type of the metadata. Operations returned
     * include those that have completed/failed/canceled within the last 7 days,
     * and pending operations.
     *
     * The async variant is {@see DatabaseAdminClient::listDatabaseOperationsAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/list_database_operations.php
     *
     * @param ListDatabaseOperationsRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatabaseOperations(ListDatabaseOperationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDatabaseOperations', $request, $callOptions);
    }

    /**
     * Lists Cloud Spanner database roles.
     *
     * The async variant is {@see DatabaseAdminClient::listDatabaseRolesAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/list_database_roles.php
     *
     * @param ListDatabaseRolesRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatabaseRoles(ListDatabaseRolesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDatabaseRoles', $request, $callOptions);
    }

    /**
     * Lists Cloud Spanner databases.
     *
     * The async variant is {@see DatabaseAdminClient::listDatabasesAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/list_databases.php
     *
     * @param ListDatabasesRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDatabases(ListDatabasesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDatabases', $request, $callOptions);
    }

    /**
     * Create a new database by restoring from a completed backup. The new
     * database must be in the same project and in an instance with the same
     * instance configuration as the instance containing
     * the backup. The returned database [long-running
     * operation][google.longrunning.Operation] has a name of the format
     * `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`,
     * and can be used to track the progress of the operation, and to cancel it.
     * The [metadata][google.longrunning.Operation.metadata] field type is
     * [RestoreDatabaseMetadata][google.spanner.admin.database.v1.RestoreDatabaseMetadata].
     * The [response][google.longrunning.Operation.response] type
     * is [Database][google.spanner.admin.database.v1.Database], if
     * successful. Cancelling the returned operation will stop the restore and
     * delete the database.
     * There can be only one database being restored into an instance at a time.
     * Once the restore operation completes, a new restore operation can be
     * initiated, without waiting for the optimize operation associated with the
     * first restore to complete.
     *
     * The async variant is {@see DatabaseAdminClient::restoreDatabaseAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/restore_database.php
     *
     * @param RestoreDatabaseRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreDatabase(RestoreDatabaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RestoreDatabase', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on a database or backup resource.
     * Replaces any existing policy.
     *
     * Authorization requires `spanner.databases.setIamPolicy`
     * permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
     * For backups, authorization requires `spanner.backups.setIamPolicy`
     * permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
     *
     * The async variant is {@see DatabaseAdminClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that the caller has on the specified database or backup
     * resource.
     *
     * Attempting this RPC on a non-existent Cloud Spanner database will
     * result in a NOT_FOUND error if the user has
     * `spanner.databases.list` permission on the containing Cloud
     * Spanner instance. Otherwise returns an empty set of permissions.
     * Calling this method on a backup that does not exist will
     * result in a NOT_FOUND error if the user has
     * `spanner.backups.list` permission on the containing instance.
     *
     * The async variant is {@see DatabaseAdminClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates a pending or completed
     * [Backup][google.spanner.admin.database.v1.Backup].
     *
     * The async variant is {@see DatabaseAdminClient::updateBackupAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/update_backup.php
     *
     * @param UpdateBackupRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Backup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateBackup(UpdateBackupRequest $request, array $callOptions = []): Backup
    {
        return $this->startApiCall('UpdateBackup', $request, $callOptions)->wait();
    }

    /**
     * Updates a Cloud Spanner database. The returned
     * [long-running operation][google.longrunning.Operation] can be used to track
     * the progress of updating the database. If the named database does not
     * exist, returns `NOT_FOUND`.
     *
     * While the operation is pending:
     *
     * * The database's
     * [reconciling][google.spanner.admin.database.v1.Database.reconciling]
     * field is set to true.
     * * Cancelling the operation is best-effort. If the cancellation succeeds,
     * the operation metadata's
     * [cancel_time][google.spanner.admin.database.v1.UpdateDatabaseMetadata.cancel_time]
     * is set, the updates are reverted, and the operation terminates with a
     * `CANCELLED` status.
     * * New UpdateDatabase requests will return a `FAILED_PRECONDITION` error
     * until the pending operation is done (returns successfully or with
     * error).
     * * Reading the database via the API continues to give the pre-request
     * values.
     *
     * Upon completion of the returned operation:
     *
     * * The new values are in effect and readable via the API.
     * * The database's
     * [reconciling][google.spanner.admin.database.v1.Database.reconciling]
     * field becomes false.
     *
     * The returned [long-running operation][google.longrunning.Operation] will
     * have a name of the format
     * `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`
     * and can be used to track the database modification. The
     * [metadata][google.longrunning.Operation.metadata] field type is
     * [UpdateDatabaseMetadata][google.spanner.admin.database.v1.UpdateDatabaseMetadata].
     * The [response][google.longrunning.Operation.response] field type is
     * [Database][google.spanner.admin.database.v1.Database], if successful.
     *
     * The async variant is {@see DatabaseAdminClient::updateDatabaseAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/update_database.php
     *
     * @param UpdateDatabaseRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDatabase(UpdateDatabaseRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDatabase', $request, $callOptions)->wait();
    }

    /**
     * Updates the schema of a Cloud Spanner database by
     * creating/altering/dropping tables, columns, indexes, etc. The returned
     * [long-running operation][google.longrunning.Operation] will have a name of
     * the format `<database_name>/operations/<operation_id>` and can be used to
     * track execution of the schema change(s). The
     * [metadata][google.longrunning.Operation.metadata] field type is
     * [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].
     * The operation has no response.
     *
     * The async variant is {@see DatabaseAdminClient::updateDatabaseDdlAsync()} .
     *
     * @example samples/V1/DatabaseAdminClient/update_database_ddl.php
     *
     * @param UpdateDatabaseDdlRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDatabaseDdl(UpdateDatabaseDdlRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDatabaseDdl', $request, $callOptions)->wait();
    }

    /** Configure the gapic configuration to use a service emulator. */
    private function setDefaultEmulatorConfig(array $options): array
    {
        $emulatorHost = getenv('SPANNER_EMULATOR_HOST');
        if (empty($emulatorHost)) {
            return $options;
        }

        if ($scheme = parse_url($emulatorHost, PHP_URL_SCHEME)) {
            $search = $scheme . '://';
            $emulatorHost = str_replace($search, '', $emulatorHost);
        }

        $options['apiEndpoint'] ??= $emulatorHost;
        $options['transportConfig']['grpc']['stubOpts']['credentials'] ??= ChannelCredentials::createInsecure();
        $options['credentials'] ??= new InsecureCredentialsWrapper();
        return $options;
    }
}
