<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/task_template.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * TaskTemplate describes the data a task should have when created
 * from a template.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.TaskTemplate</code>
 */
class TaskTemplate extends \Google\Protobuf\Internal\Message
{
    /**
     * Holds the single container that defines the unit of execution for this
     * task.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     */
    private $containers;
    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     */
    private $volumes;
    /**
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 4;</code>
     */
    protected $timeout = null;
    /**
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     *
     * Generated from protobuf field <code>string service_account = 5;</code>
     */
    protected $service_account = '';
    /**
     * The execution environment being used to host this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
     */
    protected $execution_environment = 0;
    /**
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 7 [(.google.api.resource_reference) = {</code>
     */
    protected $encryption_key = '';
    /**
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     */
    protected $vpc_access = null;
    protected $retries;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type array<\Google\Cloud\Run\V2\Container>|\Google\Protobuf\Internal\RepeatedField $containers
     *           Holds the single container that defines the unit of execution for this
     *           task.
     *     @type array<\Google\Cloud\Run\V2\Volume>|\Google\Protobuf\Internal\RepeatedField $volumes
     *           A list of Volumes to make available to containers.
     *     @type int $max_retries
     *           Number of retries allowed per Task, before marking this Task failed.
     *           Defaults to 3.
     *     @type \Google\Protobuf\Duration $timeout
     *           Max allowed time duration the Task may be active before the system will
     *           actively try to mark it failed and kill associated containers. This applies
     *           per attempt of a task, meaning each retry can run for the full timeout.
     *           Defaults to 600 seconds.
     *     @type string $service_account
     *           Email address of the IAM service account associated with the Task of a
     *           Job. The service account represents the identity of the
     *           running task, and determines what permissions the task has. If
     *           not provided, the task will use the project's default service account.
     *     @type int $execution_environment
     *           The execution environment being used to host this Task.
     *     @type string $encryption_key
     *           A reference to a customer managed encryption key (CMEK) to use to encrypt
     *           this container image. For more information, go to
     *           https://cloud.google.com/run/docs/securing/using-cmek
     *     @type \Google\Cloud\Run\V2\VpcAccess $vpc_access
     *           VPC Access configuration to use for this Task. For more information,
     *           visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\TaskTemplate::initOnce();
        parent::__construct($data);
    }

    /**
     * Holds the single container that defines the unit of execution for this
     * task.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContainers()
    {
        return $this->containers;
    }

    /**
     * Holds the single container that defines the unit of execution for this
     * task.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 1;</code>
     * @param array<\Google\Cloud\Run\V2\Container>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContainers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Container::class);
        $this->containers = $arr;

        return $this;
    }

    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVolumes()
    {
        return $this->volumes;
    }

    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 2;</code>
     * @param array<\Google\Cloud\Run\V2\Volume>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVolumes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Volume::class);
        $this->volumes = $arr;

        return $this;
    }

    /**
     * Number of retries allowed per Task, before marking this Task failed.
     * Defaults to 3.
     *
     * Generated from protobuf field <code>int32 max_retries = 3;</code>
     * @return int
     */
    public function getMaxRetries()
    {
        return $this->readOneof(3);
    }

    public function hasMaxRetries()
    {
        return $this->hasOneof(3);
    }

    /**
     * Number of retries allowed per Task, before marking this Task failed.
     * Defaults to 3.
     *
     * Generated from protobuf field <code>int32 max_retries = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxRetries($var)
    {
        GPBUtil::checkInt32($var);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 4;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTimeout()
    {
        return $this->timeout;
    }

    public function hasTimeout()
    {
        return isset($this->timeout);
    }

    public function clearTimeout()
    {
        unset($this->timeout);
    }

    /**
     * Max allowed time duration the Task may be active before the system will
     * actively try to mark it failed and kill associated containers. This applies
     * per attempt of a task, meaning each retry can run for the full timeout.
     * Defaults to 600 seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration timeout = 4;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->timeout = $var;

        return $this;
    }

    /**
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     *
     * Generated from protobuf field <code>string service_account = 5;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Email address of the IAM service account associated with the Task of a
     * Job. The service account represents the identity of the
     * running task, and determines what permissions the task has. If
     * not provided, the task will use the project's default service account.
     *
     * Generated from protobuf field <code>string service_account = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * The execution environment being used to host this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
     * @return int
     */
    public function getExecutionEnvironment()
    {
        return $this->execution_environment;
    }

    /**
     * The execution environment being used to host this Task.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.ExecutionEnvironment execution_environment = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setExecutionEnvironment($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Run\V2\ExecutionEnvironment::class);
        $this->execution_environment = $var;

        return $this;
    }

    /**
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 7 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEncryptionKey()
    {
        return $this->encryption_key;
    }

    /**
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 7 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEncryptionKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->encryption_key = $var;

        return $this;
    }

    /**
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     * @return \Google\Cloud\Run\V2\VpcAccess|null
     */
    public function getVpcAccess()
    {
        return $this->vpc_access;
    }

    public function hasVpcAccess()
    {
        return isset($this->vpc_access);
    }

    public function clearVpcAccess()
    {
        unset($this->vpc_access);
    }

    /**
     * VPC Access configuration to use for this Task. For more information,
     * visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 8;</code>
     * @param \Google\Cloud\Run\V2\VpcAccess $var
     * @return $this
     */
    public function setVpcAccess($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\VpcAccess::class);
        $this->vpc_access = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getRetries()
    {
        return $this->whichOneof("retries");
    }

}

