<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/fleetengine/delivery/v1/common.proto

namespace Google\Maps\FleetEngine\Delivery\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The location, speed, and heading of a vehicle at a point in time.
 *
 * Generated from protobuf message <code>maps.fleetengine.delivery.v1.DeliveryVehicleLocation</code>
 */
class DeliveryVehicleLocation extends \Google\Protobuf\Internal\Message
{
    /**
     * The location of the vehicle.
     * When it is sent to Fleet Engine, the vehicle's location is a GPS location.
     * When you receive it in a response, the vehicle's location can be either a
     * GPS location, a supplemental location, or some other estimated location.
     * The source is specified in `location_sensor`.
     *
     * Generated from protobuf field <code>.google.type.LatLng location = 1;</code>
     */
    protected $location = null;
    /**
     * Deprecated: Use `latlng_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue horizontal_accuracy = 8 [deprecated = true];</code>
     * @deprecated
     */
    protected $horizontal_accuracy = null;
    /**
     * Accuracy of `location` in meters as a radius.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue latlng_accuracy = 22;</code>
     */
    protected $latlng_accuracy = null;
    /**
     * Direction the vehicle is moving in degrees.  0 represents North.
     * The valid range is [0,360).
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value heading = 2;</code>
     */
    protected $heading = null;
    /**
     * Deprecated: Use `heading_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue bearing_accuracy = 10 [deprecated = true];</code>
     * @deprecated
     */
    protected $bearing_accuracy = null;
    /**
     * Accuracy of `heading` in degrees.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue heading_accuracy = 23;</code>
     */
    protected $heading_accuracy = null;
    /**
     * Altitude in meters above WGS84.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude = 5;</code>
     */
    protected $altitude = null;
    /**
     * Deprecated: Use `altitude_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue vertical_accuracy = 9 [deprecated = true];</code>
     * @deprecated
     */
    protected $vertical_accuracy = null;
    /**
     * Accuracy of `altitude` in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude_accuracy = 24;</code>
     */
    protected $altitude_accuracy = null;
    /**
     * Speed of the vehicle in kilometers per hour.
     * Deprecated: Use `speed` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value speed_kmph = 3 [deprecated = true];</code>
     * @deprecated
     */
    protected $speed_kmph = null;
    /**
     * Speed of the vehicle in meters/second
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed = 6;</code>
     */
    protected $speed = null;
    /**
     * Accuracy of `speed` in meters/second.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed_accuracy = 7;</code>
     */
    protected $speed_accuracy = null;
    /**
     * The time when `location` was reported by the sensor according to the
     * sensor's clock.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4;</code>
     */
    protected $update_time = null;
    /**
     * Output only. The time when the server received the location information.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp server_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $server_time = null;
    /**
     * Provider of location data (for example, `GPS`).
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor location_sensor = 11;</code>
     */
    protected $location_sensor = 0;
    /**
     * Whether `location` is snapped to a road.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_road_snapped = 27;</code>
     */
    protected $is_road_snapped = null;
    /**
     * Input only. Indicates whether the GPS sensor is enabled on the mobile
     * device.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_gps_sensor_enabled = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $is_gps_sensor_enabled = null;
    /**
     * Input only. Time (in seconds) since this location was first sent to the
     * server. This will be zero for the first update. If the time is unknown (for
     * example, when the app restarts), this value resets to zero.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value time_since_update = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $time_since_update = null;
    /**
     * Input only. Deprecated: Other signals are now used to determine if a
     * location is stale.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value num_stale_updates = 15 [deprecated = true, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @deprecated
     */
    protected $num_stale_updates = null;
    /**
     * Raw vehicle location (unprocessed by road-snapper).
     *
     * Generated from protobuf field <code>.google.type.LatLng raw_location = 16;</code>
     */
    protected $raw_location = null;
    /**
     * Timestamp associated with the raw location.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp raw_location_time = 17;</code>
     */
    protected $raw_location_time = null;
    /**
     * Source of the raw location. Defaults to `GPS`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor raw_location_sensor = 28;</code>
     */
    protected $raw_location_sensor = 0;
    /**
     * Accuracy of `raw_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue raw_location_accuracy = 25;</code>
     */
    protected $raw_location_accuracy = null;
    /**
     * Supplemental location provided by the integrating app.
     *
     * Generated from protobuf field <code>.google.type.LatLng supplemental_location = 18;</code>
     */
    protected $supplemental_location = null;
    /**
     * Timestamp associated with the supplemental location.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp supplemental_location_time = 19;</code>
     */
    protected $supplemental_location_time = null;
    /**
     * Source of the supplemental location. Defaults to
     * `CUSTOMER_SUPPLIED_LOCATION`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor supplemental_location_sensor = 20;</code>
     */
    protected $supplemental_location_sensor = 0;
    /**
     * Accuracy of `supplemental_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue supplemental_location_accuracy = 21;</code>
     */
    protected $supplemental_location_accuracy = null;
    /**
     * Deprecated: Use `is_road_snapped` instead.
     *
     * Generated from protobuf field <code>bool road_snapped = 26 [deprecated = true];</code>
     * @deprecated
     */
    protected $road_snapped = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Type\LatLng $location
     *           The location of the vehicle.
     *           When it is sent to Fleet Engine, the vehicle's location is a GPS location.
     *           When you receive it in a response, the vehicle's location can be either a
     *           GPS location, a supplemental location, or some other estimated location.
     *           The source is specified in `location_sensor`.
     *     @type \Google\Protobuf\DoubleValue $horizontal_accuracy
     *           Deprecated: Use `latlng_accuracy` instead.
     *     @type \Google\Protobuf\DoubleValue $latlng_accuracy
     *           Accuracy of `location` in meters as a radius.
     *     @type \Google\Protobuf\Int32Value $heading
     *           Direction the vehicle is moving in degrees.  0 represents North.
     *           The valid range is [0,360).
     *     @type \Google\Protobuf\DoubleValue $bearing_accuracy
     *           Deprecated: Use `heading_accuracy` instead.
     *     @type \Google\Protobuf\DoubleValue $heading_accuracy
     *           Accuracy of `heading` in degrees.
     *     @type \Google\Protobuf\DoubleValue $altitude
     *           Altitude in meters above WGS84.
     *     @type \Google\Protobuf\DoubleValue $vertical_accuracy
     *           Deprecated: Use `altitude_accuracy` instead.
     *     @type \Google\Protobuf\DoubleValue $altitude_accuracy
     *           Accuracy of `altitude` in meters.
     *     @type \Google\Protobuf\Int32Value $speed_kmph
     *           Speed of the vehicle in kilometers per hour.
     *           Deprecated: Use `speed` instead.
     *     @type \Google\Protobuf\DoubleValue $speed
     *           Speed of the vehicle in meters/second
     *     @type \Google\Protobuf\DoubleValue $speed_accuracy
     *           Accuracy of `speed` in meters/second.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           The time when `location` was reported by the sensor according to the
     *           sensor's clock.
     *     @type \Google\Protobuf\Timestamp $server_time
     *           Output only. The time when the server received the location information.
     *     @type int $location_sensor
     *           Provider of location data (for example, `GPS`).
     *     @type \Google\Protobuf\BoolValue $is_road_snapped
     *           Whether `location` is snapped to a road.
     *     @type \Google\Protobuf\BoolValue $is_gps_sensor_enabled
     *           Input only. Indicates whether the GPS sensor is enabled on the mobile
     *           device.
     *     @type \Google\Protobuf\Int32Value $time_since_update
     *           Input only. Time (in seconds) since this location was first sent to the
     *           server. This will be zero for the first update. If the time is unknown (for
     *           example, when the app restarts), this value resets to zero.
     *     @type \Google\Protobuf\Int32Value $num_stale_updates
     *           Input only. Deprecated: Other signals are now used to determine if a
     *           location is stale.
     *     @type \Google\Type\LatLng $raw_location
     *           Raw vehicle location (unprocessed by road-snapper).
     *     @type \Google\Protobuf\Timestamp $raw_location_time
     *           Timestamp associated with the raw location.
     *     @type int $raw_location_sensor
     *           Source of the raw location. Defaults to `GPS`.
     *     @type \Google\Protobuf\DoubleValue $raw_location_accuracy
     *           Accuracy of `raw_location` as a radius, in meters.
     *     @type \Google\Type\LatLng $supplemental_location
     *           Supplemental location provided by the integrating app.
     *     @type \Google\Protobuf\Timestamp $supplemental_location_time
     *           Timestamp associated with the supplemental location.
     *     @type int $supplemental_location_sensor
     *           Source of the supplemental location. Defaults to
     *           `CUSTOMER_SUPPLIED_LOCATION`.
     *     @type \Google\Protobuf\DoubleValue $supplemental_location_accuracy
     *           Accuracy of `supplemental_location` as a radius, in meters.
     *     @type bool $road_snapped
     *           Deprecated: Use `is_road_snapped` instead.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Fleetengine\Delivery\V1\Common::initOnce();
        parent::__construct($data);
    }

    /**
     * The location of the vehicle.
     * When it is sent to Fleet Engine, the vehicle's location is a GPS location.
     * When you receive it in a response, the vehicle's location can be either a
     * GPS location, a supplemental location, or some other estimated location.
     * The source is specified in `location_sensor`.
     *
     * Generated from protobuf field <code>.google.type.LatLng location = 1;</code>
     * @return \Google\Type\LatLng|null
     */
    public function getLocation()
    {
        return $this->location;
    }

    public function hasLocation()
    {
        return isset($this->location);
    }

    public function clearLocation()
    {
        unset($this->location);
    }

    /**
     * The location of the vehicle.
     * When it is sent to Fleet Engine, the vehicle's location is a GPS location.
     * When you receive it in a response, the vehicle's location can be either a
     * GPS location, a supplemental location, or some other estimated location.
     * The source is specified in `location_sensor`.
     *
     * Generated from protobuf field <code>.google.type.LatLng location = 1;</code>
     * @param \Google\Type\LatLng $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\LatLng::class);
        $this->location = $var;

        return $this;
    }

    /**
     * Deprecated: Use `latlng_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue horizontal_accuracy = 8 [deprecated = true];</code>
     * @return \Google\Protobuf\DoubleValue|null
     * @deprecated
     */
    public function getHorizontalAccuracy()
    {
        @trigger_error('horizontal_accuracy is deprecated.', E_USER_DEPRECATED);
        return $this->horizontal_accuracy;
    }

    public function hasHorizontalAccuracy()
    {
        @trigger_error('horizontal_accuracy is deprecated.', E_USER_DEPRECATED);
        return isset($this->horizontal_accuracy);
    }

    public function clearHorizontalAccuracy()
    {
        @trigger_error('horizontal_accuracy is deprecated.', E_USER_DEPRECATED);
        unset($this->horizontal_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getHorizontalAccuracy()</code>

     * Deprecated: Use `latlng_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue horizontal_accuracy = 8 [deprecated = true];</code>
     * @return float|null
     */
    public function getHorizontalAccuracyUnwrapped()
    {
        @trigger_error('horizontal_accuracy is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("horizontal_accuracy");
    }

    /**
     * Deprecated: Use `latlng_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue horizontal_accuracy = 8 [deprecated = true];</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     * @deprecated
     */
    public function setHorizontalAccuracy($var)
    {
        @trigger_error('horizontal_accuracy is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->horizontal_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Deprecated: Use `latlng_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue horizontal_accuracy = 8 [deprecated = true];</code>
     * @param float|null $var
     * @return $this
     */
    public function setHorizontalAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("horizontal_accuracy", $var);
        return $this;}

    /**
     * Accuracy of `location` in meters as a radius.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue latlng_accuracy = 22;</code>
     * @return \Google\Protobuf\DoubleValue|null
     */
    public function getLatlngAccuracy()
    {
        return $this->latlng_accuracy;
    }

    public function hasLatlngAccuracy()
    {
        return isset($this->latlng_accuracy);
    }

    public function clearLatlngAccuracy()
    {
        unset($this->latlng_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getLatlngAccuracy()</code>

     * Accuracy of `location` in meters as a radius.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue latlng_accuracy = 22;</code>
     * @return float|null
     */
    public function getLatlngAccuracyUnwrapped()
    {
        return $this->readWrapperValue("latlng_accuracy");
    }

    /**
     * Accuracy of `location` in meters as a radius.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue latlng_accuracy = 22;</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     */
    public function setLatlngAccuracy($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->latlng_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Accuracy of `location` in meters as a radius.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue latlng_accuracy = 22;</code>
     * @param float|null $var
     * @return $this
     */
    public function setLatlngAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("latlng_accuracy", $var);
        return $this;}

    /**
     * Direction the vehicle is moving in degrees.  0 represents North.
     * The valid range is [0,360).
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value heading = 2;</code>
     * @return \Google\Protobuf\Int32Value|null
     */
    public function getHeading()
    {
        return $this->heading;
    }

    public function hasHeading()
    {
        return isset($this->heading);
    }

    public function clearHeading()
    {
        unset($this->heading);
    }

    /**
     * Returns the unboxed value from <code>getHeading()</code>

     * Direction the vehicle is moving in degrees.  0 represents North.
     * The valid range is [0,360).
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value heading = 2;</code>
     * @return int|null
     */
    public function getHeadingUnwrapped()
    {
        return $this->readWrapperValue("heading");
    }

    /**
     * Direction the vehicle is moving in degrees.  0 represents North.
     * The valid range is [0,360).
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value heading = 2;</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     */
    public function setHeading($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->heading = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * Direction the vehicle is moving in degrees.  0 represents North.
     * The valid range is [0,360).
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value heading = 2;</code>
     * @param int|null $var
     * @return $this
     */
    public function setHeadingUnwrapped($var)
    {
        $this->writeWrapperValue("heading", $var);
        return $this;}

    /**
     * Deprecated: Use `heading_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue bearing_accuracy = 10 [deprecated = true];</code>
     * @return \Google\Protobuf\DoubleValue|null
     * @deprecated
     */
    public function getBearingAccuracy()
    {
        @trigger_error('bearing_accuracy is deprecated.', E_USER_DEPRECATED);
        return $this->bearing_accuracy;
    }

    public function hasBearingAccuracy()
    {
        @trigger_error('bearing_accuracy is deprecated.', E_USER_DEPRECATED);
        return isset($this->bearing_accuracy);
    }

    public function clearBearingAccuracy()
    {
        @trigger_error('bearing_accuracy is deprecated.', E_USER_DEPRECATED);
        unset($this->bearing_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getBearingAccuracy()</code>

     * Deprecated: Use `heading_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue bearing_accuracy = 10 [deprecated = true];</code>
     * @return float|null
     */
    public function getBearingAccuracyUnwrapped()
    {
        @trigger_error('bearing_accuracy is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("bearing_accuracy");
    }

    /**
     * Deprecated: Use `heading_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue bearing_accuracy = 10 [deprecated = true];</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     * @deprecated
     */
    public function setBearingAccuracy($var)
    {
        @trigger_error('bearing_accuracy is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->bearing_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Deprecated: Use `heading_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue bearing_accuracy = 10 [deprecated = true];</code>
     * @param float|null $var
     * @return $this
     */
    public function setBearingAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("bearing_accuracy", $var);
        return $this;}

    /**
     * Accuracy of `heading` in degrees.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue heading_accuracy = 23;</code>
     * @return \Google\Protobuf\DoubleValue|null
     */
    public function getHeadingAccuracy()
    {
        return $this->heading_accuracy;
    }

    public function hasHeadingAccuracy()
    {
        return isset($this->heading_accuracy);
    }

    public function clearHeadingAccuracy()
    {
        unset($this->heading_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getHeadingAccuracy()</code>

     * Accuracy of `heading` in degrees.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue heading_accuracy = 23;</code>
     * @return float|null
     */
    public function getHeadingAccuracyUnwrapped()
    {
        return $this->readWrapperValue("heading_accuracy");
    }

    /**
     * Accuracy of `heading` in degrees.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue heading_accuracy = 23;</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     */
    public function setHeadingAccuracy($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->heading_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Accuracy of `heading` in degrees.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue heading_accuracy = 23;</code>
     * @param float|null $var
     * @return $this
     */
    public function setHeadingAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("heading_accuracy", $var);
        return $this;}

    /**
     * Altitude in meters above WGS84.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude = 5;</code>
     * @return \Google\Protobuf\DoubleValue|null
     */
    public function getAltitude()
    {
        return $this->altitude;
    }

    public function hasAltitude()
    {
        return isset($this->altitude);
    }

    public function clearAltitude()
    {
        unset($this->altitude);
    }

    /**
     * Returns the unboxed value from <code>getAltitude()</code>

     * Altitude in meters above WGS84.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude = 5;</code>
     * @return float|null
     */
    public function getAltitudeUnwrapped()
    {
        return $this->readWrapperValue("altitude");
    }

    /**
     * Altitude in meters above WGS84.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude = 5;</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     */
    public function setAltitude($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->altitude = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Altitude in meters above WGS84.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude = 5;</code>
     * @param float|null $var
     * @return $this
     */
    public function setAltitudeUnwrapped($var)
    {
        $this->writeWrapperValue("altitude", $var);
        return $this;}

    /**
     * Deprecated: Use `altitude_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue vertical_accuracy = 9 [deprecated = true];</code>
     * @return \Google\Protobuf\DoubleValue|null
     * @deprecated
     */
    public function getVerticalAccuracy()
    {
        @trigger_error('vertical_accuracy is deprecated.', E_USER_DEPRECATED);
        return $this->vertical_accuracy;
    }

    public function hasVerticalAccuracy()
    {
        @trigger_error('vertical_accuracy is deprecated.', E_USER_DEPRECATED);
        return isset($this->vertical_accuracy);
    }

    public function clearVerticalAccuracy()
    {
        @trigger_error('vertical_accuracy is deprecated.', E_USER_DEPRECATED);
        unset($this->vertical_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getVerticalAccuracy()</code>

     * Deprecated: Use `altitude_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue vertical_accuracy = 9 [deprecated = true];</code>
     * @return float|null
     */
    public function getVerticalAccuracyUnwrapped()
    {
        @trigger_error('vertical_accuracy is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("vertical_accuracy");
    }

    /**
     * Deprecated: Use `altitude_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue vertical_accuracy = 9 [deprecated = true];</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     * @deprecated
     */
    public function setVerticalAccuracy($var)
    {
        @trigger_error('vertical_accuracy is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->vertical_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Deprecated: Use `altitude_accuracy` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue vertical_accuracy = 9 [deprecated = true];</code>
     * @param float|null $var
     * @return $this
     */
    public function setVerticalAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("vertical_accuracy", $var);
        return $this;}

    /**
     * Accuracy of `altitude` in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude_accuracy = 24;</code>
     * @return \Google\Protobuf\DoubleValue|null
     */
    public function getAltitudeAccuracy()
    {
        return $this->altitude_accuracy;
    }

    public function hasAltitudeAccuracy()
    {
        return isset($this->altitude_accuracy);
    }

    public function clearAltitudeAccuracy()
    {
        unset($this->altitude_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getAltitudeAccuracy()</code>

     * Accuracy of `altitude` in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude_accuracy = 24;</code>
     * @return float|null
     */
    public function getAltitudeAccuracyUnwrapped()
    {
        return $this->readWrapperValue("altitude_accuracy");
    }

    /**
     * Accuracy of `altitude` in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude_accuracy = 24;</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     */
    public function setAltitudeAccuracy($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->altitude_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Accuracy of `altitude` in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue altitude_accuracy = 24;</code>
     * @param float|null $var
     * @return $this
     */
    public function setAltitudeAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("altitude_accuracy", $var);
        return $this;}

    /**
     * Speed of the vehicle in kilometers per hour.
     * Deprecated: Use `speed` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value speed_kmph = 3 [deprecated = true];</code>
     * @return \Google\Protobuf\Int32Value|null
     * @deprecated
     */
    public function getSpeedKmph()
    {
        @trigger_error('speed_kmph is deprecated.', E_USER_DEPRECATED);
        return $this->speed_kmph;
    }

    public function hasSpeedKmph()
    {
        @trigger_error('speed_kmph is deprecated.', E_USER_DEPRECATED);
        return isset($this->speed_kmph);
    }

    public function clearSpeedKmph()
    {
        @trigger_error('speed_kmph is deprecated.', E_USER_DEPRECATED);
        unset($this->speed_kmph);
    }

    /**
     * Returns the unboxed value from <code>getSpeedKmph()</code>

     * Speed of the vehicle in kilometers per hour.
     * Deprecated: Use `speed` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value speed_kmph = 3 [deprecated = true];</code>
     * @return int|null
     */
    public function getSpeedKmphUnwrapped()
    {
        @trigger_error('speed_kmph is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("speed_kmph");
    }

    /**
     * Speed of the vehicle in kilometers per hour.
     * Deprecated: Use `speed` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value speed_kmph = 3 [deprecated = true];</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     * @deprecated
     */
    public function setSpeedKmph($var)
    {
        @trigger_error('speed_kmph is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->speed_kmph = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * Speed of the vehicle in kilometers per hour.
     * Deprecated: Use `speed` instead.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value speed_kmph = 3 [deprecated = true];</code>
     * @param int|null $var
     * @return $this
     */
    public function setSpeedKmphUnwrapped($var)
    {
        $this->writeWrapperValue("speed_kmph", $var);
        return $this;}

    /**
     * Speed of the vehicle in meters/second
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed = 6;</code>
     * @return \Google\Protobuf\DoubleValue|null
     */
    public function getSpeed()
    {
        return $this->speed;
    }

    public function hasSpeed()
    {
        return isset($this->speed);
    }

    public function clearSpeed()
    {
        unset($this->speed);
    }

    /**
     * Returns the unboxed value from <code>getSpeed()</code>

     * Speed of the vehicle in meters/second
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed = 6;</code>
     * @return float|null
     */
    public function getSpeedUnwrapped()
    {
        return $this->readWrapperValue("speed");
    }

    /**
     * Speed of the vehicle in meters/second
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed = 6;</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     */
    public function setSpeed($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->speed = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Speed of the vehicle in meters/second
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed = 6;</code>
     * @param float|null $var
     * @return $this
     */
    public function setSpeedUnwrapped($var)
    {
        $this->writeWrapperValue("speed", $var);
        return $this;}

    /**
     * Accuracy of `speed` in meters/second.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed_accuracy = 7;</code>
     * @return \Google\Protobuf\DoubleValue|null
     */
    public function getSpeedAccuracy()
    {
        return $this->speed_accuracy;
    }

    public function hasSpeedAccuracy()
    {
        return isset($this->speed_accuracy);
    }

    public function clearSpeedAccuracy()
    {
        unset($this->speed_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getSpeedAccuracy()</code>

     * Accuracy of `speed` in meters/second.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed_accuracy = 7;</code>
     * @return float|null
     */
    public function getSpeedAccuracyUnwrapped()
    {
        return $this->readWrapperValue("speed_accuracy");
    }

    /**
     * Accuracy of `speed` in meters/second.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed_accuracy = 7;</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     */
    public function setSpeedAccuracy($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->speed_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Accuracy of `speed` in meters/second.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue speed_accuracy = 7;</code>
     * @param float|null $var
     * @return $this
     */
    public function setSpeedAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("speed_accuracy", $var);
        return $this;}

    /**
     * The time when `location` was reported by the sensor according to the
     * sensor's clock.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * The time when `location` was reported by the sensor according to the
     * sensor's clock.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The time when the server received the location information.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp server_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getServerTime()
    {
        return $this->server_time;
    }

    public function hasServerTime()
    {
        return isset($this->server_time);
    }

    public function clearServerTime()
    {
        unset($this->server_time);
    }

    /**
     * Output only. The time when the server received the location information.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp server_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setServerTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->server_time = $var;

        return $this;
    }

    /**
     * Provider of location data (for example, `GPS`).
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor location_sensor = 11;</code>
     * @return int
     */
    public function getLocationSensor()
    {
        return $this->location_sensor;
    }

    /**
     * Provider of location data (for example, `GPS`).
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor location_sensor = 11;</code>
     * @param int $var
     * @return $this
     */
    public function setLocationSensor($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\Delivery\V1\DeliveryVehicleLocationSensor::class);
        $this->location_sensor = $var;

        return $this;
    }

    /**
     * Whether `location` is snapped to a road.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_road_snapped = 27;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getIsRoadSnapped()
    {
        return $this->is_road_snapped;
    }

    public function hasIsRoadSnapped()
    {
        return isset($this->is_road_snapped);
    }

    public function clearIsRoadSnapped()
    {
        unset($this->is_road_snapped);
    }

    /**
     * Returns the unboxed value from <code>getIsRoadSnapped()</code>

     * Whether `location` is snapped to a road.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_road_snapped = 27;</code>
     * @return bool|null
     */
    public function getIsRoadSnappedUnwrapped()
    {
        return $this->readWrapperValue("is_road_snapped");
    }

    /**
     * Whether `location` is snapped to a road.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_road_snapped = 27;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setIsRoadSnapped($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->is_road_snapped = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Whether `location` is snapped to a road.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_road_snapped = 27;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setIsRoadSnappedUnwrapped($var)
    {
        $this->writeWrapperValue("is_road_snapped", $var);
        return $this;}

    /**
     * Input only. Indicates whether the GPS sensor is enabled on the mobile
     * device.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_gps_sensor_enabled = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getIsGpsSensorEnabled()
    {
        return $this->is_gps_sensor_enabled;
    }

    public function hasIsGpsSensorEnabled()
    {
        return isset($this->is_gps_sensor_enabled);
    }

    public function clearIsGpsSensorEnabled()
    {
        unset($this->is_gps_sensor_enabled);
    }

    /**
     * Returns the unboxed value from <code>getIsGpsSensorEnabled()</code>

     * Input only. Indicates whether the GPS sensor is enabled on the mobile
     * device.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_gps_sensor_enabled = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return bool|null
     */
    public function getIsGpsSensorEnabledUnwrapped()
    {
        return $this->readWrapperValue("is_gps_sensor_enabled");
    }

    /**
     * Input only. Indicates whether the GPS sensor is enabled on the mobile
     * device.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_gps_sensor_enabled = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setIsGpsSensorEnabled($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->is_gps_sensor_enabled = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Input only. Indicates whether the GPS sensor is enabled on the mobile
     * device.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_gps_sensor_enabled = 12 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param bool|null $var
     * @return $this
     */
    public function setIsGpsSensorEnabledUnwrapped($var)
    {
        $this->writeWrapperValue("is_gps_sensor_enabled", $var);
        return $this;}

    /**
     * Input only. Time (in seconds) since this location was first sent to the
     * server. This will be zero for the first update. If the time is unknown (for
     * example, when the app restarts), this value resets to zero.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value time_since_update = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\Int32Value|null
     */
    public function getTimeSinceUpdate()
    {
        return $this->time_since_update;
    }

    public function hasTimeSinceUpdate()
    {
        return isset($this->time_since_update);
    }

    public function clearTimeSinceUpdate()
    {
        unset($this->time_since_update);
    }

    /**
     * Returns the unboxed value from <code>getTimeSinceUpdate()</code>

     * Input only. Time (in seconds) since this location was first sent to the
     * server. This will be zero for the first update. If the time is unknown (for
     * example, when the app restarts), this value resets to zero.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value time_since_update = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int|null
     */
    public function getTimeSinceUpdateUnwrapped()
    {
        return $this->readWrapperValue("time_since_update");
    }

    /**
     * Input only. Time (in seconds) since this location was first sent to the
     * server. This will be zero for the first update. If the time is unknown (for
     * example, when the app restarts), this value resets to zero.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value time_since_update = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     */
    public function setTimeSinceUpdate($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->time_since_update = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * Input only. Time (in seconds) since this location was first sent to the
     * server. This will be zero for the first update. If the time is unknown (for
     * example, when the app restarts), this value resets to zero.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value time_since_update = 14 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int|null $var
     * @return $this
     */
    public function setTimeSinceUpdateUnwrapped($var)
    {
        $this->writeWrapperValue("time_since_update", $var);
        return $this;}

    /**
     * Input only. Deprecated: Other signals are now used to determine if a
     * location is stale.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value num_stale_updates = 15 [deprecated = true, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\Int32Value|null
     * @deprecated
     */
    public function getNumStaleUpdates()
    {
        @trigger_error('num_stale_updates is deprecated.', E_USER_DEPRECATED);
        return $this->num_stale_updates;
    }

    public function hasNumStaleUpdates()
    {
        @trigger_error('num_stale_updates is deprecated.', E_USER_DEPRECATED);
        return isset($this->num_stale_updates);
    }

    public function clearNumStaleUpdates()
    {
        @trigger_error('num_stale_updates is deprecated.', E_USER_DEPRECATED);
        unset($this->num_stale_updates);
    }

    /**
     * Returns the unboxed value from <code>getNumStaleUpdates()</code>

     * Input only. Deprecated: Other signals are now used to determine if a
     * location is stale.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value num_stale_updates = 15 [deprecated = true, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int|null
     */
    public function getNumStaleUpdatesUnwrapped()
    {
        @trigger_error('num_stale_updates is deprecated.', E_USER_DEPRECATED);
        return $this->readWrapperValue("num_stale_updates");
    }

    /**
     * Input only. Deprecated: Other signals are now used to determine if a
     * location is stale.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value num_stale_updates = 15 [deprecated = true, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     * @deprecated
     */
    public function setNumStaleUpdates($var)
    {
        @trigger_error('num_stale_updates is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->num_stale_updates = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * Input only. Deprecated: Other signals are now used to determine if a
     * location is stale.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value num_stale_updates = 15 [deprecated = true, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int|null $var
     * @return $this
     */
    public function setNumStaleUpdatesUnwrapped($var)
    {
        $this->writeWrapperValue("num_stale_updates", $var);
        return $this;}

    /**
     * Raw vehicle location (unprocessed by road-snapper).
     *
     * Generated from protobuf field <code>.google.type.LatLng raw_location = 16;</code>
     * @return \Google\Type\LatLng|null
     */
    public function getRawLocation()
    {
        return $this->raw_location;
    }

    public function hasRawLocation()
    {
        return isset($this->raw_location);
    }

    public function clearRawLocation()
    {
        unset($this->raw_location);
    }

    /**
     * Raw vehicle location (unprocessed by road-snapper).
     *
     * Generated from protobuf field <code>.google.type.LatLng raw_location = 16;</code>
     * @param \Google\Type\LatLng $var
     * @return $this
     */
    public function setRawLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\LatLng::class);
        $this->raw_location = $var;

        return $this;
    }

    /**
     * Timestamp associated with the raw location.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp raw_location_time = 17;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getRawLocationTime()
    {
        return $this->raw_location_time;
    }

    public function hasRawLocationTime()
    {
        return isset($this->raw_location_time);
    }

    public function clearRawLocationTime()
    {
        unset($this->raw_location_time);
    }

    /**
     * Timestamp associated with the raw location.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp raw_location_time = 17;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setRawLocationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->raw_location_time = $var;

        return $this;
    }

    /**
     * Source of the raw location. Defaults to `GPS`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor raw_location_sensor = 28;</code>
     * @return int
     */
    public function getRawLocationSensor()
    {
        return $this->raw_location_sensor;
    }

    /**
     * Source of the raw location. Defaults to `GPS`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor raw_location_sensor = 28;</code>
     * @param int $var
     * @return $this
     */
    public function setRawLocationSensor($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\Delivery\V1\DeliveryVehicleLocationSensor::class);
        $this->raw_location_sensor = $var;

        return $this;
    }

    /**
     * Accuracy of `raw_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue raw_location_accuracy = 25;</code>
     * @return \Google\Protobuf\DoubleValue|null
     */
    public function getRawLocationAccuracy()
    {
        return $this->raw_location_accuracy;
    }

    public function hasRawLocationAccuracy()
    {
        return isset($this->raw_location_accuracy);
    }

    public function clearRawLocationAccuracy()
    {
        unset($this->raw_location_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getRawLocationAccuracy()</code>

     * Accuracy of `raw_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue raw_location_accuracy = 25;</code>
     * @return float|null
     */
    public function getRawLocationAccuracyUnwrapped()
    {
        return $this->readWrapperValue("raw_location_accuracy");
    }

    /**
     * Accuracy of `raw_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue raw_location_accuracy = 25;</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     */
    public function setRawLocationAccuracy($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->raw_location_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Accuracy of `raw_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue raw_location_accuracy = 25;</code>
     * @param float|null $var
     * @return $this
     */
    public function setRawLocationAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("raw_location_accuracy", $var);
        return $this;}

    /**
     * Supplemental location provided by the integrating app.
     *
     * Generated from protobuf field <code>.google.type.LatLng supplemental_location = 18;</code>
     * @return \Google\Type\LatLng|null
     */
    public function getSupplementalLocation()
    {
        return $this->supplemental_location;
    }

    public function hasSupplementalLocation()
    {
        return isset($this->supplemental_location);
    }

    public function clearSupplementalLocation()
    {
        unset($this->supplemental_location);
    }

    /**
     * Supplemental location provided by the integrating app.
     *
     * Generated from protobuf field <code>.google.type.LatLng supplemental_location = 18;</code>
     * @param \Google\Type\LatLng $var
     * @return $this
     */
    public function setSupplementalLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\LatLng::class);
        $this->supplemental_location = $var;

        return $this;
    }

    /**
     * Timestamp associated with the supplemental location.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp supplemental_location_time = 19;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getSupplementalLocationTime()
    {
        return $this->supplemental_location_time;
    }

    public function hasSupplementalLocationTime()
    {
        return isset($this->supplemental_location_time);
    }

    public function clearSupplementalLocationTime()
    {
        unset($this->supplemental_location_time);
    }

    /**
     * Timestamp associated with the supplemental location.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp supplemental_location_time = 19;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setSupplementalLocationTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->supplemental_location_time = $var;

        return $this;
    }

    /**
     * Source of the supplemental location. Defaults to
     * `CUSTOMER_SUPPLIED_LOCATION`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor supplemental_location_sensor = 20;</code>
     * @return int
     */
    public function getSupplementalLocationSensor()
    {
        return $this->supplemental_location_sensor;
    }

    /**
     * Source of the supplemental location. Defaults to
     * `CUSTOMER_SUPPLIED_LOCATION`.
     *
     * Generated from protobuf field <code>.maps.fleetengine.delivery.v1.DeliveryVehicleLocationSensor supplemental_location_sensor = 20;</code>
     * @param int $var
     * @return $this
     */
    public function setSupplementalLocationSensor($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\Delivery\V1\DeliveryVehicleLocationSensor::class);
        $this->supplemental_location_sensor = $var;

        return $this;
    }

    /**
     * Accuracy of `supplemental_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue supplemental_location_accuracy = 21;</code>
     * @return \Google\Protobuf\DoubleValue|null
     */
    public function getSupplementalLocationAccuracy()
    {
        return $this->supplemental_location_accuracy;
    }

    public function hasSupplementalLocationAccuracy()
    {
        return isset($this->supplemental_location_accuracy);
    }

    public function clearSupplementalLocationAccuracy()
    {
        unset($this->supplemental_location_accuracy);
    }

    /**
     * Returns the unboxed value from <code>getSupplementalLocationAccuracy()</code>

     * Accuracy of `supplemental_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue supplemental_location_accuracy = 21;</code>
     * @return float|null
     */
    public function getSupplementalLocationAccuracyUnwrapped()
    {
        return $this->readWrapperValue("supplemental_location_accuracy");
    }

    /**
     * Accuracy of `supplemental_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue supplemental_location_accuracy = 21;</code>
     * @param \Google\Protobuf\DoubleValue $var
     * @return $this
     */
    public function setSupplementalLocationAccuracy($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\DoubleValue::class);
        $this->supplemental_location_accuracy = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\DoubleValue object.

     * Accuracy of `supplemental_location` as a radius, in meters.
     *
     * Generated from protobuf field <code>.google.protobuf.DoubleValue supplemental_location_accuracy = 21;</code>
     * @param float|null $var
     * @return $this
     */
    public function setSupplementalLocationAccuracyUnwrapped($var)
    {
        $this->writeWrapperValue("supplemental_location_accuracy", $var);
        return $this;}

    /**
     * Deprecated: Use `is_road_snapped` instead.
     *
     * Generated from protobuf field <code>bool road_snapped = 26 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getRoadSnapped()
    {
        @trigger_error('road_snapped is deprecated.', E_USER_DEPRECATED);
        return $this->road_snapped;
    }

    /**
     * Deprecated: Use `is_road_snapped` instead.
     *
     * Generated from protobuf field <code>bool road_snapped = 26 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setRoadSnapped($var)
    {
        @trigger_error('road_snapped is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->road_snapped = $var;

        return $this;
    }

}

