<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networkconnectivity/v1/data_transfer.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetworkConnectivity\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\NetworkConnectivity\V1\CreateDestinationRequest;
use Google\Cloud\NetworkConnectivity\V1\CreateMulticloudDataTransferConfigRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteDestinationRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteMulticloudDataTransferConfigRequest;
use Google\Cloud\NetworkConnectivity\V1\Destination;
use Google\Cloud\NetworkConnectivity\V1\GetDestinationRequest;
use Google\Cloud\NetworkConnectivity\V1\GetMulticloudDataTransferConfigRequest;
use Google\Cloud\NetworkConnectivity\V1\GetMulticloudDataTransferSupportedServiceRequest;
use Google\Cloud\NetworkConnectivity\V1\ListDestinationsRequest;
use Google\Cloud\NetworkConnectivity\V1\ListMulticloudDataTransferConfigsRequest;
use Google\Cloud\NetworkConnectivity\V1\ListMulticloudDataTransferSupportedServicesRequest;
use Google\Cloud\NetworkConnectivity\V1\MulticloudDataTransferConfig;
use Google\Cloud\NetworkConnectivity\V1\MulticloudDataTransferSupportedService;
use Google\Cloud\NetworkConnectivity\V1\UpdateDestinationRequest;
use Google\Cloud\NetworkConnectivity\V1\UpdateMulticloudDataTransferConfigRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: DataTransferService is the service for the Data Transfer API.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createDestinationAsync(CreateDestinationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createMulticloudDataTransferConfigAsync(CreateMulticloudDataTransferConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteDestinationAsync(DeleteDestinationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteMulticloudDataTransferConfigAsync(DeleteMulticloudDataTransferConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Destination> getDestinationAsync(GetDestinationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MulticloudDataTransferConfig> getMulticloudDataTransferConfigAsync(GetMulticloudDataTransferConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<MulticloudDataTransferSupportedService> getMulticloudDataTransferSupportedServiceAsync(GetMulticloudDataTransferSupportedServiceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listDestinationsAsync(ListDestinationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMulticloudDataTransferConfigsAsync(ListMulticloudDataTransferConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listMulticloudDataTransferSupportedServicesAsync(ListMulticloudDataTransferSupportedServicesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateDestinationAsync(UpdateDestinationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateMulticloudDataTransferConfigAsync(UpdateMulticloudDataTransferConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class DataTransferServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.networkconnectivity.v1.DataTransferService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'networkconnectivity.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'networkconnectivity.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/data_transfer_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/data_transfer_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/data_transfer_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/data_transfer_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a destination
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $multicloudDataTransferConfig
     * @param string $destination
     *
     * @return string The formatted destination resource.
     */
    public static function destinationName(
        string $project,
        string $location,
        string $multicloudDataTransferConfig,
        string $destination
    ): string {
        return self::getPathTemplate('destination')->render([
            'project' => $project,
            'location' => $location,
            'multicloud_data_transfer_config' => $multicloudDataTransferConfig,
            'destination' => $destination,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * multicloud_data_transfer_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $multicloudDataTransferConfig
     *
     * @return string The formatted multicloud_data_transfer_config resource.
     */
    public static function multicloudDataTransferConfigName(
        string $project,
        string $location,
        string $multicloudDataTransferConfig
    ): string {
        return self::getPathTemplate('multicloudDataTransferConfig')->render([
            'project' => $project,
            'location' => $location,
            'multicloud_data_transfer_config' => $multicloudDataTransferConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * multicloud_data_transfer_supported_service resource.
     *
     * @param string $project
     * @param string $location
     * @param string $multicloudDataTransferSupportedService
     *
     * @return string The formatted multicloud_data_transfer_supported_service resource.
     */
    public static function multicloudDataTransferSupportedServiceName(
        string $project,
        string $location,
        string $multicloudDataTransferSupportedService
    ): string {
        return self::getPathTemplate('multicloudDataTransferSupportedService')->render([
            'project' => $project,
            'location' => $location,
            'multicloud_data_transfer_supported_service' => $multicloudDataTransferSupportedService,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - destination: projects/{project}/locations/{location}/multicloudDataTransferConfigs/{multicloud_data_transfer_config}/destinations/{destination}
     * - location: projects/{project}/locations/{location}
     * - multicloudDataTransferConfig: projects/{project}/locations/{location}/multicloudDataTransferConfigs/{multicloud_data_transfer_config}
     * - multicloudDataTransferSupportedService: projects/{project}/locations/{location}/multicloudDataTransferSupportedServices/{multicloud_data_transfer_supported_service}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networkconnectivity.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a `Destination` resource in a specified project and location.
     *
     * The async variant is {@see DataTransferServiceClient::createDestinationAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/create_destination.php
     *
     * @param CreateDestinationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createDestination(CreateDestinationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateDestination', $request, $callOptions)->wait();
    }

    /**
     * Creates a `MulticloudDataTransferConfig` resource in a specified project
     * and location.
     *
     * The async variant is
     * {@see DataTransferServiceClient::createMulticloudDataTransferConfigAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/create_multicloud_data_transfer_config.php
     *
     * @param CreateMulticloudDataTransferConfigRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createMulticloudDataTransferConfig(
        CreateMulticloudDataTransferConfigRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateMulticloudDataTransferConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a `Destination` resource.
     *
     * The async variant is {@see DataTransferServiceClient::deleteDestinationAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/delete_destination.php
     *
     * @param DeleteDestinationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteDestination(DeleteDestinationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteDestination', $request, $callOptions)->wait();
    }

    /**
     * Deletes a `MulticloudDataTransferConfig` resource.
     *
     * The async variant is
     * {@see DataTransferServiceClient::deleteMulticloudDataTransferConfigAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/delete_multicloud_data_transfer_config.php
     *
     * @param DeleteMulticloudDataTransferConfigRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteMulticloudDataTransferConfig(
        DeleteMulticloudDataTransferConfigRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteMulticloudDataTransferConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a `Destination` resource.
     *
     * The async variant is {@see DataTransferServiceClient::getDestinationAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/get_destination.php
     *
     * @param GetDestinationRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Destination
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDestination(GetDestinationRequest $request, array $callOptions = []): Destination
    {
        return $this->startApiCall('GetDestination', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a `MulticloudDataTransferConfig` resource.
     *
     * The async variant is
     * {@see DataTransferServiceClient::getMulticloudDataTransferConfigAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/get_multicloud_data_transfer_config.php
     *
     * @param GetMulticloudDataTransferConfigRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MulticloudDataTransferConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMulticloudDataTransferConfig(
        GetMulticloudDataTransferConfigRequest $request,
        array $callOptions = []
    ): MulticloudDataTransferConfig {
        return $this->startApiCall('GetMulticloudDataTransferConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a service that is supported for Data Transfer
     * Essentials.
     *
     * The async variant is
     * {@see DataTransferServiceClient::getMulticloudDataTransferSupportedServiceAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/get_multicloud_data_transfer_supported_service.php
     *
     * @param GetMulticloudDataTransferSupportedServiceRequest $request     A request to house fields associated with the call.
     * @param array                                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return MulticloudDataTransferSupportedService
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getMulticloudDataTransferSupportedService(
        GetMulticloudDataTransferSupportedServiceRequest $request,
        array $callOptions = []
    ): MulticloudDataTransferSupportedService {
        return $this->startApiCall('GetMulticloudDataTransferSupportedService', $request, $callOptions)->wait();
    }

    /**
     * Lists the `Destination` resources in a specified project and location.
     *
     * The async variant is {@see DataTransferServiceClient::listDestinationsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/list_destinations.php
     *
     * @param ListDestinationsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listDestinations(ListDestinationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListDestinations', $request, $callOptions);
    }

    /**
     * Lists the `MulticloudDataTransferConfig` resources in a specified project
     * and location.
     *
     * The async variant is
     * {@see DataTransferServiceClient::listMulticloudDataTransferConfigsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/list_multicloud_data_transfer_configs.php
     *
     * @param ListMulticloudDataTransferConfigsRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMulticloudDataTransferConfigs(
        ListMulticloudDataTransferConfigsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListMulticloudDataTransferConfigs', $request, $callOptions);
    }

    /**
     * Lists the services in the project for a region that are supported for
     * Data Transfer Essentials.
     *
     * The async variant is
     * {@see DataTransferServiceClient::listMulticloudDataTransferSupportedServicesAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/list_multicloud_data_transfer_supported_services.php
     *
     * @param ListMulticloudDataTransferSupportedServicesRequest $request     A request to house fields associated with the call.
     * @param array                                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listMulticloudDataTransferSupportedServices(
        ListMulticloudDataTransferSupportedServicesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListMulticloudDataTransferSupportedServices', $request, $callOptions);
    }

    /**
     * Updates a `Destination` resource in a specified project and location.
     *
     * The async variant is {@see DataTransferServiceClient::updateDestinationAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/update_destination.php
     *
     * @param UpdateDestinationRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateDestination(UpdateDestinationRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateDestination', $request, $callOptions)->wait();
    }

    /**
     * Updates a `MulticloudDataTransferConfig` resource in a specified project
     * and location.
     *
     * The async variant is
     * {@see DataTransferServiceClient::updateMulticloudDataTransferConfigAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/update_multicloud_data_transfer_config.php
     *
     * @param UpdateMulticloudDataTransferConfigRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateMulticloudDataTransferConfig(
        UpdateMulticloudDataTransferConfigRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('UpdateMulticloudDataTransferConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see DataTransferServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see DataTransferServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see DataTransferServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see DataTransferServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/DataTransferServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is {@see DataTransferServiceClient::testIamPermissionsAsync()}
     * .
     *
     * @example samples/V1/DataTransferServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
