<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dataplex/v1/catalog.proto

namespace Google\Cloud\Dataplex\V1\MetadataJob\ExportJobSpec;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The scope of the export job.
 *
 * Generated from protobuf message <code>google.cloud.dataplex.v1.MetadataJob.ExportJobSpec.ExportJobScope</code>
 */
class ExportJobScope extends \Google\Protobuf\Internal\Message
{
    /**
     * Whether the metadata export job is an organization-level export job.
     * - If `true`, the job exports the entries from the same organization and
     * VPC Service Controls perimeter as the job. The project that the job
     * belongs to determines the VPC Service Controls perimeter. If you set
     * the job scope to be at the organization level, then don't provide a
     * list of projects or entry groups.
     * - If `false`, you must specify a list of projects or a list of entry
     * groups whose entries you want to export.
     * The default is `false`.
     *
     * Generated from protobuf field <code>bool organization_level = 1;</code>
     */
    protected $organization_level = false;
    /**
     * The projects whose metadata you want to export, in the format
     * `projects/{project_id_or_number}`. Only the entries from
     * the specified projects are exported.
     * The projects must be in the same organization and VPC Service Controls
     * perimeter as the job.
     * If you set the job scope to be a list of projects, then set the
     * organization-level export flag to false and don't provide a list of
     * entry groups.
     *
     * Generated from protobuf field <code>repeated string projects = 2 [(.google.api.resource_reference) = {</code>
     */
    private $projects;
    /**
     * The entry groups whose metadata you want to export, in the format
     * `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
     * Only the entries in the specified entry groups are exported.
     * The entry groups must be in the same location and the same VPC Service
     * Controls perimeter as the job.
     * If you set the job scope to be a list of entry groups, then set the
     * organization-level export flag to false and don't provide a list of
     * projects.
     *
     * Generated from protobuf field <code>repeated string entry_groups = 3 [(.google.api.resource_reference) = {</code>
     */
    private $entry_groups;
    /**
     * The entry types that are in scope for the export job, specified as
     * relative resource names in the format
     * `projects/{project_id_or_number}/locations/{location}/entryTypes/{entry_type_id}`.
     * Only entries that belong to the specified entry types are affected by
     * the job.
     *
     * Generated from protobuf field <code>repeated string entry_types = 4 [(.google.api.resource_reference) = {</code>
     */
    private $entry_types;
    /**
     * The aspect types that are in scope for the export job, specified as
     * relative resource names in the format
     * `projects/{project_id_or_number}/locations/{location}/aspectTypes/{aspect_type_id}`.
     * Only aspects that belong to the specified aspect types are affected by
     * the job.
     *
     * Generated from protobuf field <code>repeated string aspect_types = 5 [(.google.api.resource_reference) = {</code>
     */
    private $aspect_types;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $organization_level
     *           Whether the metadata export job is an organization-level export job.
     *           - If `true`, the job exports the entries from the same organization and
     *           VPC Service Controls perimeter as the job. The project that the job
     *           belongs to determines the VPC Service Controls perimeter. If you set
     *           the job scope to be at the organization level, then don't provide a
     *           list of projects or entry groups.
     *           - If `false`, you must specify a list of projects or a list of entry
     *           groups whose entries you want to export.
     *           The default is `false`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $projects
     *           The projects whose metadata you want to export, in the format
     *           `projects/{project_id_or_number}`. Only the entries from
     *           the specified projects are exported.
     *           The projects must be in the same organization and VPC Service Controls
     *           perimeter as the job.
     *           If you set the job scope to be a list of projects, then set the
     *           organization-level export flag to false and don't provide a list of
     *           entry groups.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $entry_groups
     *           The entry groups whose metadata you want to export, in the format
     *           `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
     *           Only the entries in the specified entry groups are exported.
     *           The entry groups must be in the same location and the same VPC Service
     *           Controls perimeter as the job.
     *           If you set the job scope to be a list of entry groups, then set the
     *           organization-level export flag to false and don't provide a list of
     *           projects.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $entry_types
     *           The entry types that are in scope for the export job, specified as
     *           relative resource names in the format
     *           `projects/{project_id_or_number}/locations/{location}/entryTypes/{entry_type_id}`.
     *           Only entries that belong to the specified entry types are affected by
     *           the job.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $aspect_types
     *           The aspect types that are in scope for the export job, specified as
     *           relative resource names in the format
     *           `projects/{project_id_or_number}/locations/{location}/aspectTypes/{aspect_type_id}`.
     *           Only aspects that belong to the specified aspect types are affected by
     *           the job.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dataplex\V1\Catalog::initOnce();
        parent::__construct($data);
    }

    /**
     * Whether the metadata export job is an organization-level export job.
     * - If `true`, the job exports the entries from the same organization and
     * VPC Service Controls perimeter as the job. The project that the job
     * belongs to determines the VPC Service Controls perimeter. If you set
     * the job scope to be at the organization level, then don't provide a
     * list of projects or entry groups.
     * - If `false`, you must specify a list of projects or a list of entry
     * groups whose entries you want to export.
     * The default is `false`.
     *
     * Generated from protobuf field <code>bool organization_level = 1;</code>
     * @return bool
     */
    public function getOrganizationLevel()
    {
        return $this->organization_level;
    }

    /**
     * Whether the metadata export job is an organization-level export job.
     * - If `true`, the job exports the entries from the same organization and
     * VPC Service Controls perimeter as the job. The project that the job
     * belongs to determines the VPC Service Controls perimeter. If you set
     * the job scope to be at the organization level, then don't provide a
     * list of projects or entry groups.
     * - If `false`, you must specify a list of projects or a list of entry
     * groups whose entries you want to export.
     * The default is `false`.
     *
     * Generated from protobuf field <code>bool organization_level = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setOrganizationLevel($var)
    {
        GPBUtil::checkBool($var);
        $this->organization_level = $var;

        return $this;
    }

    /**
     * The projects whose metadata you want to export, in the format
     * `projects/{project_id_or_number}`. Only the entries from
     * the specified projects are exported.
     * The projects must be in the same organization and VPC Service Controls
     * perimeter as the job.
     * If you set the job scope to be a list of projects, then set the
     * organization-level export flag to false and don't provide a list of
     * entry groups.
     *
     * Generated from protobuf field <code>repeated string projects = 2 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProjects()
    {
        return $this->projects;
    }

    /**
     * The projects whose metadata you want to export, in the format
     * `projects/{project_id_or_number}`. Only the entries from
     * the specified projects are exported.
     * The projects must be in the same organization and VPC Service Controls
     * perimeter as the job.
     * If you set the job scope to be a list of projects, then set the
     * organization-level export flag to false and don't provide a list of
     * entry groups.
     *
     * Generated from protobuf field <code>repeated string projects = 2 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProjects($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->projects = $arr;

        return $this;
    }

    /**
     * The entry groups whose metadata you want to export, in the format
     * `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
     * Only the entries in the specified entry groups are exported.
     * The entry groups must be in the same location and the same VPC Service
     * Controls perimeter as the job.
     * If you set the job scope to be a list of entry groups, then set the
     * organization-level export flag to false and don't provide a list of
     * projects.
     *
     * Generated from protobuf field <code>repeated string entry_groups = 3 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntryGroups()
    {
        return $this->entry_groups;
    }

    /**
     * The entry groups whose metadata you want to export, in the format
     * `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
     * Only the entries in the specified entry groups are exported.
     * The entry groups must be in the same location and the same VPC Service
     * Controls perimeter as the job.
     * If you set the job scope to be a list of entry groups, then set the
     * organization-level export flag to false and don't provide a list of
     * projects.
     *
     * Generated from protobuf field <code>repeated string entry_groups = 3 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntryGroups($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->entry_groups = $arr;

        return $this;
    }

    /**
     * The entry types that are in scope for the export job, specified as
     * relative resource names in the format
     * `projects/{project_id_or_number}/locations/{location}/entryTypes/{entry_type_id}`.
     * Only entries that belong to the specified entry types are affected by
     * the job.
     *
     * Generated from protobuf field <code>repeated string entry_types = 4 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntryTypes()
    {
        return $this->entry_types;
    }

    /**
     * The entry types that are in scope for the export job, specified as
     * relative resource names in the format
     * `projects/{project_id_or_number}/locations/{location}/entryTypes/{entry_type_id}`.
     * Only entries that belong to the specified entry types are affected by
     * the job.
     *
     * Generated from protobuf field <code>repeated string entry_types = 4 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntryTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->entry_types = $arr;

        return $this;
    }

    /**
     * The aspect types that are in scope for the export job, specified as
     * relative resource names in the format
     * `projects/{project_id_or_number}/locations/{location}/aspectTypes/{aspect_type_id}`.
     * Only aspects that belong to the specified aspect types are affected by
     * the job.
     *
     * Generated from protobuf field <code>repeated string aspect_types = 5 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAspectTypes()
    {
        return $this->aspect_types;
    }

    /**
     * The aspect types that are in scope for the export job, specified as
     * relative resource names in the format
     * `projects/{project_id_or_number}/locations/{location}/aspectTypes/{aspect_type_id}`.
     * Only aspects that belong to the specified aspect types are affected by
     * the job.
     *
     * Generated from protobuf field <code>repeated string aspect_types = 5 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAspectTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->aspect_types = $arr;

        return $this;
    }

}


