<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4beta1/event.proto

namespace Google\Cloud\Talent\V4beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An event issued when an end user interacts with the application that
 * implements Cloud Talent Solution. Providing this information improves the
 * quality of search and recommendation for the API clients, enabling the
 * service to perform optimally. The number of events sent must be consistent
 * with other calls, such as job searches, issued to the service by the client.
 *
 * Generated from protobuf message <code>google.cloud.talent.v4beta1.ClientEvent</code>
 */
class ClientEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * Required.
     * A unique ID generated in the API responses. It can be found in
     * [ResponseMetadata.request_id][google.cloud.talent.v4beta1.ResponseMetadata.request_id].
     *
     * Generated from protobuf field <code>string request_id = 1;</code>
     */
    private $request_id = '';
    /**
     * Required.
     * A unique identifier, generated by the client application. This `event_id`
     * is used to establish the relationship between different events
     * (see [parent_event_id][google.cloud.talent.v4beta1.ClientEvent.parent_event_id]).
     *
     * Generated from protobuf field <code>string event_id = 2;</code>
     */
    private $event_id = '';
    /**
     * Required except the first event.
     * The event_id of an event that resulted in the current event. For example, a
     * [Job view][JobEventType.VIEW] event usually follows a parent
     * [impression][JobEventType.IMPRESSION] event: A job seeker first does a
     * search where a list of jobs appears
     * ([impression][JobEventType.IMPRESSION]). The job seeker then selects a
     * result and views the description of a particular job ([Job
     * view][JobEventType.VIEW]).
     *
     * Generated from protobuf field <code>string parent_event_id = 3;</code>
     */
    private $parent_event_id = '';
    /**
     * Required.
     * The timestamp of the event.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private $create_time = null;
    /**
     * Optional.
     * Extra information about this event. Used for storing information with no
     * matching field in [event][google.cloud.talent.v4beta1.event] payload, for example, user application specific
     * context or details.
     * At most 20 keys are supported. The maximum total size of all keys and
     * values is 2 KB.
     *
     * Generated from protobuf field <code>map<string, string> extra_info = 7;</code>
     */
    private $extra_info;
    protected $event;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $request_id
     *           Required.
     *           A unique ID generated in the API responses. It can be found in
     *           [ResponseMetadata.request_id][google.cloud.talent.v4beta1.ResponseMetadata.request_id].
     *     @type string $event_id
     *           Required.
     *           A unique identifier, generated by the client application. This `event_id`
     *           is used to establish the relationship between different events
     *           (see [parent_event_id][google.cloud.talent.v4beta1.ClientEvent.parent_event_id]).
     *     @type string $parent_event_id
     *           Required except the first event.
     *           The event_id of an event that resulted in the current event. For example, a
     *           [Job view][JobEventType.VIEW] event usually follows a parent
     *           [impression][JobEventType.IMPRESSION] event: A job seeker first does a
     *           search where a list of jobs appears
     *           ([impression][JobEventType.IMPRESSION]). The job seeker then selects a
     *           result and views the description of a particular job ([Job
     *           view][JobEventType.VIEW]).
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Required.
     *           The timestamp of the event.
     *     @type \Google\Cloud\Talent\V4beta1\JobEvent $job_event
     *           An event issued when a job seeker interacts with the application that
     *           implements Cloud Talent Solution.
     *     @type \Google\Cloud\Talent\V4beta1\ProfileEvent $profile_event
     *           An event issued when a profile searcher interacts with the application
     *           that implements Cloud Talent Solution.
     *     @type array|\Google\Protobuf\Internal\MapField $extra_info
     *           Optional.
     *           Extra information about this event. Used for storing information with no
     *           matching field in [event][google.cloud.talent.v4beta1.event] payload, for example, user application specific
     *           context or details.
     *           At most 20 keys are supported. The maximum total size of all keys and
     *           values is 2 KB.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4Beta1\Event::initOnce();
        parent::__construct($data);
    }

    /**
     * Required.
     * A unique ID generated in the API responses. It can be found in
     * [ResponseMetadata.request_id][google.cloud.talent.v4beta1.ResponseMetadata.request_id].
     *
     * Generated from protobuf field <code>string request_id = 1;</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Required.
     * A unique ID generated in the API responses. It can be found in
     * [ResponseMetadata.request_id][google.cloud.talent.v4beta1.ResponseMetadata.request_id].
     *
     * Generated from protobuf field <code>string request_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

    /**
     * Required.
     * A unique identifier, generated by the client application. This `event_id`
     * is used to establish the relationship between different events
     * (see [parent_event_id][google.cloud.talent.v4beta1.ClientEvent.parent_event_id]).
     *
     * Generated from protobuf field <code>string event_id = 2;</code>
     * @return string
     */
    public function getEventId()
    {
        return $this->event_id;
    }

    /**
     * Required.
     * A unique identifier, generated by the client application. This `event_id`
     * is used to establish the relationship between different events
     * (see [parent_event_id][google.cloud.talent.v4beta1.ClientEvent.parent_event_id]).
     *
     * Generated from protobuf field <code>string event_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setEventId($var)
    {
        GPBUtil::checkString($var, True);
        $this->event_id = $var;

        return $this;
    }

    /**
     * Required except the first event.
     * The event_id of an event that resulted in the current event. For example, a
     * [Job view][JobEventType.VIEW] event usually follows a parent
     * [impression][JobEventType.IMPRESSION] event: A job seeker first does a
     * search where a list of jobs appears
     * ([impression][JobEventType.IMPRESSION]). The job seeker then selects a
     * result and views the description of a particular job ([Job
     * view][JobEventType.VIEW]).
     *
     * Generated from protobuf field <code>string parent_event_id = 3;</code>
     * @return string
     */
    public function getParentEventId()
    {
        return $this->parent_event_id;
    }

    /**
     * Required except the first event.
     * The event_id of an event that resulted in the current event. For example, a
     * [Job view][JobEventType.VIEW] event usually follows a parent
     * [impression][JobEventType.IMPRESSION] event: A job seeker first does a
     * search where a list of jobs appears
     * ([impression][JobEventType.IMPRESSION]). The job seeker then selects a
     * result and views the description of a particular job ([Job
     * view][JobEventType.VIEW]).
     *
     * Generated from protobuf field <code>string parent_event_id = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setParentEventId($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent_event_id = $var;

        return $this;
    }

    /**
     * Required.
     * The timestamp of the event.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    /**
     * Required.
     * The timestamp of the event.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.JobEvent job_event = 5;</code>
     * @return \Google\Cloud\Talent\V4beta1\JobEvent
     */
    public function getJobEvent()
    {
        return $this->readOneof(5);
    }

    /**
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.JobEvent job_event = 5;</code>
     * @param \Google\Cloud\Talent\V4beta1\JobEvent $var
     * @return $this
     */
    public function setJobEvent($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\JobEvent::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * An event issued when a profile searcher interacts with the application
     * that implements Cloud Talent Solution.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.ProfileEvent profile_event = 6;</code>
     * @return \Google\Cloud\Talent\V4beta1\ProfileEvent
     */
    public function getProfileEvent()
    {
        return $this->readOneof(6);
    }

    /**
     * An event issued when a profile searcher interacts with the application
     * that implements Cloud Talent Solution.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.ProfileEvent profile_event = 6;</code>
     * @param \Google\Cloud\Talent\V4beta1\ProfileEvent $var
     * @return $this
     */
    public function setProfileEvent($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\ProfileEvent::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Optional.
     * Extra information about this event. Used for storing information with no
     * matching field in [event][google.cloud.talent.v4beta1.event] payload, for example, user application specific
     * context or details.
     * At most 20 keys are supported. The maximum total size of all keys and
     * values is 2 KB.
     *
     * Generated from protobuf field <code>map<string, string> extra_info = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getExtraInfo()
    {
        return $this->extra_info;
    }

    /**
     * Optional.
     * Extra information about this event. Used for storing information with no
     * matching field in [event][google.cloud.talent.v4beta1.event] payload, for example, user application specific
     * context or details.
     * At most 20 keys are supported. The maximum total size of all keys and
     * values is 2 KB.
     *
     * Generated from protobuf field <code>map<string, string> extra_info = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setExtraInfo($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->extra_info = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getEvent()
    {
        return $this->whichOneof("event");
    }

}

