<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v1/cloudbuild.proto

namespace Google\Cloud\Build\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Pairs a set of secret environment variables mapped to encrypted
 * values with the Cloud KMS key to use to decrypt the value.
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v1.InlineSecret</code>
 */
class InlineSecret extends \Google\Protobuf\Internal\Message
{
    /**
     * Resource name of Cloud KMS crypto key to decrypt the encrypted value.
     * In format: projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;
     *
     * Generated from protobuf field <code>string kms_key_name = 1 [(.google.api.resource_reference) = {</code>
     */
    private $kms_key_name = '';
    /**
     * Map of environment variable name to its encrypted value.
     * Secret environment variables must be unique across all of a build's
     * secrets, and must be used by at least one build step. Values can be at most
     * 64 KB in size. There can be at most 100 secret values across all of a
     * build's secrets.
     *
     * Generated from protobuf field <code>map<string, bytes> env_map = 2;</code>
     */
    private $env_map;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $kms_key_name
     *           Resource name of Cloud KMS crypto key to decrypt the encrypted value.
     *           In format: projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;
     *     @type array|\Google\Protobuf\Internal\MapField $env_map
     *           Map of environment variable name to its encrypted value.
     *           Secret environment variables must be unique across all of a build's
     *           secrets, and must be used by at least one build step. Values can be at most
     *           64 KB in size. There can be at most 100 secret values across all of a
     *           build's secrets.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudbuild\V1\Cloudbuild::initOnce();
        parent::__construct($data);
    }

    /**
     * Resource name of Cloud KMS crypto key to decrypt the encrypted value.
     * In format: projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;
     *
     * Generated from protobuf field <code>string kms_key_name = 1 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKeyName()
    {
        return $this->kms_key_name;
    }

    /**
     * Resource name of Cloud KMS crypto key to decrypt the encrypted value.
     * In format: projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;
     *
     * Generated from protobuf field <code>string kms_key_name = 1 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_name = $var;

        return $this;
    }

    /**
     * Map of environment variable name to its encrypted value.
     * Secret environment variables must be unique across all of a build's
     * secrets, and must be used by at least one build step. Values can be at most
     * 64 KB in size. There can be at most 100 secret values across all of a
     * build's secrets.
     *
     * Generated from protobuf field <code>map<string, bytes> env_map = 2;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getEnvMap()
    {
        return $this->env_map;
    }

    /**
     * Map of environment variable name to its encrypted value.
     * Secret environment variables must be unique across all of a build's
     * secrets, and must be used by at least one build step. Values can be at most
     * 64 KB in size. There can be at most 100 secret values across all of a
     * build's secrets.
     *
     * Generated from protobuf field <code>map<string, bytes> env_map = 2;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setEnvMap($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::BYTES);
        $this->env_map = $arr;

        return $this;
    }

}

