<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/templates.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A request to create a Cloud Dataflow job from a template.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.CreateJobFromTemplateRequest</code>
 */
class CreateJobFromTemplateRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     */
    private $project_id = '';
    /**
     * Required. The job name to use for the created job.
     *
     * Generated from protobuf field <code>string job_name = 4;</code>
     */
    private $job_name = '';
    /**
     * The runtime parameters to pass to the job.
     *
     * Generated from protobuf field <code>map<string, string> parameters = 3;</code>
     */
    private $parameters;
    /**
     * The runtime environment for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.RuntimeEnvironment environment = 5;</code>
     */
    private $environment = null;
    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 6;</code>
     */
    private $location = '';
    protected $template;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $project_id
     *           Required. The ID of the Cloud Platform project that the job belongs to.
     *     @type string $job_name
     *           Required. The job name to use for the created job.
     *     @type string $gcs_path
     *           Required. A Cloud Storage path to the template from which to
     *           create the job.
     *           Must be a valid Cloud Storage URL, beginning with `gs://`.
     *     @type array|\Google\Protobuf\Internal\MapField $parameters
     *           The runtime parameters to pass to the job.
     *     @type \Google\Cloud\Dataflow\V1beta3\RuntimeEnvironment $environment
     *           The runtime environment for the job.
     *     @type string $location
     *           The [regional endpoint]
     *           (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     *           which to direct the request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Templates::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * Required. The ID of the Cloud Platform project that the job belongs to.
     *
     * Generated from protobuf field <code>string project_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Required. The job name to use for the created job.
     *
     * Generated from protobuf field <code>string job_name = 4;</code>
     * @return string
     */
    public function getJobName()
    {
        return $this->job_name;
    }

    /**
     * Required. The job name to use for the created job.
     *
     * Generated from protobuf field <code>string job_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setJobName($var)
    {
        GPBUtil::checkString($var, True);
        $this->job_name = $var;

        return $this;
    }

    /**
     * Required. A Cloud Storage path to the template from which to
     * create the job.
     * Must be a valid Cloud Storage URL, beginning with `gs://`.
     *
     * Generated from protobuf field <code>string gcs_path = 2;</code>
     * @return string
     */
    public function getGcsPath()
    {
        return $this->readOneof(2);
    }

    public function hasGcsPath()
    {
        return $this->hasOneof(2);
    }

    /**
     * Required. A Cloud Storage path to the template from which to
     * create the job.
     * Must be a valid Cloud Storage URL, beginning with `gs://`.
     *
     * Generated from protobuf field <code>string gcs_path = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setGcsPath($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The runtime parameters to pass to the job.
     *
     * Generated from protobuf field <code>map<string, string> parameters = 3;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    /**
     * The runtime parameters to pass to the job.
     *
     * Generated from protobuf field <code>map<string, string> parameters = 3;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setParameters($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->parameters = $arr;

        return $this;
    }

    /**
     * The runtime environment for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.RuntimeEnvironment environment = 5;</code>
     * @return \Google\Cloud\Dataflow\V1beta3\RuntimeEnvironment|null
     */
    public function getEnvironment()
    {
        return isset($this->environment) ? $this->environment : null;
    }

    public function hasEnvironment()
    {
        return isset($this->environment);
    }

    public function clearEnvironment()
    {
        unset($this->environment);
    }

    /**
     * The runtime environment for the job.
     *
     * Generated from protobuf field <code>.google.dataflow.v1beta3.RuntimeEnvironment environment = 5;</code>
     * @param \Google\Cloud\Dataflow\V1beta3\RuntimeEnvironment $var
     * @return $this
     */
    public function setEnvironment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dataflow\V1beta3\RuntimeEnvironment::class);
        $this->environment = $var;

        return $this;
    }

    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 6;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * The [regional endpoint]
     * (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) to
     * which to direct the request.
     *
     * Generated from protobuf field <code>string location = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTemplate()
    {
        return $this->whichOneof("template");
    }

}

