<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v1p1beta1/resource.proto

namespace Google\Cloud\Speech\V1p1beta1\PhraseSet;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A phrases containing words and phrase "hints" so that
 * the speech recognition is more likely to recognize them. This can be used
 * to improve the accuracy for specific words and phrases, for example, if
 * specific commands are typically spoken by the user. This can also be used
 * to add additional words to the vocabulary of the recognizer. See
 * [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
 * List items can also include pre-built or custom classes containing groups
 * of words that represent common concepts that occur in natural language. For
 * example, rather than providing a phrase hint for every month of the
 * year (e.g. "i was born in january", "i was born in febuary", ...), use the
 * pre-built `$MONTH` class improves the likelihood of correctly transcribing
 * audio that includes months (e.g. "i was born in $month").
 * To refer to pre-built classes, use the class' symbol prepended with `$`
 * e.g. `$MONTH`. To refer to custom classes that were defined inline in the
 * request, set the class's `custom_class_id` to a string unique to all class
 * resources and inline classes. Then use the class' id wrapped in $`{...}`
 * e.g. "${my-months}". To refer to custom classes resources, use the class'
 * id wrapped in `${}` (e.g. `${my-months}`).
 * Speech-to-Text supports three locations: `global`, `us` (US North America),
 * and `eu` (Europe). If you are calling the `speech.googleapis.com`
 * endpoint, use the `global` location. To specify a region, use a
 * [regional endpoint](https://cloud.google.com/speech-to-text/docs/endpoints) with matching `us` or
 * `eu` location value.
 *
 * Generated from protobuf message <code>google.cloud.speech.v1p1beta1.PhraseSet.Phrase</code>
 */
class Phrase extends \Google\Protobuf\Internal\Message
{
    /**
     * The phrase itself.
     *
     * Generated from protobuf field <code>string value = 1;</code>
     */
    private $value = '';
    /**
     * Hint Boost. Overrides the boost set at the phrase set level.
     * Positive value will increase the probability that a specific phrase will
     * be recognized over other similar sounding phrases. The higher the boost,
     * the higher the chance of false positive recognition as well. Negative
     * boost will simply be ignored. Though `boost` can accept a wide range of
     * positive values, most use cases are best served
     * with values between 0 and 20. We recommend using a binary search approach
     * to finding the optimal value for your use case. Speech recognition
     * will skip PhraseSets with a boost value of 0.
     *
     * Generated from protobuf field <code>float boost = 2;</code>
     */
    private $boost = 0.0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $value
     *           The phrase itself.
     *     @type float $boost
     *           Hint Boost. Overrides the boost set at the phrase set level.
     *           Positive value will increase the probability that a specific phrase will
     *           be recognized over other similar sounding phrases. The higher the boost,
     *           the higher the chance of false positive recognition as well. Negative
     *           boost will simply be ignored. Though `boost` can accept a wide range of
     *           positive values, most use cases are best served
     *           with values between 0 and 20. We recommend using a binary search approach
     *           to finding the optimal value for your use case. Speech recognition
     *           will skip PhraseSets with a boost value of 0.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V1P1Beta1\Resource::initOnce();
        parent::__construct($data);
    }

    /**
     * The phrase itself.
     *
     * Generated from protobuf field <code>string value = 1;</code>
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * The phrase itself.
     *
     * Generated from protobuf field <code>string value = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setValue($var)
    {
        GPBUtil::checkString($var, True);
        $this->value = $var;

        return $this;
    }

    /**
     * Hint Boost. Overrides the boost set at the phrase set level.
     * Positive value will increase the probability that a specific phrase will
     * be recognized over other similar sounding phrases. The higher the boost,
     * the higher the chance of false positive recognition as well. Negative
     * boost will simply be ignored. Though `boost` can accept a wide range of
     * positive values, most use cases are best served
     * with values between 0 and 20. We recommend using a binary search approach
     * to finding the optimal value for your use case. Speech recognition
     * will skip PhraseSets with a boost value of 0.
     *
     * Generated from protobuf field <code>float boost = 2;</code>
     * @return float
     */
    public function getBoost()
    {
        return $this->boost;
    }

    /**
     * Hint Boost. Overrides the boost set at the phrase set level.
     * Positive value will increase the probability that a specific phrase will
     * be recognized over other similar sounding phrases. The higher the boost,
     * the higher the chance of false positive recognition as well. Negative
     * boost will simply be ignored. Though `boost` can accept a wide range of
     * positive values, most use cases are best served
     * with values between 0 and 20. We recommend using a binary search approach
     * to finding the optimal value for your use case. Speech recognition
     * will skip PhraseSets with a boost value of 0.
     *
     * Generated from protobuf field <code>float boost = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setBoost($var)
    {
        GPBUtil::checkFloat($var);
        $this->boost = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Phrase::class, \Google\Cloud\Speech\V1p1beta1\PhraseSet_Phrase::class);

