<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/catalog.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configures what level the product should be uploaded with regards to
 * how users will be send events and how predictions will be made.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.ProductLevelConfig</code>
 */
class ProductLevelConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The type of [Product][google.cloud.retail.v2.Product]s allowed to be
     * ingested into the catalog. Acceptable values are:
     * * `primary` (default): You can ingest
     * [Product][google.cloud.retail.v2.Product]s of all types. When
     *   ingesting a [Product][google.cloud.retail.v2.Product], its type will
     *   default to
     *   [Product.Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] if
     *   unset.
     * * `variant`: You can only ingest
     * [Product.Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     *   This means
     *   [Product.primary_product_id][google.cloud.retail.v2.Product.primary_product_id]
     *   cannot be empty.
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * If this field is `variant` and
     * [merchant_center_product_id_field][google.cloud.retail.v2.ProductLevelConfig.merchant_center_product_id_field]
     * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     * See [Using product
     * levels](https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
     * for more details.
     *
     * Generated from protobuf field <code>string ingestion_product_type = 1;</code>
     */
    private $ingestion_product_type = '';
    /**
     * Which field of [Merchant Center
     * Product](https://cloud.google.com/bigquery-transfer/docs/merchant-center-products-schema) should be
     * imported as [Product.id][google.cloud.retail.v2.Product.id]. Acceptable
     * values are:
     * * `offerId` (default): Import `offerId` as the product ID.
     * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *   API will choose one item from the ones with the same `itemGroupId`, and
     *   use it to represent the item group.
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * If this field is `itemGroupId` and
     * [ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * is `variant`, an INVALID_ARGUMENT error is returned.
     * See [Using product
     * levels](https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
     * for more details.
     *
     * Generated from protobuf field <code>string merchant_center_product_id_field = 2;</code>
     */
    private $merchant_center_product_id_field = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $ingestion_product_type
     *           The type of [Product][google.cloud.retail.v2.Product]s allowed to be
     *           ingested into the catalog. Acceptable values are:
     *           * `primary` (default): You can ingest
     *           [Product][google.cloud.retail.v2.Product]s of all types. When
     *             ingesting a [Product][google.cloud.retail.v2.Product], its type will
     *             default to
     *             [Product.Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] if
     *             unset.
     *           * `variant`: You can only ingest
     *           [Product.Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     *           [Product][google.cloud.retail.v2.Product]s.
     *             This means
     *             [Product.primary_product_id][google.cloud.retail.v2.Product.primary_product_id]
     *             cannot be empty.
     *           If this field is set to an invalid value other than these, an
     *           INVALID_ARGUMENT error is returned.
     *           If this field is `variant` and
     *           [merchant_center_product_id_field][google.cloud.retail.v2.ProductLevelConfig.merchant_center_product_id_field]
     *           is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     *           See [Using product
     *           levels](https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
     *           for more details.
     *     @type string $merchant_center_product_id_field
     *           Which field of [Merchant Center
     *           Product](https://cloud.google.com/bigquery-transfer/docs/merchant-center-products-schema) should be
     *           imported as [Product.id][google.cloud.retail.v2.Product.id]. Acceptable
     *           values are:
     *           * `offerId` (default): Import `offerId` as the product ID.
     *           * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *             API will choose one item from the ones with the same `itemGroupId`, and
     *             use it to represent the item group.
     *           If this field is set to an invalid value other than these, an
     *           INVALID_ARGUMENT error is returned.
     *           If this field is `itemGroupId` and
     *           [ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     *           is `variant`, an INVALID_ARGUMENT error is returned.
     *           See [Using product
     *           levels](https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
     *           for more details.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\Catalog::initOnce();
        parent::__construct($data);
    }

    /**
     * The type of [Product][google.cloud.retail.v2.Product]s allowed to be
     * ingested into the catalog. Acceptable values are:
     * * `primary` (default): You can ingest
     * [Product][google.cloud.retail.v2.Product]s of all types. When
     *   ingesting a [Product][google.cloud.retail.v2.Product], its type will
     *   default to
     *   [Product.Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] if
     *   unset.
     * * `variant`: You can only ingest
     * [Product.Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     *   This means
     *   [Product.primary_product_id][google.cloud.retail.v2.Product.primary_product_id]
     *   cannot be empty.
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * If this field is `variant` and
     * [merchant_center_product_id_field][google.cloud.retail.v2.ProductLevelConfig.merchant_center_product_id_field]
     * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     * See [Using product
     * levels](https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
     * for more details.
     *
     * Generated from protobuf field <code>string ingestion_product_type = 1;</code>
     * @return string
     */
    public function getIngestionProductType()
    {
        return $this->ingestion_product_type;
    }

    /**
     * The type of [Product][google.cloud.retail.v2.Product]s allowed to be
     * ingested into the catalog. Acceptable values are:
     * * `primary` (default): You can ingest
     * [Product][google.cloud.retail.v2.Product]s of all types. When
     *   ingesting a [Product][google.cloud.retail.v2.Product], its type will
     *   default to
     *   [Product.Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY] if
     *   unset.
     * * `variant`: You can only ingest
     * [Product.Type.VARIANT][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s.
     *   This means
     *   [Product.primary_product_id][google.cloud.retail.v2.Product.primary_product_id]
     *   cannot be empty.
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * If this field is `variant` and
     * [merchant_center_product_id_field][google.cloud.retail.v2.ProductLevelConfig.merchant_center_product_id_field]
     * is `itemGroupId`, an INVALID_ARGUMENT error is returned.
     * See [Using product
     * levels](https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
     * for more details.
     *
     * Generated from protobuf field <code>string ingestion_product_type = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setIngestionProductType($var)
    {
        GPBUtil::checkString($var, True);
        $this->ingestion_product_type = $var;

        return $this;
    }

    /**
     * Which field of [Merchant Center
     * Product](https://cloud.google.com/bigquery-transfer/docs/merchant-center-products-schema) should be
     * imported as [Product.id][google.cloud.retail.v2.Product.id]. Acceptable
     * values are:
     * * `offerId` (default): Import `offerId` as the product ID.
     * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *   API will choose one item from the ones with the same `itemGroupId`, and
     *   use it to represent the item group.
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * If this field is `itemGroupId` and
     * [ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * is `variant`, an INVALID_ARGUMENT error is returned.
     * See [Using product
     * levels](https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
     * for more details.
     *
     * Generated from protobuf field <code>string merchant_center_product_id_field = 2;</code>
     * @return string
     */
    public function getMerchantCenterProductIdField()
    {
        return $this->merchant_center_product_id_field;
    }

    /**
     * Which field of [Merchant Center
     * Product](https://cloud.google.com/bigquery-transfer/docs/merchant-center-products-schema) should be
     * imported as [Product.id][google.cloud.retail.v2.Product.id]. Acceptable
     * values are:
     * * `offerId` (default): Import `offerId` as the product ID.
     * * `itemGroupId`: Import `itemGroupId` as the product ID. Notice that Retail
     *   API will choose one item from the ones with the same `itemGroupId`, and
     *   use it to represent the item group.
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     * If this field is `itemGroupId` and
     * [ingestion_product_type][google.cloud.retail.v2.ProductLevelConfig.ingestion_product_type]
     * is `variant`, an INVALID_ARGUMENT error is returned.
     * See [Using product
     * levels](https://cloud.google.com/retail/recommendations-ai/docs/catalog#product-levels)
     * for more details.
     *
     * Generated from protobuf field <code>string merchant_center_product_id_field = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setMerchantCenterProductIdField($var)
    {
        GPBUtil::checkString($var, True);
        $this->merchant_center_product_id_field = $var;

        return $this;
    }

}

