<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * SecurityBulletinEvent is a notification sent to customers when a security
 * bulletin has been posted that they are vulnerable to.
 *
 * Generated from protobuf message <code>google.container.v1.SecurityBulletinEvent</code>
 */
class SecurityBulletinEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource type (node/control plane) that has the vulnerability. Multiple
     * notifications (1 notification per resource type) will be sent for a
     * vulnerability that affects > 1 resource type.
     *
     * Generated from protobuf field <code>string resource_type_affected = 1;</code>
     */
    private $resource_type_affected = '';
    /**
     * The ID of the bulletin corresponding to the vulnerability.
     *
     * Generated from protobuf field <code>string bulletin_id = 2;</code>
     */
    private $bulletin_id = '';
    /**
     * The CVEs associated with this bulletin.
     *
     * Generated from protobuf field <code>repeated string cve_ids = 3;</code>
     */
    private $cve_ids;
    /**
     * The severity of this bulletin as it relates to GKE.
     *
     * Generated from protobuf field <code>string severity = 4;</code>
     */
    private $severity = '';
    /**
     * The URI link to the bulletin on the website for more information.
     *
     * Generated from protobuf field <code>string bulletin_uri = 5;</code>
     */
    private $bulletin_uri = '';
    /**
     * A brief description of the bulletin. See the bulletin pointed to by the
     * bulletin_uri field for an expanded description.
     *
     * Generated from protobuf field <code>string brief_description = 6;</code>
     */
    private $brief_description = '';
    /**
     * The GKE minor versions affected by this vulnerability.
     *
     * Generated from protobuf field <code>repeated string affected_supported_minors = 7;</code>
     */
    private $affected_supported_minors;
    /**
     * The GKE versions where this vulnerability is patched.
     *
     * Generated from protobuf field <code>repeated string patched_versions = 8;</code>
     */
    private $patched_versions;
    /**
     * This represents a version selected from the patched_versions field that
     * the cluster receiving this notification should most likely want to upgrade
     * to based on its current version. Note that if this notification is being
     * received by a given cluster, it means that this version is currently
     * available as an upgrade target in that cluster's location.
     *
     * Generated from protobuf field <code>string suggested_upgrade_target = 9;</code>
     */
    private $suggested_upgrade_target = '';
    /**
     * If this field is specified, it means there are manual steps that the user
     * must take to make their clusters safe.
     *
     * Generated from protobuf field <code>bool manual_steps_required = 10;</code>
     */
    private $manual_steps_required = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $resource_type_affected
     *           The resource type (node/control plane) that has the vulnerability. Multiple
     *           notifications (1 notification per resource type) will be sent for a
     *           vulnerability that affects > 1 resource type.
     *     @type string $bulletin_id
     *           The ID of the bulletin corresponding to the vulnerability.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $cve_ids
     *           The CVEs associated with this bulletin.
     *     @type string $severity
     *           The severity of this bulletin as it relates to GKE.
     *     @type string $bulletin_uri
     *           The URI link to the bulletin on the website for more information.
     *     @type string $brief_description
     *           A brief description of the bulletin. See the bulletin pointed to by the
     *           bulletin_uri field for an expanded description.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $affected_supported_minors
     *           The GKE minor versions affected by this vulnerability.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $patched_versions
     *           The GKE versions where this vulnerability is patched.
     *     @type string $suggested_upgrade_target
     *           This represents a version selected from the patched_versions field that
     *           the cluster receiving this notification should most likely want to upgrade
     *           to based on its current version. Note that if this notification is being
     *           received by a given cluster, it means that this version is currently
     *           available as an upgrade target in that cluster's location.
     *     @type bool $manual_steps_required
     *           If this field is specified, it means there are manual steps that the user
     *           must take to make their clusters safe.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource type (node/control plane) that has the vulnerability. Multiple
     * notifications (1 notification per resource type) will be sent for a
     * vulnerability that affects > 1 resource type.
     *
     * Generated from protobuf field <code>string resource_type_affected = 1;</code>
     * @return string
     */
    public function getResourceTypeAffected()
    {
        return $this->resource_type_affected;
    }

    /**
     * The resource type (node/control plane) that has the vulnerability. Multiple
     * notifications (1 notification per resource type) will be sent for a
     * vulnerability that affects > 1 resource type.
     *
     * Generated from protobuf field <code>string resource_type_affected = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceTypeAffected($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_type_affected = $var;

        return $this;
    }

    /**
     * The ID of the bulletin corresponding to the vulnerability.
     *
     * Generated from protobuf field <code>string bulletin_id = 2;</code>
     * @return string
     */
    public function getBulletinId()
    {
        return $this->bulletin_id;
    }

    /**
     * The ID of the bulletin corresponding to the vulnerability.
     *
     * Generated from protobuf field <code>string bulletin_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setBulletinId($var)
    {
        GPBUtil::checkString($var, True);
        $this->bulletin_id = $var;

        return $this;
    }

    /**
     * The CVEs associated with this bulletin.
     *
     * Generated from protobuf field <code>repeated string cve_ids = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCveIds()
    {
        return $this->cve_ids;
    }

    /**
     * The CVEs associated with this bulletin.
     *
     * Generated from protobuf field <code>repeated string cve_ids = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCveIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->cve_ids = $arr;

        return $this;
    }

    /**
     * The severity of this bulletin as it relates to GKE.
     *
     * Generated from protobuf field <code>string severity = 4;</code>
     * @return string
     */
    public function getSeverity()
    {
        return $this->severity;
    }

    /**
     * The severity of this bulletin as it relates to GKE.
     *
     * Generated from protobuf field <code>string severity = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setSeverity($var)
    {
        GPBUtil::checkString($var, True);
        $this->severity = $var;

        return $this;
    }

    /**
     * The URI link to the bulletin on the website for more information.
     *
     * Generated from protobuf field <code>string bulletin_uri = 5;</code>
     * @return string
     */
    public function getBulletinUri()
    {
        return $this->bulletin_uri;
    }

    /**
     * The URI link to the bulletin on the website for more information.
     *
     * Generated from protobuf field <code>string bulletin_uri = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setBulletinUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->bulletin_uri = $var;

        return $this;
    }

    /**
     * A brief description of the bulletin. See the bulletin pointed to by the
     * bulletin_uri field for an expanded description.
     *
     * Generated from protobuf field <code>string brief_description = 6;</code>
     * @return string
     */
    public function getBriefDescription()
    {
        return $this->brief_description;
    }

    /**
     * A brief description of the bulletin. See the bulletin pointed to by the
     * bulletin_uri field for an expanded description.
     *
     * Generated from protobuf field <code>string brief_description = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setBriefDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->brief_description = $var;

        return $this;
    }

    /**
     * The GKE minor versions affected by this vulnerability.
     *
     * Generated from protobuf field <code>repeated string affected_supported_minors = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAffectedSupportedMinors()
    {
        return $this->affected_supported_minors;
    }

    /**
     * The GKE minor versions affected by this vulnerability.
     *
     * Generated from protobuf field <code>repeated string affected_supported_minors = 7;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAffectedSupportedMinors($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->affected_supported_minors = $arr;

        return $this;
    }

    /**
     * The GKE versions where this vulnerability is patched.
     *
     * Generated from protobuf field <code>repeated string patched_versions = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPatchedVersions()
    {
        return $this->patched_versions;
    }

    /**
     * The GKE versions where this vulnerability is patched.
     *
     * Generated from protobuf field <code>repeated string patched_versions = 8;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPatchedVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->patched_versions = $arr;

        return $this;
    }

    /**
     * This represents a version selected from the patched_versions field that
     * the cluster receiving this notification should most likely want to upgrade
     * to based on its current version. Note that if this notification is being
     * received by a given cluster, it means that this version is currently
     * available as an upgrade target in that cluster's location.
     *
     * Generated from protobuf field <code>string suggested_upgrade_target = 9;</code>
     * @return string
     */
    public function getSuggestedUpgradeTarget()
    {
        return $this->suggested_upgrade_target;
    }

    /**
     * This represents a version selected from the patched_versions field that
     * the cluster receiving this notification should most likely want to upgrade
     * to based on its current version. Note that if this notification is being
     * received by a given cluster, it means that this version is currently
     * available as an upgrade target in that cluster's location.
     *
     * Generated from protobuf field <code>string suggested_upgrade_target = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setSuggestedUpgradeTarget($var)
    {
        GPBUtil::checkString($var, True);
        $this->suggested_upgrade_target = $var;

        return $this;
    }

    /**
     * If this field is specified, it means there are manual steps that the user
     * must take to make their clusters safe.
     *
     * Generated from protobuf field <code>bool manual_steps_required = 10;</code>
     * @return bool
     */
    public function getManualStepsRequired()
    {
        return $this->manual_steps_required;
    }

    /**
     * If this field is specified, it means there are manual steps that the user
     * must take to make their clusters safe.
     *
     * Generated from protobuf field <code>bool manual_steps_required = 10;</code>
     * @param bool $var
     * @return $this
     */
    public function setManualStepsRequired($var)
    {
        GPBUtil::checkBool($var);
        $this->manual_steps_required = $var;

        return $this;
    }

}

