<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/spanner.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The response for
 * [ExecuteBatchDml][google.spanner.v1.Spanner.ExecuteBatchDml]. Contains a list
 * of [ResultSet][google.spanner.v1.ResultSet], one for each DML statement that
 * has successfully executed. If a statement fails, the error is returned as
 * part of the response payload. Clients can determine whether all DML
 * statements have run successfully, or if a statement failed, using one of the
 * following approaches:
 *   1. Check if 'status' field is OkStatus.
 *   2. Check if result_sets_size() equals the number of statements in
 *      [ExecuteBatchDmlRequest][Spanner.ExecuteBatchDmlRequest].
 * Example 1: A request with 5 DML statements, all executed successfully.
 * Result: A response with 5 ResultSets, one for each statement in the same
 * order, and an OK status.
 * Example 2: A request with 5 DML statements. The 3rd statement has a syntax
 * error.
 * Result: A response with 2 ResultSets, for the first 2 statements that
 * run successfully, and a syntax error (INVALID_ARGUMENT) status. From
 * result_set_size() client can determine that the 3rd statement has failed.
 *
 * Generated from protobuf message <code>google.spanner.v1.ExecuteBatchDmlResponse</code>
 */
class ExecuteBatchDmlResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * ResultSets, one for each statement in the request that ran successfully, in
     * the same order as the statements in the request. Each
     * [ResultSet][google.spanner.v1.ResultSet] will not contain any rows. The
     * [ResultSetStats][google.spanner.v1.ResultSetStats] in each
     * [ResultSet][google.spanner.v1.ResultSet] will contain the number of rows
     * modified by the statement.
     * Only the first ResultSet in the response contains a valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     */
    private $result_sets;
    /**
     * If all DML statements are executed successfully, status will be OK.
     * Otherwise, the error status of the first failed statement.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     */
    private $status = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Spanner\V1\ResultSet[]|\Google\Protobuf\Internal\RepeatedField $result_sets
     *           ResultSets, one for each statement in the request that ran successfully, in
     *           the same order as the statements in the request. Each
     *           [ResultSet][google.spanner.v1.ResultSet] will not contain any rows. The
     *           [ResultSetStats][google.spanner.v1.ResultSetStats] in each
     *           [ResultSet][google.spanner.v1.ResultSet] will contain the number of rows
     *           modified by the statement.
     *           Only the first ResultSet in the response contains a valid
     *           [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     *     @type \Google\Rpc\Status $status
     *           If all DML statements are executed successfully, status will be OK.
     *           Otherwise, the error status of the first failed statement.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Spanner::initOnce();
        parent::__construct($data);
    }

    /**
     * ResultSets, one for each statement in the request that ran successfully, in
     * the same order as the statements in the request. Each
     * [ResultSet][google.spanner.v1.ResultSet] will not contain any rows. The
     * [ResultSetStats][google.spanner.v1.ResultSetStats] in each
     * [ResultSet][google.spanner.v1.ResultSet] will contain the number of rows
     * modified by the statement.
     * Only the first ResultSet in the response contains a valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getResultSets()
    {
        return $this->result_sets;
    }

    /**
     * ResultSets, one for each statement in the request that ran successfully, in
     * the same order as the statements in the request. Each
     * [ResultSet][google.spanner.v1.ResultSet] will not contain any rows. The
     * [ResultSetStats][google.spanner.v1.ResultSetStats] in each
     * [ResultSet][google.spanner.v1.ResultSet] will contain the number of rows
     * modified by the statement.
     * Only the first ResultSet in the response contains a valid
     * [ResultSetMetadata][google.spanner.v1.ResultSetMetadata].
     *
     * Generated from protobuf field <code>repeated .google.spanner.v1.ResultSet result_sets = 1;</code>
     * @param \Google\Cloud\Spanner\V1\ResultSet[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setResultSets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Spanner\V1\ResultSet::class);
        $this->result_sets = $arr;

        return $this;
    }

    /**
     * If all DML statements are executed successfully, status will be OK.
     * Otherwise, the error status of the first failed statement.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     * @return \Google\Rpc\Status
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * If all DML statements are executed successfully, status will be OK.
     * Otherwise, the error status of the first failed statement.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->status = $var;

        return $this;
    }

}

