<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/change_stream.proto

namespace Google\Cloud\Spanner\V1\ChangeStreamRecord;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A partition end record serves as a notification that the client should stop
 * reading the partition. No further records are expected to be retrieved on
 * it.
 *
 * Generated from protobuf message <code>google.spanner.v1.ChangeStreamRecord.PartitionEndRecord</code>
 */
class PartitionEndRecord extends \Google\Protobuf\Internal\Message
{
    /**
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps <=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     */
    protected $end_timestamp = null;
    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     */
    protected $record_sequence = '';
    /**
     * Unique partition identifier describing the terminated change stream
     * partition.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEndRecord.
     *
     * Generated from protobuf field <code>string partition_token = 3;</code>
     */
    protected $partition_token = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Timestamp $end_timestamp
     *           End timestamp at which the change stream partition is terminated. All
     *           changes generated by this partition will have timestamps <=
     *           end_timestamp. DataChangeRecord.commit_timestamps,
     *           PartitionStartRecord.start_timestamps,
     *           PartitionEventRecord.commit_timestamps, and
     *           PartitionEndRecord.end_timestamps can have the same value in the same
     *           partition. PartitionEndRecord is the last record returned for a
     *           partition.
     *     @type string $record_sequence
     *           Record sequence numbers are unique and monotonically increasing (but not
     *           necessarily contiguous) for a specific timestamp across record
     *           types in the same partition. To guarantee ordered processing, the reader
     *           should process records (of potentially different types) in
     *           record_sequence order for a specific timestamp in the same partition.
     *     @type string $partition_token
     *           Unique partition identifier describing the terminated change stream
     *           partition.
     *           [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
     *           is equal to the partition token of the change stream partition currently
     *           queried to return this PartitionEndRecord.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\ChangeStream::initOnce();
        parent::__construct($data);
    }

    /**
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps <=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTimestamp()
    {
        return $this->end_timestamp;
    }

    public function hasEndTimestamp()
    {
        return isset($this->end_timestamp);
    }

    public function clearEndTimestamp()
    {
        unset($this->end_timestamp);
    }

    /**
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps <=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_timestamp = $var;

        return $this;
    }

    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     * @return string
     */
    public function getRecordSequence()
    {
        return $this->record_sequence;
    }

    /**
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * Generated from protobuf field <code>string record_sequence = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setRecordSequence($var)
    {
        GPBUtil::checkString($var, True);
        $this->record_sequence = $var;

        return $this;
    }

    /**
     * Unique partition identifier describing the terminated change stream
     * partition.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEndRecord.
     *
     * Generated from protobuf field <code>string partition_token = 3;</code>
     * @return string
     */
    public function getPartitionToken()
    {
        return $this->partition_token;
    }

    /**
     * Unique partition identifier describing the terminated change stream
     * partition.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEndRecord.
     *
     * Generated from protobuf field <code>string partition_token = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setPartitionToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->partition_token = $var;

        return $this;
    }

}


