<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/oracledatabase/v1/vm_cluster.proto

namespace Google\Cloud\OracleDatabase\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Details of the Cloud VM Cluster resource.
 * https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/CloudVmCluster/
 *
 * Generated from protobuf message <code>google.cloud.oracledatabase.v1.CloudVmCluster</code>
 */
class CloudVmCluster extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the VM Cluster resource with the format:
     * projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The name of the Exadata Infrastructure resource on which VM
     * cluster resource is created, in the following format:
     * projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
     *
     * Generated from protobuf field <code>string exadata_infrastructure = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $exadata_infrastructure = '';
    /**
     * Optional. User friendly name for this resource.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $display_name = '';
    /**
     * Optional. Various properties of the VM Cluster.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.CloudVmClusterProperties properties = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $properties = null;
    /**
     * Optional. Labels or tags associated with the VM Cluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. The date and time that the VM cluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Optional. Network settings. CIDR to use for cluster IP allocation.
     *
     * Generated from protobuf field <code>string cidr = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cidr = '';
    /**
     * Optional. CIDR range of the backup subnet.
     *
     * Generated from protobuf field <code>string backup_subnet_cidr = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $backup_subnet_cidr = '';
    /**
     * Optional. The name of the VPC network.
     * Format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $network = '';
    /**
     * Output only. The GCP Oracle zone where Oracle CloudVmCluster is hosted.
     * This will be the same as the gcp_oracle_zone of the
     * CloudExadataInfrastructure. Example: us-east4-b-r2.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $gcp_oracle_zone = '';
    /**
     * Optional. The name of the OdbNetwork associated with the VM Cluster.
     * Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}
     * It is optional but if specified, this should match the parent ODBNetwork of
     * the odb_subnet and backup_odb_subnet.
     *
     * Generated from protobuf field <code>string odb_network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $odb_network = '';
    /**
     * Optional. The name of the OdbSubnet associated with the VM Cluster for
     * IP allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $odb_subnet = '';
    /**
     * Optional. The name of the backup OdbSubnet associated with the VM Cluster.
     * Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string backup_odb_subnet = 15 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $backup_odb_subnet = '';
    /**
     * Output only. The identity connector details which will allow OCI to
     * securely access the resources in the customer project.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.IdentityConnector identity_connector = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $identity_connector = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the VM Cluster resource with the format:
     *           projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
     *     @type string $exadata_infrastructure
     *           Required. The name of the Exadata Infrastructure resource on which VM
     *           cluster resource is created, in the following format:
     *           projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
     *     @type string $display_name
     *           Optional. User friendly name for this resource.
     *     @type \Google\Cloud\OracleDatabase\V1\CloudVmClusterProperties $properties
     *           Optional. Various properties of the VM Cluster.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Labels or tags associated with the VM Cluster.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The date and time that the VM cluster was created.
     *     @type string $cidr
     *           Optional. Network settings. CIDR to use for cluster IP allocation.
     *     @type string $backup_subnet_cidr
     *           Optional. CIDR range of the backup subnet.
     *     @type string $network
     *           Optional. The name of the VPC network.
     *           Format: projects/{project}/global/networks/{network}
     *     @type string $gcp_oracle_zone
     *           Output only. The GCP Oracle zone where Oracle CloudVmCluster is hosted.
     *           This will be the same as the gcp_oracle_zone of the
     *           CloudExadataInfrastructure. Example: us-east4-b-r2.
     *     @type string $odb_network
     *           Optional. The name of the OdbNetwork associated with the VM Cluster.
     *           Format:
     *           projects/{project}/locations/{location}/odbNetworks/{odb_network}
     *           It is optional but if specified, this should match the parent ODBNetwork of
     *           the odb_subnet and backup_odb_subnet.
     *     @type string $odb_subnet
     *           Optional. The name of the OdbSubnet associated with the VM Cluster for
     *           IP allocation. Format:
     *           projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *     @type string $backup_odb_subnet
     *           Optional. The name of the backup OdbSubnet associated with the VM Cluster.
     *           Format:
     *           projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *     @type \Google\Cloud\OracleDatabase\V1\IdentityConnector $identity_connector
     *           Output only. The identity connector details which will allow OCI to
     *           securely access the resources in the customer project.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Oracledatabase\V1\VmCluster::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the VM Cluster resource with the format:
     * projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the VM Cluster resource with the format:
     * projects/{project}/locations/{region}/cloudVmClusters/{cloud_vm_cluster}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The name of the Exadata Infrastructure resource on which VM
     * cluster resource is created, in the following format:
     * projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
     *
     * Generated from protobuf field <code>string exadata_infrastructure = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getExadataInfrastructure()
    {
        return $this->exadata_infrastructure;
    }

    /**
     * Required. The name of the Exadata Infrastructure resource on which VM
     * cluster resource is created, in the following format:
     * projects/{project}/locations/{region}/cloudExadataInfrastuctures/{cloud_extradata_infrastructure}
     *
     * Generated from protobuf field <code>string exadata_infrastructure = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setExadataInfrastructure($var)
    {
        GPBUtil::checkString($var, True);
        $this->exadata_infrastructure = $var;

        return $this;
    }

    /**
     * Optional. User friendly name for this resource.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Optional. User friendly name for this resource.
     *
     * Generated from protobuf field <code>string display_name = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. Various properties of the VM Cluster.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.CloudVmClusterProperties properties = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\OracleDatabase\V1\CloudVmClusterProperties|null
     */
    public function getProperties()
    {
        return $this->properties;
    }

    public function hasProperties()
    {
        return isset($this->properties);
    }

    public function clearProperties()
    {
        unset($this->properties);
    }

    /**
     * Optional. Various properties of the VM Cluster.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.CloudVmClusterProperties properties = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\OracleDatabase\V1\CloudVmClusterProperties $var
     * @return $this
     */
    public function setProperties($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\CloudVmClusterProperties::class);
        $this->properties = $var;

        return $this;
    }

    /**
     * Optional. Labels or tags associated with the VM Cluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Labels or tags associated with the VM Cluster.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The date and time that the VM cluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The date and time that the VM cluster was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Optional. Network settings. CIDR to use for cluster IP allocation.
     *
     * Generated from protobuf field <code>string cidr = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getCidr()
    {
        return $this->cidr;
    }

    /**
     * Optional. Network settings. CIDR to use for cluster IP allocation.
     *
     * Generated from protobuf field <code>string cidr = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setCidr($var)
    {
        GPBUtil::checkString($var, True);
        $this->cidr = $var;

        return $this;
    }

    /**
     * Optional. CIDR range of the backup subnet.
     *
     * Generated from protobuf field <code>string backup_subnet_cidr = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getBackupSubnetCidr()
    {
        return $this->backup_subnet_cidr;
    }

    /**
     * Optional. CIDR range of the backup subnet.
     *
     * Generated from protobuf field <code>string backup_subnet_cidr = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setBackupSubnetCidr($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_subnet_cidr = $var;

        return $this;
    }

    /**
     * Optional. The name of the VPC network.
     * Format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Optional. The name of the VPC network.
     * Format: projects/{project}/global/networks/{network}
     *
     * Generated from protobuf field <code>string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Output only. The GCP Oracle zone where Oracle CloudVmCluster is hosted.
     * This will be the same as the gcp_oracle_zone of the
     * CloudExadataInfrastructure. Example: us-east4-b-r2.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getGcpOracleZone()
    {
        return $this->gcp_oracle_zone;
    }

    /**
     * Output only. The GCP Oracle zone where Oracle CloudVmCluster is hosted.
     * This will be the same as the gcp_oracle_zone of the
     * CloudExadataInfrastructure. Example: us-east4-b-r2.
     *
     * Generated from protobuf field <code>string gcp_oracle_zone = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setGcpOracleZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->gcp_oracle_zone = $var;

        return $this;
    }

    /**
     * Optional. The name of the OdbNetwork associated with the VM Cluster.
     * Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}
     * It is optional but if specified, this should match the parent ODBNetwork of
     * the odb_subnet and backup_odb_subnet.
     *
     * Generated from protobuf field <code>string odb_network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getOdbNetwork()
    {
        return $this->odb_network;
    }

    /**
     * Optional. The name of the OdbNetwork associated with the VM Cluster.
     * Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}
     * It is optional but if specified, this should match the parent ODBNetwork of
     * the odb_subnet and backup_odb_subnet.
     *
     * Generated from protobuf field <code>string odb_network = 13 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setOdbNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->odb_network = $var;

        return $this;
    }

    /**
     * Optional. The name of the OdbSubnet associated with the VM Cluster for
     * IP allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getOdbSubnet()
    {
        return $this->odb_subnet;
    }

    /**
     * Optional. The name of the OdbSubnet associated with the VM Cluster for
     * IP allocation. Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string odb_subnet = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setOdbSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->odb_subnet = $var;

        return $this;
    }

    /**
     * Optional. The name of the backup OdbSubnet associated with the VM Cluster.
     * Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string backup_odb_subnet = 15 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBackupOdbSubnet()
    {
        return $this->backup_odb_subnet;
    }

    /**
     * Optional. The name of the backup OdbSubnet associated with the VM Cluster.
     * Format:
     * projects/{project}/locations/{location}/odbNetworks/{odb_network}/odbSubnets/{odb_subnet}
     *
     * Generated from protobuf field <code>string backup_odb_subnet = 15 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBackupOdbSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->backup_odb_subnet = $var;

        return $this;
    }

    /**
     * Output only. The identity connector details which will allow OCI to
     * securely access the resources in the customer project.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.IdentityConnector identity_connector = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\OracleDatabase\V1\IdentityConnector|null
     */
    public function getIdentityConnector()
    {
        return $this->identity_connector;
    }

    public function hasIdentityConnector()
    {
        return isset($this->identity_connector);
    }

    public function clearIdentityConnector()
    {
        unset($this->identity_connector);
    }

    /**
     * Output only. The identity connector details which will allow OCI to
     * securely access the resources in the customer project.
     *
     * Generated from protobuf field <code>.google.cloud.oracledatabase.v1.IdentityConnector identity_connector = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\OracleDatabase\V1\IdentityConnector $var
     * @return $this
     */
    public function setIdentityConnector($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\OracleDatabase\V1\IdentityConnector::class);
        $this->identity_connector = $var;

        return $this;
    }

}

