<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1/resources.proto

namespace Google\Cloud\AlloyDb\V1\Instance;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * PscInstanceConfig contains PSC related configuration at an
 * instance level.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1.Instance.PscInstanceConfig</code>
 */
class PscInstanceConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The service attachment created when Private
     * Service Connect (PSC) is enabled for the instance.
     * The name of the resource will be in the format of
     * `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
     *
     * Generated from protobuf field <code>string service_attachment_link = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     */
    protected $service_attachment_link = '';
    /**
     * Optional. List of consumer projects that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowed_consumer_projects;
    /**
     * Output only. The DNS name of the instance for PSC connectivity.
     * Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
     *
     * Generated from protobuf field <code>string psc_dns_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $psc_dns_name = '';
    /**
     * Optional. Configurations for setting up PSC interfaces attached to the
     * instance which are used for outbound connectivity. Only primary instances
     * can have PSC interface attached. Currently we only support 0 or 1 PSC
     * interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.Instance.PscInterfaceConfig psc_interface_configs = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $psc_interface_configs;
    /**
     * Optional. Configurations for setting up PSC service automation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.Instance.PscAutoConnectionConfig psc_auto_connections = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $psc_auto_connections;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service_attachment_link
     *           Output only. The service attachment created when Private
     *           Service Connect (PSC) is enabled for the instance.
     *           The name of the resource will be in the format of
     *           `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowed_consumer_projects
     *           Optional. List of consumer projects that are allowed to create
     *           PSC endpoints to service-attachments to this instance.
     *     @type string $psc_dns_name
     *           Output only. The DNS name of the instance for PSC connectivity.
     *           Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
     *     @type array<\Google\Cloud\AlloyDb\V1\Instance\PscInterfaceConfig>|\Google\Protobuf\Internal\RepeatedField $psc_interface_configs
     *           Optional. Configurations for setting up PSC interfaces attached to the
     *           instance which are used for outbound connectivity. Only primary instances
     *           can have PSC interface attached. Currently we only support 0 or 1 PSC
     *           interface.
     *     @type array<\Google\Cloud\AlloyDb\V1\Instance\PscAutoConnectionConfig>|\Google\Protobuf\Internal\RepeatedField $psc_auto_connections
     *           Optional. Configurations for setting up PSC service automation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The service attachment created when Private
     * Service Connect (PSC) is enabled for the instance.
     * The name of the resource will be in the format of
     * `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
     *
     * Generated from protobuf field <code>string service_attachment_link = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServiceAttachmentLink()
    {
        return $this->service_attachment_link;
    }

    /**
     * Output only. The service attachment created when Private
     * Service Connect (PSC) is enabled for the instance.
     * The name of the resource will be in the format of
     * `projects/<alloydb-tenant-project-number>/regions/<region-name>/serviceAttachments/<service-attachment-name>`
     *
     * Generated from protobuf field <code>string service_attachment_link = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAttachmentLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_attachment_link = $var;

        return $this;
    }

    /**
     * Optional. List of consumer projects that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedConsumerProjects()
    {
        return $this->allowed_consumer_projects;
    }

    /**
     * Optional. List of consumer projects that are allowed to create
     * PSC endpoints to service-attachments to this instance.
     *
     * Generated from protobuf field <code>repeated string allowed_consumer_projects = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedConsumerProjects($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowed_consumer_projects = $arr;

        return $this;
    }

    /**
     * Output only. The DNS name of the instance for PSC connectivity.
     * Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
     *
     * Generated from protobuf field <code>string psc_dns_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPscDnsName()
    {
        return $this->psc_dns_name;
    }

    /**
     * Output only. The DNS name of the instance for PSC connectivity.
     * Name convention: <uid>.<uid>.<region>.alloydb-psc.goog
     *
     * Generated from protobuf field <code>string psc_dns_name = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPscDnsName($var)
    {
        GPBUtil::checkString($var, True);
        $this->psc_dns_name = $var;

        return $this;
    }

    /**
     * Optional. Configurations for setting up PSC interfaces attached to the
     * instance which are used for outbound connectivity. Only primary instances
     * can have PSC interface attached. Currently we only support 0 or 1 PSC
     * interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.Instance.PscInterfaceConfig psc_interface_configs = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPscInterfaceConfigs()
    {
        return $this->psc_interface_configs;
    }

    /**
     * Optional. Configurations for setting up PSC interfaces attached to the
     * instance which are used for outbound connectivity. Only primary instances
     * can have PSC interface attached. Currently we only support 0 or 1 PSC
     * interface.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.Instance.PscInterfaceConfig psc_interface_configs = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\AlloyDb\V1\Instance\PscInterfaceConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPscInterfaceConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AlloyDb\V1\Instance\PscInterfaceConfig::class);
        $this->psc_interface_configs = $arr;

        return $this;
    }

    /**
     * Optional. Configurations for setting up PSC service automation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.Instance.PscAutoConnectionConfig psc_auto_connections = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPscAutoConnections()
    {
        return $this->psc_auto_connections;
    }

    /**
     * Optional. Configurations for setting up PSC service automation.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.Instance.PscAutoConnectionConfig psc_auto_connections = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\AlloyDb\V1\Instance\PscAutoConnectionConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPscAutoConnections($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AlloyDb\V1\Instance\PscAutoConnectionConfig::class);
        $this->psc_auto_connections = $arr;

        return $this;
    }

}


