<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/lfp/v1/lfpstore.proto

namespace Google\Shopping\Merchant\Lfp\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A store for the merchant. This will be used to match to a store under the
 * Google Business Profile of the target merchant. If a matching store can't be
 * found, the inventories or sales submitted with the store code will not be
 * used.
 *
 * Generated from protobuf message <code>google.shopping.merchant.lfp.v1.LfpStore</code>
 */
class LfpStore extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Identifier. The name of the `LfpStore` resource.
     * Format: `accounts/{account}/lfpStores/{target_merchant}~{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The Merchant Center id of the merchant to submit the store for.
     *
     * Generated from protobuf field <code>int64 target_account = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $target_account = 0;
    /**
     * Required. Immutable. A store identifier that is unique for the target
     * merchant.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $store_code = '';
    /**
     * Required. The street address of the store.
     * Example: 1600 Amphitheatre Pkwy, Mountain View, CA 94043, USA.
     *
     * Generated from protobuf field <code>string store_address = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $store_address = '';
    /**
     * Optional. The merchant or store name.
     *
     * Generated from protobuf field <code>optional string store_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $store_name = null;
    /**
     * Optional. The store phone number in
     * [E.164](https://en.wikipedia.org/wiki/E.164) format. Example:
     * `+15556767888`
     *
     * Generated from protobuf field <code>optional string phone_number = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $phone_number = null;
    /**
     * Optional. The website URL for the store or merchant.
     *
     * Generated from protobuf field <code>optional string website_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $website_uri = null;
    /**
     * Optional. [Google My Business category
     * id](https://gcid-explorer.corp.google.com/static/gcid.html).
     *
     * Generated from protobuf field <code>repeated string gcid_category = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $gcid_category;
    /**
     * Optional. The [Google Place
     * Id](https://developers.google.com/maps/documentation/places/web-service/place-id#id-overview)
     * of the store location.
     *
     * Generated from protobuf field <code>optional string place_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $place_id = null;
    /**
     * Optional. Output only. The state of matching to a Google Business Profile.
     * See
     * [matchingStateHint][google.shopping.merchant.lfp.v1.LfpStore.matching_state_hint]
     * for further details if no match is found.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.lfp.v1.LfpStore.StoreMatchingState matching_state = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $matching_state = 0;
    /**
     * Optional. Output only. The hint of why the matching has failed. This is
     * only set when
     * [matchingState][google.shopping.merchant.lfp.v1.LfpStore.matching_state]=`STORE_MATCHING_STATE_FAILED`.
     * Possible values are:
     * - "`linked-store-not-found`": There aren't any Google Business
     * Profile stores available for matching.
     * - "`store-match-not-found`": The provided `LfpStore` couldn't be matched to
     * any of the connected Google Business Profile stores. Merchant Center
     * account is connected correctly and stores are available on Google Business
     * Profile, but the `LfpStore` location address does not match with Google
     * Business Profile stores' addresses. Update the `LfpStore` address or Google
     * Business Profile store address to match correctly.
     * - "`store-match-unverified`": The provided `LfpStore` couldn't be matched
     * to any of the connected Google Business Profile stores, as the matched
     * Google Business Profile store is unverified. Go through the Google Business
     * Profile verification process to match correctly.
     *
     * Generated from protobuf field <code>optional string matching_state_hint = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $matching_state_hint = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Identifier. The name of the `LfpStore` resource.
     *           Format: `accounts/{account}/lfpStores/{target_merchant}~{store_code}`
     *     @type int|string $target_account
     *           Required. The Merchant Center id of the merchant to submit the store for.
     *     @type string $store_code
     *           Required. Immutable. A store identifier that is unique for the target
     *           merchant.
     *     @type string $store_address
     *           Required. The street address of the store.
     *           Example: 1600 Amphitheatre Pkwy, Mountain View, CA 94043, USA.
     *     @type string $store_name
     *           Optional. The merchant or store name.
     *     @type string $phone_number
     *           Optional. The store phone number in
     *           [E.164](https://en.wikipedia.org/wiki/E.164) format. Example:
     *           `+15556767888`
     *     @type string $website_uri
     *           Optional. The website URL for the store or merchant.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $gcid_category
     *           Optional. [Google My Business category
     *           id](https://gcid-explorer.corp.google.com/static/gcid.html).
     *     @type string $place_id
     *           Optional. The [Google Place
     *           Id](https://developers.google.com/maps/documentation/places/web-service/place-id#id-overview)
     *           of the store location.
     *     @type int $matching_state
     *           Optional. Output only. The state of matching to a Google Business Profile.
     *           See
     *           [matchingStateHint][google.shopping.merchant.lfp.v1.LfpStore.matching_state_hint]
     *           for further details if no match is found.
     *     @type string $matching_state_hint
     *           Optional. Output only. The hint of why the matching has failed. This is
     *           only set when
     *           [matchingState][google.shopping.merchant.lfp.v1.LfpStore.matching_state]=`STORE_MATCHING_STATE_FAILED`.
     *           Possible values are:
     *           - "`linked-store-not-found`": There aren't any Google Business
     *           Profile stores available for matching.
     *           - "`store-match-not-found`": The provided `LfpStore` couldn't be matched to
     *           any of the connected Google Business Profile stores. Merchant Center
     *           account is connected correctly and stores are available on Google Business
     *           Profile, but the `LfpStore` location address does not match with Google
     *           Business Profile stores' addresses. Update the `LfpStore` address or Google
     *           Business Profile store address to match correctly.
     *           - "`store-match-unverified`": The provided `LfpStore` couldn't be matched
     *           to any of the connected Google Business Profile stores, as the matched
     *           Google Business Profile store is unverified. Go through the Google Business
     *           Profile verification process to match correctly.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Lfp\V1\Lfpstore::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Identifier. The name of the `LfpStore` resource.
     * Format: `accounts/{account}/lfpStores/{target_merchant}~{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Identifier. The name of the `LfpStore` resource.
     * Format: `accounts/{account}/lfpStores/{target_merchant}~{store_code}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The Merchant Center id of the merchant to submit the store for.
     *
     * Generated from protobuf field <code>int64 target_account = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int|string
     */
    public function getTargetAccount()
    {
        return $this->target_account;
    }

    /**
     * Required. The Merchant Center id of the merchant to submit the store for.
     *
     * Generated from protobuf field <code>int64 target_account = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int|string $var
     * @return $this
     */
    public function setTargetAccount($var)
    {
        GPBUtil::checkInt64($var);
        $this->target_account = $var;

        return $this;
    }

    /**
     * Required. Immutable. A store identifier that is unique for the target
     * merchant.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getStoreCode()
    {
        return $this->store_code;
    }

    /**
     * Required. Immutable. A store identifier that is unique for the target
     * merchant.
     *
     * Generated from protobuf field <code>string store_code = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setStoreCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->store_code = $var;

        return $this;
    }

    /**
     * Required. The street address of the store.
     * Example: 1600 Amphitheatre Pkwy, Mountain View, CA 94043, USA.
     *
     * Generated from protobuf field <code>string store_address = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getStoreAddress()
    {
        return $this->store_address;
    }

    /**
     * Required. The street address of the store.
     * Example: 1600 Amphitheatre Pkwy, Mountain View, CA 94043, USA.
     *
     * Generated from protobuf field <code>string store_address = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setStoreAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->store_address = $var;

        return $this;
    }

    /**
     * Optional. The merchant or store name.
     *
     * Generated from protobuf field <code>optional string store_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getStoreName()
    {
        return isset($this->store_name) ? $this->store_name : '';
    }

    public function hasStoreName()
    {
        return isset($this->store_name);
    }

    public function clearStoreName()
    {
        unset($this->store_name);
    }

    /**
     * Optional. The merchant or store name.
     *
     * Generated from protobuf field <code>optional string store_name = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setStoreName($var)
    {
        GPBUtil::checkString($var, True);
        $this->store_name = $var;

        return $this;
    }

    /**
     * Optional. The store phone number in
     * [E.164](https://en.wikipedia.org/wiki/E.164) format. Example:
     * `+15556767888`
     *
     * Generated from protobuf field <code>optional string phone_number = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPhoneNumber()
    {
        return isset($this->phone_number) ? $this->phone_number : '';
    }

    public function hasPhoneNumber()
    {
        return isset($this->phone_number);
    }

    public function clearPhoneNumber()
    {
        unset($this->phone_number);
    }

    /**
     * Optional. The store phone number in
     * [E.164](https://en.wikipedia.org/wiki/E.164) format. Example:
     * `+15556767888`
     *
     * Generated from protobuf field <code>optional string phone_number = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPhoneNumber($var)
    {
        GPBUtil::checkString($var, True);
        $this->phone_number = $var;

        return $this;
    }

    /**
     * Optional. The website URL for the store or merchant.
     *
     * Generated from protobuf field <code>optional string website_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getWebsiteUri()
    {
        return isset($this->website_uri) ? $this->website_uri : '';
    }

    public function hasWebsiteUri()
    {
        return isset($this->website_uri);
    }

    public function clearWebsiteUri()
    {
        unset($this->website_uri);
    }

    /**
     * Optional. The website URL for the store or merchant.
     *
     * Generated from protobuf field <code>optional string website_uri = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setWebsiteUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->website_uri = $var;

        return $this;
    }

    /**
     * Optional. [Google My Business category
     * id](https://gcid-explorer.corp.google.com/static/gcid.html).
     *
     * Generated from protobuf field <code>repeated string gcid_category = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGcidCategory()
    {
        return $this->gcid_category;
    }

    /**
     * Optional. [Google My Business category
     * id](https://gcid-explorer.corp.google.com/static/gcid.html).
     *
     * Generated from protobuf field <code>repeated string gcid_category = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGcidCategory($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->gcid_category = $arr;

        return $this;
    }

    /**
     * Optional. The [Google Place
     * Id](https://developers.google.com/maps/documentation/places/web-service/place-id#id-overview)
     * of the store location.
     *
     * Generated from protobuf field <code>optional string place_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getPlaceId()
    {
        return isset($this->place_id) ? $this->place_id : '';
    }

    public function hasPlaceId()
    {
        return isset($this->place_id);
    }

    public function clearPlaceId()
    {
        unset($this->place_id);
    }

    /**
     * Optional. The [Google Place
     * Id](https://developers.google.com/maps/documentation/places/web-service/place-id#id-overview)
     * of the store location.
     *
     * Generated from protobuf field <code>optional string place_id = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setPlaceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->place_id = $var;

        return $this;
    }

    /**
     * Optional. Output only. The state of matching to a Google Business Profile.
     * See
     * [matchingStateHint][google.shopping.merchant.lfp.v1.LfpStore.matching_state_hint]
     * for further details if no match is found.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.lfp.v1.LfpStore.StoreMatchingState matching_state = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getMatchingState()
    {
        return $this->matching_state;
    }

    /**
     * Optional. Output only. The state of matching to a Google Business Profile.
     * See
     * [matchingStateHint][google.shopping.merchant.lfp.v1.LfpStore.matching_state_hint]
     * for further details if no match is found.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.lfp.v1.LfpStore.StoreMatchingState matching_state = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setMatchingState($var)
    {
        GPBUtil::checkEnum($var, \Google\Shopping\Merchant\Lfp\V1\LfpStore\StoreMatchingState::class);
        $this->matching_state = $var;

        return $this;
    }

    /**
     * Optional. Output only. The hint of why the matching has failed. This is
     * only set when
     * [matchingState][google.shopping.merchant.lfp.v1.LfpStore.matching_state]=`STORE_MATCHING_STATE_FAILED`.
     * Possible values are:
     * - "`linked-store-not-found`": There aren't any Google Business
     * Profile stores available for matching.
     * - "`store-match-not-found`": The provided `LfpStore` couldn't be matched to
     * any of the connected Google Business Profile stores. Merchant Center
     * account is connected correctly and stores are available on Google Business
     * Profile, but the `LfpStore` location address does not match with Google
     * Business Profile stores' addresses. Update the `LfpStore` address or Google
     * Business Profile store address to match correctly.
     * - "`store-match-unverified`": The provided `LfpStore` couldn't be matched
     * to any of the connected Google Business Profile stores, as the matched
     * Google Business Profile store is unverified. Go through the Google Business
     * Profile verification process to match correctly.
     *
     * Generated from protobuf field <code>optional string matching_state_hint = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getMatchingStateHint()
    {
        return isset($this->matching_state_hint) ? $this->matching_state_hint : '';
    }

    public function hasMatchingStateHint()
    {
        return isset($this->matching_state_hint);
    }

    public function clearMatchingStateHint()
    {
        unset($this->matching_state_hint);
    }

    /**
     * Optional. Output only. The hint of why the matching has failed. This is
     * only set when
     * [matchingState][google.shopping.merchant.lfp.v1.LfpStore.matching_state]=`STORE_MATCHING_STATE_FAILED`.
     * Possible values are:
     * - "`linked-store-not-found`": There aren't any Google Business
     * Profile stores available for matching.
     * - "`store-match-not-found`": The provided `LfpStore` couldn't be matched to
     * any of the connected Google Business Profile stores. Merchant Center
     * account is connected correctly and stores are available on Google Business
     * Profile, but the `LfpStore` location address does not match with Google
     * Business Profile stores' addresses. Update the `LfpStore` address or Google
     * Business Profile store address to match correctly.
     * - "`store-match-unverified`": The provided `LfpStore` couldn't be matched
     * to any of the connected Google Business Profile stores, as the matched
     * Google Business Profile store is unverified. Go through the Google Business
     * Profile verification process to match correctly.
     *
     * Generated from protobuf field <code>optional string matching_state_hint = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setMatchingStateHint($var)
    {
        GPBUtil::checkString($var, True);
        $this->matching_state_hint = $var;

        return $this;
    }

}

