<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/maps/fleetengine/v1/vehicles.proto

namespace Google\Maps\FleetEngine\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Vehicle metadata.
 *
 * Generated from protobuf message <code>maps.fleetengine.v1.Vehicle</code>
 */
class Vehicle extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The unique name for this vehicle.
     * The format is `providers/{provider}/vehicles/{vehicle}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * The vehicle state.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleState vehicle_state = 2;</code>
     */
    protected $vehicle_state = 0;
    /**
     * Trip types supported by this vehicle.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripType supported_trip_types = 3;</code>
     */
    private $supported_trip_types;
    /**
     * Output only. List of `trip_id`'s for trips currently assigned to this
     * vehicle.
     *
     * Generated from protobuf field <code>repeated string current_trips = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $current_trips;
    /**
     * Last reported location of the vehicle.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleLocation last_location = 5;</code>
     */
    protected $last_location = null;
    /**
     * Input only. Locations where this vehicle has been in the past that haven't
     * yet been reported to Fleet Engine. This is used in `UpdateVehicleRequest`
     * to record locations which were previously unable to be sent to the server.
     * Typically this happens when the vehicle does not have internet
     * connectivity.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.VehicleLocation past_locations = 30 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private $past_locations;
    /**
     * The total numbers of riders this vehicle can carry.  The driver is not
     * considered in this value. This value must be greater than or equal to one.
     *
     * Generated from protobuf field <code>int32 maximum_capacity = 6;</code>
     */
    protected $maximum_capacity = 0;
    /**
     * List of vehicle attributes. A vehicle can have at most 100
     * attributes, and each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.VehicleAttribute attributes = 8;</code>
     */
    private $attributes;
    /**
     * Required. The type of this vehicle.  Can be used to filter vehicles in
     * `SearchVehicles` results.  Also influences ETA and route calculations.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.Vehicle.VehicleType vehicle_type = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $vehicle_type = null;
    /**
     * License plate information for the vehicle.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.LicensePlate license_plate = 10;</code>
     */
    protected $license_plate = null;
    /**
     * Deprecated: Use `Vehicle.waypoints` instead.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TerminalLocation route = 12 [deprecated = true];</code>
     * @deprecated
     */
    private $route;
    /**
     * The polyline specifying the route the driver app intends to take to
     * the next waypoint. This list is also returned in
     * `Trip.current_route_segment` for all active trips assigned to the vehicle.
     * Note: This field is intended only for use by the Driver SDK. Decoding is
     * not yet supported.
     *
     * Generated from protobuf field <code>string current_route_segment = 20;</code>
     */
    protected $current_route_segment = '';
    /**
     * Input only. Fleet Engine uses this information to improve journey sharing.
     * Note: This field is intended only for use by the Driver SDK.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TrafficPolylineData current_route_segment_traffic = 28 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $current_route_segment_traffic = null;
    /**
     * Output only. Time when `current_route_segment` was set. It can be stored by
     * the client and passed in future `GetVehicle` requests to prevent returning
     * routes that haven't changed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_version = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $current_route_segment_version = null;
    /**
     * The waypoint where `current_route_segment` ends. This can be supplied by
     * drivers on `UpdateVehicle` calls either as a full trip waypoint, a waypoint
     * `LatLng`, or as the last `LatLng` of the `current_route_segment`. Fleet
     * Engine will then do its best to interpolate to an actual waypoint if it is
     * not fully specified. This field is ignored in `UpdateVehicle` calls unless
     * `current_route_segment` is also specified.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripWaypoint current_route_segment_end_point = 24;</code>
     */
    protected $current_route_segment_end_point = null;
    /**
     * The remaining driving distance for the `current_route_segment`.
     * This value is also returned in `Trip.remaining_distance_meters` for all
     * active trips assigned to the vehicle. The value is unspecified if the
     * `current_route_segment` field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 18;</code>
     */
    protected $remaining_distance_meters = null;
    /**
     * The ETA to the first entry in the `waypoints` field.  The value is
     * unspecified if the `waypoints` field is empty or the
     * `Vehicle.current_route_segment` field is empty.
     * When updating a vehicle, `remaining_time_seconds` takes precedence over
     * `eta_to_first_waypoint` in the same request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp eta_to_first_waypoint = 19;</code>
     */
    protected $eta_to_first_waypoint = null;
    /**
     * Input only. The remaining driving time for the `current_route_segment`. The
     * value is unspecified if the `waypoints` field is empty or the
     * `Vehicle.current_route_segment` field is empty. This value should match
     * `eta_to_first_waypoint` - `current_time` if all parties are using the same
     * clock.
     * When updating a vehicle, `remaining_time_seconds` takes precedence over
     * `eta_to_first_waypoint` in the same request.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_time_seconds = 25 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $remaining_time_seconds = null;
    /**
     * The remaining waypoints assigned to this Vehicle.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint waypoints = 22;</code>
     */
    private $waypoints;
    /**
     * Output only. Last time the `waypoints` field was updated. Clients should
     * cache this value and pass it in `GetVehicleRequest` to ensure the
     * `waypoints` field is only returned if it is updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp waypoints_version = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $waypoints_version = null;
    /**
     * Indicates if the driver accepts back-to-back trips. If `true`,
     * `SearchVehicles` may include the vehicle even if it is currently assigned
     * to a trip. The default value is `false`.
     *
     * Generated from protobuf field <code>bool back_to_back_enabled = 23;</code>
     */
    protected $back_to_back_enabled = false;
    /**
     * The vehicle's navigation status.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.NavigationStatus navigation_status = 26;</code>
     */
    protected $navigation_status = 0;
    /**
     * Input only. Information about settings in the mobile device being used by
     * the driver.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.DeviceSettings device_settings = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $device_settings = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The unique name for this vehicle.
     *           The format is `providers/{provider}/vehicles/{vehicle}`.
     *     @type int $vehicle_state
     *           The vehicle state.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $supported_trip_types
     *           Trip types supported by this vehicle.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $current_trips
     *           Output only. List of `trip_id`'s for trips currently assigned to this
     *           vehicle.
     *     @type \Google\Maps\FleetEngine\V1\VehicleLocation $last_location
     *           Last reported location of the vehicle.
     *     @type array<\Google\Maps\FleetEngine\V1\VehicleLocation>|\Google\Protobuf\Internal\RepeatedField $past_locations
     *           Input only. Locations where this vehicle has been in the past that haven't
     *           yet been reported to Fleet Engine. This is used in `UpdateVehicleRequest`
     *           to record locations which were previously unable to be sent to the server.
     *           Typically this happens when the vehicle does not have internet
     *           connectivity.
     *     @type int $maximum_capacity
     *           The total numbers of riders this vehicle can carry.  The driver is not
     *           considered in this value. This value must be greater than or equal to one.
     *     @type array<\Google\Maps\FleetEngine\V1\VehicleAttribute>|\Google\Protobuf\Internal\RepeatedField $attributes
     *           List of vehicle attributes. A vehicle can have at most 100
     *           attributes, and each attribute must have a unique key.
     *     @type \Google\Maps\FleetEngine\V1\Vehicle\VehicleType $vehicle_type
     *           Required. The type of this vehicle.  Can be used to filter vehicles in
     *           `SearchVehicles` results.  Also influences ETA and route calculations.
     *     @type \Google\Maps\FleetEngine\V1\LicensePlate $license_plate
     *           License plate information for the vehicle.
     *     @type array<\Google\Maps\FleetEngine\V1\TerminalLocation>|\Google\Protobuf\Internal\RepeatedField $route
     *           Deprecated: Use `Vehicle.waypoints` instead.
     *     @type string $current_route_segment
     *           The polyline specifying the route the driver app intends to take to
     *           the next waypoint. This list is also returned in
     *           `Trip.current_route_segment` for all active trips assigned to the vehicle.
     *           Note: This field is intended only for use by the Driver SDK. Decoding is
     *           not yet supported.
     *     @type \Google\Maps\FleetEngine\V1\TrafficPolylineData $current_route_segment_traffic
     *           Input only. Fleet Engine uses this information to improve journey sharing.
     *           Note: This field is intended only for use by the Driver SDK.
     *     @type \Google\Protobuf\Timestamp $current_route_segment_version
     *           Output only. Time when `current_route_segment` was set. It can be stored by
     *           the client and passed in future `GetVehicle` requests to prevent returning
     *           routes that haven't changed.
     *     @type \Google\Maps\FleetEngine\V1\TripWaypoint $current_route_segment_end_point
     *           The waypoint where `current_route_segment` ends. This can be supplied by
     *           drivers on `UpdateVehicle` calls either as a full trip waypoint, a waypoint
     *           `LatLng`, or as the last `LatLng` of the `current_route_segment`. Fleet
     *           Engine will then do its best to interpolate to an actual waypoint if it is
     *           not fully specified. This field is ignored in `UpdateVehicle` calls unless
     *           `current_route_segment` is also specified.
     *     @type \Google\Protobuf\Int32Value $remaining_distance_meters
     *           The remaining driving distance for the `current_route_segment`.
     *           This value is also returned in `Trip.remaining_distance_meters` for all
     *           active trips assigned to the vehicle. The value is unspecified if the
     *           `current_route_segment` field is empty.
     *     @type \Google\Protobuf\Timestamp $eta_to_first_waypoint
     *           The ETA to the first entry in the `waypoints` field.  The value is
     *           unspecified if the `waypoints` field is empty or the
     *           `Vehicle.current_route_segment` field is empty.
     *           When updating a vehicle, `remaining_time_seconds` takes precedence over
     *           `eta_to_first_waypoint` in the same request.
     *     @type \Google\Protobuf\Int32Value $remaining_time_seconds
     *           Input only. The remaining driving time for the `current_route_segment`. The
     *           value is unspecified if the `waypoints` field is empty or the
     *           `Vehicle.current_route_segment` field is empty. This value should match
     *           `eta_to_first_waypoint` - `current_time` if all parties are using the same
     *           clock.
     *           When updating a vehicle, `remaining_time_seconds` takes precedence over
     *           `eta_to_first_waypoint` in the same request.
     *     @type array<\Google\Maps\FleetEngine\V1\TripWaypoint>|\Google\Protobuf\Internal\RepeatedField $waypoints
     *           The remaining waypoints assigned to this Vehicle.
     *     @type \Google\Protobuf\Timestamp $waypoints_version
     *           Output only. Last time the `waypoints` field was updated. Clients should
     *           cache this value and pass it in `GetVehicleRequest` to ensure the
     *           `waypoints` field is only returned if it is updated.
     *     @type bool $back_to_back_enabled
     *           Indicates if the driver accepts back-to-back trips. If `true`,
     *           `SearchVehicles` may include the vehicle even if it is currently assigned
     *           to a trip. The default value is `false`.
     *     @type int $navigation_status
     *           The vehicle's navigation status.
     *     @type \Google\Maps\FleetEngine\V1\DeviceSettings $device_settings
     *           Input only. Information about settings in the mobile device being used by
     *           the driver.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Maps\Fleetengine\V1\Vehicles::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The unique name for this vehicle.
     * The format is `providers/{provider}/vehicles/{vehicle}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The unique name for this vehicle.
     * The format is `providers/{provider}/vehicles/{vehicle}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The vehicle state.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleState vehicle_state = 2;</code>
     * @return int
     */
    public function getVehicleState()
    {
        return $this->vehicle_state;
    }

    /**
     * The vehicle state.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleState vehicle_state = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setVehicleState($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\V1\VehicleState::class);
        $this->vehicle_state = $var;

        return $this;
    }

    /**
     * Trip types supported by this vehicle.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripType supported_trip_types = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSupportedTripTypes()
    {
        return $this->supported_trip_types;
    }

    /**
     * Trip types supported by this vehicle.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripType supported_trip_types = 3;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSupportedTripTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Maps\FleetEngine\V1\TripType::class);
        $this->supported_trip_types = $arr;

        return $this;
    }

    /**
     * Output only. List of `trip_id`'s for trips currently assigned to this
     * vehicle.
     *
     * Generated from protobuf field <code>repeated string current_trips = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCurrentTrips()
    {
        return $this->current_trips;
    }

    /**
     * Output only. List of `trip_id`'s for trips currently assigned to this
     * vehicle.
     *
     * Generated from protobuf field <code>repeated string current_trips = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCurrentTrips($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->current_trips = $arr;

        return $this;
    }

    /**
     * Last reported location of the vehicle.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleLocation last_location = 5;</code>
     * @return \Google\Maps\FleetEngine\V1\VehicleLocation|null
     */
    public function getLastLocation()
    {
        return $this->last_location;
    }

    public function hasLastLocation()
    {
        return isset($this->last_location);
    }

    public function clearLastLocation()
    {
        unset($this->last_location);
    }

    /**
     * Last reported location of the vehicle.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.VehicleLocation last_location = 5;</code>
     * @param \Google\Maps\FleetEngine\V1\VehicleLocation $var
     * @return $this
     */
    public function setLastLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\VehicleLocation::class);
        $this->last_location = $var;

        return $this;
    }

    /**
     * Input only. Locations where this vehicle has been in the past that haven't
     * yet been reported to Fleet Engine. This is used in `UpdateVehicleRequest`
     * to record locations which were previously unable to be sent to the server.
     * Typically this happens when the vehicle does not have internet
     * connectivity.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.VehicleLocation past_locations = 30 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPastLocations()
    {
        return $this->past_locations;
    }

    /**
     * Input only. Locations where this vehicle has been in the past that haven't
     * yet been reported to Fleet Engine. This is used in `UpdateVehicleRequest`
     * to record locations which were previously unable to be sent to the server.
     * Typically this happens when the vehicle does not have internet
     * connectivity.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.VehicleLocation past_locations = 30 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param array<\Google\Maps\FleetEngine\V1\VehicleLocation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPastLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\VehicleLocation::class);
        $this->past_locations = $arr;

        return $this;
    }

    /**
     * The total numbers of riders this vehicle can carry.  The driver is not
     * considered in this value. This value must be greater than or equal to one.
     *
     * Generated from protobuf field <code>int32 maximum_capacity = 6;</code>
     * @return int
     */
    public function getMaximumCapacity()
    {
        return $this->maximum_capacity;
    }

    /**
     * The total numbers of riders this vehicle can carry.  The driver is not
     * considered in this value. This value must be greater than or equal to one.
     *
     * Generated from protobuf field <code>int32 maximum_capacity = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setMaximumCapacity($var)
    {
        GPBUtil::checkInt32($var);
        $this->maximum_capacity = $var;

        return $this;
    }

    /**
     * List of vehicle attributes. A vehicle can have at most 100
     * attributes, and each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.VehicleAttribute attributes = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * List of vehicle attributes. A vehicle can have at most 100
     * attributes, and each attribute must have a unique key.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.VehicleAttribute attributes = 8;</code>
     * @param array<\Google\Maps\FleetEngine\V1\VehicleAttribute>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\VehicleAttribute::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * Required. The type of this vehicle.  Can be used to filter vehicles in
     * `SearchVehicles` results.  Also influences ETA and route calculations.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.Vehicle.VehicleType vehicle_type = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Maps\FleetEngine\V1\Vehicle\VehicleType|null
     */
    public function getVehicleType()
    {
        return $this->vehicle_type;
    }

    public function hasVehicleType()
    {
        return isset($this->vehicle_type);
    }

    public function clearVehicleType()
    {
        unset($this->vehicle_type);
    }

    /**
     * Required. The type of this vehicle.  Can be used to filter vehicles in
     * `SearchVehicles` results.  Also influences ETA and route calculations.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.Vehicle.VehicleType vehicle_type = 9 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Maps\FleetEngine\V1\Vehicle\VehicleType $var
     * @return $this
     */
    public function setVehicleType($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\Vehicle\VehicleType::class);
        $this->vehicle_type = $var;

        return $this;
    }

    /**
     * License plate information for the vehicle.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.LicensePlate license_plate = 10;</code>
     * @return \Google\Maps\FleetEngine\V1\LicensePlate|null
     */
    public function getLicensePlate()
    {
        return $this->license_plate;
    }

    public function hasLicensePlate()
    {
        return isset($this->license_plate);
    }

    public function clearLicensePlate()
    {
        unset($this->license_plate);
    }

    /**
     * License plate information for the vehicle.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.LicensePlate license_plate = 10;</code>
     * @param \Google\Maps\FleetEngine\V1\LicensePlate $var
     * @return $this
     */
    public function setLicensePlate($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\LicensePlate::class);
        $this->license_plate = $var;

        return $this;
    }

    /**
     * Deprecated: Use `Vehicle.waypoints` instead.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TerminalLocation route = 12 [deprecated = true];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     * @deprecated
     */
    public function getRoute()
    {
        if ($this->route->count() !== 0) {
            @trigger_error('route is deprecated.', E_USER_DEPRECATED);
        }
        return $this->route;
    }

    /**
     * Deprecated: Use `Vehicle.waypoints` instead.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TerminalLocation route = 12 [deprecated = true];</code>
     * @param array<\Google\Maps\FleetEngine\V1\TerminalLocation>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     * @deprecated
     */
    public function setRoute($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\TerminalLocation::class);
        if (count($arr) !== 0) {
            @trigger_error('route is deprecated.', E_USER_DEPRECATED);
        }
        $this->route = $arr;

        return $this;
    }

    /**
     * The polyline specifying the route the driver app intends to take to
     * the next waypoint. This list is also returned in
     * `Trip.current_route_segment` for all active trips assigned to the vehicle.
     * Note: This field is intended only for use by the Driver SDK. Decoding is
     * not yet supported.
     *
     * Generated from protobuf field <code>string current_route_segment = 20;</code>
     * @return string
     */
    public function getCurrentRouteSegment()
    {
        return $this->current_route_segment;
    }

    /**
     * The polyline specifying the route the driver app intends to take to
     * the next waypoint. This list is also returned in
     * `Trip.current_route_segment` for all active trips assigned to the vehicle.
     * Note: This field is intended only for use by the Driver SDK. Decoding is
     * not yet supported.
     *
     * Generated from protobuf field <code>string current_route_segment = 20;</code>
     * @param string $var
     * @return $this
     */
    public function setCurrentRouteSegment($var)
    {
        GPBUtil::checkString($var, True);
        $this->current_route_segment = $var;

        return $this;
    }

    /**
     * Input only. Fleet Engine uses this information to improve journey sharing.
     * Note: This field is intended only for use by the Driver SDK.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TrafficPolylineData current_route_segment_traffic = 28 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\V1\TrafficPolylineData|null
     */
    public function getCurrentRouteSegmentTraffic()
    {
        return $this->current_route_segment_traffic;
    }

    public function hasCurrentRouteSegmentTraffic()
    {
        return isset($this->current_route_segment_traffic);
    }

    public function clearCurrentRouteSegmentTraffic()
    {
        unset($this->current_route_segment_traffic);
    }

    /**
     * Input only. Fleet Engine uses this information to improve journey sharing.
     * Note: This field is intended only for use by the Driver SDK.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TrafficPolylineData current_route_segment_traffic = 28 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\V1\TrafficPolylineData $var
     * @return $this
     */
    public function setCurrentRouteSegmentTraffic($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\TrafficPolylineData::class);
        $this->current_route_segment_traffic = $var;

        return $this;
    }

    /**
     * Output only. Time when `current_route_segment` was set. It can be stored by
     * the client and passed in future `GetVehicle` requests to prevent returning
     * routes that haven't changed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_version = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCurrentRouteSegmentVersion()
    {
        return $this->current_route_segment_version;
    }

    public function hasCurrentRouteSegmentVersion()
    {
        return isset($this->current_route_segment_version);
    }

    public function clearCurrentRouteSegmentVersion()
    {
        unset($this->current_route_segment_version);
    }

    /**
     * Output only. Time when `current_route_segment` was set. It can be stored by
     * the client and passed in future `GetVehicle` requests to prevent returning
     * routes that haven't changed.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp current_route_segment_version = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCurrentRouteSegmentVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->current_route_segment_version = $var;

        return $this;
    }

    /**
     * The waypoint where `current_route_segment` ends. This can be supplied by
     * drivers on `UpdateVehicle` calls either as a full trip waypoint, a waypoint
     * `LatLng`, or as the last `LatLng` of the `current_route_segment`. Fleet
     * Engine will then do its best to interpolate to an actual waypoint if it is
     * not fully specified. This field is ignored in `UpdateVehicle` calls unless
     * `current_route_segment` is also specified.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripWaypoint current_route_segment_end_point = 24;</code>
     * @return \Google\Maps\FleetEngine\V1\TripWaypoint|null
     */
    public function getCurrentRouteSegmentEndPoint()
    {
        return $this->current_route_segment_end_point;
    }

    public function hasCurrentRouteSegmentEndPoint()
    {
        return isset($this->current_route_segment_end_point);
    }

    public function clearCurrentRouteSegmentEndPoint()
    {
        unset($this->current_route_segment_end_point);
    }

    /**
     * The waypoint where `current_route_segment` ends. This can be supplied by
     * drivers on `UpdateVehicle` calls either as a full trip waypoint, a waypoint
     * `LatLng`, or as the last `LatLng` of the `current_route_segment`. Fleet
     * Engine will then do its best to interpolate to an actual waypoint if it is
     * not fully specified. This field is ignored in `UpdateVehicle` calls unless
     * `current_route_segment` is also specified.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.TripWaypoint current_route_segment_end_point = 24;</code>
     * @param \Google\Maps\FleetEngine\V1\TripWaypoint $var
     * @return $this
     */
    public function setCurrentRouteSegmentEndPoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\TripWaypoint::class);
        $this->current_route_segment_end_point = $var;

        return $this;
    }

    /**
     * The remaining driving distance for the `current_route_segment`.
     * This value is also returned in `Trip.remaining_distance_meters` for all
     * active trips assigned to the vehicle. The value is unspecified if the
     * `current_route_segment` field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 18;</code>
     * @return \Google\Protobuf\Int32Value|null
     */
    public function getRemainingDistanceMeters()
    {
        return $this->remaining_distance_meters;
    }

    public function hasRemainingDistanceMeters()
    {
        return isset($this->remaining_distance_meters);
    }

    public function clearRemainingDistanceMeters()
    {
        unset($this->remaining_distance_meters);
    }

    /**
     * Returns the unboxed value from <code>getRemainingDistanceMeters()</code>

     * The remaining driving distance for the `current_route_segment`.
     * This value is also returned in `Trip.remaining_distance_meters` for all
     * active trips assigned to the vehicle. The value is unspecified if the
     * `current_route_segment` field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 18;</code>
     * @return int|null
     */
    public function getRemainingDistanceMetersUnwrapped()
    {
        return $this->readWrapperValue("remaining_distance_meters");
    }

    /**
     * The remaining driving distance for the `current_route_segment`.
     * This value is also returned in `Trip.remaining_distance_meters` for all
     * active trips assigned to the vehicle. The value is unspecified if the
     * `current_route_segment` field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 18;</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     */
    public function setRemainingDistanceMeters($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->remaining_distance_meters = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * The remaining driving distance for the `current_route_segment`.
     * This value is also returned in `Trip.remaining_distance_meters` for all
     * active trips assigned to the vehicle. The value is unspecified if the
     * `current_route_segment` field is empty.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_distance_meters = 18;</code>
     * @param int|null $var
     * @return $this
     */
    public function setRemainingDistanceMetersUnwrapped($var)
    {
        $this->writeWrapperValue("remaining_distance_meters", $var);
        return $this;}

    /**
     * The ETA to the first entry in the `waypoints` field.  The value is
     * unspecified if the `waypoints` field is empty or the
     * `Vehicle.current_route_segment` field is empty.
     * When updating a vehicle, `remaining_time_seconds` takes precedence over
     * `eta_to_first_waypoint` in the same request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp eta_to_first_waypoint = 19;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEtaToFirstWaypoint()
    {
        return $this->eta_to_first_waypoint;
    }

    public function hasEtaToFirstWaypoint()
    {
        return isset($this->eta_to_first_waypoint);
    }

    public function clearEtaToFirstWaypoint()
    {
        unset($this->eta_to_first_waypoint);
    }

    /**
     * The ETA to the first entry in the `waypoints` field.  The value is
     * unspecified if the `waypoints` field is empty or the
     * `Vehicle.current_route_segment` field is empty.
     * When updating a vehicle, `remaining_time_seconds` takes precedence over
     * `eta_to_first_waypoint` in the same request.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp eta_to_first_waypoint = 19;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEtaToFirstWaypoint($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->eta_to_first_waypoint = $var;

        return $this;
    }

    /**
     * Input only. The remaining driving time for the `current_route_segment`. The
     * value is unspecified if the `waypoints` field is empty or the
     * `Vehicle.current_route_segment` field is empty. This value should match
     * `eta_to_first_waypoint` - `current_time` if all parties are using the same
     * clock.
     * When updating a vehicle, `remaining_time_seconds` takes precedence over
     * `eta_to_first_waypoint` in the same request.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_time_seconds = 25 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Protobuf\Int32Value|null
     */
    public function getRemainingTimeSeconds()
    {
        return $this->remaining_time_seconds;
    }

    public function hasRemainingTimeSeconds()
    {
        return isset($this->remaining_time_seconds);
    }

    public function clearRemainingTimeSeconds()
    {
        unset($this->remaining_time_seconds);
    }

    /**
     * Returns the unboxed value from <code>getRemainingTimeSeconds()</code>

     * Input only. The remaining driving time for the `current_route_segment`. The
     * value is unspecified if the `waypoints` field is empty or the
     * `Vehicle.current_route_segment` field is empty. This value should match
     * `eta_to_first_waypoint` - `current_time` if all parties are using the same
     * clock.
     * When updating a vehicle, `remaining_time_seconds` takes precedence over
     * `eta_to_first_waypoint` in the same request.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_time_seconds = 25 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return int|null
     */
    public function getRemainingTimeSecondsUnwrapped()
    {
        return $this->readWrapperValue("remaining_time_seconds");
    }

    /**
     * Input only. The remaining driving time for the `current_route_segment`. The
     * value is unspecified if the `waypoints` field is empty or the
     * `Vehicle.current_route_segment` field is empty. This value should match
     * `eta_to_first_waypoint` - `current_time` if all parties are using the same
     * clock.
     * When updating a vehicle, `remaining_time_seconds` takes precedence over
     * `eta_to_first_waypoint` in the same request.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_time_seconds = 25 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     */
    public function setRemainingTimeSeconds($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->remaining_time_seconds = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * Input only. The remaining driving time for the `current_route_segment`. The
     * value is unspecified if the `waypoints` field is empty or the
     * `Vehicle.current_route_segment` field is empty. This value should match
     * `eta_to_first_waypoint` - `current_time` if all parties are using the same
     * clock.
     * When updating a vehicle, `remaining_time_seconds` takes precedence over
     * `eta_to_first_waypoint` in the same request.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value remaining_time_seconds = 25 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param int|null $var
     * @return $this
     */
    public function setRemainingTimeSecondsUnwrapped($var)
    {
        $this->writeWrapperValue("remaining_time_seconds", $var);
        return $this;}

    /**
     * The remaining waypoints assigned to this Vehicle.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint waypoints = 22;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getWaypoints()
    {
        return $this->waypoints;
    }

    /**
     * The remaining waypoints assigned to this Vehicle.
     *
     * Generated from protobuf field <code>repeated .maps.fleetengine.v1.TripWaypoint waypoints = 22;</code>
     * @param array<\Google\Maps\FleetEngine\V1\TripWaypoint>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setWaypoints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Maps\FleetEngine\V1\TripWaypoint::class);
        $this->waypoints = $arr;

        return $this;
    }

    /**
     * Output only. Last time the `waypoints` field was updated. Clients should
     * cache this value and pass it in `GetVehicleRequest` to ensure the
     * `waypoints` field is only returned if it is updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp waypoints_version = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getWaypointsVersion()
    {
        return $this->waypoints_version;
    }

    public function hasWaypointsVersion()
    {
        return isset($this->waypoints_version);
    }

    public function clearWaypointsVersion()
    {
        unset($this->waypoints_version);
    }

    /**
     * Output only. Last time the `waypoints` field was updated. Clients should
     * cache this value and pass it in `GetVehicleRequest` to ensure the
     * `waypoints` field is only returned if it is updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp waypoints_version = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setWaypointsVersion($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->waypoints_version = $var;

        return $this;
    }

    /**
     * Indicates if the driver accepts back-to-back trips. If `true`,
     * `SearchVehicles` may include the vehicle even if it is currently assigned
     * to a trip. The default value is `false`.
     *
     * Generated from protobuf field <code>bool back_to_back_enabled = 23;</code>
     * @return bool
     */
    public function getBackToBackEnabled()
    {
        return $this->back_to_back_enabled;
    }

    /**
     * Indicates if the driver accepts back-to-back trips. If `true`,
     * `SearchVehicles` may include the vehicle even if it is currently assigned
     * to a trip. The default value is `false`.
     *
     * Generated from protobuf field <code>bool back_to_back_enabled = 23;</code>
     * @param bool $var
     * @return $this
     */
    public function setBackToBackEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->back_to_back_enabled = $var;

        return $this;
    }

    /**
     * The vehicle's navigation status.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.NavigationStatus navigation_status = 26;</code>
     * @return int
     */
    public function getNavigationStatus()
    {
        return $this->navigation_status;
    }

    /**
     * The vehicle's navigation status.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.NavigationStatus navigation_status = 26;</code>
     * @param int $var
     * @return $this
     */
    public function setNavigationStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Maps\FleetEngine\V1\NavigationStatus::class);
        $this->navigation_status = $var;

        return $this;
    }

    /**
     * Input only. Information about settings in the mobile device being used by
     * the driver.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.DeviceSettings device_settings = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Maps\FleetEngine\V1\DeviceSettings|null
     */
    public function getDeviceSettings()
    {
        return $this->device_settings;
    }

    public function hasDeviceSettings()
    {
        return isset($this->device_settings);
    }

    public function clearDeviceSettings()
    {
        unset($this->device_settings);
    }

    /**
     * Input only. Information about settings in the mobile device being used by
     * the driver.
     *
     * Generated from protobuf field <code>.maps.fleetengine.v1.DeviceSettings device_settings = 27 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Maps\FleetEngine\V1\DeviceSettings $var
     * @return $this
     */
    public function setDeviceSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Maps\FleetEngine\V1\DeviceSettings::class);
        $this->device_settings = $var;

        return $this;
    }

}

