<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/financialservices/v1/dataset.proto

namespace Google\Cloud\FinancialServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The Dataset resource contains summary information about a dataset.
 *
 * Generated from protobuf message <code>google.cloud.financialservices.v1.Dataset</code>
 */
class Dataset extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the Dataset.
     * format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Output only. The timestamp of creation of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp of the most recent update of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Required. The set of BigQuery tables in the dataset.  The key should be the
     * table type and the value should be the BigQuery tables in the format
     * `bq://{project}.{dataset}.{table}`.
     * Current table types are:
     *   * `party`
     *   * `account_party_link`
     *   * `transaction`
     *   * `risk_case_event`
     *   * `party_supplementary_data`
     *
     * Generated from protobuf field <code>map<string, string> table_specs = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $table_specs;
    /**
     * Output only. State of the dataset (creating, active, deleting, etc.)
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.Dataset.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Required. Core time window of the dataset. All tables should have complete
     * data covering this period.
     *
     * Generated from protobuf field <code>.google.type.Interval date_range = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $date_range = null;
    /**
     * The timezone of the data, default will act as UTC.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 9;</code>
     */
    protected $time_zone = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the Dataset.
     *           format:
     *           `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp of creation of this resource.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp of the most recent update of this resource.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels
     *     @type array|\Google\Protobuf\Internal\MapField $table_specs
     *           Required. The set of BigQuery tables in the dataset.  The key should be the
     *           table type and the value should be the BigQuery tables in the format
     *           `bq://{project}.{dataset}.{table}`.
     *           Current table types are:
     *             * `party`
     *             * `account_party_link`
     *             * `transaction`
     *             * `risk_case_event`
     *             * `party_supplementary_data`
     *     @type int $state
     *           Output only. State of the dataset (creating, active, deleting, etc.)
     *     @type \Google\Type\Interval $date_range
     *           Required. Core time window of the dataset. All tables should have complete
     *           data covering this period.
     *     @type \Google\Type\TimeZone $time_zone
     *           The timezone of the data, default will act as UTC.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Financialservices\V1\Dataset::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the Dataset.
     * format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the Dataset.
     * format:
     * `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp of creation of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp of creation of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp of the most recent update of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp of the most recent update of this resource.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Required. The set of BigQuery tables in the dataset.  The key should be the
     * table type and the value should be the BigQuery tables in the format
     * `bq://{project}.{dataset}.{table}`.
     * Current table types are:
     *   * `party`
     *   * `account_party_link`
     *   * `transaction`
     *   * `risk_case_event`
     *   * `party_supplementary_data`
     *
     * Generated from protobuf field <code>map<string, string> table_specs = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getTableSpecs()
    {
        return $this->table_specs;
    }

    /**
     * Required. The set of BigQuery tables in the dataset.  The key should be the
     * table type and the value should be the BigQuery tables in the format
     * `bq://{project}.{dataset}.{table}`.
     * Current table types are:
     *   * `party`
     *   * `account_party_link`
     *   * `transaction`
     *   * `risk_case_event`
     *   * `party_supplementary_data`
     *
     * Generated from protobuf field <code>map<string, string> table_specs = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setTableSpecs($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->table_specs = $arr;

        return $this;
    }

    /**
     * Output only. State of the dataset (creating, active, deleting, etc.)
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.Dataset.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the dataset (creating, active, deleting, etc.)
     *
     * Generated from protobuf field <code>.google.cloud.financialservices.v1.Dataset.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\FinancialServices\V1\Dataset\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Required. Core time window of the dataset. All tables should have complete
     * data covering this period.
     *
     * Generated from protobuf field <code>.google.type.Interval date_range = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Type\Interval|null
     */
    public function getDateRange()
    {
        return $this->date_range;
    }

    public function hasDateRange()
    {
        return isset($this->date_range);
    }

    public function clearDateRange()
    {
        unset($this->date_range);
    }

    /**
     * Required. Core time window of the dataset. All tables should have complete
     * data covering this period.
     *
     * Generated from protobuf field <code>.google.type.Interval date_range = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setDateRange($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->date_range = $var;

        return $this;
    }

    /**
     * The timezone of the data, default will act as UTC.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 9;</code>
     * @return \Google\Type\TimeZone|null
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    public function hasTimeZone()
    {
        return isset($this->time_zone);
    }

    public function clearTimeZone()
    {
        unset($this->time_zone);
    }

    /**
     * The timezone of the data, default will act as UTC.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 9;</code>
     * @param \Google\Type\TimeZone $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\TimeZone::class);
        $this->time_zone = $var;

        return $this;
    }

}

