<?php
/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/chronicle/v1/rule.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Chronicle\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Chronicle\V1\CreateRetrohuntRequest;
use Google\Cloud\Chronicle\V1\CreateRuleRequest;
use Google\Cloud\Chronicle\V1\DeleteRuleRequest;
use Google\Cloud\Chronicle\V1\GetRetrohuntRequest;
use Google\Cloud\Chronicle\V1\GetRuleDeploymentRequest;
use Google\Cloud\Chronicle\V1\GetRuleRequest;
use Google\Cloud\Chronicle\V1\ListRetrohuntsRequest;
use Google\Cloud\Chronicle\V1\ListRuleDeploymentsRequest;
use Google\Cloud\Chronicle\V1\ListRuleRevisionsRequest;
use Google\Cloud\Chronicle\V1\ListRulesRequest;
use Google\Cloud\Chronicle\V1\Retrohunt;
use Google\Cloud\Chronicle\V1\Rule;
use Google\Cloud\Chronicle\V1\RuleDeployment;
use Google\Cloud\Chronicle\V1\UpdateRuleDeploymentRequest;
use Google\Cloud\Chronicle\V1\UpdateRuleRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: RuleService provides interface for user-created rules.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createRetrohuntAsync(CreateRetrohuntRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Rule> createRuleAsync(CreateRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteRuleAsync(DeleteRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Retrohunt> getRetrohuntAsync(GetRetrohuntRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Rule> getRuleAsync(GetRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RuleDeployment> getRuleDeploymentAsync(GetRuleDeploymentRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRetrohuntsAsync(ListRetrohuntsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRuleDeploymentsAsync(ListRuleDeploymentsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRuleRevisionsAsync(ListRuleRevisionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listRulesAsync(ListRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Rule> updateRuleAsync(UpdateRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RuleDeployment> updateRuleDeploymentAsync(UpdateRuleDeploymentRequest $request, array $optionalArgs = [])
 */
final class RuleServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.chronicle.v1.RuleService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'chronicle.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'chronicle.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/rule_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/rule_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/rule_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/rule_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * data_access_scope resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $dataAccessScope
     *
     * @return string The formatted data_access_scope resource.
     */
    public static function dataAccessScopeName(
        string $project,
        string $location,
        string $instance,
        string $dataAccessScope
    ): string {
        return self::getPathTemplate('dataAccessScope')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'data_access_scope' => $dataAccessScope,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName(string $project, string $location, string $instance): string
    {
        return self::getPathTemplate('instance')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * reference_list resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $referenceList
     *
     * @return string The formatted reference_list resource.
     */
    public static function referenceListName(
        string $project,
        string $location,
        string $instance,
        string $referenceList
    ): string {
        return self::getPathTemplate('referenceList')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'reference_list' => $referenceList,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a retrohunt
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $rule
     * @param string $retrohunt
     *
     * @return string The formatted retrohunt resource.
     */
    public static function retrohuntName(
        string $project,
        string $location,
        string $instance,
        string $rule,
        string $retrohunt
    ): string {
        return self::getPathTemplate('retrohunt')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'rule' => $rule,
            'retrohunt' => $retrohunt,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a rule
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $rule
     *
     * @return string The formatted rule resource.
     */
    public static function ruleName(string $project, string $location, string $instance, string $rule): string
    {
        return self::getPathTemplate('rule')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'rule' => $rule,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * rule_deployment resource.
     *
     * @param string $project
     * @param string $location
     * @param string $instance
     * @param string $rule
     *
     * @return string The formatted rule_deployment resource.
     */
    public static function ruleDeploymentName(string $project, string $location, string $instance, string $rule): string
    {
        return self::getPathTemplate('ruleDeployment')->render([
            'project' => $project,
            'location' => $location,
            'instance' => $instance,
            'rule' => $rule,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - dataAccessScope: projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope}
     * - instance: projects/{project}/locations/{location}/instances/{instance}
     * - referenceList: projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}
     * - retrohunt: projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/retrohunts/{retrohunt}
     * - rule: projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
     * - ruleDeployment: projects/{project}/locations/{location}/instances/{instance}/rules/{rule}/deployment
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'chronicle.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Chronicle\V1\RuleServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new RuleServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Create a Retrohunt.
     *
     * The async variant is {@see RuleServiceClient::createRetrohuntAsync()} .
     *
     * @example samples/V1/RuleServiceClient/create_retrohunt.php
     *
     * @param CreateRetrohuntRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<Retrohunt>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRetrohunt(CreateRetrohuntRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateRetrohunt', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Rule.
     *
     * The async variant is {@see RuleServiceClient::createRuleAsync()} .
     *
     * @example samples/V1/RuleServiceClient/create_rule.php
     *
     * @param CreateRuleRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createRule(CreateRuleRequest $request, array $callOptions = []): Rule
    {
        return $this->startApiCall('CreateRule', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Rule.
     *
     * The async variant is {@see RuleServiceClient::deleteRuleAsync()} .
     *
     * @example samples/V1/RuleServiceClient/delete_rule.php
     *
     * @param DeleteRuleRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteRule(DeleteRuleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteRule', $request, $callOptions)->wait();
    }

    /**
     * Get a Retrohunt.
     *
     * The async variant is {@see RuleServiceClient::getRetrohuntAsync()} .
     *
     * @example samples/V1/RuleServiceClient/get_retrohunt.php
     *
     * @param GetRetrohuntRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Retrohunt
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRetrohunt(GetRetrohuntRequest $request, array $callOptions = []): Retrohunt
    {
        return $this->startApiCall('GetRetrohunt', $request, $callOptions)->wait();
    }

    /**
     * Gets a Rule.
     *
     * The async variant is {@see RuleServiceClient::getRuleAsync()} .
     *
     * @example samples/V1/RuleServiceClient/get_rule.php
     *
     * @param GetRuleRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRule(GetRuleRequest $request, array $callOptions = []): Rule
    {
        return $this->startApiCall('GetRule', $request, $callOptions)->wait();
    }

    /**
     * Gets a RuleDeployment.
     *
     * The async variant is {@see RuleServiceClient::getRuleDeploymentAsync()} .
     *
     * @example samples/V1/RuleServiceClient/get_rule_deployment.php
     *
     * @param GetRuleDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RuleDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getRuleDeployment(GetRuleDeploymentRequest $request, array $callOptions = []): RuleDeployment
    {
        return $this->startApiCall('GetRuleDeployment', $request, $callOptions)->wait();
    }

    /**
     * List Retrohunts.
     *
     * The async variant is {@see RuleServiceClient::listRetrohuntsAsync()} .
     *
     * @example samples/V1/RuleServiceClient/list_retrohunts.php
     *
     * @param ListRetrohuntsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRetrohunts(ListRetrohuntsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRetrohunts', $request, $callOptions);
    }

    /**
     * Lists RuleDeployments across all Rules.
     *
     * The async variant is {@see RuleServiceClient::listRuleDeploymentsAsync()} .
     *
     * @example samples/V1/RuleServiceClient/list_rule_deployments.php
     *
     * @param ListRuleDeploymentsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRuleDeployments(ListRuleDeploymentsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRuleDeployments', $request, $callOptions);
    }

    /**
     * Lists all revisions of the rule.
     *
     * The async variant is {@see RuleServiceClient::listRuleRevisionsAsync()} .
     *
     * @example samples/V1/RuleServiceClient/list_rule_revisions.php
     *
     * @param ListRuleRevisionsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRuleRevisions(ListRuleRevisionsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRuleRevisions', $request, $callOptions);
    }

    /**
     * Lists Rules.
     *
     * The async variant is {@see RuleServiceClient::listRulesAsync()} .
     *
     * @example samples/V1/RuleServiceClient/list_rules.php
     *
     * @param ListRulesRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listRules(ListRulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListRules', $request, $callOptions);
    }

    /**
     * Updates a Rule.
     *
     * The async variant is {@see RuleServiceClient::updateRuleAsync()} .
     *
     * @example samples/V1/RuleServiceClient/update_rule.php
     *
     * @param UpdateRuleRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Rule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRule(UpdateRuleRequest $request, array $callOptions = []): Rule
    {
        return $this->startApiCall('UpdateRule', $request, $callOptions)->wait();
    }

    /**
     * Updates a RuleDeployment.
     * Failures are not necessarily atomic. If there is a request to update
     * multiple fields, and any update to a single field fails, an error will be
     * returned, but other fields may remain successfully updated.
     *
     * The async variant is {@see RuleServiceClient::updateRuleDeploymentAsync()} .
     *
     * @example samples/V1/RuleServiceClient/update_rule_deployment.php
     *
     * @param UpdateRuleDeploymentRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RuleDeployment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateRuleDeployment(UpdateRuleDeploymentRequest $request, array $callOptions = []): RuleDeployment
    {
        return $this->startApiCall('UpdateRuleDeployment', $request, $callOptions)->wait();
    }
}
