<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/appengine/v1/appengine.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AppEngine\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AppEngine\V1\BatchUpdateIngressRulesRequest;
use Google\Cloud\AppEngine\V1\BatchUpdateIngressRulesResponse;
use Google\Cloud\AppEngine\V1\CreateIngressRuleRequest;
use Google\Cloud\AppEngine\V1\DeleteIngressRuleRequest;
use Google\Cloud\AppEngine\V1\FirewallRule;
use Google\Cloud\AppEngine\V1\GetIngressRuleRequest;
use Google\Cloud\AppEngine\V1\ListIngressRulesRequest;
use Google\Cloud\AppEngine\V1\UpdateIngressRuleRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Firewall resources are used to define a collection of access control rules
 * for an Application. Each rule is defined with a position which specifies
 * the rule's order in the sequence of rules, an IP range to be matched against
 * requests, and an action to take upon matching requests.
 *
 * Every request is evaluated against the Firewall rules in priority order.
 * Processesing stops at the first rule which matches the request's IP address.
 * A final rule always specifies an action that applies to all remaining
 * IP addresses. The default final rule for a newly-created application will be
 * set to "allow" if not otherwise specified by the user.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * @method PromiseInterface<BatchUpdateIngressRulesResponse> batchUpdateIngressRulesAsync(BatchUpdateIngressRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FirewallRule> createIngressRuleAsync(CreateIngressRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteIngressRuleAsync(DeleteIngressRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FirewallRule> getIngressRuleAsync(GetIngressRuleRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listIngressRulesAsync(ListIngressRulesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FirewallRule> updateIngressRuleAsync(UpdateIngressRuleRequest $request, array $optionalArgs = [])
 */
final class FirewallClient
{
    use GapicClientTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.appengine.v1.Firewall';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'appengine.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'appengine.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/appengine.admin',
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/firewall_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/firewall_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/firewall_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/firewall_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'appengine.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\AppEngine\V1\FirewallClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new FirewallClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Replaces the entire firewall ruleset in one bulk operation. This overrides
     * and replaces the rules of an existing firewall with the new rules.
     *
     * If the final rule does not match traffic with the '*' wildcard IP range,
     * then an "allow all" rule is explicitly added to the end of the list.
     *
     * The async variant is {@see FirewallClient::batchUpdateIngressRulesAsync()} .
     *
     * @example samples/V1/FirewallClient/batch_update_ingress_rules.php
     *
     * @param BatchUpdateIngressRulesRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchUpdateIngressRulesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchUpdateIngressRules(BatchUpdateIngressRulesRequest $request, array $callOptions = []): BatchUpdateIngressRulesResponse
    {
        return $this->startApiCall('BatchUpdateIngressRules', $request, $callOptions)->wait();
    }

    /**
     * Creates a firewall rule for the application.
     *
     * The async variant is {@see FirewallClient::createIngressRuleAsync()} .
     *
     * @example samples/V1/FirewallClient/create_ingress_rule.php
     *
     * @param CreateIngressRuleRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FirewallRule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createIngressRule(CreateIngressRuleRequest $request, array $callOptions = []): FirewallRule
    {
        return $this->startApiCall('CreateIngressRule', $request, $callOptions)->wait();
    }

    /**
     * Deletes the specified firewall rule.
     *
     * The async variant is {@see FirewallClient::deleteIngressRuleAsync()} .
     *
     * @example samples/V1/FirewallClient/delete_ingress_rule.php
     *
     * @param DeleteIngressRuleRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteIngressRule(DeleteIngressRuleRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteIngressRule', $request, $callOptions)->wait();
    }

    /**
     * Gets the specified firewall rule.
     *
     * The async variant is {@see FirewallClient::getIngressRuleAsync()} .
     *
     * @example samples/V1/FirewallClient/get_ingress_rule.php
     *
     * @param GetIngressRuleRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FirewallRule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIngressRule(GetIngressRuleRequest $request, array $callOptions = []): FirewallRule
    {
        return $this->startApiCall('GetIngressRule', $request, $callOptions)->wait();
    }

    /**
     * Lists the firewall rules of an application.
     *
     * The async variant is {@see FirewallClient::listIngressRulesAsync()} .
     *
     * @example samples/V1/FirewallClient/list_ingress_rules.php
     *
     * @param ListIngressRulesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listIngressRules(ListIngressRulesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListIngressRules', $request, $callOptions);
    }

    /**
     * Updates the specified firewall rule.
     *
     * The async variant is {@see FirewallClient::updateIngressRuleAsync()} .
     *
     * @example samples/V1/FirewallClient/update_ingress_rule.php
     *
     * @param UpdateIngressRuleRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FirewallRule
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateIngressRule(UpdateIngressRuleRequest $request, array $callOptions = []): FirewallRule
    {
        return $this->startApiCall('UpdateIngressRule', $request, $callOptions)->wait();
    }
}
