<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/search_service.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] method.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.SearchRequest</code>
 */
class SearchRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the search engine placement, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`
     * This field is used to identify the serving configuration name and the set
     * of models that will be used to make the search.
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $placement = '';
    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     */
    private $branch = '';
    /**
     * Raw search query.
     *
     * Generated from protobuf field <code>string query = 3;</code>
     */
    private $query = '';
    /**
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2.UserEvent.visitor_id].
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $visitor_id = '';
    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 5;</code>
     */
    private $user_info = null;
    /**
     * Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
     * unspecified, defaults to a reasonable value. The maximum allowed value is
     * 120. Values above 120 will be coerced to 120.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 7;</code>
     */
    private $page_size = 0;
    /**
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
     * match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Generated from protobuf field <code>string page_token = 8;</code>
     */
    private $page_token = '';
    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the [Product][google.cloud.retail.v2.Product]s
     * deemed by the API as relevant) in search results. This field is only
     * considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * is unset.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     */
    private $offset = 0;
    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. See more details at this [user
     * guide](https://cloud.google.com/retail/docs/filter-and-order#filter).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string filter = 10;</code>
     */
    private $filter = '';
    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. For example, if a query does not have enough
     * results, an expanded query with
     * [SearchRequest.canonical_filter][google.cloud.retail.v2.SearchRequest.canonical_filter]
     * will be returned as a supplement of the original query. This field is
     * strongly recommended to achieve high search quality.
     * See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * more details about filter syntax.
     *
     * Generated from protobuf field <code>string canonical_filter = 28;</code>
     */
    private $canonical_filter = '';
    /**
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
     * unset if ordered by relevance. OrderBy expression is case-sensitive. See
     * more details at this [user
     * guide](https://cloud.google.com/retail/docs/filter-and-order#order).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string order_by = 11;</code>
     */
    private $order_by = '';
    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.FacetSpec facet_specs = 12;</code>
     */
    private $facet_specs;
    /**
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];</code>
     * @deprecated
     */
    protected $dynamic_facet_spec = null;
    /**
     * Boost specification to boost certain products. See more details at this
     * [user guide](https://cloud.google.com/retail/docs/boosting).
     * Notice that if both [ServingConfig.boost_control_ids][] and
     * [SearchRequest.boost_spec] are set, the boost conditions from both places
     * are evaluated. If a search request matches multiple boost conditions,
     * the final boost score is equal to the sum of the boost scores from all
     * matched boost conditions.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.BoostSpec boost_spec = 13;</code>
     */
    private $boost_spec = null;
    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion will occur. See more details at this [user
     * guide](https://cloud.google.com/retail/docs/result-size#query_expansion).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;</code>
     */
    private $query_expansion_spec = null;
    /**
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s attributes. The
     * attributes from all the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s are merged and
     * de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     * Supported keys are:
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.inventories.attributes][] map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-5".
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string variant_rollup_keys = 17;</code>
     */
    private $variant_rollup_keys;
    /**
     * The categories associated with a category page. Required for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *
     * Generated from protobuf field <code>repeated string page_categories = 23;</code>
     */
    private $page_categories;
    /**
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.SearchMode search_mode = 31;</code>
     */
    private $search_mode = 0;
    /**
     * The specification for personalization.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 32;</code>
     */
    private $personalization_spec = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $placement
     *           Required. The resource name of the search engine placement, such as
     *           `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`
     *           This field is used to identify the serving configuration name and the set
     *           of models that will be used to make the search.
     *     @type string $branch
     *           The branch resource name, such as
     *           `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     *           Use "default_branch" as the branch ID or leave this field empty, to search
     *           products under the default branch.
     *     @type string $query
     *           Raw search query.
     *     @type string $visitor_id
     *           Required. A unique identifier for tracking visitors. For example, this
     *           could be implemented with an HTTP cookie, which should be able to uniquely
     *           identify a visitor on a single device. This unique identifier should not
     *           change if the visitor logs in or out of the website.
     *           This should be the same identifier as
     *           [UserEvent.visitor_id][google.cloud.retail.v2.UserEvent.visitor_id].
     *           The field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type \Google\Cloud\Retail\V2\UserInfo $user_info
     *           User information.
     *     @type int $page_size
     *           Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
     *           unspecified, defaults to a reasonable value. The maximum allowed value is
     *           120. Values above 120 will be coerced to 120.
     *           If this field is negative, an INVALID_ARGUMENT is returned.
     *     @type string $page_token
     *           A page token
     *           [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
     *           received from a previous
     *           [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
     *           Provide this to retrieve the subsequent page.
     *           When paginating, all other parameters provided to
     *           [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
     *           match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
     *           error is returned.
     *     @type int $offset
     *           A 0-indexed integer that specifies the current offset (that is, starting
     *           result location, amongst the [Product][google.cloud.retail.v2.Product]s
     *           deemed by the API as relevant) in search results. This field is only
     *           considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
     *           is unset.
     *           If this field is negative, an INVALID_ARGUMENT is returned.
     *     @type string $filter
     *           The filter syntax consists of an expression language for constructing a
     *           predicate from one or more fields of the products being filtered. Filter
     *           expression is case-sensitive. See more details at this [user
     *           guide](https://cloud.google.com/retail/docs/filter-and-order#filter).
     *           If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *     @type string $canonical_filter
     *           The default filter that is applied when a user performs a search without
     *           checking any filters on the search page.
     *           The filter applied to every search request when quality improvement such as
     *           query expansion is needed. For example, if a query does not have enough
     *           results, an expanded query with
     *           [SearchRequest.canonical_filter][google.cloud.retail.v2.SearchRequest.canonical_filter]
     *           will be returned as a supplement of the original query. This field is
     *           strongly recommended to achieve high search quality.
     *           See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     *           more details about filter syntax.
     *     @type string $order_by
     *           The order in which products are returned. Products can be ordered by
     *           a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
     *           unset if ordered by relevance. OrderBy expression is case-sensitive. See
     *           more details at this [user
     *           guide](https://cloud.google.com/retail/docs/filter-and-order#order).
     *           If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\FacetSpec[]|\Google\Protobuf\Internal\RepeatedField $facet_specs
     *           Facet specifications for faceted search. If empty, no facets are returned.
     *           A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     *           is returned.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec $dynamic_facet_spec
     *           Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     *           to enable dynamic facets. Do not set this field.
     *           The specification for dynamically generated facets. Notice that only
     *           textual facets can be dynamically generated.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\BoostSpec $boost_spec
     *           Boost specification to boost certain products. See more details at this
     *           [user guide](https://cloud.google.com/retail/docs/boosting).
     *           Notice that if both [ServingConfig.boost_control_ids][] and
     *           [SearchRequest.boost_spec] are set, the boost conditions from both places
     *           are evaluated. If a search request matches multiple boost conditions,
     *           the final boost score is equal to the sum of the boost scores from all
     *           matched boost conditions.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\QueryExpansionSpec $query_expansion_spec
     *           The query expansion specification that specifies the conditions under which
     *           query expansion will occur. See more details at this [user
     *           guide](https://cloud.google.com/retail/docs/result-size#query_expansion).
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $variant_rollup_keys
     *           The keys to fetch and rollup the matching
     *           [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     *           [Product][google.cloud.retail.v2.Product]s attributes,
     *           [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo] or
     *           [LocalInventory][google.cloud.retail.v2.LocalInventory]s attributes. The
     *           attributes from all the matching
     *           [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     *           [Product][google.cloud.retail.v2.Product]s or
     *           [LocalInventory][google.cloud.retail.v2.LocalInventory]s are merged and
     *           de-duplicated. Notice that rollup attributes will lead to extra query
     *           latency. Maximum number of keys is 30.
     *           For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
     *           fulfillment type and a fulfillment ID must be provided in the format of
     *           "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     *           "pickupInStore" is fulfillment type and "store123" is the store ID.
     *           Supported keys are:
     *           * colorFamilies
     *           * price
     *           * originalPrice
     *           * discount
     *           * variantId
     *           * inventory(place_id,price)
     *           * inventory(place_id,original_price)
     *           * inventory(place_id,attributes.key), where key is any key in the
     *             [Product.inventories.attributes][] map.
     *           * attributes.key, where key is any key in the
     *             [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
     *           * pickupInStore.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "pickup-in-store".
     *           * shipToStore.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "ship-to-store".
     *           * sameDayDelivery.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "same-day-delivery".
     *           * nextDayDelivery.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "next-day-delivery".
     *           * customFulfillment1.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-1".
     *           * customFulfillment2.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-2".
     *           * customFulfillment3.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-3".
     *           * customFulfillment4.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-4".
     *           * customFulfillment5.id, where id is any
     *           [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     *           for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *             "custom-type-5".
     *           If this field is set to an invalid value other than these, an
     *           INVALID_ARGUMENT error is returned.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $page_categories
     *           The categories associated with a category page. Required for category
     *           navigation queries to achieve good search quality. The format should be
     *           the same as
     *           [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
     *           To represent full path of category, use '>' sign to separate different
     *           hierarchies. If '>' is part of the category name, please replace it with
     *           other character(s).
     *           Category pages include special pages such as sales or promotions. For
     *           instance, a special sale page may have the category hierarchy:
     *           "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *     @type int $search_mode
     *           The search mode of the search request. If not specified, a single search
     *           request triggers both product search and faceted search.
     *     @type \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec $personalization_spec
     *           The specification for personalization.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the search engine placement, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`
     * This field is used to identify the serving configuration name and the set
     * of models that will be used to make the search.
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPlacement()
    {
        return $this->placement;
    }

    /**
     * Required. The resource name of the search engine placement, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/placements/default_search`
     * This field is used to identify the serving configuration name and the set
     * of models that will be used to make the search.
     *
     * Generated from protobuf field <code>string placement = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPlacement($var)
    {
        GPBUtil::checkString($var, True);
        $this->placement = $var;

        return $this;
    }

    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getBranch()
    {
        return $this->branch;
    }

    /**
     * The branch resource name, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/0`.
     * Use "default_branch" as the branch ID or leave this field empty, to search
     * products under the default branch.
     *
     * Generated from protobuf field <code>string branch = 2 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setBranch($var)
    {
        GPBUtil::checkString($var, True);
        $this->branch = $var;

        return $this;
    }

    /**
     * Raw search query.
     *
     * Generated from protobuf field <code>string query = 3;</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * Raw search query.
     *
     * Generated from protobuf field <code>string query = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

    /**
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2.UserEvent.visitor_id].
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getVisitorId()
    {
        return $this->visitor_id;
    }

    /**
     * Required. A unique identifier for tracking visitors. For example, this
     * could be implemented with an HTTP cookie, which should be able to uniquely
     * identify a visitor on a single device. This unique identifier should not
     * change if the visitor logs in or out of the website.
     * This should be the same identifier as
     * [UserEvent.visitor_id][google.cloud.retail.v2.UserEvent.visitor_id].
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setVisitorId($var)
    {
        GPBUtil::checkString($var, True);
        $this->visitor_id = $var;

        return $this;
    }

    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 5;</code>
     * @return \Google\Cloud\Retail\V2\UserInfo|null
     */
    public function getUserInfo()
    {
        return $this->user_info;
    }

    public function hasUserInfo()
    {
        return isset($this->user_info);
    }

    public function clearUserInfo()
    {
        unset($this->user_info);
    }

    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 5;</code>
     * @param \Google\Cloud\Retail\V2\UserInfo $var
     * @return $this
     */
    public function setUserInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\UserInfo::class);
        $this->user_info = $var;

        return $this;
    }

    /**
     * Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
     * unspecified, defaults to a reasonable value. The maximum allowed value is
     * 120. Values above 120 will be coerced to 120.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 7;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * Maximum number of [Product][google.cloud.retail.v2.Product]s to return. If
     * unspecified, defaults to a reasonable value. The maximum allowed value is
     * 120. Values above 120 will be coerced to 120.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 page_size = 7;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
     * match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Generated from protobuf field <code>string page_token = 8;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * A page token
     * [SearchResponse.next_page_token][google.cloud.retail.v2.SearchResponse.next_page_token],
     * received from a previous
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] call.
     * Provide this to retrieve the subsequent page.
     * When paginating, all other parameters provided to
     * [SearchService.Search][google.cloud.retail.v2.SearchService.Search] must
     * match the call that provided the page token. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     *
     * Generated from protobuf field <code>string page_token = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the [Product][google.cloud.retail.v2.Product]s
     * deemed by the API as relevant) in search results. This field is only
     * considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * is unset.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * A 0-indexed integer that specifies the current offset (that is, starting
     * result location, amongst the [Product][google.cloud.retail.v2.Product]s
     * deemed by the API as relevant) in search results. This field is only
     * considered if [page_token][google.cloud.retail.v2.SearchRequest.page_token]
     * is unset.
     * If this field is negative, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>int32 offset = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setOffset($var)
    {
        GPBUtil::checkInt32($var);
        $this->offset = $var;

        return $this;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. See more details at this [user
     * guide](https://cloud.google.com/retail/docs/filter-and-order#filter).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string filter = 10;</code>
     * @return string
     */
    public function getFilter()
    {
        return $this->filter;
    }

    /**
     * The filter syntax consists of an expression language for constructing a
     * predicate from one or more fields of the products being filtered. Filter
     * expression is case-sensitive. See more details at this [user
     * guide](https://cloud.google.com/retail/docs/filter-and-order#filter).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string filter = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter = $var;

        return $this;
    }

    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. For example, if a query does not have enough
     * results, an expanded query with
     * [SearchRequest.canonical_filter][google.cloud.retail.v2.SearchRequest.canonical_filter]
     * will be returned as a supplement of the original query. This field is
     * strongly recommended to achieve high search quality.
     * See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * more details about filter syntax.
     *
     * Generated from protobuf field <code>string canonical_filter = 28;</code>
     * @return string
     */
    public function getCanonicalFilter()
    {
        return $this->canonical_filter;
    }

    /**
     * The default filter that is applied when a user performs a search without
     * checking any filters on the search page.
     * The filter applied to every search request when quality improvement such as
     * query expansion is needed. For example, if a query does not have enough
     * results, an expanded query with
     * [SearchRequest.canonical_filter][google.cloud.retail.v2.SearchRequest.canonical_filter]
     * will be returned as a supplement of the original query. This field is
     * strongly recommended to achieve high search quality.
     * See [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * more details about filter syntax.
     *
     * Generated from protobuf field <code>string canonical_filter = 28;</code>
     * @param string $var
     * @return $this
     */
    public function setCanonicalFilter($var)
    {
        GPBUtil::checkString($var, True);
        $this->canonical_filter = $var;

        return $this;
    }

    /**
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
     * unset if ordered by relevance. OrderBy expression is case-sensitive. See
     * more details at this [user
     * guide](https://cloud.google.com/retail/docs/filter-and-order#order).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string order_by = 11;</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * The order in which products are returned. Products can be ordered by
     * a field in an [Product][google.cloud.retail.v2.Product] object. Leave it
     * unset if ordered by relevance. OrderBy expression is case-sensitive. See
     * more details at this [user
     * guide](https://cloud.google.com/retail/docs/filter-and-order#order).
     * If this field is unrecognizable, an INVALID_ARGUMENT is returned.
     *
     * Generated from protobuf field <code>string order_by = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.FacetSpec facet_specs = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFacetSpecs()
    {
        return $this->facet_specs;
    }

    /**
     * Facet specifications for faceted search. If empty, no facets are returned.
     * A maximum of 100 values are allowed. Otherwise, an INVALID_ARGUMENT error
     * is returned.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.SearchRequest.FacetSpec facet_specs = 12;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\FacetSpec[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFacetSpecs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\SearchRequest\FacetSpec::class);
        $this->facet_specs = $arr;

        return $this;
    }

    /**
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec|null
     * @deprecated
     */
    public function getDynamicFacetSpec()
    {
        @trigger_error('dynamic_facet_spec is deprecated.', E_USER_DEPRECATED);
        return $this->dynamic_facet_spec;
    }

    public function hasDynamicFacetSpec()
    {
        @trigger_error('dynamic_facet_spec is deprecated.', E_USER_DEPRECATED);
        return isset($this->dynamic_facet_spec);
    }

    public function clearDynamicFacetSpec()
    {
        @trigger_error('dynamic_facet_spec is deprecated.', E_USER_DEPRECATED);
        unset($this->dynamic_facet_spec);
    }

    /**
     * Deprecated. Refer to https://cloud.google.com/retail/docs/configs#dynamic
     * to enable dynamic facets. Do not set this field.
     * The specification for dynamically generated facets. Notice that only
     * textual facets can be dynamically generated.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.DynamicFacetSpec dynamic_facet_spec = 21 [deprecated = true];</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec $var
     * @return $this
     * @deprecated
     */
    public function setDynamicFacetSpec($var)
    {
        @trigger_error('dynamic_facet_spec is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\DynamicFacetSpec::class);
        $this->dynamic_facet_spec = $var;

        return $this;
    }

    /**
     * Boost specification to boost certain products. See more details at this
     * [user guide](https://cloud.google.com/retail/docs/boosting).
     * Notice that if both [ServingConfig.boost_control_ids][] and
     * [SearchRequest.boost_spec] are set, the boost conditions from both places
     * are evaluated. If a search request matches multiple boost conditions,
     * the final boost score is equal to the sum of the boost scores from all
     * matched boost conditions.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.BoostSpec boost_spec = 13;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\BoostSpec|null
     */
    public function getBoostSpec()
    {
        return $this->boost_spec;
    }

    public function hasBoostSpec()
    {
        return isset($this->boost_spec);
    }

    public function clearBoostSpec()
    {
        unset($this->boost_spec);
    }

    /**
     * Boost specification to boost certain products. See more details at this
     * [user guide](https://cloud.google.com/retail/docs/boosting).
     * Notice that if both [ServingConfig.boost_control_ids][] and
     * [SearchRequest.boost_spec] are set, the boost conditions from both places
     * are evaluated. If a search request matches multiple boost conditions,
     * the final boost score is equal to the sum of the boost scores from all
     * matched boost conditions.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.BoostSpec boost_spec = 13;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\BoostSpec $var
     * @return $this
     */
    public function setBoostSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\BoostSpec::class);
        $this->boost_spec = $var;

        return $this;
    }

    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion will occur. See more details at this [user
     * guide](https://cloud.google.com/retail/docs/result-size#query_expansion).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\QueryExpansionSpec|null
     */
    public function getQueryExpansionSpec()
    {
        return $this->query_expansion_spec;
    }

    public function hasQueryExpansionSpec()
    {
        return isset($this->query_expansion_spec);
    }

    public function clearQueryExpansionSpec()
    {
        unset($this->query_expansion_spec);
    }

    /**
     * The query expansion specification that specifies the conditions under which
     * query expansion will occur. See more details at this [user
     * guide](https://cloud.google.com/retail/docs/result-size#query_expansion).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.QueryExpansionSpec query_expansion_spec = 14;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\QueryExpansionSpec $var
     * @return $this
     */
    public function setQueryExpansionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\QueryExpansionSpec::class);
        $this->query_expansion_spec = $var;

        return $this;
    }

    /**
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s attributes. The
     * attributes from all the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s are merged and
     * de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     * Supported keys are:
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.inventories.attributes][] map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-5".
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string variant_rollup_keys = 17;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVariantRollupKeys()
    {
        return $this->variant_rollup_keys;
    }

    /**
     * The keys to fetch and rollup the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s attributes,
     * [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo] or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s attributes. The
     * attributes from all the matching
     * [variant][google.cloud.retail.v2.Product.Type.VARIANT]
     * [Product][google.cloud.retail.v2.Product]s or
     * [LocalInventory][google.cloud.retail.v2.LocalInventory]s are merged and
     * de-duplicated. Notice that rollup attributes will lead to extra query
     * latency. Maximum number of keys is 30.
     * For [FulfillmentInfo][google.cloud.retail.v2.FulfillmentInfo], a
     * fulfillment type and a fulfillment ID must be provided in the format of
     * "fulfillmentType.fulfillmentId". E.g., in "pickupInStore.store123",
     * "pickupInStore" is fulfillment type and "store123" is the store ID.
     * Supported keys are:
     * * colorFamilies
     * * price
     * * originalPrice
     * * discount
     * * variantId
     * * inventory(place_id,price)
     * * inventory(place_id,original_price)
     * * inventory(place_id,attributes.key), where key is any key in the
     *   [Product.inventories.attributes][] map.
     * * attributes.key, where key is any key in the
     *   [Product.attributes][google.cloud.retail.v2.Product.attributes] map.
     * * pickupInStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "pickup-in-store".
     * * shipToStore.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "ship-to-store".
     * * sameDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "same-day-delivery".
     * * nextDayDelivery.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "next-day-delivery".
     * * customFulfillment1.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-1".
     * * customFulfillment2.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-2".
     * * customFulfillment3.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-3".
     * * customFulfillment4.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-4".
     * * customFulfillment5.id, where id is any
     * [FulfillmentInfo.place_ids][google.cloud.retail.v2.FulfillmentInfo.place_ids]
     * for [FulfillmentInfo.type][google.cloud.retail.v2.FulfillmentInfo.type]
     *   "custom-type-5".
     * If this field is set to an invalid value other than these, an
     * INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string variant_rollup_keys = 17;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVariantRollupKeys($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->variant_rollup_keys = $arr;

        return $this;
    }

    /**
     * The categories associated with a category page. Required for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *
     * Generated from protobuf field <code>repeated string page_categories = 23;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPageCategories()
    {
        return $this->page_categories;
    }

    /**
     * The categories associated with a category page. Required for category
     * navigation queries to achieve good search quality. The format should be
     * the same as
     * [UserEvent.page_categories][google.cloud.retail.v2.UserEvent.page_categories];
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *
     * Generated from protobuf field <code>repeated string page_categories = 23;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPageCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->page_categories = $arr;

        return $this;
    }

    /**
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.SearchMode search_mode = 31;</code>
     * @return int
     */
    public function getSearchMode()
    {
        return $this->search_mode;
    }

    /**
     * The search mode of the search request. If not specified, a single search
     * request triggers both product search and faceted search.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.SearchMode search_mode = 31;</code>
     * @param int $var
     * @return $this
     */
    public function setSearchMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\SearchRequest\SearchMode::class);
        $this->search_mode = $var;

        return $this;
    }

    /**
     * The specification for personalization.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 32;</code>
     * @return \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec|null
     */
    public function getPersonalizationSpec()
    {
        return $this->personalization_spec;
    }

    public function hasPersonalizationSpec()
    {
        return isset($this->personalization_spec);
    }

    public function clearPersonalizationSpec()
    {
        unset($this->personalization_spec);
    }

    /**
     * The specification for personalization.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.SearchRequest.PersonalizationSpec personalization_spec = 32;</code>
     * @param \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec $var
     * @return $this
     */
    public function setPersonalizationSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\SearchRequest\PersonalizationSpec::class);
        $this->personalization_spec = $var;

        return $this;
    }

}

