<?php
/*
 * Copyright 2016 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/logging/v2/logging_config.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Logging\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;

use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Logging\V2\CmekSettings;
use Google\Cloud\Logging\V2\CopyLogEntriesRequest;
use Google\Cloud\Logging\V2\CreateBucketRequest;
use Google\Cloud\Logging\V2\CreateExclusionRequest;
use Google\Cloud\Logging\V2\CreateSinkRequest;
use Google\Cloud\Logging\V2\CreateViewRequest;
use Google\Cloud\Logging\V2\DeleteBucketRequest;
use Google\Cloud\Logging\V2\DeleteExclusionRequest;
use Google\Cloud\Logging\V2\DeleteSinkRequest;
use Google\Cloud\Logging\V2\DeleteViewRequest;
use Google\Cloud\Logging\V2\GetBucketRequest;
use Google\Cloud\Logging\V2\GetCmekSettingsRequest;
use Google\Cloud\Logging\V2\GetExclusionRequest;
use Google\Cloud\Logging\V2\GetSettingsRequest;
use Google\Cloud\Logging\V2\GetSinkRequest;
use Google\Cloud\Logging\V2\GetViewRequest;
use Google\Cloud\Logging\V2\ListBucketsRequest;
use Google\Cloud\Logging\V2\ListBucketsResponse;
use Google\Cloud\Logging\V2\ListExclusionsRequest;
use Google\Cloud\Logging\V2\ListExclusionsResponse;
use Google\Cloud\Logging\V2\ListSinksRequest;
use Google\Cloud\Logging\V2\ListSinksResponse;
use Google\Cloud\Logging\V2\ListViewsRequest;
use Google\Cloud\Logging\V2\ListViewsResponse;
use Google\Cloud\Logging\V2\LogBucket;
use Google\Cloud\Logging\V2\LogExclusion;
use Google\Cloud\Logging\V2\LogSink;
use Google\Cloud\Logging\V2\LogView;
use Google\Cloud\Logging\V2\Settings;
use Google\Cloud\Logging\V2\UndeleteBucketRequest;
use Google\Cloud\Logging\V2\UpdateBucketRequest;
use Google\Cloud\Logging\V2\UpdateCmekSettingsRequest;
use Google\Cloud\Logging\V2\UpdateExclusionRequest;
use Google\Cloud\Logging\V2\UpdateSettingsRequest;
use Google\Cloud\Logging\V2\UpdateSinkRequest;
use Google\Cloud\Logging\V2\UpdateViewRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Service for configuring sinks used to route log entries.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $configServiceV2Client = new ConfigServiceV2Client();
 * try {
 *     $name = 'name';
 *     $destination = 'destination';
 *     $operationResponse = $configServiceV2Client->copyLogEntries($name, $destination);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $configServiceV2Client->copyLogEntries($name, $destination);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $configServiceV2Client->resumeOperation($operationName, 'copyLogEntries');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $configServiceV2Client->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class ConfigServiceV2GapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.logging.v2.ConfigServiceV2';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'logging.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
        'https://www.googleapis.com/auth/logging.admin',
        'https://www.googleapis.com/auth/logging.read',
    ];

    private static $billingAccountNameTemplate;

    private static $billingAccountCmekSettingsNameTemplate;

    private static $billingAccountExclusionNameTemplate;

    private static $billingAccountLocationNameTemplate;

    private static $billingAccountLocationBucketNameTemplate;

    private static $billingAccountLocationBucketViewNameTemplate;

    private static $billingAccountSettingsNameTemplate;

    private static $billingAccountSinkNameTemplate;

    private static $cmekSettingsNameTemplate;

    private static $folderNameTemplate;

    private static $folderCmekSettingsNameTemplate;

    private static $folderExclusionNameTemplate;

    private static $folderLocationNameTemplate;

    private static $folderLocationBucketNameTemplate;

    private static $folderLocationBucketViewNameTemplate;

    private static $folderSettingsNameTemplate;

    private static $folderSinkNameTemplate;

    private static $locationNameTemplate;

    private static $logBucketNameTemplate;

    private static $logExclusionNameTemplate;

    private static $logSinkNameTemplate;

    private static $logViewNameTemplate;

    private static $organizationNameTemplate;

    private static $organizationCmekSettingsNameTemplate;

    private static $organizationExclusionNameTemplate;

    private static $organizationLocationNameTemplate;

    private static $organizationLocationBucketNameTemplate;

    private static $organizationLocationBucketViewNameTemplate;

    private static $organizationSettingsNameTemplate;

    private static $organizationSinkNameTemplate;

    private static $projectNameTemplate;

    private static $projectCmekSettingsNameTemplate;

    private static $projectExclusionNameTemplate;

    private static $projectLocationBucketNameTemplate;

    private static $projectLocationBucketViewNameTemplate;

    private static $projectSettingsNameTemplate;

    private static $projectSinkNameTemplate;

    private static $settingsNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/config_service_v2_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/config_service_v2_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/config_service_v2_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/config_service_v2_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getBillingAccountNameTemplate()
    {
        if (self::$billingAccountNameTemplate == null) {
            self::$billingAccountNameTemplate = new PathTemplate('billingAccounts/{billing_account}');
        }

        return self::$billingAccountNameTemplate;
    }

    private static function getBillingAccountCmekSettingsNameTemplate()
    {
        if (self::$billingAccountCmekSettingsNameTemplate == null) {
            self::$billingAccountCmekSettingsNameTemplate = new PathTemplate('billingAccounts/{billing_account}/cmekSettings');
        }

        return self::$billingAccountCmekSettingsNameTemplate;
    }

    private static function getBillingAccountExclusionNameTemplate()
    {
        if (self::$billingAccountExclusionNameTemplate == null) {
            self::$billingAccountExclusionNameTemplate = new PathTemplate('billingAccounts/{billing_account}/exclusions/{exclusion}');
        }

        return self::$billingAccountExclusionNameTemplate;
    }

    private static function getBillingAccountLocationNameTemplate()
    {
        if (self::$billingAccountLocationNameTemplate == null) {
            self::$billingAccountLocationNameTemplate = new PathTemplate('billingAccounts/{billing_account}/locations/{location}');
        }

        return self::$billingAccountLocationNameTemplate;
    }

    private static function getBillingAccountLocationBucketNameTemplate()
    {
        if (self::$billingAccountLocationBucketNameTemplate == null) {
            self::$billingAccountLocationBucketNameTemplate = new PathTemplate('billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}');
        }

        return self::$billingAccountLocationBucketNameTemplate;
    }

    private static function getBillingAccountLocationBucketViewNameTemplate()
    {
        if (self::$billingAccountLocationBucketViewNameTemplate == null) {
            self::$billingAccountLocationBucketViewNameTemplate = new PathTemplate('billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}/views/{view}');
        }

        return self::$billingAccountLocationBucketViewNameTemplate;
    }

    private static function getBillingAccountSettingsNameTemplate()
    {
        if (self::$billingAccountSettingsNameTemplate == null) {
            self::$billingAccountSettingsNameTemplate = new PathTemplate('billingAccounts/{billing_account}/settings');
        }

        return self::$billingAccountSettingsNameTemplate;
    }

    private static function getBillingAccountSinkNameTemplate()
    {
        if (self::$billingAccountSinkNameTemplate == null) {
            self::$billingAccountSinkNameTemplate = new PathTemplate('billingAccounts/{billing_account}/sinks/{sink}');
        }

        return self::$billingAccountSinkNameTemplate;
    }

    private static function getCmekSettingsNameTemplate()
    {
        if (self::$cmekSettingsNameTemplate == null) {
            self::$cmekSettingsNameTemplate = new PathTemplate('projects/{project}/cmekSettings');
        }

        return self::$cmekSettingsNameTemplate;
    }

    private static function getFolderNameTemplate()
    {
        if (self::$folderNameTemplate == null) {
            self::$folderNameTemplate = new PathTemplate('folders/{folder}');
        }

        return self::$folderNameTemplate;
    }

    private static function getFolderCmekSettingsNameTemplate()
    {
        if (self::$folderCmekSettingsNameTemplate == null) {
            self::$folderCmekSettingsNameTemplate = new PathTemplate('folders/{folder}/cmekSettings');
        }

        return self::$folderCmekSettingsNameTemplate;
    }

    private static function getFolderExclusionNameTemplate()
    {
        if (self::$folderExclusionNameTemplate == null) {
            self::$folderExclusionNameTemplate = new PathTemplate('folders/{folder}/exclusions/{exclusion}');
        }

        return self::$folderExclusionNameTemplate;
    }

    private static function getFolderLocationNameTemplate()
    {
        if (self::$folderLocationNameTemplate == null) {
            self::$folderLocationNameTemplate = new PathTemplate('folders/{folder}/locations/{location}');
        }

        return self::$folderLocationNameTemplate;
    }

    private static function getFolderLocationBucketNameTemplate()
    {
        if (self::$folderLocationBucketNameTemplate == null) {
            self::$folderLocationBucketNameTemplate = new PathTemplate('folders/{folder}/locations/{location}/buckets/{bucket}');
        }

        return self::$folderLocationBucketNameTemplate;
    }

    private static function getFolderLocationBucketViewNameTemplate()
    {
        if (self::$folderLocationBucketViewNameTemplate == null) {
            self::$folderLocationBucketViewNameTemplate = new PathTemplate('folders/{folder}/locations/{location}/buckets/{bucket}/views/{view}');
        }

        return self::$folderLocationBucketViewNameTemplate;
    }

    private static function getFolderSettingsNameTemplate()
    {
        if (self::$folderSettingsNameTemplate == null) {
            self::$folderSettingsNameTemplate = new PathTemplate('folders/{folder}/settings');
        }

        return self::$folderSettingsNameTemplate;
    }

    private static function getFolderSinkNameTemplate()
    {
        if (self::$folderSinkNameTemplate == null) {
            self::$folderSinkNameTemplate = new PathTemplate('folders/{folder}/sinks/{sink}');
        }

        return self::$folderSinkNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getLogBucketNameTemplate()
    {
        if (self::$logBucketNameTemplate == null) {
            self::$logBucketNameTemplate = new PathTemplate('projects/{project}/locations/{location}/buckets/{bucket}');
        }

        return self::$logBucketNameTemplate;
    }

    private static function getLogExclusionNameTemplate()
    {
        if (self::$logExclusionNameTemplate == null) {
            self::$logExclusionNameTemplate = new PathTemplate('projects/{project}/exclusions/{exclusion}');
        }

        return self::$logExclusionNameTemplate;
    }

    private static function getLogSinkNameTemplate()
    {
        if (self::$logSinkNameTemplate == null) {
            self::$logSinkNameTemplate = new PathTemplate('projects/{project}/sinks/{sink}');
        }

        return self::$logSinkNameTemplate;
    }

    private static function getLogViewNameTemplate()
    {
        if (self::$logViewNameTemplate == null) {
            self::$logViewNameTemplate = new PathTemplate('projects/{project}/locations/{location}/buckets/{bucket}/views/{view}');
        }

        return self::$logViewNameTemplate;
    }

    private static function getOrganizationNameTemplate()
    {
        if (self::$organizationNameTemplate == null) {
            self::$organizationNameTemplate = new PathTemplate('organizations/{organization}');
        }

        return self::$organizationNameTemplate;
    }

    private static function getOrganizationCmekSettingsNameTemplate()
    {
        if (self::$organizationCmekSettingsNameTemplate == null) {
            self::$organizationCmekSettingsNameTemplate = new PathTemplate('organizations/{organization}/cmekSettings');
        }

        return self::$organizationCmekSettingsNameTemplate;
    }

    private static function getOrganizationExclusionNameTemplate()
    {
        if (self::$organizationExclusionNameTemplate == null) {
            self::$organizationExclusionNameTemplate = new PathTemplate('organizations/{organization}/exclusions/{exclusion}');
        }

        return self::$organizationExclusionNameTemplate;
    }

    private static function getOrganizationLocationNameTemplate()
    {
        if (self::$organizationLocationNameTemplate == null) {
            self::$organizationLocationNameTemplate = new PathTemplate('organizations/{organization}/locations/{location}');
        }

        return self::$organizationLocationNameTemplate;
    }

    private static function getOrganizationLocationBucketNameTemplate()
    {
        if (self::$organizationLocationBucketNameTemplate == null) {
            self::$organizationLocationBucketNameTemplate = new PathTemplate('organizations/{organization}/locations/{location}/buckets/{bucket}');
        }

        return self::$organizationLocationBucketNameTemplate;
    }

    private static function getOrganizationLocationBucketViewNameTemplate()
    {
        if (self::$organizationLocationBucketViewNameTemplate == null) {
            self::$organizationLocationBucketViewNameTemplate = new PathTemplate('organizations/{organization}/locations/{location}/buckets/{bucket}/views/{view}');
        }

        return self::$organizationLocationBucketViewNameTemplate;
    }

    private static function getOrganizationSettingsNameTemplate()
    {
        if (self::$organizationSettingsNameTemplate == null) {
            self::$organizationSettingsNameTemplate = new PathTemplate('organizations/{organization}/settings');
        }

        return self::$organizationSettingsNameTemplate;
    }

    private static function getOrganizationSinkNameTemplate()
    {
        if (self::$organizationSinkNameTemplate == null) {
            self::$organizationSinkNameTemplate = new PathTemplate('organizations/{organization}/sinks/{sink}');
        }

        return self::$organizationSinkNameTemplate;
    }

    private static function getProjectNameTemplate()
    {
        if (self::$projectNameTemplate == null) {
            self::$projectNameTemplate = new PathTemplate('projects/{project}');
        }

        return self::$projectNameTemplate;
    }

    private static function getProjectCmekSettingsNameTemplate()
    {
        if (self::$projectCmekSettingsNameTemplate == null) {
            self::$projectCmekSettingsNameTemplate = new PathTemplate('projects/{project}/cmekSettings');
        }

        return self::$projectCmekSettingsNameTemplate;
    }

    private static function getProjectExclusionNameTemplate()
    {
        if (self::$projectExclusionNameTemplate == null) {
            self::$projectExclusionNameTemplate = new PathTemplate('projects/{project}/exclusions/{exclusion}');
        }

        return self::$projectExclusionNameTemplate;
    }

    private static function getProjectLocationBucketNameTemplate()
    {
        if (self::$projectLocationBucketNameTemplate == null) {
            self::$projectLocationBucketNameTemplate = new PathTemplate('projects/{project}/locations/{location}/buckets/{bucket}');
        }

        return self::$projectLocationBucketNameTemplate;
    }

    private static function getProjectLocationBucketViewNameTemplate()
    {
        if (self::$projectLocationBucketViewNameTemplate == null) {
            self::$projectLocationBucketViewNameTemplate = new PathTemplate('projects/{project}/locations/{location}/buckets/{bucket}/views/{view}');
        }

        return self::$projectLocationBucketViewNameTemplate;
    }

    private static function getProjectSettingsNameTemplate()
    {
        if (self::$projectSettingsNameTemplate == null) {
            self::$projectSettingsNameTemplate = new PathTemplate('projects/{project}/settings');
        }

        return self::$projectSettingsNameTemplate;
    }

    private static function getProjectSinkNameTemplate()
    {
        if (self::$projectSinkNameTemplate == null) {
            self::$projectSinkNameTemplate = new PathTemplate('projects/{project}/sinks/{sink}');
        }

        return self::$projectSinkNameTemplate;
    }

    private static function getSettingsNameTemplate()
    {
        if (self::$settingsNameTemplate == null) {
            self::$settingsNameTemplate = new PathTemplate('projects/{project}/settings');
        }

        return self::$settingsNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'billingAccount' => self::getBillingAccountNameTemplate(),
                'billingAccountCmekSettings' => self::getBillingAccountCmekSettingsNameTemplate(),
                'billingAccountExclusion' => self::getBillingAccountExclusionNameTemplate(),
                'billingAccountLocation' => self::getBillingAccountLocationNameTemplate(),
                'billingAccountLocationBucket' => self::getBillingAccountLocationBucketNameTemplate(),
                'billingAccountLocationBucketView' => self::getBillingAccountLocationBucketViewNameTemplate(),
                'billingAccountSettings' => self::getBillingAccountSettingsNameTemplate(),
                'billingAccountSink' => self::getBillingAccountSinkNameTemplate(),
                'cmekSettings' => self::getCmekSettingsNameTemplate(),
                'folder' => self::getFolderNameTemplate(),
                'folderCmekSettings' => self::getFolderCmekSettingsNameTemplate(),
                'folderExclusion' => self::getFolderExclusionNameTemplate(),
                'folderLocation' => self::getFolderLocationNameTemplate(),
                'folderLocationBucket' => self::getFolderLocationBucketNameTemplate(),
                'folderLocationBucketView' => self::getFolderLocationBucketViewNameTemplate(),
                'folderSettings' => self::getFolderSettingsNameTemplate(),
                'folderSink' => self::getFolderSinkNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'logBucket' => self::getLogBucketNameTemplate(),
                'logExclusion' => self::getLogExclusionNameTemplate(),
                'logSink' => self::getLogSinkNameTemplate(),
                'logView' => self::getLogViewNameTemplate(),
                'organization' => self::getOrganizationNameTemplate(),
                'organizationCmekSettings' => self::getOrganizationCmekSettingsNameTemplate(),
                'organizationExclusion' => self::getOrganizationExclusionNameTemplate(),
                'organizationLocation' => self::getOrganizationLocationNameTemplate(),
                'organizationLocationBucket' => self::getOrganizationLocationBucketNameTemplate(),
                'organizationLocationBucketView' => self::getOrganizationLocationBucketViewNameTemplate(),
                'organizationSettings' => self::getOrganizationSettingsNameTemplate(),
                'organizationSink' => self::getOrganizationSinkNameTemplate(),
                'project' => self::getProjectNameTemplate(),
                'projectCmekSettings' => self::getProjectCmekSettingsNameTemplate(),
                'projectExclusion' => self::getProjectExclusionNameTemplate(),
                'projectLocationBucket' => self::getProjectLocationBucketNameTemplate(),
                'projectLocationBucketView' => self::getProjectLocationBucketViewNameTemplate(),
                'projectSettings' => self::getProjectSettingsNameTemplate(),
                'projectSink' => self::getProjectSinkNameTemplate(),
                'settings' => self::getSettingsNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account resource.
     *
     * @param string $billingAccount
     *
     * @return string The formatted billing_account resource.
     */
    public static function billingAccountName($billingAccount)
    {
        return self::getBillingAccountNameTemplate()->render([
            'billing_account' => $billingAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_cmekSettings resource.
     *
     * @param string $billingAccount
     *
     * @return string The formatted billing_account_cmekSettings resource.
     */
    public static function billingAccountCmekSettingsName($billingAccount)
    {
        return self::getBillingAccountCmekSettingsNameTemplate()->render([
            'billing_account' => $billingAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_exclusion resource.
     *
     * @param string $billingAccount
     * @param string $exclusion
     *
     * @return string The formatted billing_account_exclusion resource.
     */
    public static function billingAccountExclusionName($billingAccount, $exclusion)
    {
        return self::getBillingAccountExclusionNameTemplate()->render([
            'billing_account' => $billingAccount,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location resource.
     *
     * @param string $billingAccount
     * @param string $location
     *
     * @return string The formatted billing_account_location resource.
     */
    public static function billingAccountLocationName($billingAccount, $location)
    {
        return self::getBillingAccountLocationNameTemplate()->render([
            'billing_account' => $billingAccount,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_bucket resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted billing_account_location_bucket resource.
     */
    public static function billingAccountLocationBucketName($billingAccount, $location, $bucket)
    {
        return self::getBillingAccountLocationBucketNameTemplate()->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_location_bucket_view resource.
     *
     * @param string $billingAccount
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted billing_account_location_bucket_view resource.
     */
    public static function billingAccountLocationBucketViewName($billingAccount, $location, $bucket, $view)
    {
        return self::getBillingAccountLocationBucketViewNameTemplate()->render([
            'billing_account' => $billingAccount,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_settings resource.
     *
     * @param string $billingAccount
     *
     * @return string The formatted billing_account_settings resource.
     */
    public static function billingAccountSettingsName($billingAccount)
    {
        return self::getBillingAccountSettingsNameTemplate()->render([
            'billing_account' => $billingAccount,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * billing_account_sink resource.
     *
     * @param string $billingAccount
     * @param string $sink
     *
     * @return string The formatted billing_account_sink resource.
     */
    public static function billingAccountSinkName($billingAccount, $sink)
    {
        return self::getBillingAccountSinkNameTemplate()->render([
            'billing_account' => $billingAccount,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * cmek_settings resource.
     *
     * @param string $project
     *
     * @return string The formatted cmek_settings resource.
     */
    public static function cmekSettingsName($project)
    {
        return self::getCmekSettingsNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName($folder)
    {
        return self::getFolderNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_cmekSettings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_cmekSettings resource.
     */
    public static function folderCmekSettingsName($folder)
    {
        return self::getFolderCmekSettingsNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_exclusion resource.
     *
     * @param string $folder
     * @param string $exclusion
     *
     * @return string The formatted folder_exclusion resource.
     */
    public static function folderExclusionName($folder, $exclusion)
    {
        return self::getFolderExclusionNameTemplate()->render([
            'folder' => $folder,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName($folder, $location)
    {
        return self::getFolderLocationNameTemplate()->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_bucket resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted folder_location_bucket resource.
     */
    public static function folderLocationBucketName($folder, $location, $bucket)
    {
        return self::getFolderLocationBucketNameTemplate()->render([
            'folder' => $folder,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_bucket_view resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted folder_location_bucket_view resource.
     */
    public static function folderLocationBucketViewName($folder, $location, $bucket, $view)
    {
        return self::getFolderLocationBucketViewNameTemplate()->render([
            'folder' => $folder,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_settings resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder_settings resource.
     */
    public static function folderSettingsName($folder)
    {
        return self::getFolderSettingsNameTemplate()->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder_sink
     * resource.
     *
     * @param string $folder
     * @param string $sink
     *
     * @return string The formatted folder_sink resource.
     */
    public static function folderSinkName($folder, $sink)
    {
        return self::getFolderSinkNameTemplate()->render([
            'folder' => $folder,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a log_bucket
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted log_bucket resource.
     */
    public static function logBucketName($project, $location, $bucket)
    {
        return self::getLogBucketNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * log_exclusion resource.
     *
     * @param string $project
     * @param string $exclusion
     *
     * @return string The formatted log_exclusion resource.
     */
    public static function logExclusionName($project, $exclusion)
    {
        return self::getLogExclusionNameTemplate()->render([
            'project' => $project,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a log_sink
     * resource.
     *
     * @param string $project
     * @param string $sink
     *
     * @return string The formatted log_sink resource.
     */
    public static function logSinkName($project, $sink)
    {
        return self::getLogSinkNameTemplate()->render([
            'project' => $project,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a log_view
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted log_view resource.
     */
    public static function logViewName($project, $location, $bucket, $view)
    {
        return self::getLogViewNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName($organization)
    {
        return self::getOrganizationNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_cmekSettings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_cmekSettings resource.
     */
    public static function organizationCmekSettingsName($organization)
    {
        return self::getOrganizationCmekSettingsNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_exclusion resource.
     *
     * @param string $organization
     * @param string $exclusion
     *
     * @return string The formatted organization_exclusion resource.
     */
    public static function organizationExclusionName($organization, $exclusion)
    {
        return self::getOrganizationExclusionNameTemplate()->render([
            'organization' => $organization,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName($organization, $location)
    {
        return self::getOrganizationLocationNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_bucket resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted organization_location_bucket resource.
     */
    public static function organizationLocationBucketName($organization, $location, $bucket)
    {
        return self::getOrganizationLocationBucketNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_bucket_view resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted organization_location_bucket_view resource.
     */
    public static function organizationLocationBucketViewName($organization, $location, $bucket, $view)
    {
        return self::getOrganizationLocationBucketViewNameTemplate()->render([
            'organization' => $organization,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_settings resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization_settings resource.
     */
    public static function organizationSettingsName($organization)
    {
        return self::getOrganizationSettingsNameTemplate()->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_sink resource.
     *
     * @param string $organization
     * @param string $sink
     *
     * @return string The formatted organization_sink resource.
     */
    public static function organizationSinkName($organization, $sink)
    {
        return self::getOrganizationSinkNameTemplate()->render([
            'organization' => $organization,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName($project)
    {
        return self::getProjectNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_cmekSettings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_cmekSettings resource.
     */
    public static function projectCmekSettingsName($project)
    {
        return self::getProjectCmekSettingsNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_exclusion resource.
     *
     * @param string $project
     * @param string $exclusion
     *
     * @return string The formatted project_exclusion resource.
     */
    public static function projectExclusionName($project, $exclusion)
    {
        return self::getProjectExclusionNameTemplate()->render([
            'project' => $project,
            'exclusion' => $exclusion,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_bucket resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     *
     * @return string The formatted project_location_bucket resource.
     */
    public static function projectLocationBucketName($project, $location, $bucket)
    {
        return self::getProjectLocationBucketNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_bucket_view resource.
     *
     * @param string $project
     * @param string $location
     * @param string $bucket
     * @param string $view
     *
     * @return string The formatted project_location_bucket_view resource.
     */
    public static function projectLocationBucketViewName($project, $location, $bucket, $view)
    {
        return self::getProjectLocationBucketViewNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'bucket' => $bucket,
            'view' => $view,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_settings resource.
     *
     * @param string $project
     *
     * @return string The formatted project_settings resource.
     */
    public static function projectSettingsName($project)
    {
        return self::getProjectSettingsNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project_sink
     * resource.
     *
     * @param string $project
     * @param string $sink
     *
     * @return string The formatted project_sink resource.
     */
    public static function projectSinkName($project, $sink)
    {
        return self::getProjectSinkNameTemplate()->render([
            'project' => $project,
            'sink' => $sink,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a settings
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted settings resource.
     */
    public static function settingsName($project)
    {
        return self::getSettingsNameTemplate()->render([
            'project' => $project,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - billingAccount: billingAccounts/{billing_account}
     * - billingAccountCmekSettings: billingAccounts/{billing_account}/cmekSettings
     * - billingAccountExclusion: billingAccounts/{billing_account}/exclusions/{exclusion}
     * - billingAccountLocation: billingAccounts/{billing_account}/locations/{location}
     * - billingAccountLocationBucket: billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}
     * - billingAccountLocationBucketView: billingAccounts/{billing_account}/locations/{location}/buckets/{bucket}/views/{view}
     * - billingAccountSettings: billingAccounts/{billing_account}/settings
     * - billingAccountSink: billingAccounts/{billing_account}/sinks/{sink}
     * - cmekSettings: projects/{project}/cmekSettings
     * - folder: folders/{folder}
     * - folderCmekSettings: folders/{folder}/cmekSettings
     * - folderExclusion: folders/{folder}/exclusions/{exclusion}
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationBucket: folders/{folder}/locations/{location}/buckets/{bucket}
     * - folderLocationBucketView: folders/{folder}/locations/{location}/buckets/{bucket}/views/{view}
     * - folderSettings: folders/{folder}/settings
     * - folderSink: folders/{folder}/sinks/{sink}
     * - location: projects/{project}/locations/{location}
     * - logBucket: projects/{project}/locations/{location}/buckets/{bucket}
     * - logExclusion: projects/{project}/exclusions/{exclusion}
     * - logSink: projects/{project}/sinks/{sink}
     * - logView: projects/{project}/locations/{location}/buckets/{bucket}/views/{view}
     * - organization: organizations/{organization}
     * - organizationCmekSettings: organizations/{organization}/cmekSettings
     * - organizationExclusion: organizations/{organization}/exclusions/{exclusion}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationBucket: organizations/{organization}/locations/{location}/buckets/{bucket}
     * - organizationLocationBucketView: organizations/{organization}/locations/{location}/buckets/{bucket}/views/{view}
     * - organizationSettings: organizations/{organization}/settings
     * - organizationSink: organizations/{organization}/sinks/{sink}
     * - project: projects/{project}
     * - projectCmekSettings: projects/{project}/cmekSettings
     * - projectExclusion: projects/{project}/exclusions/{exclusion}
     * - projectLocationBucket: projects/{project}/locations/{location}/buckets/{bucket}
     * - projectLocationBucketView: projects/{project}/locations/{location}/buckets/{bucket}/views/{view}
     * - projectSettings: projects/{project}/settings
     * - projectSink: projects/{project}/sinks/{sink}
     * - settings: projects/{project}/settings
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'logging.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Copies a set of log entries from a log bucket to a Cloud Storage bucket.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $name = 'name';
     *     $destination = 'destination';
     *     $operationResponse = $configServiceV2Client->copyLogEntries($name, $destination);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $configServiceV2Client->copyLogEntries($name, $destination);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $configServiceV2Client->resumeOperation($operationName, 'copyLogEntries');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. Log bucket from which to copy log entries.
     *
     *                             For example:
     *
     *                             `"projects/my-project/locations/global/buckets/my-source-bucket"`
     * @param string $destination  Required. Destination to which to copy log entries.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $filter
     *           Optional. A filter specifying which log entries to copy. The filter must be no more
     *           than 20k characters. An empty filter matches all log entries.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function copyLogEntries($name, $destination, array $optionalArgs = [])
    {
        $request = new CopyLogEntriesRequest();
        $request->setName($name);
        $request->setDestination($destination);
        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        return $this->startOperationsCall('CopyLogEntries', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates a log bucket that can be used to store log entries. After a bucket
     * has been created, the bucket's location cannot be changed.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedParent = $configServiceV2Client->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     $bucketId = 'bucket_id';
     *     $bucket = new LogBucket();
     *     $response = $configServiceV2Client->createBucket($formattedParent, $bucketId, $bucket);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string    $parent       Required. The resource in which to create the log bucket:
     *
     *                                "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
     *
     *                                For example:
     *
     *                                `"projects/my-project/locations/global"`
     * @param string    $bucketId     Required. A client-assigned identifier such as `"my-bucket"`. Identifiers are limited
     *                                to 100 characters and can include only letters, digits, underscores,
     *                                hyphens, and periods.
     * @param LogBucket $bucket       Required. The new bucket. The region specified in the new bucket must be compliant
     *                                with any Location Restriction Org Policy. The name field in the bucket is
     *                                ignored.
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogBucket
     *
     * @throws ApiException if the remote call fails
     */
    public function createBucket($parent, $bucketId, $bucket, array $optionalArgs = [])
    {
        $request = new CreateBucketRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setBucketId($bucketId);
        $request->setBucket($bucket);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateBucket', LogBucket::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a new exclusion in the _Default sink in a specified parent
     * resource. Only log entries belonging to that resource can be excluded. You
     * can have up to 10 exclusions in a resource.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedParent = $configServiceV2Client->projectName('[PROJECT]');
     *     $exclusion = new LogExclusion();
     *     $response = $configServiceV2Client->createExclusion($formattedParent, $exclusion);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string       $parent       Required. The parent resource in which to create the exclusion:
     *
     *                                   "projects/[PROJECT_ID]"
     *                                   "organizations/[ORGANIZATION_ID]"
     *                                   "billingAccounts/[BILLING_ACCOUNT_ID]"
     *                                   "folders/[FOLDER_ID]"
     *
     *                                   For examples:
     *
     *                                   `"projects/my-logging-project"`
     *                                   `"organizations/123456789"`
     * @param LogExclusion $exclusion    Required. The new exclusion, whose `name` parameter is an exclusion name
     *                                   that is not already used in the parent resource.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogExclusion
     *
     * @throws ApiException if the remote call fails
     */
    public function createExclusion($parent, $exclusion, array $optionalArgs = [])
    {
        $request = new CreateExclusionRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setExclusion($exclusion);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateExclusion', LogExclusion::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a sink that exports specified log entries to a destination. The
     * export of newly-ingested log entries begins immediately, unless the sink's
     * `writer_identity` is not permitted to write to the destination. A sink can
     * export log entries only from the resource owning the sink.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedParent = $configServiceV2Client->projectName('[PROJECT]');
     *     $sink = new LogSink();
     *     $response = $configServiceV2Client->createSink($formattedParent, $sink);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The resource in which to create the sink:
     *
     *                              "projects/[PROJECT_ID]"
     *                              "organizations/[ORGANIZATION_ID]"
     *                              "billingAccounts/[BILLING_ACCOUNT_ID]"
     *                              "folders/[FOLDER_ID]"
     *
     *                              For examples:
     *
     *                              `"projects/my-project"`
     *                              `"organizations/123456789"`
     * @param LogSink $sink         Required. The new sink, whose `name` parameter is a sink identifier that
     *                              is not already in use.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type bool $uniqueWriterIdentity
     *           Optional. Determines the kind of IAM identity returned as `writer_identity`
     *           in the new sink. If this value is omitted or set to false, and if the
     *           sink's parent is a project, then the value returned as `writer_identity` is
     *           the same group or service account used by Cloud Logging before the addition
     *           of writer identities to this API. The sink's destination must be in the
     *           same project as the sink itself.
     *
     *           If this field is set to true, or if the sink is owned by a non-project
     *           resource such as an organization, then the value of `writer_identity` will
     *           be a unique service account used only for exports from the new sink. For
     *           more information, see `writer_identity` in [LogSink][google.logging.v2.LogSink].
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogSink
     *
     * @throws ApiException if the remote call fails
     */
    public function createSink($parent, $sink, array $optionalArgs = [])
    {
        $request = new CreateSinkRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSink($sink);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['uniqueWriterIdentity'])) {
            $request->setUniqueWriterIdentity($optionalArgs['uniqueWriterIdentity']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateSink', LogSink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a view over log entries in a log bucket. A bucket may contain a
     * maximum of 30 views.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $parent = 'parent';
     *     $viewId = 'view_id';
     *     $view = new LogView();
     *     $response = $configServiceV2Client->createView($parent, $viewId, $view);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string  $parent       Required. The bucket in which to create the view
     *
     *                              `"projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"`
     *
     *                              For example:
     *
     *                              `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param string  $viewId       Required. The id to use for this view.
     * @param LogView $view         Required. The new view.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogView
     *
     * @throws ApiException if the remote call fails
     */
    public function createView($parent, $viewId, $view, array $optionalArgs = [])
    {
        $request = new CreateViewRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setViewId($viewId);
        $request->setView($view);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateView', LogView::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a log bucket.
     *
     * Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
     * After 7 days, the bucket will be purged and all log entries in the bucket
     * will be permanently deleted.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logBucketName('[PROJECT]', '[LOCATION]', '[BUCKET]');
     *     $configServiceV2Client->deleteBucket($formattedName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. The full resource name of the bucket to delete.
     *
     *                             "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteBucket($name, array $optionalArgs = [])
    {
        $request = new DeleteBucketRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteBucket', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes an exclusion in the _Default sink.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logExclusionName('[PROJECT]', '[EXCLUSION]');
     *     $configServiceV2Client->deleteExclusion($formattedName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of an existing exclusion to delete:
     *
     *                             "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
     *                             "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
     *                             "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/exclusions/my-exclusion"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteExclusion($name, array $optionalArgs = [])
    {
        $request = new DeleteExclusionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteExclusion', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a sink. If the sink has a unique `writer_identity`, then that
     * service account is also deleted.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedSinkName = $configServiceV2Client->logSinkName('[PROJECT]', '[SINK]');
     *     $configServiceV2Client->deleteSink($formattedSinkName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $sinkName     Required. The full resource name of the sink to delete, including the parent
     *                             resource and the sink identifier:
     *
     *                             "projects/[PROJECT_ID]/sinks/[SINK_ID]"
     *                             "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
     *                             "folders/[FOLDER_ID]/sinks/[SINK_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/sinks/my-sink"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSink($sinkName, array $optionalArgs = [])
    {
        $request = new DeleteSinkRequest();
        $requestParamHeaders = [];
        $request->setSinkName($sinkName);
        $requestParamHeaders['sink_name'] = $sinkName;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteSink', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a view on a log bucket.
     * If an `UNAVAILABLE` error is returned, this indicates that system is not in
     * a state where it can delete the view. If this occurs, please try again in a
     * few minutes.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logViewName('[PROJECT]', '[LOCATION]', '[BUCKET]', '[VIEW]');
     *     $configServiceV2Client->deleteView($formattedName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. The full resource name of the view to delete:
     *
     *                             "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteView($name, array $optionalArgs = [])
    {
        $request = new DeleteViewRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteView', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a log bucket.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logBucketName('[PROJECT]', '[LOCATION]', '[BUCKET]');
     *     $response = $configServiceV2Client->getBucket($formattedName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the bucket:
     *
     *                             "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogBucket
     *
     * @throws ApiException if the remote call fails
     */
    public function getBucket($name, array $optionalArgs = [])
    {
        $request = new GetBucketRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetBucket', LogBucket::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the Logging CMEK settings for the given resource.
     *
     * Note: CMEK for the Log Router can be configured for Google Cloud projects,
     * folders, organizations and billing accounts. Once configured for an
     * organization, it applies to all projects and folders in the Google Cloud
     * organization.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $response = $configServiceV2Client->getCmekSettings();
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Required. The resource for which to retrieve CMEK settings.
     *
     *           "projects/[PROJECT_ID]/cmekSettings"
     *           "organizations/[ORGANIZATION_ID]/cmekSettings"
     *           "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
     *           "folders/[FOLDER_ID]/cmekSettings"
     *
     *           For example:
     *
     *           `"organizations/12345/cmekSettings"`
     *
     *           Note: CMEK for the Log Router can be configured for Google Cloud projects,
     *           folders, organizations and billing accounts. Once configured for an
     *           organization, it applies to all projects and folders in the Google Cloud
     *           organization.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\CmekSettings
     *
     * @throws ApiException if the remote call fails
     */
    public function getCmekSettings(array $optionalArgs = [])
    {
        $request = new GetCmekSettingsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetCmekSettings', CmekSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the description of an exclusion in the _Default sink.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logExclusionName('[PROJECT]', '[EXCLUSION]');
     *     $response = $configServiceV2Client->getExclusion($formattedName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of an existing exclusion:
     *
     *                             "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
     *                             "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
     *                             "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/exclusions/my-exclusion"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogExclusion
     *
     * @throws ApiException if the remote call fails
     */
    public function getExclusion($name, array $optionalArgs = [])
    {
        $request = new GetExclusionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetExclusion', LogExclusion::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the Log Router settings for the given resource.
     *
     * Note: Settings for the Log Router can be get for Google Cloud projects,
     * folders, organizations and billing accounts. Currently it can only be
     * configured for organizations. Once configured for an organization, it
     * applies to all projects and folders in the Google Cloud organization.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->settingsName('[PROJECT]');
     *     $response = $configServiceV2Client->getSettings($formattedName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource for which to retrieve settings.
     *
     *                             "projects/[PROJECT_ID]/settings"
     *                             "organizations/[ORGANIZATION_ID]/settings"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/settings"
     *                             "folders/[FOLDER_ID]/settings"
     *
     *                             For example:
     *
     *                             `"organizations/12345/settings"`
     *
     *                             Note: Settings for the Log Router can be get for Google Cloud projects,
     *                             folders, organizations and billing accounts. Currently it can only be
     *                             configured for organizations. Once configured for an organization, it
     *                             applies to all projects and folders in the Google Cloud organization.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\Settings
     *
     * @throws ApiException if the remote call fails
     */
    public function getSettings($name, array $optionalArgs = [])
    {
        $request = new GetSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSettings', Settings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a sink.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedSinkName = $configServiceV2Client->logSinkName('[PROJECT]', '[SINK]');
     *     $response = $configServiceV2Client->getSink($formattedSinkName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $sinkName     Required. The resource name of the sink:
     *
     *                             "projects/[PROJECT_ID]/sinks/[SINK_ID]"
     *                             "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
     *                             "folders/[FOLDER_ID]/sinks/[SINK_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/sinks/my-sink"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogSink
     *
     * @throws ApiException if the remote call fails
     */
    public function getSink($sinkName, array $optionalArgs = [])
    {
        $request = new GetSinkRequest();
        $requestParamHeaders = [];
        $request->setSinkName($sinkName);
        $requestParamHeaders['sink_name'] = $sinkName;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetSink', LogSink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a view on a log bucket..
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logViewName('[PROJECT]', '[LOCATION]', '[BUCKET]', '[VIEW]');
     *     $response = $configServiceV2Client->getView($formattedName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. The resource name of the policy:
     *
     *                             "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogView
     *
     * @throws ApiException if the remote call fails
     */
    public function getView($name, array $optionalArgs = [])
    {
        $request = new GetViewRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetView', LogView::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists log buckets.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedParent = $configServiceV2Client->organizationLocationName('[ORGANIZATION]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $configServiceV2Client->listBuckets($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $configServiceV2Client->listBuckets($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource whose buckets are to be listed:
     *
     *                             "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
     *                             "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
     *                             "folders/[FOLDER_ID]/locations/[LOCATION_ID]"
     *
     *                             Note: The locations portion of the resource must be specified, but
     *                             supplying the character `-` in place of [LOCATION_ID] will return all
     *                             buckets.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listBuckets($parent, array $optionalArgs = [])
    {
        $request = new ListBucketsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListBuckets', $optionalArgs, ListBucketsResponse::class, $request);
    }

    /**
     * Lists all the exclusions on the _Default sink in a parent resource.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedParent = $configServiceV2Client->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $configServiceV2Client->listExclusions($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $configServiceV2Client->listExclusions($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource whose exclusions are to be listed.
     *
     *                             "projects/[PROJECT_ID]"
     *                             "organizations/[ORGANIZATION_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]"
     *                             "folders/[FOLDER_ID]"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listExclusions($parent, array $optionalArgs = [])
    {
        $request = new ListExclusionsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListExclusions', $optionalArgs, ListExclusionsResponse::class, $request);
    }

    /**
     * Lists sinks.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedParent = $configServiceV2Client->projectName('[PROJECT]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $configServiceV2Client->listSinks($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $configServiceV2Client->listSinks($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource whose sinks are to be listed:
     *
     *                             "projects/[PROJECT_ID]"
     *                             "organizations/[ORGANIZATION_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]"
     *                             "folders/[FOLDER_ID]"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSinks($parent, array $optionalArgs = [])
    {
        $request = new ListSinksRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListSinks', $optionalArgs, ListSinksResponse::class, $request);
    }

    /**
     * Lists views on a log bucket.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $configServiceV2Client->listViews($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $configServiceV2Client->listViews($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $parent       Required. The bucket whose views are to be listed:
     *
     *                             "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listViews($parent, array $optionalArgs = [])
    {
        $request = new ListViewsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListViews', $optionalArgs, ListViewsResponse::class, $request);
    }

    /**
     * Undeletes a log bucket. A bucket that has been deleted can be undeleted
     * within the grace period of 7 days.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logBucketName('[PROJECT]', '[LOCATION]', '[BUCKET]');
     *     $configServiceV2Client->undeleteBucket($formattedName);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string $name         Required. The full resource name of the bucket to undelete.
     *
     *                             "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                             "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *
     *                             For example:
     *
     *                             `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function undeleteBucket($name, array $optionalArgs = [])
    {
        $request = new UndeleteBucketRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UndeleteBucket', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a log bucket. This method replaces the following fields in the
     * existing bucket with values from the new bucket: `retention_period`
     *
     * If the retention period is decreased and the bucket is locked,
     * `FAILED_PRECONDITION` will be returned.
     *
     * If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
     * `FAILED_PRECONDITION` will be returned.
     *
     * After a bucket has been created, the bucket's location cannot be changed.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logBucketName('[PROJECT]', '[LOCATION]', '[BUCKET]');
     *     $bucket = new LogBucket();
     *     $updateMask = new FieldMask();
     *     $response = $configServiceV2Client->updateBucket($formattedName, $bucket, $updateMask);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string    $name         Required. The full resource name of the bucket to update.
     *
     *                                "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                                "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                                "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *                                "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *
     *                                For example:
     *
     *                                `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param LogBucket $bucket       Required. The updated bucket.
     * @param FieldMask $updateMask   Required. Field mask that specifies the fields in `bucket` that need an update. A
     *                                bucket field will be overwritten if, and only if, it is in the update mask.
     *                                `name` and output only fields cannot be updated.
     *
     *                                For a detailed `FieldMask` definition, see:
     *                                https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
     *
     *                                For example: `updateMask=retention_days`
     * @param array     $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogBucket
     *
     * @throws ApiException if the remote call fails
     */
    public function updateBucket($name, $bucket, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateBucketRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setBucket($bucket);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateBucket', LogBucket::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the Log Router CMEK settings for the given resource.
     *
     * Note: CMEK for the Log Router can currently only be configured for Google
     * Cloud organizations. Once configured, it applies to all projects and
     * folders in the Google Cloud organization.
     *
     * [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
     * will fail if 1) `kms_key_name` is invalid, or 2) the associated service
     * account does not have the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
     * 3) access to the key is disabled.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $response = $configServiceV2Client->updateCmekSettings();
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Required. The resource name for the CMEK settings to update.
     *
     *           "projects/[PROJECT_ID]/cmekSettings"
     *           "organizations/[ORGANIZATION_ID]/cmekSettings"
     *           "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
     *           "folders/[FOLDER_ID]/cmekSettings"
     *
     *           For example:
     *
     *           `"organizations/12345/cmekSettings"`
     *
     *           Note: CMEK for the Log Router can currently only be configured for Google
     *           Cloud organizations. Once configured, it applies to all projects and
     *           folders in the Google Cloud organization.
     *     @type CmekSettings $cmekSettings
     *           Required. The CMEK settings to update.
     *
     *           See [Enabling CMEK for Log
     *           Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     *           for more information.
     *     @type FieldMask $updateMask
     *           Optional. Field mask identifying which fields from `cmek_settings` should
     *           be updated. A field will be overwritten if and only if it is in the update
     *           mask. Output only fields cannot be updated.
     *
     *           See [FieldMask][google.protobuf.FieldMask] for more information.
     *
     *           For example: `"updateMask=kmsKeyName"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\CmekSettings
     *
     * @throws ApiException if the remote call fails
     */
    public function updateCmekSettings(array $optionalArgs = [])
    {
        $request = new UpdateCmekSettingsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['cmekSettings'])) {
            $request->setCmekSettings($optionalArgs['cmekSettings']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateCmekSettings', CmekSettings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Changes one or more properties of an existing exclusion in the _Default
     * sink.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedName = $configServiceV2Client->logExclusionName('[PROJECT]', '[EXCLUSION]');
     *     $exclusion = new LogExclusion();
     *     $updateMask = new FieldMask();
     *     $response = $configServiceV2Client->updateExclusion($formattedName, $exclusion, $updateMask);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string       $name         Required. The resource name of the exclusion to update:
     *
     *                                   "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
     *                                   "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
     *                                   "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
     *                                   "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
     *
     *                                   For example:
     *
     *                                   `"projects/my-project/exclusions/my-exclusion"`
     * @param LogExclusion $exclusion    Required. New values for the existing exclusion. Only the fields specified in
     *                                   `update_mask` are relevant.
     * @param FieldMask    $updateMask   Required. A non-empty list of fields to change in the existing exclusion. New values
     *                                   for the fields are taken from the corresponding fields in the
     *                                   [LogExclusion][google.logging.v2.LogExclusion] included in this request. Fields not mentioned in
     *                                   `update_mask` are not changed and are ignored in the request.
     *
     *                                   For example, to change the filter and description of an exclusion,
     *                                   specify an `update_mask` of `"filter,description"`.
     * @param array        $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogExclusion
     *
     * @throws ApiException if the remote call fails
     */
    public function updateExclusion($name, $exclusion, $updateMask, array $optionalArgs = [])
    {
        $request = new UpdateExclusionRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setExclusion($exclusion);
        $request->setUpdateMask($updateMask);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateExclusion', LogExclusion::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates the Log Router settings for the given resource.
     *
     * Note: Settings for the Log Router can currently only be configured for
     * Google Cloud organizations. Once configured, it applies to all projects and
     * folders in the Google Cloud organization.
     *
     * [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
     * will fail if 1) `kms_key_name` is invalid, or 2) the associated service
     * account does not have the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
     * 3) access to the key is disabled. 4) `location_id` is not supported by
     * Logging. 5) `location_id` violate OrgPolicy.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $name = 'name';
     *     $settings = new Settings();
     *     $response = $configServiceV2Client->updateSettings($name, $settings);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string   $name         Required. The resource name for the settings to update.
     *
     *                               "organizations/[ORGANIZATION_ID]/settings"
     *
     *                               For example:
     *
     *                               `"organizations/12345/settings"`
     *
     *                               Note: Settings for the Log Router can currently only be configured for
     *                               Google Cloud organizations. Once configured, it applies to all projects and
     *                               folders in the Google Cloud organization.
     * @param Settings $settings     Required. The settings to update.
     *
     *                               See [Enabling CMEK for Log
     *                               Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     *                               for more information.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask identifying which fields from `settings` should
     *           be updated. A field will be overwritten if and only if it is in the update
     *           mask. Output only fields cannot be updated.
     *
     *           See [FieldMask][google.protobuf.FieldMask] for more information.
     *
     *           For example: `"updateMask=kmsKeyName"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\Settings
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSettings($name, $settings, array $optionalArgs = [])
    {
        $request = new UpdateSettingsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setSettings($settings);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSettings', Settings::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a sink. This method replaces the following fields in the existing
     * sink with values from the new sink: `destination`, and `filter`.
     *
     * The updated sink might also have a new `writer_identity`; see the
     * `unique_writer_identity` field.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $formattedSinkName = $configServiceV2Client->logSinkName('[PROJECT]', '[SINK]');
     *     $sink = new LogSink();
     *     $response = $configServiceV2Client->updateSink($formattedSinkName, $sink);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string  $sinkName     Required. The full resource name of the sink to update, including the parent
     *                              resource and the sink identifier:
     *
     *                              "projects/[PROJECT_ID]/sinks/[SINK_ID]"
     *                              "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
     *                              "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
     *                              "folders/[FOLDER_ID]/sinks/[SINK_ID]"
     *
     *                              For example:
     *
     *                              `"projects/my-project/sinks/my-sink"`
     * @param LogSink $sink         Required. The updated sink, whose name is the same identifier that appears as part
     *                              of `sink_name`.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type bool $uniqueWriterIdentity
     *           Optional. See [sinks.create][google.logging.v2.ConfigServiceV2.CreateSink]
     *           for a description of this field. When updating a sink, the effect of this
     *           field on the value of `writer_identity` in the updated sink depends on both
     *           the old and new values of this field:
     *
     *           +   If the old and new values of this field are both false or both true,
     *           then there is no change to the sink's `writer_identity`.
     *           +   If the old value is false and the new value is true, then
     *           `writer_identity` is changed to a unique service account.
     *           +   It is an error if the old value is true and the new value is
     *           set to false or defaulted to false.
     *     @type FieldMask $updateMask
     *           Optional. Field mask that specifies the fields in `sink` that need
     *           an update. A sink field will be overwritten if, and only if, it is
     *           in the update mask. `name` and output only fields cannot be updated.
     *
     *           An empty `updateMask` is temporarily treated as using the following mask
     *           for backwards compatibility purposes:
     *
     *           `destination,filter,includeChildren`
     *
     *           At some point in the future, behavior will be removed and specifying an
     *           empty `updateMask` will be an error.
     *
     *           For a detailed `FieldMask` definition, see
     *           https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
     *
     *           For example: `updateMask=filter`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogSink
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSink($sinkName, $sink, array $optionalArgs = [])
    {
        $request = new UpdateSinkRequest();
        $requestParamHeaders = [];
        $request->setSinkName($sinkName);
        $request->setSink($sink);
        $requestParamHeaders['sink_name'] = $sinkName;
        if (isset($optionalArgs['uniqueWriterIdentity'])) {
            $request->setUniqueWriterIdentity($optionalArgs['uniqueWriterIdentity']);
        }

        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateSink', LogSink::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a view on a log bucket. This method replaces the following fields
     * in the existing view with values from the new view: `filter`.
     * If an `UNAVAILABLE` error is returned, this indicates that system is not in
     * a state where it can update the view. If this occurs, please try again in a
     * few minutes.
     *
     * Sample code:
     * ```
     * $configServiceV2Client = new ConfigServiceV2Client();
     * try {
     *     $name = 'name';
     *     $view = new LogView();
     *     $response = $configServiceV2Client->updateView($name, $view);
     * } finally {
     *     $configServiceV2Client->close();
     * }
     * ```
     *
     * @param string  $name         Required. The full resource name of the view to update
     *
     *                              "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
     *
     *                              For example:
     *
     *                              `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
     * @param LogView $view         Required. The updated view.
     * @param array   $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Field mask that specifies the fields in `view` that need
     *           an update. A field will be overwritten if, and only if, it is
     *           in the update mask. `name` and output only fields cannot be updated.
     *
     *           For a detailed `FieldMask` definition, see
     *           https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
     *
     *           For example: `updateMask=filter`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Logging\V2\LogView
     *
     * @throws ApiException if the remote call fails
     */
    public function updateView($name, $view, array $optionalArgs = [])
    {
        $request = new UpdateViewRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setView($view);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateView', LogView::class, $optionalArgs, $request)->wait();
    }
}
