# Google Cloud Storage Insights for PHP

> Idiomatic PHP client for [Google Cloud Storage Insights](https://cloud.google.com/storage/docs/insights/inventory-reports).

[![Latest Stable Version](https://poser.pugx.org/google/cloud-storageinsights/v/stable)](https://packagist.org/packages/google/cloud-storageinsights) [![Packagist](https://img.shields.io/packagist/dm/google/cloud-storageinsights.svg)](https://packagist.org/packages/google/cloud-storageinsights)

* [API documentation](https://cloud.google.com/php/docs/reference/cloud-storageinsights/latest)

**NOTE:** This repository is part of [Google Cloud PHP](https://github.com/googleapis/google-cloud-php). Any
support requests, bug reports, or development contributions should be directed to
that project.

### Installation

To begin, install the preferred dependency manager for PHP, [Composer](https://getcomposer.org/).

Now, install this component:

```sh
$ composer require google/cloud-storageinsights
```

> Browse the complete list of [Google Cloud APIs](https://cloud.google.com/php/docs/reference)
> for PHP

This component supports both REST over HTTP/1.1 and gRPC. In order to take advantage of the benefits
offered by gRPC (such as streaming methods) please see our
[gRPC installation guide](https://cloud.google.com/php/grpc).

### Authentication

Please see our [Authentication guide](https://github.com/googleapis/google-cloud-php/blob/main/AUTHENTICATION.md) for more information
on authenticating your client. Once authenticated, you'll be ready to start making requests.

### Sample

```php
Google\ApiCore\ApiException;
Google\Cloud\Location\GetLocationRequest;
Google\Cloud\Location\Location;
Google\Cloud\StorageInsights\V1\Client\StorageInsightsClient;

// Create a client.
$storageInsightsClient = new StorageInsightsClient();

// Prepare the request message.
$request = new GetLocationRequest();

// Call the API and handle any network failures.
try {
    /** @var Location $response */
    $response = $storageInsightsClient->getLocation($request);
    printf('Response data: %s' . PHP_EOL, $response->serializeToJsonString());
} catch (ApiException $ex) {
    printf('Call failed with message: %s' . PHP_EOL, $ex->getMessage());
}
```

See the [samples directory](samples/) for a canonical list of samples.

### Debugging

Please see our [Debugging guide](https://github.com/googleapis/google-cloud-php/blob/main/DEBUG.md)
for more information about the debugging tools.

### Version

This component is considered GA (generally available). As such, it will not introduce backwards-incompatible changes in
any minor or patch releases. We will address issues and requests with the highest priority.

### Next Steps

1. Understand the [official documentation](https://cloud.google.com/php/docs/reference/cloud-storageinsights/latest).
