<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1beta/tax_rule.proto

namespace Google\Shopping\Merchant\Accounts\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Primary type convension
 * percent micro : 100% = 1 000 000 and 1% = 10 000
 *                 cannot be negative.
 * Information about tax nexus and related parameters applicable to orders
 * delivered to the area covered by a single tax admin. Nexus is created when a
 * merchant is doing business in an area administered by tax admin (only US
 * states are supported for nexus configuration). If merchant has nexus in a US
 * state, merchant needs to pay tax to all tax authorities associated with
 * the shipping destination.
 * Next Id : 8
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1beta.TaxRule</code>
 */
class TaxRule extends \Google\Protobuf\Internal\Message
{
    /**
     * Region code in which this rule is applicable
     *
     * Generated from protobuf field <code>string region_code = 1;</code>
     */
    protected $region_code = '';
    /**
     * If set, shipping charge is taxed (at the same rate as product) when
     * delivering to this admin's area.
     * Can only be set on US states without category.
     *
     * Generated from protobuf field <code>bool shipping_taxed = 6;</code>
     */
    protected $shipping_taxed = false;
    /**
     * Required. Time period when this rule is effective. If the duration is
     * missing from effective_time listed, then it is open ended to the future.
     * The start of this time period is inclusive, and the end is exclusive.
     *
     * Generated from protobuf field <code>.google.type.Interval effective_time_period = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $effective_time_period = null;
    protected $location;
    protected $rate_calculation;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $location_id
     *           The admin_id or criteria_id of the region in which this rule is
     *           applicable.
     *     @type \Google\Shopping\Merchant\Accounts\V1beta\TaxRule\TaxPostalCodeRange $post_code_range
     *           The range of postal codes in which this rule is applicable.
     *     @type bool $use_google_rate
     *           Rate that depends on delivery location: if merchant has a nexus in
     *           corresponding US state, rates from authorities with jurisdiction over
     *           delivery area are added up.
     *     @type int|string $self_specified_rate_micros
     *           A fixed rate specified in micros, where 100% = 1_000_000.
     *           Suitable for origin-based states.
     *     @type string $region_code
     *           Region code in which this rule is applicable
     *     @type bool $shipping_taxed
     *           If set, shipping charge is taxed (at the same rate as product) when
     *           delivering to this admin's area.
     *           Can only be set on US states without category.
     *     @type \Google\Type\Interval $effective_time_period
     *           Required. Time period when this rule is effective. If the duration is
     *           missing from effective_time listed, then it is open ended to the future.
     *           The start of this time period is inclusive, and the end is exclusive.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1Beta\TaxRule::initOnce();
        parent::__construct($data);
    }

    /**
     * The admin_id or criteria_id of the region in which this rule is
     * applicable.
     *
     * Generated from protobuf field <code>int64 location_id = 2;</code>
     * @return int|string
     */
    public function getLocationId()
    {
        return $this->readOneof(2);
    }

    public function hasLocationId()
    {
        return $this->hasOneof(2);
    }

    /**
     * The admin_id or criteria_id of the region in which this rule is
     * applicable.
     *
     * Generated from protobuf field <code>int64 location_id = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setLocationId($var)
    {
        GPBUtil::checkInt64($var);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The range of postal codes in which this rule is applicable.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1beta.TaxRule.TaxPostalCodeRange post_code_range = 3;</code>
     * @return \Google\Shopping\Merchant\Accounts\V1beta\TaxRule\TaxPostalCodeRange|null
     */
    public function getPostCodeRange()
    {
        return $this->readOneof(3);
    }

    public function hasPostCodeRange()
    {
        return $this->hasOneof(3);
    }

    /**
     * The range of postal codes in which this rule is applicable.
     *
     * Generated from protobuf field <code>.google.shopping.merchant.accounts.v1beta.TaxRule.TaxPostalCodeRange post_code_range = 3;</code>
     * @param \Google\Shopping\Merchant\Accounts\V1beta\TaxRule\TaxPostalCodeRange $var
     * @return $this
     */
    public function setPostCodeRange($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Merchant\Accounts\V1beta\TaxRule\TaxPostalCodeRange::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Rate that depends on delivery location: if merchant has a nexus in
     * corresponding US state, rates from authorities with jurisdiction over
     * delivery area are added up.
     *
     * Generated from protobuf field <code>bool use_google_rate = 4;</code>
     * @return bool
     */
    public function getUseGoogleRate()
    {
        return $this->readOneof(4);
    }

    public function hasUseGoogleRate()
    {
        return $this->hasOneof(4);
    }

    /**
     * Rate that depends on delivery location: if merchant has a nexus in
     * corresponding US state, rates from authorities with jurisdiction over
     * delivery area are added up.
     *
     * Generated from protobuf field <code>bool use_google_rate = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseGoogleRate($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * A fixed rate specified in micros, where 100% = 1_000_000.
     * Suitable for origin-based states.
     *
     * Generated from protobuf field <code>int64 self_specified_rate_micros = 5;</code>
     * @return int|string
     */
    public function getSelfSpecifiedRateMicros()
    {
        return $this->readOneof(5);
    }

    public function hasSelfSpecifiedRateMicros()
    {
        return $this->hasOneof(5);
    }

    /**
     * A fixed rate specified in micros, where 100% = 1_000_000.
     * Suitable for origin-based states.
     *
     * Generated from protobuf field <code>int64 self_specified_rate_micros = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSelfSpecifiedRateMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Region code in which this rule is applicable
     *
     * Generated from protobuf field <code>string region_code = 1;</code>
     * @return string
     */
    public function getRegionCode()
    {
        return $this->region_code;
    }

    /**
     * Region code in which this rule is applicable
     *
     * Generated from protobuf field <code>string region_code = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setRegionCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->region_code = $var;

        return $this;
    }

    /**
     * If set, shipping charge is taxed (at the same rate as product) when
     * delivering to this admin's area.
     * Can only be set on US states without category.
     *
     * Generated from protobuf field <code>bool shipping_taxed = 6;</code>
     * @return bool
     */
    public function getShippingTaxed()
    {
        return $this->shipping_taxed;
    }

    /**
     * If set, shipping charge is taxed (at the same rate as product) when
     * delivering to this admin's area.
     * Can only be set on US states without category.
     *
     * Generated from protobuf field <code>bool shipping_taxed = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setShippingTaxed($var)
    {
        GPBUtil::checkBool($var);
        $this->shipping_taxed = $var;

        return $this;
    }

    /**
     * Required. Time period when this rule is effective. If the duration is
     * missing from effective_time listed, then it is open ended to the future.
     * The start of this time period is inclusive, and the end is exclusive.
     *
     * Generated from protobuf field <code>.google.type.Interval effective_time_period = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Type\Interval|null
     */
    public function getEffectiveTimePeriod()
    {
        return $this->effective_time_period;
    }

    public function hasEffectiveTimePeriod()
    {
        return isset($this->effective_time_period);
    }

    public function clearEffectiveTimePeriod()
    {
        unset($this->effective_time_period);
    }

    /**
     * Required. Time period when this rule is effective. If the duration is
     * missing from effective_time listed, then it is open ended to the future.
     * The start of this time period is inclusive, and the end is exclusive.
     *
     * Generated from protobuf field <code>.google.type.Interval effective_time_period = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Type\Interval $var
     * @return $this
     */
    public function setEffectiveTimePeriod($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\Interval::class);
        $this->effective_time_period = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getLocation()
    {
        return $this->whichOneof("location");
    }

    /**
     * @return string
     */
    public function getRateCalculation()
    {
        return $this->whichOneof("rate_calculation");
    }

}

