<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: grafeas/v1/provenance.proto

namespace Grafeas\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Provenance of a build. Contains all information needed to verify the full
 * details about the build from source to completion.
 *
 * Generated from protobuf message <code>grafeas.v1.BuildProvenance</code>
 */
class BuildProvenance extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Unique identifier of the build.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     */
    protected $id = '';
    /**
     * ID of the project.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     */
    protected $project_id = '';
    /**
     * Commands requested by the build.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Command commands = 3;</code>
     */
    private $commands;
    /**
     * Output of the build.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Artifact built_artifacts = 4;</code>
     */
    private $built_artifacts;
    /**
     * Time at which the build was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    protected $create_time = null;
    /**
     * Time at which execution of the build was started.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 6;</code>
     */
    protected $start_time = null;
    /**
     * Time at which execution of the build was finished.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 7;</code>
     */
    protected $end_time = null;
    /**
     * E-mail address of the user who initiated this build. Note that this was the
     * user's e-mail address at the time the build was initiated; this address may
     * not represent the same end-user for all time.
     *
     * Generated from protobuf field <code>string creator = 8;</code>
     */
    protected $creator = '';
    /**
     * URI where any logs for this provenance were written.
     *
     * Generated from protobuf field <code>string logs_uri = 9;</code>
     */
    protected $logs_uri = '';
    /**
     * Details of the Source input to the build.
     *
     * Generated from protobuf field <code>.grafeas.v1.Source source_provenance = 10;</code>
     */
    protected $source_provenance = null;
    /**
     * Trigger identifier if the build was triggered automatically; empty if not.
     *
     * Generated from protobuf field <code>string trigger_id = 11;</code>
     */
    protected $trigger_id = '';
    /**
     * Special options applied to this build. This is a catch-all field where
     * build providers can enter any desired additional details.
     *
     * Generated from protobuf field <code>map<string, string> build_options = 12;</code>
     */
    private $build_options;
    /**
     * Version string of the builder at the time this build was executed.
     *
     * Generated from protobuf field <code>string builder_version = 13;</code>
     */
    protected $builder_version = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           Required. Unique identifier of the build.
     *     @type string $project_id
     *           ID of the project.
     *     @type array<\Grafeas\V1\Command>|\Google\Protobuf\Internal\RepeatedField $commands
     *           Commands requested by the build.
     *     @type array<\Grafeas\V1\Artifact>|\Google\Protobuf\Internal\RepeatedField $built_artifacts
     *           Output of the build.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Time at which the build was created.
     *     @type \Google\Protobuf\Timestamp $start_time
     *           Time at which execution of the build was started.
     *     @type \Google\Protobuf\Timestamp $end_time
     *           Time at which execution of the build was finished.
     *     @type string $creator
     *           E-mail address of the user who initiated this build. Note that this was the
     *           user's e-mail address at the time the build was initiated; this address may
     *           not represent the same end-user for all time.
     *     @type string $logs_uri
     *           URI where any logs for this provenance were written.
     *     @type \Grafeas\V1\Source $source_provenance
     *           Details of the Source input to the build.
     *     @type string $trigger_id
     *           Trigger identifier if the build was triggered automatically; empty if not.
     *     @type array|\Google\Protobuf\Internal\MapField $build_options
     *           Special options applied to this build. This is a catch-all field where
     *           build providers can enter any desired additional details.
     *     @type string $builder_version
     *           Version string of the builder at the time this build was executed.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Grafeas\V1\Provenance::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Unique identifier of the build.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Required. Unique identifier of the build.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * ID of the project.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     * @return string
     */
    public function getProjectId()
    {
        return $this->project_id;
    }

    /**
     * ID of the project.
     *
     * Generated from protobuf field <code>string project_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setProjectId($var)
    {
        GPBUtil::checkString($var, True);
        $this->project_id = $var;

        return $this;
    }

    /**
     * Commands requested by the build.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Command commands = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCommands()
    {
        return $this->commands;
    }

    /**
     * Commands requested by the build.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Command commands = 3;</code>
     * @param array<\Grafeas\V1\Command>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCommands($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Grafeas\V1\Command::class);
        $this->commands = $arr;

        return $this;
    }

    /**
     * Output of the build.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Artifact built_artifacts = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBuiltArtifacts()
    {
        return $this->built_artifacts;
    }

    /**
     * Output of the build.
     *
     * Generated from protobuf field <code>repeated .grafeas.v1.Artifact built_artifacts = 4;</code>
     * @param array<\Grafeas\V1\Artifact>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBuiltArtifacts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Grafeas\V1\Artifact::class);
        $this->built_artifacts = $arr;

        return $this;
    }

    /**
     * Time at which the build was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Time at which the build was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 5;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Time at which execution of the build was started.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 6;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getStartTime()
    {
        return $this->start_time;
    }

    public function hasStartTime()
    {
        return isset($this->start_time);
    }

    public function clearStartTime()
    {
        unset($this->start_time);
    }

    /**
     * Time at which execution of the build was started.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp start_time = 6;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->start_time = $var;

        return $this;
    }

    /**
     * Time at which execution of the build was finished.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 7;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEndTime()
    {
        return $this->end_time;
    }

    public function hasEndTime()
    {
        return isset($this->end_time);
    }

    public function clearEndTime()
    {
        unset($this->end_time);
    }

    /**
     * Time at which execution of the build was finished.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp end_time = 7;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->end_time = $var;

        return $this;
    }

    /**
     * E-mail address of the user who initiated this build. Note that this was the
     * user's e-mail address at the time the build was initiated; this address may
     * not represent the same end-user for all time.
     *
     * Generated from protobuf field <code>string creator = 8;</code>
     * @return string
     */
    public function getCreator()
    {
        return $this->creator;
    }

    /**
     * E-mail address of the user who initiated this build. Note that this was the
     * user's e-mail address at the time the build was initiated; this address may
     * not represent the same end-user for all time.
     *
     * Generated from protobuf field <code>string creator = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCreator($var)
    {
        GPBUtil::checkString($var, True);
        $this->creator = $var;

        return $this;
    }

    /**
     * URI where any logs for this provenance were written.
     *
     * Generated from protobuf field <code>string logs_uri = 9;</code>
     * @return string
     */
    public function getLogsUri()
    {
        return $this->logs_uri;
    }

    /**
     * URI where any logs for this provenance were written.
     *
     * Generated from protobuf field <code>string logs_uri = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setLogsUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->logs_uri = $var;

        return $this;
    }

    /**
     * Details of the Source input to the build.
     *
     * Generated from protobuf field <code>.grafeas.v1.Source source_provenance = 10;</code>
     * @return \Grafeas\V1\Source|null
     */
    public function getSourceProvenance()
    {
        return $this->source_provenance;
    }

    public function hasSourceProvenance()
    {
        return isset($this->source_provenance);
    }

    public function clearSourceProvenance()
    {
        unset($this->source_provenance);
    }

    /**
     * Details of the Source input to the build.
     *
     * Generated from protobuf field <code>.grafeas.v1.Source source_provenance = 10;</code>
     * @param \Grafeas\V1\Source $var
     * @return $this
     */
    public function setSourceProvenance($var)
    {
        GPBUtil::checkMessage($var, \Grafeas\V1\Source::class);
        $this->source_provenance = $var;

        return $this;
    }

    /**
     * Trigger identifier if the build was triggered automatically; empty if not.
     *
     * Generated from protobuf field <code>string trigger_id = 11;</code>
     * @return string
     */
    public function getTriggerId()
    {
        return $this->trigger_id;
    }

    /**
     * Trigger identifier if the build was triggered automatically; empty if not.
     *
     * Generated from protobuf field <code>string trigger_id = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setTriggerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->trigger_id = $var;

        return $this;
    }

    /**
     * Special options applied to this build. This is a catch-all field where
     * build providers can enter any desired additional details.
     *
     * Generated from protobuf field <code>map<string, string> build_options = 12;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getBuildOptions()
    {
        return $this->build_options;
    }

    /**
     * Special options applied to this build. This is a catch-all field where
     * build providers can enter any desired additional details.
     *
     * Generated from protobuf field <code>map<string, string> build_options = 12;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setBuildOptions($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->build_options = $arr;

        return $this;
    }

    /**
     * Version string of the builder at the time this build was executed.
     *
     * Generated from protobuf field <code>string builder_version = 13;</code>
     * @return string
     */
    public function getBuilderVersion()
    {
        return $this->builder_version;
    }

    /**
     * Version string of the builder at the time this build was executed.
     *
     * Generated from protobuf field <code>string builder_version = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setBuilderVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->builder_version = $var;

        return $this;
    }

}

