<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/dataflow/v1beta3/streaming.proto

namespace Google\Cloud\Dataflow\V1beta3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Location information for a specific key-range of a sharded computation.
 * Currently we only support UTF-8 character splits to simplify encoding into
 * JSON.
 *
 * Generated from protobuf message <code>google.dataflow.v1beta3.KeyRangeLocation</code>
 */
class KeyRangeLocation extends \Google\Protobuf\Internal\Message
{
    /**
     * The start (inclusive) of the key range.
     *
     * Generated from protobuf field <code>string start = 1;</code>
     */
    protected $start = '';
    /**
     * The end (exclusive) of the key range.
     *
     * Generated from protobuf field <code>string end = 2;</code>
     */
    protected $end = '';
    /**
     * The physical location of this range assignment to be used for
     * streaming computation cross-worker message delivery.
     *
     * Generated from protobuf field <code>string delivery_endpoint = 3;</code>
     */
    protected $delivery_endpoint = '';
    /**
     * The name of the data disk where data for this range is stored.
     * This name is local to the Google Cloud Platform project and uniquely
     * identifies the disk within that project, for example
     * "myproject-1014-104817-4c2-harness-0-disk-1".
     *
     * Generated from protobuf field <code>string data_disk = 5;</code>
     */
    protected $data_disk = '';
    /**
     * DEPRECATED. The location of the persistent state for this range, as a
     * persistent directory in the worker local filesystem.
     *
     * Generated from protobuf field <code>string deprecated_persistent_directory = 4 [deprecated = true];</code>
     * @deprecated
     */
    protected $deprecated_persistent_directory = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $start
     *           The start (inclusive) of the key range.
     *     @type string $end
     *           The end (exclusive) of the key range.
     *     @type string $delivery_endpoint
     *           The physical location of this range assignment to be used for
     *           streaming computation cross-worker message delivery.
     *     @type string $data_disk
     *           The name of the data disk where data for this range is stored.
     *           This name is local to the Google Cloud Platform project and uniquely
     *           identifies the disk within that project, for example
     *           "myproject-1014-104817-4c2-harness-0-disk-1".
     *     @type string $deprecated_persistent_directory
     *           DEPRECATED. The location of the persistent state for this range, as a
     *           persistent directory in the worker local filesystem.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Dataflow\V1Beta3\Streaming::initOnce();
        parent::__construct($data);
    }

    /**
     * The start (inclusive) of the key range.
     *
     * Generated from protobuf field <code>string start = 1;</code>
     * @return string
     */
    public function getStart()
    {
        return $this->start;
    }

    /**
     * The start (inclusive) of the key range.
     *
     * Generated from protobuf field <code>string start = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setStart($var)
    {
        GPBUtil::checkString($var, True);
        $this->start = $var;

        return $this;
    }

    /**
     * The end (exclusive) of the key range.
     *
     * Generated from protobuf field <code>string end = 2;</code>
     * @return string
     */
    public function getEnd()
    {
        return $this->end;
    }

    /**
     * The end (exclusive) of the key range.
     *
     * Generated from protobuf field <code>string end = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setEnd($var)
    {
        GPBUtil::checkString($var, True);
        $this->end = $var;

        return $this;
    }

    /**
     * The physical location of this range assignment to be used for
     * streaming computation cross-worker message delivery.
     *
     * Generated from protobuf field <code>string delivery_endpoint = 3;</code>
     * @return string
     */
    public function getDeliveryEndpoint()
    {
        return $this->delivery_endpoint;
    }

    /**
     * The physical location of this range assignment to be used for
     * streaming computation cross-worker message delivery.
     *
     * Generated from protobuf field <code>string delivery_endpoint = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDeliveryEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->delivery_endpoint = $var;

        return $this;
    }

    /**
     * The name of the data disk where data for this range is stored.
     * This name is local to the Google Cloud Platform project and uniquely
     * identifies the disk within that project, for example
     * "myproject-1014-104817-4c2-harness-0-disk-1".
     *
     * Generated from protobuf field <code>string data_disk = 5;</code>
     * @return string
     */
    public function getDataDisk()
    {
        return $this->data_disk;
    }

    /**
     * The name of the data disk where data for this range is stored.
     * This name is local to the Google Cloud Platform project and uniquely
     * identifies the disk within that project, for example
     * "myproject-1014-104817-4c2-harness-0-disk-1".
     *
     * Generated from protobuf field <code>string data_disk = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDataDisk($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_disk = $var;

        return $this;
    }

    /**
     * DEPRECATED. The location of the persistent state for this range, as a
     * persistent directory in the worker local filesystem.
     *
     * Generated from protobuf field <code>string deprecated_persistent_directory = 4 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getDeprecatedPersistentDirectory()
    {
        if ($this->deprecated_persistent_directory !== '') {
            @trigger_error('deprecated_persistent_directory is deprecated.', E_USER_DEPRECATED);
        }
        return $this->deprecated_persistent_directory;
    }

    /**
     * DEPRECATED. The location of the persistent state for this range, as a
     * persistent directory in the worker local filesystem.
     *
     * Generated from protobuf field <code>string deprecated_persistent_directory = 4 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setDeprecatedPersistentDirectory($var)
    {
        @trigger_error('deprecated_persistent_directory is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->deprecated_persistent_directory = $var;

        return $this;
    }

}

