<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1/resources.proto

namespace Google\Cloud\AlloyDb\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * SupportedDatabaseFlag gives general information about a database flag,
 * like type and allowed values. This is a static value that is defined
 * on the server side, and it cannot be modified by callers.
 * To set the Database flags on a particular Instance, a caller should modify
 * the Instance.database_flags field.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1.SupportedDatabaseFlag</code>
 */
class SupportedDatabaseFlag extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the flag resource, following Google Cloud conventions, e.g.:
     *  * projects/{project}/locations/{location}/flags/{flag}
     * This field currently has no semantic meaning.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * The name of the database flag, e.g. "max_allowed_packets".
     * The is a possibly key for the Instance.database_flags map field.
     *
     * Generated from protobuf field <code>string flag_name = 2;</code>
     */
    protected $flag_name = '';
    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.ValueType value_type = 3;</code>
     */
    protected $value_type = 0;
    /**
     * Whether the database flag accepts multiple values. If true,
     * a comma-separated list of stringified values may be specified.
     *
     * Generated from protobuf field <code>bool accepts_multiple_values = 4;</code>
     */
    protected $accepts_multiple_values = false;
    /**
     * Major database engine versions for which this flag is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.DatabaseVersion supported_db_versions = 5;</code>
     */
    private $supported_db_versions;
    /**
     * Whether setting or updating this flag on an Instance requires a database
     * restart. If a flag that requires database restart is set, the backend
     * will automatically restart the database (making sure to satisfy any
     * availability SLO's).
     *
     * Generated from protobuf field <code>bool requires_db_restart = 6;</code>
     */
    protected $requires_db_restart = false;
    /**
     * The scope of the flag.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.Scope scope = 9;</code>
     */
    protected $scope = 0;
    protected $restrictions;
    protected $recommended_value;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\StringRestrictions $string_restrictions
     *           Restriction on STRING type value.
     *     @type \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\IntegerRestrictions $integer_restrictions
     *           Restriction on INTEGER type value.
     *     @type string $recommended_string_value
     *           The recommended value for a STRING flag.
     *     @type \Google\Protobuf\Int64Value $recommended_integer_value
     *           The recommended value for an INTEGER flag.
     *     @type string $name
     *           The name of the flag resource, following Google Cloud conventions, e.g.:
     *            * projects/{project}/locations/{location}/flags/{flag}
     *           This field currently has no semantic meaning.
     *     @type string $flag_name
     *           The name of the database flag, e.g. "max_allowed_packets".
     *           The is a possibly key for the Instance.database_flags map field.
     *     @type int $value_type
     *     @type bool $accepts_multiple_values
     *           Whether the database flag accepts multiple values. If true,
     *           a comma-separated list of stringified values may be specified.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $supported_db_versions
     *           Major database engine versions for which this flag is supported.
     *     @type bool $requires_db_restart
     *           Whether setting or updating this flag on an Instance requires a database
     *           restart. If a flag that requires database restart is set, the backend
     *           will automatically restart the database (making sure to satisfy any
     *           availability SLO's).
     *     @type int $scope
     *           The scope of the flag.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Restriction on STRING type value.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.StringRestrictions string_restrictions = 7;</code>
     * @return \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\StringRestrictions|null
     */
    public function getStringRestrictions()
    {
        return $this->readOneof(7);
    }

    public function hasStringRestrictions()
    {
        return $this->hasOneof(7);
    }

    /**
     * Restriction on STRING type value.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.StringRestrictions string_restrictions = 7;</code>
     * @param \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\StringRestrictions $var
     * @return $this
     */
    public function setStringRestrictions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\StringRestrictions::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * Restriction on INTEGER type value.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.IntegerRestrictions integer_restrictions = 8;</code>
     * @return \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\IntegerRestrictions|null
     */
    public function getIntegerRestrictions()
    {
        return $this->readOneof(8);
    }

    public function hasIntegerRestrictions()
    {
        return $this->hasOneof(8);
    }

    /**
     * Restriction on INTEGER type value.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.IntegerRestrictions integer_restrictions = 8;</code>
     * @param \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\IntegerRestrictions $var
     * @return $this
     */
    public function setIntegerRestrictions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\IntegerRestrictions::class);
        $this->writeOneof(8, $var);

        return $this;
    }

    /**
     * The recommended value for a STRING flag.
     *
     * Generated from protobuf field <code>string recommended_string_value = 10;</code>
     * @return string
     */
    public function getRecommendedStringValue()
    {
        return $this->readOneof(10);
    }

    public function hasRecommendedStringValue()
    {
        return $this->hasOneof(10);
    }

    /**
     * The recommended value for a STRING flag.
     *
     * Generated from protobuf field <code>string recommended_string_value = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setRecommendedStringValue($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(10, $var);

        return $this;
    }

    /**
     * The recommended value for an INTEGER flag.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value recommended_integer_value = 11;</code>
     * @return \Google\Protobuf\Int64Value|null
     */
    public function getRecommendedIntegerValue()
    {
        return $this->readOneof(11);
    }

    public function hasRecommendedIntegerValue()
    {
        return $this->hasOneof(11);
    }

    /**
     * Returns the unboxed value from <code>getRecommendedIntegerValue()</code>

     * The recommended value for an INTEGER flag.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value recommended_integer_value = 11;</code>
     * @return int|string|null
     */
    public function getRecommendedIntegerValueUnwrapped()
    {
        return $this->readWrapperValue("recommended_integer_value");
    }

    /**
     * The recommended value for an INTEGER flag.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value recommended_integer_value = 11;</code>
     * @param \Google\Protobuf\Int64Value $var
     * @return $this
     */
    public function setRecommendedIntegerValue($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int64Value::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int64Value object.

     * The recommended value for an INTEGER flag.
     *
     * Generated from protobuf field <code>.google.protobuf.Int64Value recommended_integer_value = 11;</code>
     * @param int|string|null $var
     * @return $this
     */
    public function setRecommendedIntegerValueUnwrapped($var)
    {
        $this->writeWrapperValue("recommended_integer_value", $var);
        return $this;}

    /**
     * The name of the flag resource, following Google Cloud conventions, e.g.:
     *  * projects/{project}/locations/{location}/flags/{flag}
     * This field currently has no semantic meaning.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The name of the flag resource, following Google Cloud conventions, e.g.:
     *  * projects/{project}/locations/{location}/flags/{flag}
     * This field currently has no semantic meaning.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The name of the database flag, e.g. "max_allowed_packets".
     * The is a possibly key for the Instance.database_flags map field.
     *
     * Generated from protobuf field <code>string flag_name = 2;</code>
     * @return string
     */
    public function getFlagName()
    {
        return $this->flag_name;
    }

    /**
     * The name of the database flag, e.g. "max_allowed_packets".
     * The is a possibly key for the Instance.database_flags map field.
     *
     * Generated from protobuf field <code>string flag_name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setFlagName($var)
    {
        GPBUtil::checkString($var, True);
        $this->flag_name = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.ValueType value_type = 3;</code>
     * @return int
     */
    public function getValueType()
    {
        return $this->value_type;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.ValueType value_type = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setValueType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\ValueType::class);
        $this->value_type = $var;

        return $this;
    }

    /**
     * Whether the database flag accepts multiple values. If true,
     * a comma-separated list of stringified values may be specified.
     *
     * Generated from protobuf field <code>bool accepts_multiple_values = 4;</code>
     * @return bool
     */
    public function getAcceptsMultipleValues()
    {
        return $this->accepts_multiple_values;
    }

    /**
     * Whether the database flag accepts multiple values. If true,
     * a comma-separated list of stringified values may be specified.
     *
     * Generated from protobuf field <code>bool accepts_multiple_values = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setAcceptsMultipleValues($var)
    {
        GPBUtil::checkBool($var);
        $this->accepts_multiple_values = $var;

        return $this;
    }

    /**
     * Major database engine versions for which this flag is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.DatabaseVersion supported_db_versions = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSupportedDbVersions()
    {
        return $this->supported_db_versions;
    }

    /**
     * Major database engine versions for which this flag is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.alloydb.v1.DatabaseVersion supported_db_versions = 5;</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSupportedDbVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\AlloyDb\V1\DatabaseVersion::class);
        $this->supported_db_versions = $arr;

        return $this;
    }

    /**
     * Whether setting or updating this flag on an Instance requires a database
     * restart. If a flag that requires database restart is set, the backend
     * will automatically restart the database (making sure to satisfy any
     * availability SLO's).
     *
     * Generated from protobuf field <code>bool requires_db_restart = 6;</code>
     * @return bool
     */
    public function getRequiresDbRestart()
    {
        return $this->requires_db_restart;
    }

    /**
     * Whether setting or updating this flag on an Instance requires a database
     * restart. If a flag that requires database restart is set, the backend
     * will automatically restart the database (making sure to satisfy any
     * availability SLO's).
     *
     * Generated from protobuf field <code>bool requires_db_restart = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setRequiresDbRestart($var)
    {
        GPBUtil::checkBool($var);
        $this->requires_db_restart = $var;

        return $this;
    }

    /**
     * The scope of the flag.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.Scope scope = 9;</code>
     * @return int
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * The scope of the flag.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.SupportedDatabaseFlag.Scope scope = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AlloyDb\V1\SupportedDatabaseFlag\Scope::class);
        $this->scope = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getRestrictions()
    {
        return $this->whichOneof("restrictions");
    }

    /**
     * @return string
     */
    public function getRecommendedValue()
    {
        return $this->whichOneof("recommended_value");
    }

}

