<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/search_service.proto

namespace Google\Cloud\Retail\V2\SearchRequest\FacetSpec;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies how a facet is computed.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey</code>
 */
class FacetKey extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Supported textual and numerical facet keys in
     * [Product][google.cloud.retail.v2.Product] object, over which the facet
     * values are computed. Facet key is case-sensitive.
     * Allowed facet keys when
     * [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
     * is not specified:
     * * textual_field =<br>
     *     <font color='grey'>
     *     *# The
     *     [Product.brands][google.cloud.retail.v2.Product.brands].<br>*
     *     </font>
     *     "brands";
     *     <br>
     *     <font color='categories'>
     *     *# The
     *     [Product.categories][google.cloud.retail.v2.Product.categories].<br>*
     *     </font>
     *     "categories";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Audience.genders][google.cloud.retail.v2.Audience.genders].<br>*
     *     </font>
     *     | "genders";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Audience.age_groups][google.cloud.retail.v2.Audience.age_groups].<br>*
     *     </font>
     *     | "ageGroups";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.availability][google.cloud.retail.v2.Product.availability].
     *     Value is one of<br>*
     *     *# "IN_STOCK", "OUT_OF_STOCK", PREORDER", "BACKORDER".<br>*
     *     </font>
     *     | "availability";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [ColorInfo.color_families][google.cloud.retail.v2.ColorInfo.color_families].<br>*
     *     </font>
     *     | "colorFamilies";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [ColorInfo.colors][google.cloud.retail.v2.ColorInfo.colors].<br>*
     *     </font>
     *     | "colors";
     *     <br>
     *     <font color='grey'>
     *     *# The [Product.sizes][google.cloud.retail.v2.Product.sizes].<br>*
     *     </font>
     *     | "sizes";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.materials][google.cloud.retail.v2.Product.materials].<br>*
     *     </font>
     *     | "materials";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.patterns][google.cloud.retail.v2.Product.patterns].<br>*
     *     </font>
     *     | "patterns";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.conditions][google.cloud.retail.v2.Product.conditions].<br>*
     *     </font>
     *     | "conditions";
     *     <br>
     *     <font color='grey'>
     *     *# The textual custom attribute in
     *     [Product][google.cloud.retail.v2.Product] object. Key can<br>*
     *     *# be any key in the
     *     [Product.attributes][google.cloud.retail.v2.Product.attributes]
     *     map<br>*
     *     *# if the attribute values are textual.<br>*
     *     *# map.<br>*
     *     </font>
     *     | "attributes.key";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.PICKUP_IN_STORE][].<br>*
     *     </font>
     *     | "pickupInStore";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.SHIP_TO_STORE][].<br>*
     *     </font>
     *     | "shipToStore";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.SAME_DAY_DELIVERY][].<br>*
     *     </font>
     *     | "sameDayDelivery";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.NEXT_DAY_DELIVERY][].<br>*
     *     </font>
     *     | "nextDayDelivery";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_1][].<br>*
     *     </font>
     *     | "customFulfillment1";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_2][].<br>*
     *     </font>
     *     | "customFulfillment2";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_3][].<br>*
     *     </font>
     *     | "customFulfillment3";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_4][].<br>*
     *     </font>
     *     | "customFulfillment4";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_5][].<br>*
     *     </font>
     *     | "customFulfillment5";
     * * numerical_field =<br>
     *     <font color='grey'>
     *     *# The
     *     [PriceInfo.price][google.cloud.retail.v2.PriceInfo.price].<br>*
     *     </font>
     *     "price";
     *     <br>
     *     <font color='grey'>
     *     *# The discount. Computed by (original_price-price)/price <br>*
     *     </font>
     *     "discount";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Rating.average_rating][google.cloud.retail.v2.Rating.average_rating].<br>*
     *     </font>
     *     "rating";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Rating.rating_count][google.cloud.retail.v2.Rating.rating_count].<br>*
     *     </font>
     *     "ratingCount";
     *     <br>
     *     <font color='grey'>
     *     *# The numerical custom attribute in
     *     [Product][google.cloud.retail.v2.Product] object. Key can<br>*
     *     *# be any key in the
     *     [Product.attributes][google.cloud.retail.v2.Product.attributes]
     *     map<br>*
     *     *# if the attribute values are numerical.<br>*
     *     </font>
     *     | "attributes.key";
     *
     * Generated from protobuf field <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $key = '';
    /**
     * Set only if values should be bucketized into intervals. Must be set
     * for facets with numerical values. Must not be set for facet with text
     * values. Maximum number of intervals is 30.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.Interval intervals = 2;</code>
     */
    private $intervals;
    /**
     * Only get facet for the given restricted values. For example, when using
     * "pickupInStore" as key and set restricted values to
     * ["store123", "store456"], only facets for "store123" and "store456" are
     * returned. Only supported on textual fields and fulfillments.
     * Maximum is 20.
     * Must be set for the fulfillment facet keys:
     * * pickupInStore
     * * shipToStore
     * * sameDayDelivery
     * * nextDayDelivery
     * * customFulfillment1
     * * customFulfillment2
     * * customFulfillment3
     * * customFulfillment4
     * * customFulfillment5
     *
     * Generated from protobuf field <code>repeated string restricted_values = 3;</code>
     */
    private $restricted_values;
    /**
     * Only get facet values that start with the given string prefix. For
     * example, suppose "categories" has three values "Women > Shoe",
     * "Women > Dress" and "Men > Shoe". If set "prefixes" to "Women", the
     * "categories" facet will give only "Women > Shoe" and "Women > Dress".
     * Only supported on textual fields. Maximum is 10.
     *
     * Generated from protobuf field <code>repeated string prefixes = 8;</code>
     */
    private $prefixes;
    /**
     * Only get facet values that contains the given strings. For example,
     * suppose "categories" has three values "Women > Shoe",
     * "Women > Dress" and "Men > Shoe". If set "contains" to "Shoe", the
     * "categories" facet will give only "Women > Shoe" and "Men > Shoe".
     * Only supported on textual fields. Maximum is 10.
     *
     * Generated from protobuf field <code>repeated string contains = 9;</code>
     */
    private $contains;
    /**
     * The order in which [Facet.values][] are returned.
     * Allowed values are:
     * * "count desc", which means order by [Facet.FacetValue.count][]
     * descending.
     * * "value desc", which means order by [Facet.FacetValue.value][]
     * descending.
     *   Only applies to textual facets.
     * If not set, textual values are sorted in [natural
     * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
     * intervals are sorted in the order given by
     * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.intervals];
     * [FulfillmentInfo.ids][] are sorted in the order given by
     * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.restricted_values].
     *
     * Generated from protobuf field <code>string order_by = 4;</code>
     */
    private $order_by = '';
    /**
     * The query that is used to compute facet for the given facet key.
     * When provided, it will override the default behavior of facet
     * computation. The query syntax is the same as a filter expression. See
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * detail syntax and limitations. Notice that there is no limitation on
     * [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
     * when query is specified.
     * In the response, [FacetValue.value][] will be always "1" and
     * [FacetValue.count][] will be the number of results that matches the
     * query.
     * For example, you can set a customized facet for "shipToStore",
     * where
     * [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
     * is "customizedShipToStore", and
     * [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
     * is "availability: ANY(\"IN_STOCK\") AND shipToStore: ANY(\"123\")".
     * Then the facet will count the products that are both in stock and ship
     * to store "123".
     *
     * Generated from protobuf field <code>string query = 5;</code>
     */
    private $query = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $key
     *           Required. Supported textual and numerical facet keys in
     *           [Product][google.cloud.retail.v2.Product] object, over which the facet
     *           values are computed. Facet key is case-sensitive.
     *           Allowed facet keys when
     *           [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
     *           is not specified:
     *           * textual_field =<br>
     *               <font color='grey'>
     *               *# The
     *               [Product.brands][google.cloud.retail.v2.Product.brands].<br>*
     *               </font>
     *               "brands";
     *               <br>
     *               <font color='categories'>
     *               *# The
     *               [Product.categories][google.cloud.retail.v2.Product.categories].<br>*
     *               </font>
     *               "categories";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [Audience.genders][google.cloud.retail.v2.Audience.genders].<br>*
     *               </font>
     *               | "genders";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [Audience.age_groups][google.cloud.retail.v2.Audience.age_groups].<br>*
     *               </font>
     *               | "ageGroups";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [Product.availability][google.cloud.retail.v2.Product.availability].
     *               Value is one of<br>*
     *               *# "IN_STOCK", "OUT_OF_STOCK", PREORDER", "BACKORDER".<br>*
     *               </font>
     *               | "availability";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [ColorInfo.color_families][google.cloud.retail.v2.ColorInfo.color_families].<br>*
     *               </font>
     *               | "colorFamilies";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [ColorInfo.colors][google.cloud.retail.v2.ColorInfo.colors].<br>*
     *               </font>
     *               | "colors";
     *               <br>
     *               <font color='grey'>
     *               *# The [Product.sizes][google.cloud.retail.v2.Product.sizes].<br>*
     *               </font>
     *               | "sizes";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [Product.materials][google.cloud.retail.v2.Product.materials].<br>*
     *               </font>
     *               | "materials";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [Product.patterns][google.cloud.retail.v2.Product.patterns].<br>*
     *               </font>
     *               | "patterns";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [Product.conditions][google.cloud.retail.v2.Product.conditions].<br>*
     *               </font>
     *               | "conditions";
     *               <br>
     *               <font color='grey'>
     *               *# The textual custom attribute in
     *               [Product][google.cloud.retail.v2.Product] object. Key can<br>*
     *               *# be any key in the
     *               [Product.attributes][google.cloud.retail.v2.Product.attributes]
     *               map<br>*
     *               *# if the attribute values are textual.<br>*
     *               *# map.<br>*
     *               </font>
     *               | "attributes.key";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.PICKUP_IN_STORE][].<br>*
     *               </font>
     *               | "pickupInStore";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.SHIP_TO_STORE][].<br>*
     *               </font>
     *               | "shipToStore";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.SAME_DAY_DELIVERY][].<br>*
     *               </font>
     *               | "sameDayDelivery";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.NEXT_DAY_DELIVERY][].<br>*
     *               </font>
     *               | "nextDayDelivery";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.CUSTOM_TYPE_1][].<br>*
     *               </font>
     *               | "customFulfillment1";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.CUSTOM_TYPE_2][].<br>*
     *               </font>
     *               | "customFulfillment2";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.CUSTOM_TYPE_3][].<br>*
     *               </font>
     *               | "customFulfillment3";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.CUSTOM_TYPE_4][].<br>*
     *               </font>
     *               | "customFulfillment4";
     *               <br>
     *               <font color='grey'>
     *               *# The [FulfillmentInfo.ids][] for type
     *               *# [FulfillmentInfo.Type.CUSTOM_TYPE_5][].<br>*
     *               </font>
     *               | "customFulfillment5";
     *           * numerical_field =<br>
     *               <font color='grey'>
     *               *# The
     *               [PriceInfo.price][google.cloud.retail.v2.PriceInfo.price].<br>*
     *               </font>
     *               "price";
     *               <br>
     *               <font color='grey'>
     *               *# The discount. Computed by (original_price-price)/price <br>*
     *               </font>
     *               "discount";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [Rating.average_rating][google.cloud.retail.v2.Rating.average_rating].<br>*
     *               </font>
     *               "rating";
     *               <br>
     *               <font color='grey'>
     *               *# The
     *               [Rating.rating_count][google.cloud.retail.v2.Rating.rating_count].<br>*
     *               </font>
     *               "ratingCount";
     *               <br>
     *               <font color='grey'>
     *               *# The numerical custom attribute in
     *               [Product][google.cloud.retail.v2.Product] object. Key can<br>*
     *               *# be any key in the
     *               [Product.attributes][google.cloud.retail.v2.Product.attributes]
     *               map<br>*
     *               *# if the attribute values are numerical.<br>*
     *               </font>
     *               | "attributes.key";
     *     @type \Google\Cloud\Retail\V2\Interval[]|\Google\Protobuf\Internal\RepeatedField $intervals
     *           Set only if values should be bucketized into intervals. Must be set
     *           for facets with numerical values. Must not be set for facet with text
     *           values. Maximum number of intervals is 30.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $restricted_values
     *           Only get facet for the given restricted values. For example, when using
     *           "pickupInStore" as key and set restricted values to
     *           ["store123", "store456"], only facets for "store123" and "store456" are
     *           returned. Only supported on textual fields and fulfillments.
     *           Maximum is 20.
     *           Must be set for the fulfillment facet keys:
     *           * pickupInStore
     *           * shipToStore
     *           * sameDayDelivery
     *           * nextDayDelivery
     *           * customFulfillment1
     *           * customFulfillment2
     *           * customFulfillment3
     *           * customFulfillment4
     *           * customFulfillment5
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $prefixes
     *           Only get facet values that start with the given string prefix. For
     *           example, suppose "categories" has three values "Women > Shoe",
     *           "Women > Dress" and "Men > Shoe". If set "prefixes" to "Women", the
     *           "categories" facet will give only "Women > Shoe" and "Women > Dress".
     *           Only supported on textual fields. Maximum is 10.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $contains
     *           Only get facet values that contains the given strings. For example,
     *           suppose "categories" has three values "Women > Shoe",
     *           "Women > Dress" and "Men > Shoe". If set "contains" to "Shoe", the
     *           "categories" facet will give only "Women > Shoe" and "Men > Shoe".
     *           Only supported on textual fields. Maximum is 10.
     *     @type string $order_by
     *           The order in which [Facet.values][] are returned.
     *           Allowed values are:
     *           * "count desc", which means order by [Facet.FacetValue.count][]
     *           descending.
     *           * "value desc", which means order by [Facet.FacetValue.value][]
     *           descending.
     *             Only applies to textual facets.
     *           If not set, textual values are sorted in [natural
     *           order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
     *           intervals are sorted in the order given by
     *           [FacetSpec.FacetKey.intervals][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.intervals];
     *           [FulfillmentInfo.ids][] are sorted in the order given by
     *           [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.restricted_values].
     *     @type string $query
     *           The query that is used to compute facet for the given facet key.
     *           When provided, it will override the default behavior of facet
     *           computation. The query syntax is the same as a filter expression. See
     *           [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     *           detail syntax and limitations. Notice that there is no limitation on
     *           [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
     *           when query is specified.
     *           In the response, [FacetValue.value][] will be always "1" and
     *           [FacetValue.count][] will be the number of results that matches the
     *           query.
     *           For example, you can set a customized facet for "shipToStore",
     *           where
     *           [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
     *           is "customizedShipToStore", and
     *           [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
     *           is "availability: ANY(\"IN_STOCK\") AND shipToStore: ANY(\"123\")".
     *           Then the facet will count the products that are both in stock and ship
     *           to store "123".
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\SearchService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Supported textual and numerical facet keys in
     * [Product][google.cloud.retail.v2.Product] object, over which the facet
     * values are computed. Facet key is case-sensitive.
     * Allowed facet keys when
     * [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
     * is not specified:
     * * textual_field =<br>
     *     <font color='grey'>
     *     *# The
     *     [Product.brands][google.cloud.retail.v2.Product.brands].<br>*
     *     </font>
     *     "brands";
     *     <br>
     *     <font color='categories'>
     *     *# The
     *     [Product.categories][google.cloud.retail.v2.Product.categories].<br>*
     *     </font>
     *     "categories";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Audience.genders][google.cloud.retail.v2.Audience.genders].<br>*
     *     </font>
     *     | "genders";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Audience.age_groups][google.cloud.retail.v2.Audience.age_groups].<br>*
     *     </font>
     *     | "ageGroups";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.availability][google.cloud.retail.v2.Product.availability].
     *     Value is one of<br>*
     *     *# "IN_STOCK", "OUT_OF_STOCK", PREORDER", "BACKORDER".<br>*
     *     </font>
     *     | "availability";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [ColorInfo.color_families][google.cloud.retail.v2.ColorInfo.color_families].<br>*
     *     </font>
     *     | "colorFamilies";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [ColorInfo.colors][google.cloud.retail.v2.ColorInfo.colors].<br>*
     *     </font>
     *     | "colors";
     *     <br>
     *     <font color='grey'>
     *     *# The [Product.sizes][google.cloud.retail.v2.Product.sizes].<br>*
     *     </font>
     *     | "sizes";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.materials][google.cloud.retail.v2.Product.materials].<br>*
     *     </font>
     *     | "materials";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.patterns][google.cloud.retail.v2.Product.patterns].<br>*
     *     </font>
     *     | "patterns";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.conditions][google.cloud.retail.v2.Product.conditions].<br>*
     *     </font>
     *     | "conditions";
     *     <br>
     *     <font color='grey'>
     *     *# The textual custom attribute in
     *     [Product][google.cloud.retail.v2.Product] object. Key can<br>*
     *     *# be any key in the
     *     [Product.attributes][google.cloud.retail.v2.Product.attributes]
     *     map<br>*
     *     *# if the attribute values are textual.<br>*
     *     *# map.<br>*
     *     </font>
     *     | "attributes.key";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.PICKUP_IN_STORE][].<br>*
     *     </font>
     *     | "pickupInStore";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.SHIP_TO_STORE][].<br>*
     *     </font>
     *     | "shipToStore";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.SAME_DAY_DELIVERY][].<br>*
     *     </font>
     *     | "sameDayDelivery";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.NEXT_DAY_DELIVERY][].<br>*
     *     </font>
     *     | "nextDayDelivery";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_1][].<br>*
     *     </font>
     *     | "customFulfillment1";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_2][].<br>*
     *     </font>
     *     | "customFulfillment2";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_3][].<br>*
     *     </font>
     *     | "customFulfillment3";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_4][].<br>*
     *     </font>
     *     | "customFulfillment4";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_5][].<br>*
     *     </font>
     *     | "customFulfillment5";
     * * numerical_field =<br>
     *     <font color='grey'>
     *     *# The
     *     [PriceInfo.price][google.cloud.retail.v2.PriceInfo.price].<br>*
     *     </font>
     *     "price";
     *     <br>
     *     <font color='grey'>
     *     *# The discount. Computed by (original_price-price)/price <br>*
     *     </font>
     *     "discount";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Rating.average_rating][google.cloud.retail.v2.Rating.average_rating].<br>*
     *     </font>
     *     "rating";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Rating.rating_count][google.cloud.retail.v2.Rating.rating_count].<br>*
     *     </font>
     *     "ratingCount";
     *     <br>
     *     <font color='grey'>
     *     *# The numerical custom attribute in
     *     [Product][google.cloud.retail.v2.Product] object. Key can<br>*
     *     *# be any key in the
     *     [Product.attributes][google.cloud.retail.v2.Product.attributes]
     *     map<br>*
     *     *# if the attribute values are numerical.<br>*
     *     </font>
     *     | "attributes.key";
     *
     * Generated from protobuf field <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * Required. Supported textual and numerical facet keys in
     * [Product][google.cloud.retail.v2.Product] object, over which the facet
     * values are computed. Facet key is case-sensitive.
     * Allowed facet keys when
     * [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
     * is not specified:
     * * textual_field =<br>
     *     <font color='grey'>
     *     *# The
     *     [Product.brands][google.cloud.retail.v2.Product.brands].<br>*
     *     </font>
     *     "brands";
     *     <br>
     *     <font color='categories'>
     *     *# The
     *     [Product.categories][google.cloud.retail.v2.Product.categories].<br>*
     *     </font>
     *     "categories";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Audience.genders][google.cloud.retail.v2.Audience.genders].<br>*
     *     </font>
     *     | "genders";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Audience.age_groups][google.cloud.retail.v2.Audience.age_groups].<br>*
     *     </font>
     *     | "ageGroups";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.availability][google.cloud.retail.v2.Product.availability].
     *     Value is one of<br>*
     *     *# "IN_STOCK", "OUT_OF_STOCK", PREORDER", "BACKORDER".<br>*
     *     </font>
     *     | "availability";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [ColorInfo.color_families][google.cloud.retail.v2.ColorInfo.color_families].<br>*
     *     </font>
     *     | "colorFamilies";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [ColorInfo.colors][google.cloud.retail.v2.ColorInfo.colors].<br>*
     *     </font>
     *     | "colors";
     *     <br>
     *     <font color='grey'>
     *     *# The [Product.sizes][google.cloud.retail.v2.Product.sizes].<br>*
     *     </font>
     *     | "sizes";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.materials][google.cloud.retail.v2.Product.materials].<br>*
     *     </font>
     *     | "materials";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.patterns][google.cloud.retail.v2.Product.patterns].<br>*
     *     </font>
     *     | "patterns";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Product.conditions][google.cloud.retail.v2.Product.conditions].<br>*
     *     </font>
     *     | "conditions";
     *     <br>
     *     <font color='grey'>
     *     *# The textual custom attribute in
     *     [Product][google.cloud.retail.v2.Product] object. Key can<br>*
     *     *# be any key in the
     *     [Product.attributes][google.cloud.retail.v2.Product.attributes]
     *     map<br>*
     *     *# if the attribute values are textual.<br>*
     *     *# map.<br>*
     *     </font>
     *     | "attributes.key";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.PICKUP_IN_STORE][].<br>*
     *     </font>
     *     | "pickupInStore";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.SHIP_TO_STORE][].<br>*
     *     </font>
     *     | "shipToStore";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.SAME_DAY_DELIVERY][].<br>*
     *     </font>
     *     | "sameDayDelivery";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.NEXT_DAY_DELIVERY][].<br>*
     *     </font>
     *     | "nextDayDelivery";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_1][].<br>*
     *     </font>
     *     | "customFulfillment1";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_2][].<br>*
     *     </font>
     *     | "customFulfillment2";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_3][].<br>*
     *     </font>
     *     | "customFulfillment3";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_4][].<br>*
     *     </font>
     *     | "customFulfillment4";
     *     <br>
     *     <font color='grey'>
     *     *# The [FulfillmentInfo.ids][] for type
     *     *# [FulfillmentInfo.Type.CUSTOM_TYPE_5][].<br>*
     *     </font>
     *     | "customFulfillment5";
     * * numerical_field =<br>
     *     <font color='grey'>
     *     *# The
     *     [PriceInfo.price][google.cloud.retail.v2.PriceInfo.price].<br>*
     *     </font>
     *     "price";
     *     <br>
     *     <font color='grey'>
     *     *# The discount. Computed by (original_price-price)/price <br>*
     *     </font>
     *     "discount";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Rating.average_rating][google.cloud.retail.v2.Rating.average_rating].<br>*
     *     </font>
     *     "rating";
     *     <br>
     *     <font color='grey'>
     *     *# The
     *     [Rating.rating_count][google.cloud.retail.v2.Rating.rating_count].<br>*
     *     </font>
     *     "ratingCount";
     *     <br>
     *     <font color='grey'>
     *     *# The numerical custom attribute in
     *     [Product][google.cloud.retail.v2.Product] object. Key can<br>*
     *     *# be any key in the
     *     [Product.attributes][google.cloud.retail.v2.Product.attributes]
     *     map<br>*
     *     *# if the attribute values are numerical.<br>*
     *     </font>
     *     | "attributes.key";
     *
     * Generated from protobuf field <code>string key = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->key = $var;

        return $this;
    }

    /**
     * Set only if values should be bucketized into intervals. Must be set
     * for facets with numerical values. Must not be set for facet with text
     * values. Maximum number of intervals is 30.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.Interval intervals = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIntervals()
    {
        return $this->intervals;
    }

    /**
     * Set only if values should be bucketized into intervals. Must be set
     * for facets with numerical values. Must not be set for facet with text
     * values. Maximum number of intervals is 30.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.Interval intervals = 2;</code>
     * @param \Google\Cloud\Retail\V2\Interval[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIntervals($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\Interval::class);
        $this->intervals = $arr;

        return $this;
    }

    /**
     * Only get facet for the given restricted values. For example, when using
     * "pickupInStore" as key and set restricted values to
     * ["store123", "store456"], only facets for "store123" and "store456" are
     * returned. Only supported on textual fields and fulfillments.
     * Maximum is 20.
     * Must be set for the fulfillment facet keys:
     * * pickupInStore
     * * shipToStore
     * * sameDayDelivery
     * * nextDayDelivery
     * * customFulfillment1
     * * customFulfillment2
     * * customFulfillment3
     * * customFulfillment4
     * * customFulfillment5
     *
     * Generated from protobuf field <code>repeated string restricted_values = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRestrictedValues()
    {
        return $this->restricted_values;
    }

    /**
     * Only get facet for the given restricted values. For example, when using
     * "pickupInStore" as key and set restricted values to
     * ["store123", "store456"], only facets for "store123" and "store456" are
     * returned. Only supported on textual fields and fulfillments.
     * Maximum is 20.
     * Must be set for the fulfillment facet keys:
     * * pickupInStore
     * * shipToStore
     * * sameDayDelivery
     * * nextDayDelivery
     * * customFulfillment1
     * * customFulfillment2
     * * customFulfillment3
     * * customFulfillment4
     * * customFulfillment5
     *
     * Generated from protobuf field <code>repeated string restricted_values = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRestrictedValues($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->restricted_values = $arr;

        return $this;
    }

    /**
     * Only get facet values that start with the given string prefix. For
     * example, suppose "categories" has three values "Women > Shoe",
     * "Women > Dress" and "Men > Shoe". If set "prefixes" to "Women", the
     * "categories" facet will give only "Women > Shoe" and "Women > Dress".
     * Only supported on textual fields. Maximum is 10.
     *
     * Generated from protobuf field <code>repeated string prefixes = 8;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPrefixes()
    {
        return $this->prefixes;
    }

    /**
     * Only get facet values that start with the given string prefix. For
     * example, suppose "categories" has three values "Women > Shoe",
     * "Women > Dress" and "Men > Shoe". If set "prefixes" to "Women", the
     * "categories" facet will give only "Women > Shoe" and "Women > Dress".
     * Only supported on textual fields. Maximum is 10.
     *
     * Generated from protobuf field <code>repeated string prefixes = 8;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPrefixes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->prefixes = $arr;

        return $this;
    }

    /**
     * Only get facet values that contains the given strings. For example,
     * suppose "categories" has three values "Women > Shoe",
     * "Women > Dress" and "Men > Shoe". If set "contains" to "Shoe", the
     * "categories" facet will give only "Women > Shoe" and "Men > Shoe".
     * Only supported on textual fields. Maximum is 10.
     *
     * Generated from protobuf field <code>repeated string contains = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContains()
    {
        return $this->contains;
    }

    /**
     * Only get facet values that contains the given strings. For example,
     * suppose "categories" has three values "Women > Shoe",
     * "Women > Dress" and "Men > Shoe". If set "contains" to "Shoe", the
     * "categories" facet will give only "Women > Shoe" and "Men > Shoe".
     * Only supported on textual fields. Maximum is 10.
     *
     * Generated from protobuf field <code>repeated string contains = 9;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContains($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->contains = $arr;

        return $this;
    }

    /**
     * The order in which [Facet.values][] are returned.
     * Allowed values are:
     * * "count desc", which means order by [Facet.FacetValue.count][]
     * descending.
     * * "value desc", which means order by [Facet.FacetValue.value][]
     * descending.
     *   Only applies to textual facets.
     * If not set, textual values are sorted in [natural
     * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
     * intervals are sorted in the order given by
     * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.intervals];
     * [FulfillmentInfo.ids][] are sorted in the order given by
     * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.restricted_values].
     *
     * Generated from protobuf field <code>string order_by = 4;</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * The order in which [Facet.values][] are returned.
     * Allowed values are:
     * * "count desc", which means order by [Facet.FacetValue.count][]
     * descending.
     * * "value desc", which means order by [Facet.FacetValue.value][]
     * descending.
     *   Only applies to textual facets.
     * If not set, textual values are sorted in [natural
     * order](https://en.wikipedia.org/wiki/Natural_sort_order); numerical
     * intervals are sorted in the order given by
     * [FacetSpec.FacetKey.intervals][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.intervals];
     * [FulfillmentInfo.ids][] are sorted in the order given by
     * [FacetSpec.FacetKey.restricted_values][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.restricted_values].
     *
     * Generated from protobuf field <code>string order_by = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * The query that is used to compute facet for the given facet key.
     * When provided, it will override the default behavior of facet
     * computation. The query syntax is the same as a filter expression. See
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * detail syntax and limitations. Notice that there is no limitation on
     * [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
     * when query is specified.
     * In the response, [FacetValue.value][] will be always "1" and
     * [FacetValue.count][] will be the number of results that matches the
     * query.
     * For example, you can set a customized facet for "shipToStore",
     * where
     * [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
     * is "customizedShipToStore", and
     * [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
     * is "availability: ANY(\"IN_STOCK\") AND shipToStore: ANY(\"123\")".
     * Then the facet will count the products that are both in stock and ship
     * to store "123".
     *
     * Generated from protobuf field <code>string query = 5;</code>
     * @return string
     */
    public function getQuery()
    {
        return $this->query;
    }

    /**
     * The query that is used to compute facet for the given facet key.
     * When provided, it will override the default behavior of facet
     * computation. The query syntax is the same as a filter expression. See
     * [SearchRequest.filter][google.cloud.retail.v2.SearchRequest.filter] for
     * detail syntax and limitations. Notice that there is no limitation on
     * [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
     * when query is specified.
     * In the response, [FacetValue.value][] will be always "1" and
     * [FacetValue.count][] will be the number of results that matches the
     * query.
     * For example, you can set a customized facet for "shipToStore",
     * where
     * [FacetKey.key][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.key]
     * is "customizedShipToStore", and
     * [FacetKey.query][google.cloud.retail.v2.SearchRequest.FacetSpec.FacetKey.query]
     * is "availability: ANY(\"IN_STOCK\") AND shipToStore: ANY(\"123\")".
     * Then the facet will count the products that are both in stock and ship
     * to store "123".
     *
     * Generated from protobuf field <code>string query = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->query = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FacetKey::class, \Google\Cloud\Retail\V2\SearchRequest_FacetSpec_FacetKey::class);

