<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ClusterUpdate describes an update to the cluster. Exactly one update can
 * be applied to a cluster with each request, so at most one field can be
 * provided.
 *
 * Generated from protobuf message <code>google.container.v1.ClusterUpdate</code>
 */
class ClusterUpdate extends \Google\Protobuf\Internal\Message
{
    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     */
    private $desired_node_version = '';
    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     */
    private $desired_monitoring_service = '';
    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     */
    private $desired_addons_config = null;
    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     */
    private $desired_node_pool_id = '';
    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     */
    private $desired_image_type = '';
    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
     */
    private $desired_database_encryption = null;
    /**
     * Configuration for Workload Identity.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
     */
    private $desired_workload_identity_config = null;
    /**
     * Configuration for Shielded Nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
     */
    private $desired_shielded_nodes = null;
    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    private $desired_node_pool_autoscaling = null;
    /**
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This list must always include the cluster's primary zone.
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     */
    private $desired_locations;
    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     */
    private $desired_master_authorized_networks_config = null;
    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     */
    private $desired_cluster_autoscaling = null;
    /**
     * The desired configuration options for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
     */
    private $desired_binary_authorization = null;
    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_logging_service = 19;</code>
     */
    private $desired_logging_service = '';
    /**
     * The desired configuration for exporting resource usage.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;</code>
     */
    private $desired_resource_usage_export_config = null;
    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
     */
    private $desired_vertical_pod_autoscaling = null;
    /**
     * The desired private cluster configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25;</code>
     */
    private $desired_private_cluster_config = null;
    /**
     * The desired config of Intra-node visibility.
     *
     * Generated from protobuf field <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;</code>
     */
    private $desired_intra_node_visibility_config = null;
    /**
     * The desired status of whether to disable default sNAT for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     */
    private $desired_default_snat_status = null;
    /**
     * The desired release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
     */
    private $desired_release_channel = null;
    /**
     * The desired authenticator groups config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;</code>
     */
    private $desired_authenticator_groups_config = null;
    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     */
    private $desired_master_version = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $desired_node_version
     *           The Kubernetes version to change the nodes to (typically an
     *           upgrade).
     *           Users may specify either explicit versions offered by
     *           Kubernetes Engine or version aliases, which have the following behavior:
     *           - "latest": picks the highest valid Kubernetes version
     *           - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     *           - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     *           - "1.X.Y-gke.N": picks an explicit Kubernetes version
     *           - "-": picks the Kubernetes master version
     *     @type string $desired_monitoring_service
     *           The monitoring service the cluster should use to write metrics.
     *           Currently available options:
     *           * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     *           service with a Kubernetes-native resource model
     *           * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *             longer available as of GKE 1.15).
     *           * `none` - No metrics will be exported from the cluster.
     *           If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     *           used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *     @type \Google\Cloud\Container\V1\AddonsConfig $desired_addons_config
     *           Configurations for the various addons available to run in the cluster.
     *     @type string $desired_node_pool_id
     *           The node pool to be upgraded. This field is mandatory if
     *           "desired_node_version", "desired_image_family" or
     *           "desired_node_pool_autoscaling" is specified and there is more than one
     *           node pool on the cluster.
     *     @type string $desired_image_type
     *           The desired image type for the node pool.
     *           NOTE: Set the "desired_node_pool" field as well.
     *     @type \Google\Cloud\Container\V1\DatabaseEncryption $desired_database_encryption
     *           Configuration of etcd encryption.
     *     @type \Google\Cloud\Container\V1\WorkloadIdentityConfig $desired_workload_identity_config
     *           Configuration for Workload Identity.
     *     @type \Google\Cloud\Container\V1\ShieldedNodes $desired_shielded_nodes
     *           Configuration for Shielded Nodes.
     *     @type \Google\Cloud\Container\V1\NodePoolAutoscaling $desired_node_pool_autoscaling
     *           Autoscaler configuration for the node pool specified in
     *           desired_node_pool_id. If there is only one pool in the
     *           cluster and desired_node_pool_id is not provided then
     *           the change applies to that single node pool.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $desired_locations
     *           The desired list of Google Compute Engine
     *           [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     *           cluster's nodes should be located.
     *           This list must always include the cluster's primary zone.
     *           Warning: changing cluster locations will update the locations of all node
     *           pools and will result in nodes being added and/or removed.
     *     @type \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig $desired_master_authorized_networks_config
     *           The desired configuration options for master authorized networks feature.
     *     @type \Google\Cloud\Container\V1\ClusterAutoscaling $desired_cluster_autoscaling
     *           Cluster-level autoscaling configuration.
     *     @type \Google\Cloud\Container\V1\BinaryAuthorization $desired_binary_authorization
     *           The desired configuration options for the Binary Authorization feature.
     *     @type string $desired_logging_service
     *           The logging service the cluster should use to write logs.
     *           Currently available options:
     *           * `logging.googleapis.com/kubernetes` - The Cloud Logging
     *           service with a Kubernetes-native resource model
     *           * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *             available as of GKE 1.15).
     *           * `none` - no logs will be exported from the cluster.
     *           If left as an empty string,`logging.googleapis.com/kubernetes` will be
     *           used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *     @type \Google\Cloud\Container\V1\ResourceUsageExportConfig $desired_resource_usage_export_config
     *           The desired configuration for exporting resource usage.
     *     @type \Google\Cloud\Container\V1\VerticalPodAutoscaling $desired_vertical_pod_autoscaling
     *           Cluster-level Vertical Pod Autoscaling configuration.
     *     @type \Google\Cloud\Container\V1\PrivateClusterConfig $desired_private_cluster_config
     *           The desired private cluster configuration.
     *     @type \Google\Cloud\Container\V1\IntraNodeVisibilityConfig $desired_intra_node_visibility_config
     *           The desired config of Intra-node visibility.
     *     @type \Google\Cloud\Container\V1\DefaultSnatStatus $desired_default_snat_status
     *           The desired status of whether to disable default sNAT for this cluster.
     *     @type \Google\Cloud\Container\V1\ReleaseChannel $desired_release_channel
     *           The desired release channel configuration.
     *     @type \Google\Cloud\Container\V1\AuthenticatorGroupsConfig $desired_authenticator_groups_config
     *           The desired authenticator groups config for the cluster.
     *     @type string $desired_master_version
     *           The Kubernetes version to change the master to.
     *           Users may specify either explicit versions offered by
     *           Kubernetes Engine or version aliases, which have the following behavior:
     *           - "latest": picks the highest valid Kubernetes version
     *           - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     *           - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     *           - "1.X.Y-gke.N": picks an explicit Kubernetes version
     *           - "-": picks the default Kubernetes version
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     * @return string
     */
    public function getDesiredNodeVersion()
    {
        return $this->desired_node_version;
    }

    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredNodeVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_node_version = $var;

        return $this;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     * @return string
     */
    public function getDesiredMonitoringService()
    {
        return $this->desired_monitoring_service;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com/kubernetes" - The Cloud Monitoring
     * service with a Kubernetes-native resource model
     * * `monitoring.googleapis.com` - The legacy Cloud Monitoring service (no
     *   longer available as of GKE 1.15).
     * * `none` - No metrics will be exported from the cluster.
     * If left as an empty string,`monitoring.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `monitoring.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredMonitoringService($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_monitoring_service = $var;

        return $this;
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     * @return \Google\Cloud\Container\V1\AddonsConfig|null
     */
    public function getDesiredAddonsConfig()
    {
        return isset($this->desired_addons_config) ? $this->desired_addons_config : null;
    }

    public function hasDesiredAddonsConfig()
    {
        return isset($this->desired_addons_config);
    }

    public function clearDesiredAddonsConfig()
    {
        unset($this->desired_addons_config);
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     * @param \Google\Cloud\Container\V1\AddonsConfig $var
     * @return $this
     */
    public function setDesiredAddonsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AddonsConfig::class);
        $this->desired_addons_config = $var;

        return $this;
    }

    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     * @return string
     */
    public function getDesiredNodePoolId()
    {
        return $this->desired_node_pool_id;
    }

    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredNodePoolId($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_node_pool_id = $var;

        return $this;
    }

    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     * @return string
     */
    public function getDesiredImageType()
    {
        return $this->desired_image_type;
    }

    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredImageType($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_image_type = $var;

        return $this;
    }

    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
     * @return \Google\Cloud\Container\V1\DatabaseEncryption|null
     */
    public function getDesiredDatabaseEncryption()
    {
        return isset($this->desired_database_encryption) ? $this->desired_database_encryption : null;
    }

    public function hasDesiredDatabaseEncryption()
    {
        return isset($this->desired_database_encryption);
    }

    public function clearDesiredDatabaseEncryption()
    {
        unset($this->desired_database_encryption);
    }

    /**
     * Configuration of etcd encryption.
     *
     * Generated from protobuf field <code>.google.container.v1.DatabaseEncryption desired_database_encryption = 46;</code>
     * @param \Google\Cloud\Container\V1\DatabaseEncryption $var
     * @return $this
     */
    public function setDesiredDatabaseEncryption($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\DatabaseEncryption::class);
        $this->desired_database_encryption = $var;

        return $this;
    }

    /**
     * Configuration for Workload Identity.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
     * @return \Google\Cloud\Container\V1\WorkloadIdentityConfig|null
     */
    public function getDesiredWorkloadIdentityConfig()
    {
        return isset($this->desired_workload_identity_config) ? $this->desired_workload_identity_config : null;
    }

    public function hasDesiredWorkloadIdentityConfig()
    {
        return isset($this->desired_workload_identity_config);
    }

    public function clearDesiredWorkloadIdentityConfig()
    {
        unset($this->desired_workload_identity_config);
    }

    /**
     * Configuration for Workload Identity.
     *
     * Generated from protobuf field <code>.google.container.v1.WorkloadIdentityConfig desired_workload_identity_config = 47;</code>
     * @param \Google\Cloud\Container\V1\WorkloadIdentityConfig $var
     * @return $this
     */
    public function setDesiredWorkloadIdentityConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\WorkloadIdentityConfig::class);
        $this->desired_workload_identity_config = $var;

        return $this;
    }

    /**
     * Configuration for Shielded Nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
     * @return \Google\Cloud\Container\V1\ShieldedNodes|null
     */
    public function getDesiredShieldedNodes()
    {
        return isset($this->desired_shielded_nodes) ? $this->desired_shielded_nodes : null;
    }

    public function hasDesiredShieldedNodes()
    {
        return isset($this->desired_shielded_nodes);
    }

    public function clearDesiredShieldedNodes()
    {
        unset($this->desired_shielded_nodes);
    }

    /**
     * Configuration for Shielded Nodes.
     *
     * Generated from protobuf field <code>.google.container.v1.ShieldedNodes desired_shielded_nodes = 48;</code>
     * @param \Google\Cloud\Container\V1\ShieldedNodes $var
     * @return $this
     */
    public function setDesiredShieldedNodes($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ShieldedNodes::class);
        $this->desired_shielded_nodes = $var;

        return $this;
    }

    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     * @return \Google\Cloud\Container\V1\NodePoolAutoscaling|null
     */
    public function getDesiredNodePoolAutoscaling()
    {
        return isset($this->desired_node_pool_autoscaling) ? $this->desired_node_pool_autoscaling : null;
    }

    public function hasDesiredNodePoolAutoscaling()
    {
        return isset($this->desired_node_pool_autoscaling);
    }

    public function clearDesiredNodePoolAutoscaling()
    {
        unset($this->desired_node_pool_autoscaling);
    }

    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     * @param \Google\Cloud\Container\V1\NodePoolAutoscaling $var
     * @return $this
     */
    public function setDesiredNodePoolAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodePoolAutoscaling::class);
        $this->desired_node_pool_autoscaling = $var;

        return $this;
    }

    /**
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This list must always include the cluster's primary zone.
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDesiredLocations()
    {
        return $this->desired_locations;
    }

    /**
     * The desired list of Google Compute Engine
     * [zones](https://cloud.google.com/compute/docs/zones#available) in which the
     * cluster's nodes should be located.
     * This list must always include the cluster's primary zone.
     * Warning: changing cluster locations will update the locations of all node
     * pools and will result in nodes being added and/or removed.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDesiredLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->desired_locations = $arr;

        return $this;
    }

    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     * @return \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig|null
     */
    public function getDesiredMasterAuthorizedNetworksConfig()
    {
        return isset($this->desired_master_authorized_networks_config) ? $this->desired_master_authorized_networks_config : null;
    }

    public function hasDesiredMasterAuthorizedNetworksConfig()
    {
        return isset($this->desired_master_authorized_networks_config);
    }

    public function clearDesiredMasterAuthorizedNetworksConfig()
    {
        unset($this->desired_master_authorized_networks_config);
    }

    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     * @param \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig $var
     * @return $this
     */
    public function setDesiredMasterAuthorizedNetworksConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig::class);
        $this->desired_master_authorized_networks_config = $var;

        return $this;
    }

    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     * @return \Google\Cloud\Container\V1\ClusterAutoscaling|null
     */
    public function getDesiredClusterAutoscaling()
    {
        return isset($this->desired_cluster_autoscaling) ? $this->desired_cluster_autoscaling : null;
    }

    public function hasDesiredClusterAutoscaling()
    {
        return isset($this->desired_cluster_autoscaling);
    }

    public function clearDesiredClusterAutoscaling()
    {
        unset($this->desired_cluster_autoscaling);
    }

    /**
     * Cluster-level autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ClusterAutoscaling desired_cluster_autoscaling = 15;</code>
     * @param \Google\Cloud\Container\V1\ClusterAutoscaling $var
     * @return $this
     */
    public function setDesiredClusterAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ClusterAutoscaling::class);
        $this->desired_cluster_autoscaling = $var;

        return $this;
    }

    /**
     * The desired configuration options for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
     * @return \Google\Cloud\Container\V1\BinaryAuthorization|null
     */
    public function getDesiredBinaryAuthorization()
    {
        return isset($this->desired_binary_authorization) ? $this->desired_binary_authorization : null;
    }

    public function hasDesiredBinaryAuthorization()
    {
        return isset($this->desired_binary_authorization);
    }

    public function clearDesiredBinaryAuthorization()
    {
        unset($this->desired_binary_authorization);
    }

    /**
     * The desired configuration options for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.container.v1.BinaryAuthorization desired_binary_authorization = 16;</code>
     * @param \Google\Cloud\Container\V1\BinaryAuthorization $var
     * @return $this
     */
    public function setDesiredBinaryAuthorization($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\BinaryAuthorization::class);
        $this->desired_binary_authorization = $var;

        return $this;
    }

    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_logging_service = 19;</code>
     * @return string
     */
    public function getDesiredLoggingService()
    {
        return $this->desired_logging_service;
    }

    /**
     * The logging service the cluster should use to write logs.
     * Currently available options:
     * * `logging.googleapis.com/kubernetes` - The Cloud Logging
     * service with a Kubernetes-native resource model
     * * `logging.googleapis.com` - The legacy Cloud Logging service (no longer
     *   available as of GKE 1.15).
     * * `none` - no logs will be exported from the cluster.
     * If left as an empty string,`logging.googleapis.com/kubernetes` will be
     * used for GKE 1.14+ or `logging.googleapis.com` for earlier versions.
     *
     * Generated from protobuf field <code>string desired_logging_service = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredLoggingService($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_logging_service = $var;

        return $this;
    }

    /**
     * The desired configuration for exporting resource usage.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;</code>
     * @return \Google\Cloud\Container\V1\ResourceUsageExportConfig|null
     */
    public function getDesiredResourceUsageExportConfig()
    {
        return isset($this->desired_resource_usage_export_config) ? $this->desired_resource_usage_export_config : null;
    }

    public function hasDesiredResourceUsageExportConfig()
    {
        return isset($this->desired_resource_usage_export_config);
    }

    public function clearDesiredResourceUsageExportConfig()
    {
        unset($this->desired_resource_usage_export_config);
    }

    /**
     * The desired configuration for exporting resource usage.
     *
     * Generated from protobuf field <code>.google.container.v1.ResourceUsageExportConfig desired_resource_usage_export_config = 21;</code>
     * @param \Google\Cloud\Container\V1\ResourceUsageExportConfig $var
     * @return $this
     */
    public function setDesiredResourceUsageExportConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ResourceUsageExportConfig::class);
        $this->desired_resource_usage_export_config = $var;

        return $this;
    }

    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
     * @return \Google\Cloud\Container\V1\VerticalPodAutoscaling|null
     */
    public function getDesiredVerticalPodAutoscaling()
    {
        return isset($this->desired_vertical_pod_autoscaling) ? $this->desired_vertical_pod_autoscaling : null;
    }

    public function hasDesiredVerticalPodAutoscaling()
    {
        return isset($this->desired_vertical_pod_autoscaling);
    }

    public function clearDesiredVerticalPodAutoscaling()
    {
        unset($this->desired_vertical_pod_autoscaling);
    }

    /**
     * Cluster-level Vertical Pod Autoscaling configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.VerticalPodAutoscaling desired_vertical_pod_autoscaling = 22;</code>
     * @param \Google\Cloud\Container\V1\VerticalPodAutoscaling $var
     * @return $this
     */
    public function setDesiredVerticalPodAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\VerticalPodAutoscaling::class);
        $this->desired_vertical_pod_autoscaling = $var;

        return $this;
    }

    /**
     * The desired private cluster configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25;</code>
     * @return \Google\Cloud\Container\V1\PrivateClusterConfig|null
     */
    public function getDesiredPrivateClusterConfig()
    {
        return isset($this->desired_private_cluster_config) ? $this->desired_private_cluster_config : null;
    }

    public function hasDesiredPrivateClusterConfig()
    {
        return isset($this->desired_private_cluster_config);
    }

    public function clearDesiredPrivateClusterConfig()
    {
        unset($this->desired_private_cluster_config);
    }

    /**
     * The desired private cluster configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.PrivateClusterConfig desired_private_cluster_config = 25;</code>
     * @param \Google\Cloud\Container\V1\PrivateClusterConfig $var
     * @return $this
     */
    public function setDesiredPrivateClusterConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\PrivateClusterConfig::class);
        $this->desired_private_cluster_config = $var;

        return $this;
    }

    /**
     * The desired config of Intra-node visibility.
     *
     * Generated from protobuf field <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;</code>
     * @return \Google\Cloud\Container\V1\IntraNodeVisibilityConfig|null
     */
    public function getDesiredIntraNodeVisibilityConfig()
    {
        return isset($this->desired_intra_node_visibility_config) ? $this->desired_intra_node_visibility_config : null;
    }

    public function hasDesiredIntraNodeVisibilityConfig()
    {
        return isset($this->desired_intra_node_visibility_config);
    }

    public function clearDesiredIntraNodeVisibilityConfig()
    {
        unset($this->desired_intra_node_visibility_config);
    }

    /**
     * The desired config of Intra-node visibility.
     *
     * Generated from protobuf field <code>.google.container.v1.IntraNodeVisibilityConfig desired_intra_node_visibility_config = 26;</code>
     * @param \Google\Cloud\Container\V1\IntraNodeVisibilityConfig $var
     * @return $this
     */
    public function setDesiredIntraNodeVisibilityConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\IntraNodeVisibilityConfig::class);
        $this->desired_intra_node_visibility_config = $var;

        return $this;
    }

    /**
     * The desired status of whether to disable default sNAT for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     * @return \Google\Cloud\Container\V1\DefaultSnatStatus|null
     */
    public function getDesiredDefaultSnatStatus()
    {
        return isset($this->desired_default_snat_status) ? $this->desired_default_snat_status : null;
    }

    public function hasDesiredDefaultSnatStatus()
    {
        return isset($this->desired_default_snat_status);
    }

    public function clearDesiredDefaultSnatStatus()
    {
        unset($this->desired_default_snat_status);
    }

    /**
     * The desired status of whether to disable default sNAT for this cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.DefaultSnatStatus desired_default_snat_status = 28;</code>
     * @param \Google\Cloud\Container\V1\DefaultSnatStatus $var
     * @return $this
     */
    public function setDesiredDefaultSnatStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\DefaultSnatStatus::class);
        $this->desired_default_snat_status = $var;

        return $this;
    }

    /**
     * The desired release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
     * @return \Google\Cloud\Container\V1\ReleaseChannel|null
     */
    public function getDesiredReleaseChannel()
    {
        return isset($this->desired_release_channel) ? $this->desired_release_channel : null;
    }

    public function hasDesiredReleaseChannel()
    {
        return isset($this->desired_release_channel);
    }

    public function clearDesiredReleaseChannel()
    {
        unset($this->desired_release_channel);
    }

    /**
     * The desired release channel configuration.
     *
     * Generated from protobuf field <code>.google.container.v1.ReleaseChannel desired_release_channel = 31;</code>
     * @param \Google\Cloud\Container\V1\ReleaseChannel $var
     * @return $this
     */
    public function setDesiredReleaseChannel($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\ReleaseChannel::class);
        $this->desired_release_channel = $var;

        return $this;
    }

    /**
     * The desired authenticator groups config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;</code>
     * @return \Google\Cloud\Container\V1\AuthenticatorGroupsConfig|null
     */
    public function getDesiredAuthenticatorGroupsConfig()
    {
        return isset($this->desired_authenticator_groups_config) ? $this->desired_authenticator_groups_config : null;
    }

    public function hasDesiredAuthenticatorGroupsConfig()
    {
        return isset($this->desired_authenticator_groups_config);
    }

    public function clearDesiredAuthenticatorGroupsConfig()
    {
        unset($this->desired_authenticator_groups_config);
    }

    /**
     * The desired authenticator groups config for the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AuthenticatorGroupsConfig desired_authenticator_groups_config = 63;</code>
     * @param \Google\Cloud\Container\V1\AuthenticatorGroupsConfig $var
     * @return $this
     */
    public function setDesiredAuthenticatorGroupsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AuthenticatorGroupsConfig::class);
        $this->desired_authenticator_groups_config = $var;

        return $this;
    }

    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     * @return string
     */
    public function getDesiredMasterVersion()
    {
        return $this->desired_master_version;
    }

    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredMasterVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_master_version = $var;

        return $this;
    }

}

