<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents an SSL Certificate resource.
 * Google Compute Engine has two SSL Certificate resources:
 * * [Global](/compute/docs/reference/rest/{$api_version}/sslCertificates) * [Regional](https://cloud.google.com/compute/docs/reference/rest/{$api_version}/regionSslCertificates)
 * The sslCertificates are used by:
 * - external HTTPS load balancers
 * - SSL proxy load balancers
 * The regionSslCertificates are used by internal HTTPS load balancers.
 * Optionally, certificate file contents that you upload can contain a set of up to five PEM-encoded certificates. The API call creates an object (sslCertificate) that holds this data. You can use SSL keys and certificates to secure connections to a load balancer. For more information, read  Creating and using SSL certificates, SSL certificates quotas and limits, and  Troubleshooting SSL certificates. (== resource_for {$api_version}.sslCertificates ==) (== resource_for {$api_version}.regionSslCertificates ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.SslCertificate</code>
 */
class SslCertificate extends \Google\Protobuf\Internal\Message
{
    /**
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     *
     * Generated from protobuf field <code>string certificate = 341787031;</code>
     */
    private $certificate = null;
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = null;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 422937596;</code>
     */
    private $description = null;
    /**
     * [Output Only] Expire time of the certificate. RFC3339
     *
     * Generated from protobuf field <code>string expire_time = 440691181;</code>
     */
    private $expire_time = null;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>uint64 id = 3355;</code>
     */
    private $id = null;
    /**
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = null;
    /**
     * Configuration and status of a managed SSL certificate.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;</code>
     */
    private $managed = null;
    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = null;
    /**
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     *
     * Generated from protobuf field <code>string private_key = 361331107;</code>
     */
    private $private_key = null;
    /**
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     */
    private $region = null;
    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 456214797;</code>
     */
    private $self_link = null;
    /**
     * Configuration and status of a self-managed SSL certificate.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;</code>
     */
    private $self_managed = null;
    /**
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     *
     * Generated from protobuf field <code>repeated string subject_alternative_names = 528807907;</code>
     */
    private $subject_alternative_names;
    /**
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificate.Type type = 3575610;</code>
     */
    private $type = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $certificate
     *           A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type string $expire_time
     *           [Output Only] Expire time of the certificate. RFC3339
     *     @type int|string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     *     @type \Google\Cloud\Compute\V1\SslCertificateManagedSslCertificate $managed
     *           Configuration and status of a managed SSL certificate.
     *     @type string $name
     *           Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $private_key
     *           A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     *     @type string $region
     *           [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     *     @type string $self_link
     *           [Output only] Server-defined URL for the resource.
     *     @type \Google\Cloud\Compute\V1\SslCertificateSelfManagedSslCertificate $self_managed
     *           Configuration and status of a self-managed SSL certificate.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $subject_alternative_names
     *           [Output Only] Domains associated with the certificate via Subject Alternative Name.
     *     @type int $type
     *           (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     *
     * Generated from protobuf field <code>string certificate = 341787031;</code>
     * @return string
     */
    public function getCertificate()
    {
        return isset($this->certificate) ? $this->certificate : '';
    }

    public function hasCertificate()
    {
        return isset($this->certificate);
    }

    public function clearCertificate()
    {
        unset($this->certificate);
    }

    /**
     * A value read into memory from a certificate file. The certificate file must be in PEM format. The certificate chain must be no greater than 5 certs long. The chain must include at least one intermediate cert.
     *
     * Generated from protobuf field <code>string certificate = 341787031;</code>
     * @param string $var
     * @return $this
     */
    public function setCertificate($var)
    {
        GPBUtil::checkString($var, True);
        $this->certificate = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return isset($this->creation_timestamp) ? $this->creation_timestamp : '';
    }

    public function hasCreationTimestamp()
    {
        return isset($this->creation_timestamp);
    }

    public function clearCreationTimestamp()
    {
        unset($this->creation_timestamp);
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 422937596;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 422937596;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] Expire time of the certificate. RFC3339
     *
     * Generated from protobuf field <code>string expire_time = 440691181;</code>
     * @return string
     */
    public function getExpireTime()
    {
        return isset($this->expire_time) ? $this->expire_time : '';
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * [Output Only] Expire time of the certificate. RFC3339
     *
     * Generated from protobuf field <code>string expire_time = 440691181;</code>
     * @param string $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkString($var, True);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>uint64 id = 3355;</code>
     * @return int|string
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : 0;
    }

    public function hasId()
    {
        return isset($this->id);
    }

    public function clearId()
    {
        unset($this->id);
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>uint64 id = 3355;</code>
     * @param int|string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkUint64($var);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return isset($this->kind) ? $this->kind : '';
    }

    public function hasKind()
    {
        return isset($this->kind);
    }

    public function clearKind()
    {
        unset($this->kind);
    }

    /**
     * [Output Only] Type of the resource. Always compute#sslCertificate for SSL certificates.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Configuration and status of a managed SSL certificate.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;</code>
     * @return \Google\Cloud\Compute\V1\SslCertificateManagedSslCertificate|null
     */
    public function getManaged()
    {
        return isset($this->managed) ? $this->managed : null;
    }

    public function hasManaged()
    {
        return isset($this->managed);
    }

    public function clearManaged()
    {
        unset($this->managed);
    }

    /**
     * Configuration and status of a managed SSL certificate.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificateManagedSslCertificate managed = 298389407;</code>
     * @param \Google\Cloud\Compute\V1\SslCertificateManagedSslCertificate $var
     * @return $this
     */
    public function setManaged($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\SslCertificateManagedSslCertificate::class);
        $this->managed = $var;

        return $this;
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : '';
    }

    public function hasName()
    {
        return isset($this->name);
    }

    public function clearName()
    {
        unset($this->name);
    }

    /**
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     *
     * Generated from protobuf field <code>string private_key = 361331107;</code>
     * @return string
     */
    public function getPrivateKey()
    {
        return isset($this->private_key) ? $this->private_key : '';
    }

    public function hasPrivateKey()
    {
        return isset($this->private_key);
    }

    public function clearPrivateKey()
    {
        unset($this->private_key);
    }

    /**
     * A value read into memory from a write-only private key file. The private key file must be in PEM format. For security, only insert requests include this field.
     *
     * Generated from protobuf field <code>string private_key = 361331107;</code>
     * @param string $var
     * @return $this
     */
    public function setPrivateKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->private_key = $var;

        return $this;
    }

    /**
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return isset($this->region) ? $this->region : '';
    }

    public function hasRegion()
    {
        return isset($this->region);
    }

    public function clearRegion()
    {
        unset($this->region);
    }

    /**
     * [Output Only] URL of the region where the regional SSL Certificate resides. This field is not applicable to global SSL Certificate.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 456214797;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return isset($this->self_link) ? $this->self_link : '';
    }

    public function hasSelfLink()
    {
        return isset($this->self_link);
    }

    public function clearSelfLink()
    {
        unset($this->self_link);
    }

    /**
     * [Output only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 456214797;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Configuration and status of a self-managed SSL certificate.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;</code>
     * @return \Google\Cloud\Compute\V1\SslCertificateSelfManagedSslCertificate|null
     */
    public function getSelfManaged()
    {
        return isset($this->self_managed) ? $this->self_managed : null;
    }

    public function hasSelfManaged()
    {
        return isset($this->self_managed);
    }

    public function clearSelfManaged()
    {
        unset($this->self_managed);
    }

    /**
     * Configuration and status of a self-managed SSL certificate.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificateSelfManagedSslCertificate self_managed = 329284012;</code>
     * @param \Google\Cloud\Compute\V1\SslCertificateSelfManagedSslCertificate $var
     * @return $this
     */
    public function setSelfManaged($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\SslCertificateSelfManagedSslCertificate::class);
        $this->self_managed = $var;

        return $this;
    }

    /**
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     *
     * Generated from protobuf field <code>repeated string subject_alternative_names = 528807907;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSubjectAlternativeNames()
    {
        return $this->subject_alternative_names;
    }

    /**
     * [Output Only] Domains associated with the certificate via Subject Alternative Name.
     *
     * Generated from protobuf field <code>repeated string subject_alternative_names = 528807907;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSubjectAlternativeNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->subject_alternative_names = $arr;

        return $this;
    }

    /**
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificate.Type type = 3575610;</code>
     * @return int
     */
    public function getType()
    {
        return isset($this->type) ? $this->type : 0;
    }

    public function hasType()
    {
        return isset($this->type);
    }

    public function clearType()
    {
        unset($this->type);
    }

    /**
     * (Optional) Specifies the type of SSL certificate, either "SELF_MANAGED" or "MANAGED". If not specified, the certificate is self-managed and the fields certificate and private_key are used.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.SslCertificate.Type type = 3575610;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\SslCertificate\Type::class);
        $this->type = $var;

        return $this;
    }

}

