<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/study.proto

namespace Google\Cloud\AIPlatform\V1\StudySpec;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for ConvexAutomatedStoppingSpec.
 * When there are enough completed trials (configured by
 * min_measurement_count), for pending trials with enough measurements and
 * steps, the policy first computes an overestimate of the objective value at
 * max_num_steps according to the slope of the incomplete objective value
 * curve. No prediction can be made if the curve is completely flat. If the
 * overestimation is worse than the best objective value of the completed
 * trials, this pending trial will be early-stopped, but a last measurement
 * will be added to the pending trial with max_num_steps and predicted
 * objective value from the autoregression model.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec</code>
 */
class ConvexAutomatedStoppingSpec extends \Google\Protobuf\Internal\Message
{
    /**
     * Steps used in predicting the final objective for early stopped trials. In
     * general, it's set to be the same as the defined steps in training /
     * tuning. If not defined, it will learn it from the completed trials. When
     * use_steps is false, this field is set to the maximum elapsed seconds.
     *
     * Generated from protobuf field <code>int64 max_step_count = 1;</code>
     */
    private $max_step_count = 0;
    /**
     * Minimum number of steps for a trial to complete. Trials which do not have
     * a measurement with step_count > min_step_count won't be considered for
     * early stopping. It's ok to set it to 0, and a trial can be early stopped
     * at any stage. By default, min_step_count is set to be one-tenth of the
     * max_step_count.
     * When use_elapsed_duration is true, this field is set to the minimum
     * elapsed seconds.
     *
     * Generated from protobuf field <code>int64 min_step_count = 2;</code>
     */
    private $min_step_count = 0;
    /**
     * The minimal number of measurements in a Trial.  Early-stopping checks
     * will not trigger if less than min_measurement_count+1 completed trials or
     * pending trials with less than min_measurement_count measurements. If not
     * defined, the default value is 5.
     *
     * Generated from protobuf field <code>int64 min_measurement_count = 3;</code>
     */
    private $min_measurement_count = 0;
    /**
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     *
     * Generated from protobuf field <code>string learning_rate_parameter_name = 4;</code>
     */
    private $learning_rate_parameter_name = '';
    /**
     * This bool determines whether or not the rule is applied based on
     * elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
     * decision is made according to the predicted objective values according to
     * the target steps. If use_elapsed_duration==true, elapsed_secs is used
     * instead of steps. Also, in this case, the parameters max_num_steps and
     * min_num_steps are overloaded to contain max_elapsed_seconds and
     * min_elapsed_seconds.
     *
     * Generated from protobuf field <code>bool use_elapsed_duration = 5;</code>
     */
    private $use_elapsed_duration = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $max_step_count
     *           Steps used in predicting the final objective for early stopped trials. In
     *           general, it's set to be the same as the defined steps in training /
     *           tuning. If not defined, it will learn it from the completed trials. When
     *           use_steps is false, this field is set to the maximum elapsed seconds.
     *     @type int|string $min_step_count
     *           Minimum number of steps for a trial to complete. Trials which do not have
     *           a measurement with step_count > min_step_count won't be considered for
     *           early stopping. It's ok to set it to 0, and a trial can be early stopped
     *           at any stage. By default, min_step_count is set to be one-tenth of the
     *           max_step_count.
     *           When use_elapsed_duration is true, this field is set to the minimum
     *           elapsed seconds.
     *     @type int|string $min_measurement_count
     *           The minimal number of measurements in a Trial.  Early-stopping checks
     *           will not trigger if less than min_measurement_count+1 completed trials or
     *           pending trials with less than min_measurement_count measurements. If not
     *           defined, the default value is 5.
     *     @type string $learning_rate_parameter_name
     *           The hyper-parameter name used in the tuning job that stands for learning
     *           rate. Leave it blank if learning rate is not in a parameter in tuning.
     *           The learning_rate is used to estimate the objective value of the ongoing
     *           trial.
     *     @type bool $use_elapsed_duration
     *           This bool determines whether or not the rule is applied based on
     *           elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
     *           decision is made according to the predicted objective values according to
     *           the target steps. If use_elapsed_duration==true, elapsed_secs is used
     *           instead of steps. Also, in this case, the parameters max_num_steps and
     *           min_num_steps are overloaded to contain max_elapsed_seconds and
     *           min_elapsed_seconds.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\Study::initOnce();
        parent::__construct($data);
    }

    /**
     * Steps used in predicting the final objective for early stopped trials. In
     * general, it's set to be the same as the defined steps in training /
     * tuning. If not defined, it will learn it from the completed trials. When
     * use_steps is false, this field is set to the maximum elapsed seconds.
     *
     * Generated from protobuf field <code>int64 max_step_count = 1;</code>
     * @return int|string
     */
    public function getMaxStepCount()
    {
        return $this->max_step_count;
    }

    /**
     * Steps used in predicting the final objective for early stopped trials. In
     * general, it's set to be the same as the defined steps in training /
     * tuning. If not defined, it will learn it from the completed trials. When
     * use_steps is false, this field is set to the maximum elapsed seconds.
     *
     * Generated from protobuf field <code>int64 max_step_count = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMaxStepCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->max_step_count = $var;

        return $this;
    }

    /**
     * Minimum number of steps for a trial to complete. Trials which do not have
     * a measurement with step_count > min_step_count won't be considered for
     * early stopping. It's ok to set it to 0, and a trial can be early stopped
     * at any stage. By default, min_step_count is set to be one-tenth of the
     * max_step_count.
     * When use_elapsed_duration is true, this field is set to the minimum
     * elapsed seconds.
     *
     * Generated from protobuf field <code>int64 min_step_count = 2;</code>
     * @return int|string
     */
    public function getMinStepCount()
    {
        return $this->min_step_count;
    }

    /**
     * Minimum number of steps for a trial to complete. Trials which do not have
     * a measurement with step_count > min_step_count won't be considered for
     * early stopping. It's ok to set it to 0, and a trial can be early stopped
     * at any stage. By default, min_step_count is set to be one-tenth of the
     * max_step_count.
     * When use_elapsed_duration is true, this field is set to the minimum
     * elapsed seconds.
     *
     * Generated from protobuf field <code>int64 min_step_count = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMinStepCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->min_step_count = $var;

        return $this;
    }

    /**
     * The minimal number of measurements in a Trial.  Early-stopping checks
     * will not trigger if less than min_measurement_count+1 completed trials or
     * pending trials with less than min_measurement_count measurements. If not
     * defined, the default value is 5.
     *
     * Generated from protobuf field <code>int64 min_measurement_count = 3;</code>
     * @return int|string
     */
    public function getMinMeasurementCount()
    {
        return $this->min_measurement_count;
    }

    /**
     * The minimal number of measurements in a Trial.  Early-stopping checks
     * will not trigger if less than min_measurement_count+1 completed trials or
     * pending trials with less than min_measurement_count measurements. If not
     * defined, the default value is 5.
     *
     * Generated from protobuf field <code>int64 min_measurement_count = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMinMeasurementCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->min_measurement_count = $var;

        return $this;
    }

    /**
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     *
     * Generated from protobuf field <code>string learning_rate_parameter_name = 4;</code>
     * @return string
     */
    public function getLearningRateParameterName()
    {
        return $this->learning_rate_parameter_name;
    }

    /**
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     *
     * Generated from protobuf field <code>string learning_rate_parameter_name = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setLearningRateParameterName($var)
    {
        GPBUtil::checkString($var, True);
        $this->learning_rate_parameter_name = $var;

        return $this;
    }

    /**
     * This bool determines whether or not the rule is applied based on
     * elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
     * decision is made according to the predicted objective values according to
     * the target steps. If use_elapsed_duration==true, elapsed_secs is used
     * instead of steps. Also, in this case, the parameters max_num_steps and
     * min_num_steps are overloaded to contain max_elapsed_seconds and
     * min_elapsed_seconds.
     *
     * Generated from protobuf field <code>bool use_elapsed_duration = 5;</code>
     * @return bool
     */
    public function getUseElapsedDuration()
    {
        return $this->use_elapsed_duration;
    }

    /**
     * This bool determines whether or not the rule is applied based on
     * elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
     * decision is made according to the predicted objective values according to
     * the target steps. If use_elapsed_duration==true, elapsed_secs is used
     * instead of steps. Also, in this case, the parameters max_num_steps and
     * min_num_steps are overloaded to contain max_elapsed_seconds and
     * min_elapsed_seconds.
     *
     * Generated from protobuf field <code>bool use_elapsed_duration = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setUseElapsedDuration($var)
    {
        GPBUtil::checkBool($var);
        $this->use_elapsed_duration = $var;

        return $this;
    }

}


