<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/aiplatform/v1/model_deployment_monitoring_job.proto

namespace Google\Cloud\AIPlatform\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a job that runs periodically to monitor the deployed models in an
 * endpoint. It will analyze the logged training & prediction data to detect any
 * abnormal behaviors.
 *
 * Generated from protobuf message <code>google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob</code>
 */
class ModelDeploymentMonitoringJob extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Resource name of a ModelDeploymentMonitoringJob.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Required. The user-defined name of the ModelDeploymentMonitoringJob.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * Display name of a ModelDeploymentMonitoringJob.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $display_name = '';
    /**
     * Required. Endpoint resource name.
     * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *
     * Generated from protobuf field <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $endpoint = '';
    /**
     * Output only. The detailed state of the monitoring job.
     * When the job is still creating, the state will be 'PENDING'.
     * Once the job is successfully created, the state will be 'RUNNING'.
     * Pause the job, the state will be 'PAUSED'.
     * Resume the job, the state will return to 'RUNNING'.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Output only. Schedule state when the monitoring job is in Running state.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $schedule_state = 0;
    /**
     * Output only. Latest triggered monitoring pipeline metadata.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.LatestMonitoringPipelineMetadata latest_monitoring_pipeline_metadata = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $latest_monitoring_pipeline_metadata = null;
    /**
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $model_deployment_monitoring_objective_configs;
    /**
     * Required. Schedule config for running the monitoring job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $model_deployment_monitoring_schedule_config = null;
    /**
     * Required. Sample Strategy for logging.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $logging_sampling_strategy = null;
    /**
     * Alert config for model monitoring.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;</code>
     */
    private $model_monitoring_alert_config = null;
    /**
     * YAML schema file uri describing the format of a single instance,
     * which are given to format this Endpoint's prediction (and explanation).
     * If not set, we will generate predict schema from collected predict
     * requests.
     *
     * Generated from protobuf field <code>string predict_instance_schema_uri = 9;</code>
     */
    private $predict_instance_schema_uri = '';
    /**
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     */
    private $sample_predict_instance = null;
    /**
     * YAML schema file uri describing the format of a single instance that you
     * want Tensorflow Data Validation (TFDV) to analyze.
     * If this field is empty, all the feature data types are inferred from
     * [predict_instance_schema_uri][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     * meaning that TFDV will use the data in the exact format(data type) as
     * prediction request/response.
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     *
     * Generated from protobuf field <code>string analysis_instance_schema_uri = 16;</code>
     */
    private $analysis_instance_schema_uri = '';
    /**
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query & analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $bigquery_tables;
    /**
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration log_ttl = 17;</code>
     */
    private $log_ttl = null;
    /**
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11;</code>
     */
    private $labels;
    /**
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $next_schedule_time = null;
    /**
     * Stats anomalies base folder path.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination stats_anomalies_base_directory = 20;</code>
     */
    private $stats_anomalies_base_directory = null;
    /**
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 21;</code>
     */
    private $encryption_spec = null;
    /**
     * If true, the scheduled monitoring pipeline logs are sent to
     * Google Cloud Logging, including pipeline status and anomalies detected.
     * Please note the logs incur cost, which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging#pricing).
     *
     * Generated from protobuf field <code>bool enable_monitoring_pipeline_logs = 22;</code>
     */
    private $enable_monitoring_pipeline_logs = false;
    /**
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $error = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Resource name of a ModelDeploymentMonitoringJob.
     *     @type string $display_name
     *           Required. The user-defined name of the ModelDeploymentMonitoringJob.
     *           The name can be up to 128 characters long and can consist of any UTF-8
     *           characters.
     *           Display name of a ModelDeploymentMonitoringJob.
     *     @type string $endpoint
     *           Required. Endpoint resource name.
     *           Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *     @type int $state
     *           Output only. The detailed state of the monitoring job.
     *           When the job is still creating, the state will be 'PENDING'.
     *           Once the job is successfully created, the state will be 'RUNNING'.
     *           Pause the job, the state will be 'PAUSED'.
     *           Resume the job, the state will return to 'RUNNING'.
     *     @type int $schedule_state
     *           Output only. Schedule state when the monitoring job is in Running state.
     *     @type \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringJob\LatestMonitoringPipelineMetadata $latest_monitoring_pipeline_metadata
     *           Output only. Latest triggered monitoring pipeline metadata.
     *     @type array<\Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringObjectiveConfig>|\Google\Protobuf\Internal\RepeatedField $model_deployment_monitoring_objective_configs
     *           Required. The config for monitoring objectives. This is a per DeployedModel config.
     *           Each DeployedModel needs to be configured separately.
     *     @type \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringScheduleConfig $model_deployment_monitoring_schedule_config
     *           Required. Schedule config for running the monitoring job.
     *     @type \Google\Cloud\AIPlatform\V1\SamplingStrategy $logging_sampling_strategy
     *           Required. Sample Strategy for logging.
     *     @type \Google\Cloud\AIPlatform\V1\ModelMonitoringAlertConfig $model_monitoring_alert_config
     *           Alert config for model monitoring.
     *     @type string $predict_instance_schema_uri
     *           YAML schema file uri describing the format of a single instance,
     *           which are given to format this Endpoint's prediction (and explanation).
     *           If not set, we will generate predict schema from collected predict
     *           requests.
     *     @type \Google\Protobuf\Value $sample_predict_instance
     *           Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1.PredictRequest.instances],
     *           this can be set as a replacement of
     *           [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     *           we will generate predict schema from collected predict requests.
     *     @type string $analysis_instance_schema_uri
     *           YAML schema file uri describing the format of a single instance that you
     *           want Tensorflow Data Validation (TFDV) to analyze.
     *           If this field is empty, all the feature data types are inferred from
     *           [predict_instance_schema_uri][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     *           meaning that TFDV will use the data in the exact format(data type) as
     *           prediction request/response.
     *           If there are any data type differences between predict instance and TFDV
     *           instance, this field can be used to override the schema.
     *           For models trained with Vertex AI, this field must be set as all the
     *           fields in predict instance formatted as string.
     *     @type array<\Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringBigQueryTable>|\Google\Protobuf\Internal\RepeatedField $bigquery_tables
     *           Output only. The created bigquery tables for the job under customer project. Customer
     *           could do their own query & analysis. There could be 4 log tables in
     *           maximum:
     *           1. Training data logging predict request/response
     *           2. Serving data logging predict request/response
     *     @type \Google\Protobuf\Duration $log_ttl
     *           The TTL of BigQuery tables in user projects which stores logs.
     *           A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     *           day). e.g. { second: 3600} indicates ttl = 1 day.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           The labels with user-defined metadata to organize your
     *           ModelDeploymentMonitoringJob.
     *           Label keys and values can be no longer than 64 characters
     *           (Unicode codepoints), can only contain lowercase letters, numeric
     *           characters, underscores and dashes. International characters are allowed.
     *           See https://goo.gl/xmQnxf for more information and examples of labels.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     *     @type \Google\Protobuf\Timestamp $next_schedule_time
     *           Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     *           next round.
     *     @type \Google\Cloud\AIPlatform\V1\GcsDestination $stats_anomalies_base_directory
     *           Stats anomalies base folder path.
     *     @type \Google\Cloud\AIPlatform\V1\EncryptionSpec $encryption_spec
     *           Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     *           set, this ModelDeploymentMonitoringJob and all sub-resources of this
     *           ModelDeploymentMonitoringJob will be secured by this key.
     *     @type bool $enable_monitoring_pipeline_logs
     *           If true, the scheduled monitoring pipeline logs are sent to
     *           Google Cloud Logging, including pipeline status and anomalies detected.
     *           Please note the logs incur cost, which are subject to [Cloud Logging
     *           pricing](https://cloud.google.com/logging#pricing).
     *     @type \Google\Rpc\Status $error
     *           Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     *           `JOB_STATE_CANCELLED`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Aiplatform\V1\ModelDeploymentMonitoringJob::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Resource name of a ModelDeploymentMonitoringJob.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Resource name of a ModelDeploymentMonitoringJob.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The user-defined name of the ModelDeploymentMonitoringJob.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * Display name of a ModelDeploymentMonitoringJob.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The user-defined name of the ModelDeploymentMonitoringJob.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * Display name of a ModelDeploymentMonitoringJob.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Required. Endpoint resource name.
     * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *
     * Generated from protobuf field <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * Required. Endpoint resource name.
     * Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
     *
     * Generated from protobuf field <code>string endpoint = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint = $var;

        return $this;
    }

    /**
     * Output only. The detailed state of the monitoring job.
     * When the job is still creating, the state will be 'PENDING'.
     * Once the job is successfully created, the state will be 'RUNNING'.
     * Pause the job, the state will be 'PAUSED'.
     * Resume the job, the state will return to 'RUNNING'.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. The detailed state of the monitoring job.
     * When the job is still creating, the state will be 'PENDING'.
     * Once the job is successfully created, the state will be 'RUNNING'.
     * Pause the job, the state will be 'PAUSED'.
     * Resume the job, the state will return to 'RUNNING'.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.JobState state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AIPlatform\V1\JobState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. Schedule state when the monitoring job is in Running state.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getScheduleState()
    {
        return $this->schedule_state;
    }

    /**
     * Output only. Schedule state when the monitoring job is in Running state.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.MonitoringScheduleState schedule_state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setScheduleState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringJob\MonitoringScheduleState::class);
        $this->schedule_state = $var;

        return $this;
    }

    /**
     * Output only. Latest triggered monitoring pipeline metadata.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.LatestMonitoringPipelineMetadata latest_monitoring_pipeline_metadata = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringJob\LatestMonitoringPipelineMetadata|null
     */
    public function getLatestMonitoringPipelineMetadata()
    {
        return $this->latest_monitoring_pipeline_metadata;
    }

    public function hasLatestMonitoringPipelineMetadata()
    {
        return isset($this->latest_monitoring_pipeline_metadata);
    }

    public function clearLatestMonitoringPipelineMetadata()
    {
        unset($this->latest_monitoring_pipeline_metadata);
    }

    /**
     * Output only. Latest triggered monitoring pipeline metadata.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.LatestMonitoringPipelineMetadata latest_monitoring_pipeline_metadata = 25 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringJob\LatestMonitoringPipelineMetadata $var
     * @return $this
     */
    public function setLatestMonitoringPipelineMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringJob\LatestMonitoringPipelineMetadata::class);
        $this->latest_monitoring_pipeline_metadata = $var;

        return $this;
    }

    /**
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getModelDeploymentMonitoringObjectiveConfigs()
    {
        return $this->model_deployment_monitoring_objective_configs;
    }

    /**
     * Required. The config for monitoring objectives. This is a per DeployedModel config.
     * Each DeployedModel needs to be configured separately.
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.ModelDeploymentMonitoringObjectiveConfig model_deployment_monitoring_objective_configs = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringObjectiveConfig>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setModelDeploymentMonitoringObjectiveConfigs($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringObjectiveConfig::class);
        $this->model_deployment_monitoring_objective_configs = $arr;

        return $this;
    }

    /**
     * Required. Schedule config for running the monitoring job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringScheduleConfig|null
     */
    public function getModelDeploymentMonitoringScheduleConfig()
    {
        return $this->model_deployment_monitoring_schedule_config;
    }

    public function hasModelDeploymentMonitoringScheduleConfig()
    {
        return isset($this->model_deployment_monitoring_schedule_config);
    }

    public function clearModelDeploymentMonitoringScheduleConfig()
    {
        unset($this->model_deployment_monitoring_schedule_config);
    }

    /**
     * Required. Schedule config for running the monitoring job.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelDeploymentMonitoringScheduleConfig model_deployment_monitoring_schedule_config = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringScheduleConfig $var
     * @return $this
     */
    public function setModelDeploymentMonitoringScheduleConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringScheduleConfig::class);
        $this->model_deployment_monitoring_schedule_config = $var;

        return $this;
    }

    /**
     * Required. Sample Strategy for logging.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\AIPlatform\V1\SamplingStrategy|null
     */
    public function getLoggingSamplingStrategy()
    {
        return $this->logging_sampling_strategy;
    }

    public function hasLoggingSamplingStrategy()
    {
        return isset($this->logging_sampling_strategy);
    }

    public function clearLoggingSamplingStrategy()
    {
        unset($this->logging_sampling_strategy);
    }

    /**
     * Required. Sample Strategy for logging.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.SamplingStrategy logging_sampling_strategy = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\AIPlatform\V1\SamplingStrategy $var
     * @return $this
     */
    public function setLoggingSamplingStrategy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\SamplingStrategy::class);
        $this->logging_sampling_strategy = $var;

        return $this;
    }

    /**
     * Alert config for model monitoring.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;</code>
     * @return \Google\Cloud\AIPlatform\V1\ModelMonitoringAlertConfig|null
     */
    public function getModelMonitoringAlertConfig()
    {
        return $this->model_monitoring_alert_config;
    }

    public function hasModelMonitoringAlertConfig()
    {
        return isset($this->model_monitoring_alert_config);
    }

    public function clearModelMonitoringAlertConfig()
    {
        unset($this->model_monitoring_alert_config);
    }

    /**
     * Alert config for model monitoring.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.ModelMonitoringAlertConfig model_monitoring_alert_config = 15;</code>
     * @param \Google\Cloud\AIPlatform\V1\ModelMonitoringAlertConfig $var
     * @return $this
     */
    public function setModelMonitoringAlertConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\ModelMonitoringAlertConfig::class);
        $this->model_monitoring_alert_config = $var;

        return $this;
    }

    /**
     * YAML schema file uri describing the format of a single instance,
     * which are given to format this Endpoint's prediction (and explanation).
     * If not set, we will generate predict schema from collected predict
     * requests.
     *
     * Generated from protobuf field <code>string predict_instance_schema_uri = 9;</code>
     * @return string
     */
    public function getPredictInstanceSchemaUri()
    {
        return $this->predict_instance_schema_uri;
    }

    /**
     * YAML schema file uri describing the format of a single instance,
     * which are given to format this Endpoint's prediction (and explanation).
     * If not set, we will generate predict schema from collected predict
     * requests.
     *
     * Generated from protobuf field <code>string predict_instance_schema_uri = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setPredictInstanceSchemaUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->predict_instance_schema_uri = $var;

        return $this;
    }

    /**
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     * @return \Google\Protobuf\Value|null
     */
    public function getSamplePredictInstance()
    {
        return $this->sample_predict_instance;
    }

    public function hasSamplePredictInstance()
    {
        return isset($this->sample_predict_instance);
    }

    public function clearSamplePredictInstance()
    {
        unset($this->sample_predict_instance);
    }

    /**
     * Sample Predict instance, same format as [PredictRequest.instances][google.cloud.aiplatform.v1.PredictRequest.instances],
     * this can be set as a replacement of
     * [ModelDeploymentMonitoringJob.predict_instance_schema_uri][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.predict_instance_schema_uri]. If not set,
     * we will generate predict schema from collected predict requests.
     *
     * Generated from protobuf field <code>.google.protobuf.Value sample_predict_instance = 19;</code>
     * @param \Google\Protobuf\Value $var
     * @return $this
     */
    public function setSamplePredictInstance($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Value::class);
        $this->sample_predict_instance = $var;

        return $this;
    }

    /**
     * YAML schema file uri describing the format of a single instance that you
     * want Tensorflow Data Validation (TFDV) to analyze.
     * If this field is empty, all the feature data types are inferred from
     * [predict_instance_schema_uri][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     * meaning that TFDV will use the data in the exact format(data type) as
     * prediction request/response.
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     *
     * Generated from protobuf field <code>string analysis_instance_schema_uri = 16;</code>
     * @return string
     */
    public function getAnalysisInstanceSchemaUri()
    {
        return $this->analysis_instance_schema_uri;
    }

    /**
     * YAML schema file uri describing the format of a single instance that you
     * want Tensorflow Data Validation (TFDV) to analyze.
     * If this field is empty, all the feature data types are inferred from
     * [predict_instance_schema_uri][google.cloud.aiplatform.v1.ModelDeploymentMonitoringJob.predict_instance_schema_uri],
     * meaning that TFDV will use the data in the exact format(data type) as
     * prediction request/response.
     * If there are any data type differences between predict instance and TFDV
     * instance, this field can be used to override the schema.
     * For models trained with Vertex AI, this field must be set as all the
     * fields in predict instance formatted as string.
     *
     * Generated from protobuf field <code>string analysis_instance_schema_uri = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setAnalysisInstanceSchemaUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->analysis_instance_schema_uri = $var;

        return $this;
    }

    /**
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query & analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getBigqueryTables()
    {
        return $this->bigquery_tables;
    }

    /**
     * Output only. The created bigquery tables for the job under customer project. Customer
     * could do their own query & analysis. There could be 4 log tables in
     * maximum:
     * 1. Training data logging predict request/response
     * 2. Serving data logging predict request/response
     *
     * Generated from protobuf field <code>repeated .google.cloud.aiplatform.v1.ModelDeploymentMonitoringBigQueryTable bigquery_tables = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringBigQueryTable>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setBigqueryTables($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\AIPlatform\V1\ModelDeploymentMonitoringBigQueryTable::class);
        $this->bigquery_tables = $arr;

        return $this;
    }

    /**
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration log_ttl = 17;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getLogTtl()
    {
        return $this->log_ttl;
    }

    public function hasLogTtl()
    {
        return isset($this->log_ttl);
    }

    public function clearLogTtl()
    {
        unset($this->log_ttl);
    }

    /**
     * The TTL of BigQuery tables in user projects which stores logs.
     * A day is the basic unit of the TTL and we take the ceil of TTL/86400(a
     * day). e.g. { second: 3600} indicates ttl = 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration log_ttl = 17;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setLogTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->log_ttl = $var;

        return $this;
    }

    /**
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The labels with user-defined metadata to organize your
     * ModelDeploymentMonitoringJob.
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Timestamp when this ModelDeploymentMonitoringJob was updated most recently.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getNextScheduleTime()
    {
        return $this->next_schedule_time;
    }

    public function hasNextScheduleTime()
    {
        return isset($this->next_schedule_time);
    }

    public function clearNextScheduleTime()
    {
        unset($this->next_schedule_time);
    }

    /**
     * Output only. Timestamp when this monitoring pipeline will be scheduled to run for the
     * next round.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp next_schedule_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setNextScheduleTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->next_schedule_time = $var;

        return $this;
    }

    /**
     * Stats anomalies base folder path.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination stats_anomalies_base_directory = 20;</code>
     * @return \Google\Cloud\AIPlatform\V1\GcsDestination|null
     */
    public function getStatsAnomaliesBaseDirectory()
    {
        return $this->stats_anomalies_base_directory;
    }

    public function hasStatsAnomaliesBaseDirectory()
    {
        return isset($this->stats_anomalies_base_directory);
    }

    public function clearStatsAnomaliesBaseDirectory()
    {
        unset($this->stats_anomalies_base_directory);
    }

    /**
     * Stats anomalies base folder path.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.GcsDestination stats_anomalies_base_directory = 20;</code>
     * @param \Google\Cloud\AIPlatform\V1\GcsDestination $var
     * @return $this
     */
    public function setStatsAnomaliesBaseDirectory($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\GcsDestination::class);
        $this->stats_anomalies_base_directory = $var;

        return $this;
    }

    /**
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 21;</code>
     * @return \Google\Cloud\AIPlatform\V1\EncryptionSpec|null
     */
    public function getEncryptionSpec()
    {
        return $this->encryption_spec;
    }

    public function hasEncryptionSpec()
    {
        return isset($this->encryption_spec);
    }

    public function clearEncryptionSpec()
    {
        unset($this->encryption_spec);
    }

    /**
     * Customer-managed encryption key spec for a ModelDeploymentMonitoringJob. If
     * set, this ModelDeploymentMonitoringJob and all sub-resources of this
     * ModelDeploymentMonitoringJob will be secured by this key.
     *
     * Generated from protobuf field <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 21;</code>
     * @param \Google\Cloud\AIPlatform\V1\EncryptionSpec $var
     * @return $this
     */
    public function setEncryptionSpec($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AIPlatform\V1\EncryptionSpec::class);
        $this->encryption_spec = $var;

        return $this;
    }

    /**
     * If true, the scheduled monitoring pipeline logs are sent to
     * Google Cloud Logging, including pipeline status and anomalies detected.
     * Please note the logs incur cost, which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging#pricing).
     *
     * Generated from protobuf field <code>bool enable_monitoring_pipeline_logs = 22;</code>
     * @return bool
     */
    public function getEnableMonitoringPipelineLogs()
    {
        return $this->enable_monitoring_pipeline_logs;
    }

    /**
     * If true, the scheduled monitoring pipeline logs are sent to
     * Google Cloud Logging, including pipeline status and anomalies detected.
     * Please note the logs incur cost, which are subject to [Cloud Logging
     * pricing](https://cloud.google.com/logging#pricing).
     *
     * Generated from protobuf field <code>bool enable_monitoring_pipeline_logs = 22;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableMonitoringPipelineLogs($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_monitoring_pipeline_logs = $var;

        return $this;
    }

    /**
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getError()
    {
        return $this->error;
    }

    public function hasError()
    {
        return isset($this->error);
    }

    public function clearError()
    {
        unset($this->error);
    }

    /**
     * Output only. Only populated when the job's state is `JOB_STATE_FAILED` or
     * `JOB_STATE_CANCELLED`.
     *
     * Generated from protobuf field <code>.google.rpc.Status error = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setError($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->error = $var;

        return $this;
    }

}

