<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/optimization/v1/fleet_routing.proto

namespace Google\Cloud\Optimization\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Encapsulates a set of optional conditions to satisfy when calculating
 * vehicle routes. This is similar to `RouteModifiers` in the Google Maps
 * Platform API; see:
 * https://developers.google.com/maps/documentation/routes/reference/rest/v2/RouteModifiers.
 *
 * Generated from protobuf message <code>google.cloud.optimization.v1.RouteModifiers</code>
 */
class RouteModifiers extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies whether to avoid toll roads where reasonable. Preference will be
     * given to routes not containing toll roads. Applies only to motorized travel
     * modes.
     *
     * Generated from protobuf field <code>bool avoid_tolls = 2;</code>
     */
    private $avoid_tolls = false;
    /**
     * Specifies whether to avoid highways where reasonable. Preference will be
     * given to routes not containing highways. Applies only to motorized travel
     * modes.
     *
     * Generated from protobuf field <code>bool avoid_highways = 3;</code>
     */
    private $avoid_highways = false;
    /**
     * Specifies whether to avoid ferries where reasonable. Preference will be
     * given to routes not containing travel by ferries. Applies only to motorized
     * travel modes.
     *
     * Generated from protobuf field <code>bool avoid_ferries = 4;</code>
     */
    private $avoid_ferries = false;
    /**
     * Optional. Specifies whether to avoid navigating indoors where reasonable.
     * Preference will be given to routes not containing indoor navigation.
     * Applies only to the `WALKING` travel mode.
     *
     * Generated from protobuf field <code>bool avoid_indoor = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $avoid_indoor = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $avoid_tolls
     *           Specifies whether to avoid toll roads where reasonable. Preference will be
     *           given to routes not containing toll roads. Applies only to motorized travel
     *           modes.
     *     @type bool $avoid_highways
     *           Specifies whether to avoid highways where reasonable. Preference will be
     *           given to routes not containing highways. Applies only to motorized travel
     *           modes.
     *     @type bool $avoid_ferries
     *           Specifies whether to avoid ferries where reasonable. Preference will be
     *           given to routes not containing travel by ferries. Applies only to motorized
     *           travel modes.
     *     @type bool $avoid_indoor
     *           Optional. Specifies whether to avoid navigating indoors where reasonable.
     *           Preference will be given to routes not containing indoor navigation.
     *           Applies only to the `WALKING` travel mode.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Optimization\V1\FleetRouting::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies whether to avoid toll roads where reasonable. Preference will be
     * given to routes not containing toll roads. Applies only to motorized travel
     * modes.
     *
     * Generated from protobuf field <code>bool avoid_tolls = 2;</code>
     * @return bool
     */
    public function getAvoidTolls()
    {
        return $this->avoid_tolls;
    }

    /**
     * Specifies whether to avoid toll roads where reasonable. Preference will be
     * given to routes not containing toll roads. Applies only to motorized travel
     * modes.
     *
     * Generated from protobuf field <code>bool avoid_tolls = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setAvoidTolls($var)
    {
        GPBUtil::checkBool($var);
        $this->avoid_tolls = $var;

        return $this;
    }

    /**
     * Specifies whether to avoid highways where reasonable. Preference will be
     * given to routes not containing highways. Applies only to motorized travel
     * modes.
     *
     * Generated from protobuf field <code>bool avoid_highways = 3;</code>
     * @return bool
     */
    public function getAvoidHighways()
    {
        return $this->avoid_highways;
    }

    /**
     * Specifies whether to avoid highways where reasonable. Preference will be
     * given to routes not containing highways. Applies only to motorized travel
     * modes.
     *
     * Generated from protobuf field <code>bool avoid_highways = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setAvoidHighways($var)
    {
        GPBUtil::checkBool($var);
        $this->avoid_highways = $var;

        return $this;
    }

    /**
     * Specifies whether to avoid ferries where reasonable. Preference will be
     * given to routes not containing travel by ferries. Applies only to motorized
     * travel modes.
     *
     * Generated from protobuf field <code>bool avoid_ferries = 4;</code>
     * @return bool
     */
    public function getAvoidFerries()
    {
        return $this->avoid_ferries;
    }

    /**
     * Specifies whether to avoid ferries where reasonable. Preference will be
     * given to routes not containing travel by ferries. Applies only to motorized
     * travel modes.
     *
     * Generated from protobuf field <code>bool avoid_ferries = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setAvoidFerries($var)
    {
        GPBUtil::checkBool($var);
        $this->avoid_ferries = $var;

        return $this;
    }

    /**
     * Optional. Specifies whether to avoid navigating indoors where reasonable.
     * Preference will be given to routes not containing indoor navigation.
     * Applies only to the `WALKING` travel mode.
     *
     * Generated from protobuf field <code>bool avoid_indoor = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAvoidIndoor()
    {
        return $this->avoid_indoor;
    }

    /**
     * Optional. Specifies whether to avoid navigating indoors where reasonable.
     * Preference will be given to routes not containing indoor navigation.
     * Applies only to the `WALKING` travel mode.
     *
     * Generated from protobuf field <code>bool avoid_indoor = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAvoidIndoor($var)
    {
        GPBUtil::checkBool($var);
        $this->avoid_indoor = $var;

        return $this;
    }

}

