<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/entity_type.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Entities are extracted from user input and represent parameters that are
 * meaningful to your application. For example, a date range, a proper name
 * such as a geographic location or landmark, and so on. Entities represent
 * actionable data for your application.
 * When you define an entity, you can also include synonyms that all map to
 * that entity. For example, "soft drink", "soda", "pop", and so on.
 * There are three types of entities:
 * *   **System** - entities that are defined by the Dialogflow API for common
 *     data types such as date, time, currency, and so on. A system entity is
 *     represented by the `EntityType` type.
 * *   **Custom** - entities that are defined by you that represent
 *     actionable data that is meaningful to your application. For example,
 *     you could define a `pizza.sauce` entity for red or white pizza sauce,
 *     a `pizza.cheese` entity for the different types of cheese on a pizza,
 *     a `pizza.topping` entity for different toppings, and so on. A custom
 *     entity is represented by the `EntityType` type.
 * *   **User** - entities that are built for an individual user such as
 *     favorites, preferences, playlists, and so on. A user entity is
 *     represented by the
 *     [SessionEntityType][google.cloud.dialogflow.cx.v3.SessionEntityType]
 *     type.
 * For more information about entity types, see the [Dialogflow
 * documentation](https://cloud.google.com/dialogflow/docs/entities-overview).
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.EntityType</code>
 */
class EntityType extends \Google\Protobuf\Internal\Message
{
    /**
     * The unique identifier of the entity type.
     * Required for
     * [EntityTypes.UpdateEntityType][google.cloud.dialogflow.cx.v3.EntityTypes.UpdateEntityType].
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/entityTypes/<Entity Type ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. The human-readable name of the entity type, unique within the
     * agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Required. Indicates the kind of entity type.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $kind = 0;
    /**
     * Indicates whether the entity type can be automatically expanded.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.EntityType.AutoExpansionMode auto_expansion_mode = 4;</code>
     */
    protected $auto_expansion_mode = 0;
    /**
     * The collection of entity entries associated with the entity type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 5;</code>
     */
    private $entities;
    /**
     * Collection of exceptional words and phrases that shouldn't be matched.
     * For example, if you have a size entity type with entry `giant`(an
     * adjective), you might consider adding `giants`(a noun) as an exclusion.
     * If the kind of entity type is `KIND_MAP`, then the phrases specified by
     * entities and excluded phrases should be mutually exclusive.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.ExcludedPhrase excluded_phrases = 6;</code>
     */
    private $excluded_phrases;
    /**
     * Enables fuzzy entity extraction during classification.
     *
     * Generated from protobuf field <code>bool enable_fuzzy_extraction = 7;</code>
     */
    protected $enable_fuzzy_extraction = false;
    /**
     * Indicates whether parameters of the entity type should be redacted in log.
     * If redaction is enabled, page parameters and intent parameters referring to
     * the entity type will be replaced by parameter name when logging.
     *
     * Generated from protobuf field <code>bool redact = 9;</code>
     */
    protected $redact = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The unique identifier of the entity type.
     *           Required for
     *           [EntityTypes.UpdateEntityType][google.cloud.dialogflow.cx.v3.EntityTypes.UpdateEntityType].
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/entityTypes/<Entity Type ID>`.
     *     @type string $display_name
     *           Required. The human-readable name of the entity type, unique within the
     *           agent.
     *     @type int $kind
     *           Required. Indicates the kind of entity type.
     *     @type int $auto_expansion_mode
     *           Indicates whether the entity type can be automatically expanded.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\EntityType\Entity>|\Google\Protobuf\Internal\RepeatedField $entities
     *           The collection of entity entries associated with the entity type.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\EntityType\ExcludedPhrase>|\Google\Protobuf\Internal\RepeatedField $excluded_phrases
     *           Collection of exceptional words and phrases that shouldn't be matched.
     *           For example, if you have a size entity type with entry `giant`(an
     *           adjective), you might consider adding `giants`(a noun) as an exclusion.
     *           If the kind of entity type is `KIND_MAP`, then the phrases specified by
     *           entities and excluded phrases should be mutually exclusive.
     *     @type bool $enable_fuzzy_extraction
     *           Enables fuzzy entity extraction during classification.
     *     @type bool $redact
     *           Indicates whether parameters of the entity type should be redacted in log.
     *           If redaction is enabled, page parameters and intent parameters referring to
     *           the entity type will be replaced by parameter name when logging.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\EntityType::initOnce();
        parent::__construct($data);
    }

    /**
     * The unique identifier of the entity type.
     * Required for
     * [EntityTypes.UpdateEntityType][google.cloud.dialogflow.cx.v3.EntityTypes.UpdateEntityType].
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/entityTypes/<Entity Type ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The unique identifier of the entity type.
     * Required for
     * [EntityTypes.UpdateEntityType][google.cloud.dialogflow.cx.v3.EntityTypes.UpdateEntityType].
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/entityTypes/<Entity Type ID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The human-readable name of the entity type, unique within the
     * agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The human-readable name of the entity type, unique within the
     * agent.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Required. Indicates the kind of entity type.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * Required. Indicates the kind of entity type.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\EntityType\Kind::class);
        $this->kind = $var;

        return $this;
    }

    /**
     * Indicates whether the entity type can be automatically expanded.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.EntityType.AutoExpansionMode auto_expansion_mode = 4;</code>
     * @return int
     */
    public function getAutoExpansionMode()
    {
        return $this->auto_expansion_mode;
    }

    /**
     * Indicates whether the entity type can be automatically expanded.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.EntityType.AutoExpansionMode auto_expansion_mode = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setAutoExpansionMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\EntityType\AutoExpansionMode::class);
        $this->auto_expansion_mode = $var;

        return $this;
    }

    /**
     * The collection of entity entries associated with the entity type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEntities()
    {
        return $this->entities;
    }

    /**
     * The collection of entity entries associated with the entity type.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.Entity entities = 5;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\EntityType\Entity>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEntities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\EntityType\Entity::class);
        $this->entities = $arr;

        return $this;
    }

    /**
     * Collection of exceptional words and phrases that shouldn't be matched.
     * For example, if you have a size entity type with entry `giant`(an
     * adjective), you might consider adding `giants`(a noun) as an exclusion.
     * If the kind of entity type is `KIND_MAP`, then the phrases specified by
     * entities and excluded phrases should be mutually exclusive.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.ExcludedPhrase excluded_phrases = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludedPhrases()
    {
        return $this->excluded_phrases;
    }

    /**
     * Collection of exceptional words and phrases that shouldn't be matched.
     * For example, if you have a size entity type with entry `giant`(an
     * adjective), you might consider adding `giants`(a noun) as an exclusion.
     * If the kind of entity type is `KIND_MAP`, then the phrases specified by
     * entities and excluded phrases should be mutually exclusive.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.EntityType.ExcludedPhrase excluded_phrases = 6;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\EntityType\ExcludedPhrase>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludedPhrases($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\EntityType\ExcludedPhrase::class);
        $this->excluded_phrases = $arr;

        return $this;
    }

    /**
     * Enables fuzzy entity extraction during classification.
     *
     * Generated from protobuf field <code>bool enable_fuzzy_extraction = 7;</code>
     * @return bool
     */
    public function getEnableFuzzyExtraction()
    {
        return $this->enable_fuzzy_extraction;
    }

    /**
     * Enables fuzzy entity extraction during classification.
     *
     * Generated from protobuf field <code>bool enable_fuzzy_extraction = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableFuzzyExtraction($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_fuzzy_extraction = $var;

        return $this;
    }

    /**
     * Indicates whether parameters of the entity type should be redacted in log.
     * If redaction is enabled, page parameters and intent parameters referring to
     * the entity type will be replaced by parameter name when logging.
     *
     * Generated from protobuf field <code>bool redact = 9;</code>
     * @return bool
     */
    public function getRedact()
    {
        return $this->redact;
    }

    /**
     * Indicates whether parameters of the entity type should be redacted in log.
     * If redaction is enabled, page parameters and intent parameters referring to
     * the entity type will be replaced by parameter name when logging.
     *
     * Generated from protobuf field <code>bool redact = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setRedact($var)
    {
        GPBUtil::checkBool($var);
        $this->redact = $var;

        return $this;
    }

}

