<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/storagetransfer/v1/transfer_types.proto

namespace Google\Cloud\StorageTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Specifies the logging behavior for transfer operations.
 * For cloud-to-cloud transfers, logs are sent to Cloud Logging. See
 * [Read transfer
 * logs](https://cloud.google.com/storage-transfer/docs/read-transfer-logs) for
 * details.
 * For transfers to or from a POSIX file system, logs are stored in the
 * Cloud Storage bucket that is the source or sink of the transfer.
 * See [Managing Transfer for on-premises jobs]
 * (https://cloud.google.com/storage-transfer/docs/managing-on-prem-jobs#viewing-logs)
 * for details.
 *
 * Generated from protobuf message <code>google.storagetransfer.v1.LoggingConfig</code>
 */
class LoggingConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies the actions to be logged. If empty, no logs are generated.
     * Not supported for transfers with PosixFilesystem data sources; use
     * [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs] instead.
     *
     * Generated from protobuf field <code>repeated .google.storagetransfer.v1.LoggingConfig.LoggableAction log_actions = 1;</code>
     */
    private $log_actions;
    /**
     * States in which `log_actions` are logged. If empty, no logs are generated.
     * Not supported for transfers with PosixFilesystem data sources; use
     * [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs] instead.
     *
     * Generated from protobuf field <code>repeated .google.storagetransfer.v1.LoggingConfig.LoggableActionState log_action_states = 2;</code>
     */
    private $log_action_states;
    /**
     * For transfers with a PosixFilesystem source, this option enables the Cloud
     * Storage transfer logs for this transfer.
     *
     * Generated from protobuf field <code>bool enable_onprem_gcs_transfer_logs = 3;</code>
     */
    private $enable_onprem_gcs_transfer_logs = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $log_actions
     *           Specifies the actions to be logged. If empty, no logs are generated.
     *           Not supported for transfers with PosixFilesystem data sources; use
     *           [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs] instead.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $log_action_states
     *           States in which `log_actions` are logged. If empty, no logs are generated.
     *           Not supported for transfers with PosixFilesystem data sources; use
     *           [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs] instead.
     *     @type bool $enable_onprem_gcs_transfer_logs
     *           For transfers with a PosixFilesystem source, this option enables the Cloud
     *           Storage transfer logs for this transfer.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Storagetransfer\V1\TransferTypes::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies the actions to be logged. If empty, no logs are generated.
     * Not supported for transfers with PosixFilesystem data sources; use
     * [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs] instead.
     *
     * Generated from protobuf field <code>repeated .google.storagetransfer.v1.LoggingConfig.LoggableAction log_actions = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLogActions()
    {
        return $this->log_actions;
    }

    /**
     * Specifies the actions to be logged. If empty, no logs are generated.
     * Not supported for transfers with PosixFilesystem data sources; use
     * [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs] instead.
     *
     * Generated from protobuf field <code>repeated .google.storagetransfer.v1.LoggingConfig.LoggableAction log_actions = 1;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLogActions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\StorageTransfer\V1\LoggingConfig\LoggableAction::class);
        $this->log_actions = $arr;

        return $this;
    }

    /**
     * States in which `log_actions` are logged. If empty, no logs are generated.
     * Not supported for transfers with PosixFilesystem data sources; use
     * [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs] instead.
     *
     * Generated from protobuf field <code>repeated .google.storagetransfer.v1.LoggingConfig.LoggableActionState log_action_states = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLogActionStates()
    {
        return $this->log_action_states;
    }

    /**
     * States in which `log_actions` are logged. If empty, no logs are generated.
     * Not supported for transfers with PosixFilesystem data sources; use
     * [enable_onprem_gcs_transfer_logs][google.storagetransfer.v1.LoggingConfig.enable_onprem_gcs_transfer_logs] instead.
     *
     * Generated from protobuf field <code>repeated .google.storagetransfer.v1.LoggingConfig.LoggableActionState log_action_states = 2;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLogActionStates($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\StorageTransfer\V1\LoggingConfig\LoggableActionState::class);
        $this->log_action_states = $arr;

        return $this;
    }

    /**
     * For transfers with a PosixFilesystem source, this option enables the Cloud
     * Storage transfer logs for this transfer.
     *
     * Generated from protobuf field <code>bool enable_onprem_gcs_transfer_logs = 3;</code>
     * @return bool
     */
    public function getEnableOnpremGcsTransferLogs()
    {
        return $this->enable_onprem_gcs_transfer_logs;
    }

    /**
     * For transfers with a PosixFilesystem source, this option enables the Cloud
     * Storage transfer logs for this transfer.
     *
     * Generated from protobuf field <code>bool enable_onprem_gcs_transfer_logs = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableOnpremGcsTransferLogs($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_onprem_gcs_transfer_logs = $var;

        return $this;
    }

}

