<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/speech/v1/cloud_speech.proto

namespace Google\Cloud\Speech\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Provides "hints" to the speech recognizer to favor specific words and phrases
 * in the results.
 *
 * Generated from protobuf message <code>google.cloud.speech.v1.SpeechContext</code>
 */
class SpeechContext extends \Google\Protobuf\Internal\Message
{
    /**
     * A list of strings containing words and phrases "hints" so that
     * the speech recognition is more likely to recognize them. This can be used
     * to improve the accuracy for specific words and phrases, for example, if
     * specific commands are typically spoken by the user. This can also be used
     * to add additional words to the vocabulary of the recognizer. See
     * [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
     * List items can also be set to classes for groups of words that represent
     * common concepts that occur in natural language. For example, rather than
     * providing phrase hints for every month of the year, using the $MONTH class
     * improves the likelihood of correctly transcribing audio that includes
     * months.
     *
     * Generated from protobuf field <code>repeated string phrases = 1;</code>
     */
    private $phrases;
    /**
     * Hint Boost. Positive value will increase the probability that a specific
     * phrase will be recognized over other similar sounding phrases. The higher
     * the boost, the higher the chance of false positive recognition as well.
     * Negative boost values would correspond to anti-biasing. Anti-biasing is not
     * enabled, so negative boost will simply be ignored. Though `boost` can
     * accept a wide range of positive values, most use cases are best served with
     * values between 0 and 20. We recommend using a binary search approach to
     * finding the optimal value for your use case.
     *
     * Generated from protobuf field <code>float boost = 4;</code>
     */
    private $boost = 0.0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $phrases
     *           A list of strings containing words and phrases "hints" so that
     *           the speech recognition is more likely to recognize them. This can be used
     *           to improve the accuracy for specific words and phrases, for example, if
     *           specific commands are typically spoken by the user. This can also be used
     *           to add additional words to the vocabulary of the recognizer. See
     *           [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
     *           List items can also be set to classes for groups of words that represent
     *           common concepts that occur in natural language. For example, rather than
     *           providing phrase hints for every month of the year, using the $MONTH class
     *           improves the likelihood of correctly transcribing audio that includes
     *           months.
     *     @type float $boost
     *           Hint Boost. Positive value will increase the probability that a specific
     *           phrase will be recognized over other similar sounding phrases. The higher
     *           the boost, the higher the chance of false positive recognition as well.
     *           Negative boost values would correspond to anti-biasing. Anti-biasing is not
     *           enabled, so negative boost will simply be ignored. Though `boost` can
     *           accept a wide range of positive values, most use cases are best served with
     *           values between 0 and 20. We recommend using a binary search approach to
     *           finding the optimal value for your use case.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Speech\V1\CloudSpeech::initOnce();
        parent::__construct($data);
    }

    /**
     * A list of strings containing words and phrases "hints" so that
     * the speech recognition is more likely to recognize them. This can be used
     * to improve the accuracy for specific words and phrases, for example, if
     * specific commands are typically spoken by the user. This can also be used
     * to add additional words to the vocabulary of the recognizer. See
     * [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
     * List items can also be set to classes for groups of words that represent
     * common concepts that occur in natural language. For example, rather than
     * providing phrase hints for every month of the year, using the $MONTH class
     * improves the likelihood of correctly transcribing audio that includes
     * months.
     *
     * Generated from protobuf field <code>repeated string phrases = 1;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPhrases()
    {
        return $this->phrases;
    }

    /**
     * A list of strings containing words and phrases "hints" so that
     * the speech recognition is more likely to recognize them. This can be used
     * to improve the accuracy for specific words and phrases, for example, if
     * specific commands are typically spoken by the user. This can also be used
     * to add additional words to the vocabulary of the recognizer. See
     * [usage limits](https://cloud.google.com/speech-to-text/quotas#content).
     * List items can also be set to classes for groups of words that represent
     * common concepts that occur in natural language. For example, rather than
     * providing phrase hints for every month of the year, using the $MONTH class
     * improves the likelihood of correctly transcribing audio that includes
     * months.
     *
     * Generated from protobuf field <code>repeated string phrases = 1;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPhrases($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->phrases = $arr;

        return $this;
    }

    /**
     * Hint Boost. Positive value will increase the probability that a specific
     * phrase will be recognized over other similar sounding phrases. The higher
     * the boost, the higher the chance of false positive recognition as well.
     * Negative boost values would correspond to anti-biasing. Anti-biasing is not
     * enabled, so negative boost will simply be ignored. Though `boost` can
     * accept a wide range of positive values, most use cases are best served with
     * values between 0 and 20. We recommend using a binary search approach to
     * finding the optimal value for your use case.
     *
     * Generated from protobuf field <code>float boost = 4;</code>
     * @return float
     */
    public function getBoost()
    {
        return $this->boost;
    }

    /**
     * Hint Boost. Positive value will increase the probability that a specific
     * phrase will be recognized over other similar sounding phrases. The higher
     * the boost, the higher the chance of false positive recognition as well.
     * Negative boost values would correspond to anti-biasing. Anti-biasing is not
     * enabled, so negative boost will simply be ignored. Though `boost` can
     * accept a wide range of positive values, most use cases are best served with
     * values between 0 and 20. We recommend using a binary search approach to
     * finding the optimal value for your use case.
     *
     * Generated from protobuf field <code>float boost = 4;</code>
     * @param float $var
     * @return $this
     */
    public function setBoost($var)
    {
        GPBUtil::checkFloat($var);
        $this->boost = $var;

        return $this;
    }

}

