<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/essentialcontacts/v1/service.proto

namespace Google\Cloud\EssentialContacts\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A contact that will receive notifications from Google Cloud.
 *
 * Generated from protobuf message <code>google.cloud.essentialcontacts.v1.Contact</code>
 */
class Contact extends \Google\Protobuf\Internal\Message
{
    /**
     * The identifier for the contact.
     * Format: {resource_type}/{resource_id}/contacts/{contact_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Required. The email address to send notifications to. This does not need to
     * be a Google account.
     *
     * Generated from protobuf field <code>string email = 2;</code>
     */
    private $email = '';
    /**
     * The categories of notifications that the contact will receive
     * communications for.
     *
     * Generated from protobuf field <code>repeated .google.cloud.essentialcontacts.v1.NotificationCategory notification_category_subscriptions = 3;</code>
     */
    private $notification_category_subscriptions;
    /**
     * The preferred language for notifications, as a ISO 639-1 language code. See
     * [Supported
     * languages](https://cloud.google.com/resource-manager/docs/managing-notification-contacts#supported-languages)
     * for a list of supported languages.
     *
     * Generated from protobuf field <code>string language_tag = 4;</code>
     */
    private $language_tag = '';
    /**
     * The validity of the contact. A contact is considered valid if it is the
     * correct recipient for notifications for a particular resource.
     *
     * Generated from protobuf field <code>.google.cloud.essentialcontacts.v1.ValidationState validation_state = 8;</code>
     */
    private $validation_state = 0;
    /**
     * The last time the validation_state was updated, either manually or
     * automatically. A contact is considered stale if its validation state was
     * updated more than 1 year ago.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp validate_time = 9;</code>
     */
    private $validate_time = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The identifier for the contact.
     *           Format: {resource_type}/{resource_id}/contacts/{contact_id}
     *     @type string $email
     *           Required. The email address to send notifications to. This does not need to
     *           be a Google account.
     *     @type int[]|\Google\Protobuf\Internal\RepeatedField $notification_category_subscriptions
     *           The categories of notifications that the contact will receive
     *           communications for.
     *     @type string $language_tag
     *           The preferred language for notifications, as a ISO 639-1 language code. See
     *           [Supported
     *           languages](https://cloud.google.com/resource-manager/docs/managing-notification-contacts#supported-languages)
     *           for a list of supported languages.
     *     @type int $validation_state
     *           The validity of the contact. A contact is considered valid if it is the
     *           correct recipient for notifications for a particular resource.
     *     @type \Google\Protobuf\Timestamp $validate_time
     *           The last time the validation_state was updated, either manually or
     *           automatically. A contact is considered stale if its validation state was
     *           updated more than 1 year ago.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Essentialcontacts\V1\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * The identifier for the contact.
     * Format: {resource_type}/{resource_id}/contacts/{contact_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The identifier for the contact.
     * Format: {resource_type}/{resource_id}/contacts/{contact_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The email address to send notifications to. This does not need to
     * be a Google account.
     *
     * Generated from protobuf field <code>string email = 2;</code>
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Required. The email address to send notifications to. This does not need to
     * be a Google account.
     *
     * Generated from protobuf field <code>string email = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->email = $var;

        return $this;
    }

    /**
     * The categories of notifications that the contact will receive
     * communications for.
     *
     * Generated from protobuf field <code>repeated .google.cloud.essentialcontacts.v1.NotificationCategory notification_category_subscriptions = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNotificationCategorySubscriptions()
    {
        return $this->notification_category_subscriptions;
    }

    /**
     * The categories of notifications that the contact will receive
     * communications for.
     *
     * Generated from protobuf field <code>repeated .google.cloud.essentialcontacts.v1.NotificationCategory notification_category_subscriptions = 3;</code>
     * @param int[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNotificationCategorySubscriptions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Cloud\EssentialContacts\V1\NotificationCategory::class);
        $this->notification_category_subscriptions = $arr;

        return $this;
    }

    /**
     * The preferred language for notifications, as a ISO 639-1 language code. See
     * [Supported
     * languages](https://cloud.google.com/resource-manager/docs/managing-notification-contacts#supported-languages)
     * for a list of supported languages.
     *
     * Generated from protobuf field <code>string language_tag = 4;</code>
     * @return string
     */
    public function getLanguageTag()
    {
        return $this->language_tag;
    }

    /**
     * The preferred language for notifications, as a ISO 639-1 language code. See
     * [Supported
     * languages](https://cloud.google.com/resource-manager/docs/managing-notification-contacts#supported-languages)
     * for a list of supported languages.
     *
     * Generated from protobuf field <code>string language_tag = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageTag($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_tag = $var;

        return $this;
    }

    /**
     * The validity of the contact. A contact is considered valid if it is the
     * correct recipient for notifications for a particular resource.
     *
     * Generated from protobuf field <code>.google.cloud.essentialcontacts.v1.ValidationState validation_state = 8;</code>
     * @return int
     */
    public function getValidationState()
    {
        return $this->validation_state;
    }

    /**
     * The validity of the contact. A contact is considered valid if it is the
     * correct recipient for notifications for a particular resource.
     *
     * Generated from protobuf field <code>.google.cloud.essentialcontacts.v1.ValidationState validation_state = 8;</code>
     * @param int $var
     * @return $this
     */
    public function setValidationState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\EssentialContacts\V1\ValidationState::class);
        $this->validation_state = $var;

        return $this;
    }

    /**
     * The last time the validation_state was updated, either manually or
     * automatically. A contact is considered stale if its validation state was
     * updated more than 1 year ago.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp validate_time = 9;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getValidateTime()
    {
        return $this->validate_time;
    }

    public function hasValidateTime()
    {
        return isset($this->validate_time);
    }

    public function clearValidateTime()
    {
        unset($this->validate_time);
    }

    /**
     * The last time the validation_state was updated, either manually or
     * automatically. A contact is considered stale if its validation state was
     * updated more than 1 year ago.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp validate_time = 9;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setValidateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->validate_time = $var;

        return $this;
    }

}

