<?php
/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/datacatalog/v1/datacatalog.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\DataCatalog\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\DataCatalog\V1\Contacts;
use Google\Cloud\DataCatalog\V1\CreateEntryGroupRequest;
use Google\Cloud\DataCatalog\V1\CreateEntryRequest;
use Google\Cloud\DataCatalog\V1\CreateTagRequest;
use Google\Cloud\DataCatalog\V1\CreateTagTemplateFieldRequest;
use Google\Cloud\DataCatalog\V1\CreateTagTemplateRequest;
use Google\Cloud\DataCatalog\V1\DeleteEntryGroupRequest;
use Google\Cloud\DataCatalog\V1\DeleteEntryRequest;
use Google\Cloud\DataCatalog\V1\DeleteTagRequest;
use Google\Cloud\DataCatalog\V1\DeleteTagTemplateFieldRequest;
use Google\Cloud\DataCatalog\V1\DeleteTagTemplateRequest;
use Google\Cloud\DataCatalog\V1\Entry;
use Google\Cloud\DataCatalog\V1\EntryGroup;
use Google\Cloud\DataCatalog\V1\EntryOverview;
use Google\Cloud\DataCatalog\V1\GetEntryGroupRequest;
use Google\Cloud\DataCatalog\V1\GetEntryRequest;
use Google\Cloud\DataCatalog\V1\GetTagTemplateRequest;
use Google\Cloud\DataCatalog\V1\ListEntriesRequest;
use Google\Cloud\DataCatalog\V1\ListEntriesResponse;
use Google\Cloud\DataCatalog\V1\ListEntryGroupsRequest;
use Google\Cloud\DataCatalog\V1\ListEntryGroupsResponse;
use Google\Cloud\DataCatalog\V1\ListTagsRequest;
use Google\Cloud\DataCatalog\V1\ListTagsResponse;
use Google\Cloud\DataCatalog\V1\LookupEntryRequest;
use Google\Cloud\DataCatalog\V1\ModifyEntryContactsRequest;
use Google\Cloud\DataCatalog\V1\ModifyEntryOverviewRequest;
use Google\Cloud\DataCatalog\V1\RenameTagTemplateFieldEnumValueRequest;
use Google\Cloud\DataCatalog\V1\RenameTagTemplateFieldRequest;
use Google\Cloud\DataCatalog\V1\SearchCatalogRequest;
use Google\Cloud\DataCatalog\V1\SearchCatalogRequest\Scope;
use Google\Cloud\DataCatalog\V1\SearchCatalogResponse;
use Google\Cloud\DataCatalog\V1\StarEntryRequest;
use Google\Cloud\DataCatalog\V1\StarEntryResponse;
use Google\Cloud\DataCatalog\V1\Tag;
use Google\Cloud\DataCatalog\V1\TagTemplate;
use Google\Cloud\DataCatalog\V1\TagTemplateField;
use Google\Cloud\DataCatalog\V1\UnstarEntryRequest;
use Google\Cloud\DataCatalog\V1\UnstarEntryResponse;
use Google\Cloud\DataCatalog\V1\UpdateEntryGroupRequest;
use Google\Cloud\DataCatalog\V1\UpdateEntryRequest;
use Google\Cloud\DataCatalog\V1\UpdateTagRequest;
use Google\Cloud\DataCatalog\V1\UpdateTagTemplateFieldRequest;
use Google\Cloud\DataCatalog\V1\UpdateTagTemplateRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Protobuf\FieldMask;
use Google\Protobuf\GPBEmpty;

/**
 * Service Description: Data Catalog API service allows you to discover, understand, and manage
 * your data.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $dataCatalogClient = new DataCatalogClient();
 * try {
 *     $formattedParent = $dataCatalogClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
 *     $entryId = 'entry_id';
 *     $entry = new Entry();
 *     $response = $dataCatalogClient->createEntry($formattedParent, $entryId, $entry);
 * } finally {
 *     $dataCatalogClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class DataCatalogGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.datacatalog.v1.DataCatalog';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'datacatalog.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $entryNameTemplate;

    private static $entryGroupNameTemplate;

    private static $locationNameTemplate;

    private static $tagNameTemplate;

    private static $tagTemplateNameTemplate;

    private static $tagTemplateFieldNameTemplate;

    private static $tagTemplateFieldEnumValueNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/data_catalog_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/data_catalog_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/data_catalog_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/data_catalog_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getEntryNameTemplate()
    {
        if (self::$entryNameTemplate == null) {
            self::$entryNameTemplate = new PathTemplate('projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}');
        }

        return self::$entryNameTemplate;
    }

    private static function getEntryGroupNameTemplate()
    {
        if (self::$entryGroupNameTemplate == null) {
            self::$entryGroupNameTemplate = new PathTemplate('projects/{project}/locations/{location}/entryGroups/{entry_group}');
        }

        return self::$entryGroupNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate('projects/{project}/locations/{location}');
        }

        return self::$locationNameTemplate;
    }

    private static function getTagNameTemplate()
    {
        if (self::$tagNameTemplate == null) {
            self::$tagNameTemplate = new PathTemplate('projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}/tags/{tag}');
        }

        return self::$tagNameTemplate;
    }

    private static function getTagTemplateNameTemplate()
    {
        if (self::$tagTemplateNameTemplate == null) {
            self::$tagTemplateNameTemplate = new PathTemplate('projects/{project}/locations/{location}/tagTemplates/{tag_template}');
        }

        return self::$tagTemplateNameTemplate;
    }

    private static function getTagTemplateFieldNameTemplate()
    {
        if (self::$tagTemplateFieldNameTemplate == null) {
            self::$tagTemplateFieldNameTemplate = new PathTemplate('projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{field}');
        }

        return self::$tagTemplateFieldNameTemplate;
    }

    private static function getTagTemplateFieldEnumValueNameTemplate()
    {
        if (self::$tagTemplateFieldEnumValueNameTemplate == null) {
            self::$tagTemplateFieldEnumValueNameTemplate = new PathTemplate('projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{tag_template_field_id}/enumValues/{enum_value_display_name}');
        }

        return self::$tagTemplateFieldEnumValueNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'entry' => self::getEntryNameTemplate(),
                'entryGroup' => self::getEntryGroupNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'tag' => self::getTagNameTemplate(),
                'tagTemplate' => self::getTagTemplateNameTemplate(),
                'tagTemplateField' => self::getTagTemplateFieldNameTemplate(),
                'tagTemplateFieldEnumValue' => self::getTagTemplateFieldEnumValueNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     * @param string $entry
     *
     * @return string The formatted entry resource.
     */
    public static function entryName($project, $location, $entryGroup, $entry)
    {
        return self::getEntryNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
            'entry' => $entry,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entry_group
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     *
     * @return string The formatted entry_group resource.
     */
    public static function entryGroupName($project, $location, $entryGroup)
    {
        return self::getEntryGroupNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tag
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $entryGroup
     * @param string $entry
     * @param string $tag
     *
     * @return string The formatted tag resource.
     */
    public static function tagName($project, $location, $entryGroup, $entry, $tag)
    {
        return self::getTagNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'entry_group' => $entryGroup,
            'entry' => $entry,
            'tag' => $tag,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tag_template
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tagTemplate
     *
     * @return string The formatted tag_template resource.
     */
    public static function tagTemplateName($project, $location, $tagTemplate)
    {
        return self::getTagTemplateNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tag_template' => $tagTemplate,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tag_template_field resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tagTemplate
     * @param string $field
     *
     * @return string The formatted tag_template_field resource.
     */
    public static function tagTemplateFieldName($project, $location, $tagTemplate, $field)
    {
        return self::getTagTemplateFieldNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tag_template' => $tagTemplate,
            'field' => $field,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * tag_template_field_enum_value resource.
     *
     * @param string $project
     * @param string $location
     * @param string $tagTemplate
     * @param string $tagTemplateFieldId
     * @param string $enumValueDisplayName
     *
     * @return string The formatted tag_template_field_enum_value resource.
     */
    public static function tagTemplateFieldEnumValueName($project, $location, $tagTemplate, $tagTemplateFieldId, $enumValueDisplayName)
    {
        return self::getTagTemplateFieldEnumValueNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'tag_template' => $tagTemplate,
            'tag_template_field_id' => $tagTemplateFieldId,
            'enum_value_display_name' => $enumValueDisplayName,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - entry: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}
     * - entryGroup: projects/{project}/locations/{location}/entryGroups/{entry_group}
     * - location: projects/{project}/locations/{location}
     * - tag: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}/tags/{tag}
     * - tagTemplate: projects/{project}/locations/{location}/tagTemplates/{tag_template}
     * - tagTemplateField: projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{field}
     * - tagTemplateFieldEnumValue: projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{tag_template_field_id}/enumValues/{enum_value_display_name}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'datacatalog.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Creates an entry.
     *
     * You can create entries only with 'FILESET', 'CLUSTER', 'DATA_STREAM',
     * or custom types. Data Catalog automatically creates entries with other
     * types during metadata ingestion from integrated systems.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `parent` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * An entry group can have a maximum of 100,000 entries.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedParent = $dataCatalogClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     $entryId = 'entry_id';
     *     $entry = new Entry();
     *     $response = $dataCatalogClient->createEntry($formattedParent, $entryId, $entry);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the entry group this entry belongs to.
     *
     *                             Note: The entry itself and its child resources might not be stored in
     *                             the location specified in its name.
     * @param string $entryId      Required. The ID of the entry to create.
     *
     *                             The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *                             and underscores (_).
     *                             The maximum size is 64 bytes when encoded in UTF-8.
     * @param Entry  $entry        Required. The entry to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function createEntry($parent, $entryId, $entry, array $optionalArgs = [])
    {
        $request = new CreateEntryRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntryId($entryId);
        $request->setEntry($entry);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateEntry', Entry::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates an entry group.
     *
     * An entry group contains logically related entries together with [Cloud
     * Identity and Access Management](https://cloud.google.com/data-catalog/docs/concepts/iam) policies.
     * These policies specify users who can create, edit, and view entries
     * within entry groups.
     *
     * Data Catalog automatically creates entry groups with names that start with
     * the `&#64;` symbol for the following resources:
     *
     * * BigQuery entries (`&#64;bigquery`)
     * * Pub/Sub topics (`&#64;pubsub`)
     * * Dataproc Metastore services (`&#64;dataproc_metastore_{SERVICE_NAME_HASH}`)
     *
     * You can create your own entry groups for Cloud Storage fileset entries
     * and custom entries together with the corresponding IAM policies.
     * User-created entry groups can't contain the `&#64;` symbol, it is reserved
     * for automatically created groups.
     *
     * Entry groups, like entries, can be searched.
     *
     * A maximum of 10,000 entry groups may be created per organization across all
     * locations.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `parent` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedParent = $dataCatalogClient->locationName('[PROJECT]', '[LOCATION]');
     *     $entryGroupId = 'entry_group_id';
     *     $response = $dataCatalogClient->createEntryGroup($formattedParent, $entryGroupId);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The names of the project and location that the new entry group belongs to.
     *
     *                             Note: The entry group itself and its child resources might not be
     *                             stored in the location specified in its name.
     * @param string $entryGroupId Required. The ID of the entry group to create.
     *
     *                             The ID must contain only letters (a-z, A-Z), numbers (0-9),
     *                             underscores (_), and must start with a letter or underscore.
     *                             The maximum size is 64 bytes when encoded in UTF-8.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type EntryGroup $entryGroup
     *           The entry group to create. Defaults to empty.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\EntryGroup
     *
     * @throws ApiException if the remote call fails
     */
    public function createEntryGroup($parent, $entryGroupId, array $optionalArgs = [])
    {
        $request = new CreateEntryGroupRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setEntryGroupId($entryGroupId);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['entryGroup'])) {
            $request->setEntryGroup($optionalArgs['entryGroup']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateEntryGroup', EntryGroup::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a tag and assigns it to:
     *
     * * An [Entry][google.cloud.datacatalog.v1.Entry] if the method name is
     * `projects.locations.entryGroups.entries.tags.create`.
     * * Or [EntryGroup][google.cloud.datacatalog.v1.EntryGroup]if the method
     * name is `projects.locations.entryGroups.tags.create`.
     *
     * Note: The project identified by the `parent` parameter for the [tag]
     * (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries.tags/create#path-parameters)
     * and the [tag template]
     * (https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.tagTemplates/create#path-parameters)
     * used to create the tag must be in the same organization.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedParent = $dataCatalogClient->tagName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]', '[TAG]');
     *     $tag = new Tag();
     *     $response = $dataCatalogClient->createTag($formattedParent, $tag);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the resource to attach this tag to.
     *
     *                             Tags can be attached to entries or entry groups. An entry can have up to
     *                             1000 attached tags.
     *
     *                             Note: The tag and its child resources might not be stored in
     *                             the location specified in its name.
     * @param Tag    $tag          Required. The tag to create.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\Tag
     *
     * @throws ApiException if the remote call fails
     */
    public function createTag($parent, $tag, array $optionalArgs = [])
    {
        $request = new CreateTagRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTag($tag);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateTag', Tag::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a tag template.
     *
     * You must enable the Data Catalog API in the project identified by the
     * `parent` parameter.
     * For more information, see [Data Catalog resource project]
     * (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedParent = $dataCatalogClient->locationName('[PROJECT]', '[LOCATION]');
     *     $tagTemplateId = 'tag_template_id';
     *     $tagTemplate = new TagTemplate();
     *     $response = $dataCatalogClient->createTagTemplate($formattedParent, $tagTemplateId, $tagTemplate);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string      $parent        Required. The name of the project and the template location
     *                                   [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
     * @param string      $tagTemplateId Required. The ID of the tag template to create.
     *
     *                                   The ID must contain only lowercase letters (a-z), numbers (0-9),
     *                                   or underscores (_), and must start with a letter or underscore.
     *                                   The maximum size is 64 bytes when encoded in UTF-8.
     * @param TagTemplate $tagTemplate   Required. The tag template to create.
     * @param array       $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\TagTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function createTagTemplate($parent, $tagTemplateId, $tagTemplate, array $optionalArgs = [])
    {
        $request = new CreateTagTemplateRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTagTemplateId($tagTemplateId);
        $request->setTagTemplate($tagTemplate);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateTagTemplate', TagTemplate::class, $optionalArgs, $request)->wait();
    }

    /**
     * Creates a field in a tag template.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `parent` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedParent = $dataCatalogClient->tagTemplateName('[PROJECT]', '[LOCATION]', '[TAG_TEMPLATE]');
     *     $tagTemplateFieldId = 'tag_template_field_id';
     *     $tagTemplateField = new TagTemplateField();
     *     $response = $dataCatalogClient->createTagTemplateField($formattedParent, $tagTemplateFieldId, $tagTemplateField);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string           $parent             Required. The name of the project and the template location
     *                                             [region](https://cloud.google.com/data-catalog/docs/concepts/regions).
     * @param string           $tagTemplateFieldId Required. The ID of the tag template field to create.
     *
     *                                             Note: Adding a required field to an existing template is *not* allowed.
     *
     *                                             Field IDs can contain letters (both uppercase and lowercase), numbers
     *                                             (0-9), underscores (_) and dashes (-). Field IDs must be at least 1
     *                                             character long and at most 128 characters long. Field IDs must also be
     *                                             unique within their template.
     * @param TagTemplateField $tagTemplateField   Required. The tag template field to create.
     * @param array            $optionalArgs       {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\TagTemplateField
     *
     * @throws ApiException if the remote call fails
     */
    public function createTagTemplateField($parent, $tagTemplateFieldId, $tagTemplateField, array $optionalArgs = [])
    {
        $request = new CreateTagTemplateFieldRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setTagTemplateFieldId($tagTemplateFieldId);
        $request->setTagTemplateField($tagTemplateField);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('CreateTagTemplateField', TagTemplateField::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes an existing entry.
     *
     * You can delete only the entries created by the
     * [CreateEntry][google.cloud.datacatalog.v1.DataCatalog.CreateEntry]
     * method.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $dataCatalogClient->deleteEntry($formattedName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the entry to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEntry($name, array $optionalArgs = [])
    {
        $request = new DeleteEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteEntry', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes an entry group.
     *
     * You must enable the Data Catalog API in the project
     * identified by the `name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     $dataCatalogClient->deleteEntryGroup($formattedName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the entry group to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type bool $force
     *           Optional. If true, deletes all entries in the entry group.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteEntryGroup($name, array $optionalArgs = [])
    {
        $request = new DeleteEntryGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['force'])) {
            $request->setForce($optionalArgs['force']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteEntryGroup', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a tag.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $dataCatalogClient->deleteTag($formattedName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the tag to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTag($name, array $optionalArgs = [])
    {
        $request = new DeleteTagRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteTag', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a tag template and all tags that use it.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `name` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->tagTemplateName('[PROJECT]', '[LOCATION]', '[TAG_TEMPLATE]');
     *     $force = false;
     *     $dataCatalogClient->deleteTagTemplate($formattedName, $force);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the tag template to delete.
     * @param bool   $force        Required. If true, deletes all tags that use this template.
     *
     *                             Currently, `true` is the only supported value.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTagTemplate($name, $force, array $optionalArgs = [])
    {
        $request = new DeleteTagTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setForce($force);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteTagTemplate', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Deletes a field in a tag template and all uses of this field from the tags
     * based on this template.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `name` parameter. For more information, see [Data Catalog resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->tagTemplateFieldName('[PROJECT]', '[LOCATION]', '[TAG_TEMPLATE]', '[FIELD]');
     *     $force = false;
     *     $dataCatalogClient->deleteTagTemplateField($formattedName, $force);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the tag template field to delete.
     * @param bool   $force        Required. If true, deletes this field from any tags that use it.
     *
     *                             Currently, `true` is the only supported value.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteTagTemplateField($name, $force, array $optionalArgs = [])
    {
        $request = new DeleteTagTemplateFieldRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setForce($force);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('DeleteTagTemplateField', GPBEmpty::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets an entry.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $response = $dataCatalogClient->getEntry($formattedName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the entry to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function getEntry($name, array $optionalArgs = [])
    {
        $request = new GetEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEntry', Entry::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets an entry group.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     $response = $dataCatalogClient->getEntryGroup($formattedName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the entry group to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $readMask
     *           The fields to return. If empty or omitted, all fields are returned.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\EntryGroup
     *
     * @throws ApiException if the remote call fails
     */
    public function getEntryGroup($name, array $optionalArgs = [])
    {
        $request = new GetEntryGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetEntryGroup', EntryGroup::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets the access control policy for a resource.
     *
     * May return:
     *
     * * A`NOT_FOUND` error if the resource doesn't exist or you don't have the
     * permission to view it.
     * * An empty policy if the resource exists but doesn't have a set policy.
     *
     * Supported resources are:
     *
     * - Tag templates
     * - Entry groups
     *
     * Note: This method doesn't get policies from Google Cloud Platform
     * resources ingested into Data Catalog.
     *
     * To call this method, you must have the following Google IAM permissions:
     *
     * - `datacatalog.tagTemplates.getIamPolicy` to get policies on tag
     * templates.
     * - `datacatalog.entryGroups.getIamPolicy` to get policies on entry groups.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $resource = 'resource';
     *     $response = $dataCatalogClient->getIamPolicy($resource);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetIamPolicy', Policy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets a tag template.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->tagTemplateName('[PROJECT]', '[LOCATION]', '[TAG_TEMPLATE]');
     *     $response = $dataCatalogClient->getTagTemplate($formattedName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the tag template to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\TagTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function getTagTemplate($name, array $optionalArgs = [])
    {
        $request = new GetTagTemplateRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetTagTemplate', TagTemplate::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists entries.
     *
     * Note: Currently, this method can list only custom entries.
     * To get a list of both custom and automatically created entries, use
     * [SearchCatalog][google.cloud.datacatalog.v1.DataCatalog.SearchCatalog].
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedParent = $dataCatalogClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataCatalogClient->listEntries($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataCatalogClient->listEntries($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the entry group that contains the entries to list.
     *
     *                             Can be provided in URL format.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type FieldMask $readMask
     *           The fields to return for each entry. If empty or omitted, all
     *           fields are returned.
     *
     *           For example, to return a list of entries with only the `name` field,
     *           set `read_mask` to only one path with the `name` value.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEntries($parent, array $optionalArgs = [])
    {
        $request = new ListEntriesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['readMask'])) {
            $request->setReadMask($optionalArgs['readMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEntries', $optionalArgs, ListEntriesResponse::class, $request);
    }

    /**
     * Lists entry groups.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedParent = $dataCatalogClient->entryGroupName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataCatalogClient->listEntryGroups($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataCatalogClient->listEntryGroups($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the location that contains the entry groups to list.
     *
     *                             Can be provided as a URL.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listEntryGroups($parent, array $optionalArgs = [])
    {
        $request = new ListEntryGroupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListEntryGroups', $optionalArgs, ListEntryGroupsResponse::class, $request);
    }

    /**
     * Lists tags assigned to an [Entry][google.cloud.datacatalog.v1.Entry].
     * The [columns][google.cloud.datacatalog.v1.Tag.column] in the response are
     * lowercased.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedParent = $dataCatalogClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataCatalogClient->listTags($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataCatalogClient->listTags($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The name of the Data Catalog resource to list the tags of.
     *
     *                             The resource can be an [Entry][google.cloud.datacatalog.v1.Entry]
     *                             or an [EntryGroup][google.cloud.datacatalog.v1.EntryGroup]
     *                             (without `/entries/{entries}` at the end).
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listTags($parent, array $optionalArgs = [])
    {
        $request = new ListTagsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListTags', $optionalArgs, ListTagsResponse::class, $request);
    }

    /**
     * Gets an entry by its target resource name.
     *
     * The resource name comes from the source Google Cloud Platform service.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $response = $dataCatalogClient->lookupEntry();
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $linkedResource
     *           The full name of the Google Cloud Platform resource the Data Catalog
     *           entry represents. For more information, see [Full Resource Name]
     *           (https://cloud.google.com/apis/design/resource_names#full_resource_name).
     *
     *           Full names are case-sensitive. For example:
     *
     *           * `//bigquery.googleapis.com/projects/{PROJECT_ID}/datasets/{DATASET_ID}/tables/{TABLE_ID}`
     *           * `//pubsub.googleapis.com/projects/{PROJECT_ID}/topics/{TOPIC_ID}`
     *     @type string $sqlResource
     *           The SQL name of the entry. SQL names are case-sensitive.
     *
     *           Examples:
     *
     *           * `pubsub.topic.{PROJECT_ID}.{TOPIC_ID}`
     *           * `pubsub.topic.{PROJECT_ID}.`\``{TOPIC.ID.SEPARATED.WITH.DOTS}`\`
     *           * `bigquery.table.{PROJECT_ID}.{DATASET_ID}.{TABLE_ID}`
     *           * `bigquery.dataset.{PROJECT_ID}.{DATASET_ID}`
     *           * `datacatalog.entry.{PROJECT_ID}.{LOCATION_ID}.{ENTRY_GROUP_ID}.{ENTRY_ID}`
     *
     *           Identifiers (`*_ID`) should comply with the
     *           [Lexical structure in Standard SQL]
     *           (https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical).
     *     @type string $fullyQualifiedName
     *           Fully qualified name (FQN) of the resource.
     *
     *           FQNs take two forms:
     *
     *           * For non-regionalized resources:
     *
     *           `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     *           * For regionalized resources:
     *
     *           `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     *           Example for a DPMS table:
     *
     *           `dataproc_metastore:{PROJECT_ID}.{LOCATION_ID}.{INSTANCE_ID}.{DATABASE_ID}.{TABLE_ID}`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function lookupEntry(array $optionalArgs = [])
    {
        $request = new LookupEntryRequest();
        if (isset($optionalArgs['linkedResource'])) {
            $request->setLinkedResource($optionalArgs['linkedResource']);
        }

        if (isset($optionalArgs['sqlResource'])) {
            $request->setSqlResource($optionalArgs['sqlResource']);
        }

        if (isset($optionalArgs['fullyQualifiedName'])) {
            $request->setFullyQualifiedName($optionalArgs['fullyQualifiedName']);
        }

        return $this->startCall('LookupEntry', Entry::class, $optionalArgs, $request)->wait();
    }

    /**
     * Modifies contacts, part of the business context of an
     * [Entry][google.cloud.datacatalog.v1.Entry].
     *
     * To call this method, you must have the `datacatalog.entries.updateContacts`
     * IAM permission on the corresponding project.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $contacts = new Contacts();
     *     $response = $dataCatalogClient->modifyEntryContacts($formattedName, $contacts);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string   $name         Required. The full resource name of the entry.
     * @param Contacts $contacts     Required. The new value for the Contacts.
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\Contacts
     *
     * @throws ApiException if the remote call fails
     */
    public function modifyEntryContacts($name, $contacts, array $optionalArgs = [])
    {
        $request = new ModifyEntryContactsRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setContacts($contacts);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ModifyEntryContacts', Contacts::class, $optionalArgs, $request)->wait();
    }

    /**
     * Modifies entry overview, part of the business context of an
     * [Entry][google.cloud.datacatalog.v1.Entry].
     *
     * To call this method, you must have the `datacatalog.entries.updateOverview`
     * IAM permission on the corresponding project.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $entryOverview = new EntryOverview();
     *     $response = $dataCatalogClient->modifyEntryOverview($formattedName, $entryOverview);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string        $name          Required. The full resource name of the entry.
     * @param EntryOverview $entryOverview Required. The new value for the Entry Overview.
     * @param array         $optionalArgs  {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\EntryOverview
     *
     * @throws ApiException if the remote call fails
     */
    public function modifyEntryOverview($name, $entryOverview, array $optionalArgs = [])
    {
        $request = new ModifyEntryOverviewRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setEntryOverview($entryOverview);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('ModifyEntryOverview', EntryOverview::class, $optionalArgs, $request)->wait();
    }

    /**
     * Renames a field in a tag template.
     *
     * You must enable the Data Catalog API in the project identified by the
     * `name` parameter. For more information, see [Data Catalog resource project]
     * (https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->tagTemplateFieldName('[PROJECT]', '[LOCATION]', '[TAG_TEMPLATE]', '[FIELD]');
     *     $newTagTemplateFieldId = 'new_tag_template_field_id';
     *     $response = $dataCatalogClient->renameTagTemplateField($formattedName, $newTagTemplateFieldId);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name                  Required. The name of the tag template field.
     * @param string $newTagTemplateFieldId Required. The new ID of this tag template field. For example, `my_new_field`.
     * @param array  $optionalArgs          {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\TagTemplateField
     *
     * @throws ApiException if the remote call fails
     */
    public function renameTagTemplateField($name, $newTagTemplateFieldId, array $optionalArgs = [])
    {
        $request = new RenameTagTemplateFieldRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setNewTagTemplateFieldId($newTagTemplateFieldId);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('RenameTagTemplateField', TagTemplateField::class, $optionalArgs, $request)->wait();
    }

    /**
     * Renames an enum value in a tag template.
     *
     * Within a single enum field, enum values must be unique.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->tagTemplateFieldEnumValueName('[PROJECT]', '[LOCATION]', '[TAG_TEMPLATE]', '[TAG_TEMPLATE_FIELD_ID]', '[ENUM_VALUE_DISPLAY_NAME]');
     *     $newEnumValueDisplayName = 'new_enum_value_display_name';
     *     $response = $dataCatalogClient->renameTagTemplateFieldEnumValue($formattedName, $newEnumValueDisplayName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name                    Required. The name of the enum field value.
     * @param string $newEnumValueDisplayName Required. The new display name of the enum value. For example, `my_new_enum_value`.
     * @param array  $optionalArgs            {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\TagTemplateField
     *
     * @throws ApiException if the remote call fails
     */
    public function renameTagTemplateFieldEnumValue($name, $newEnumValueDisplayName, array $optionalArgs = [])
    {
        $request = new RenameTagTemplateFieldEnumValueRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setNewEnumValueDisplayName($newEnumValueDisplayName);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('RenameTagTemplateFieldEnumValue', TagTemplateField::class, $optionalArgs, $request)->wait();
    }

    /**
     * Searches Data Catalog for multiple resources like entries and tags that
     * match a query.
     *
     * This is a [Custom Method]
     * (https://cloud.google.com/apis/design/custom_methods) that doesn't return
     * all information on a resource, only its ID and high level fields. To get
     * more information, you can subsequently call specific get methods.
     *
     * Note: Data Catalog search queries don't guarantee full recall. Results
     * that match your query might not be returned, even in subsequent
     * result pages. Additionally, returned (and not returned) results can vary
     * if you repeat search queries.
     *
     * For more information, see [Data Catalog search syntax]
     * (https://cloud.google.com/data-catalog/docs/how-to/search-reference).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $scope = new Scope();
     *     $query = 'query';
     *     // Iterate over pages of elements
     *     $pagedResponse = $dataCatalogClient->searchCatalog($scope, $query);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $dataCatalogClient->searchCatalog($scope, $query);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param Scope  $scope        Required. The scope of this search request.
     *
     *                             The `scope` is invalid if `include_org_ids`, `include_project_ids` are
     *                             empty AND `include_gcp_public_datasets` is set to `false`. In this case,
     *                             the request returns an error.
     * @param string $query        Optional. The query string with a minimum of 3 characters and specific syntax.
     *                             For more information, see
     *                             [Data Catalog search
     *                             syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference).
     *
     *                             An empty query string returns all data assets (in the specified scope)
     *                             that you have access to.
     *
     *                             A query string can be a simple `xyz` or qualified by predicates:
     *
     *                             * `name:x`
     *                             * `column:y`
     *                             * `description:z`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $orderBy
     *           Specifies the order of results.
     *
     *           Currently supported case-sensitive values are:
     *
     *           * `relevance` that can only be descending
     *           * `last_modified_timestamp [asc|desc]` with descending (`desc`) as default
     *           * `default` that can only be descending
     *
     *           If this parameter is omitted, it defaults to the descending `relevance`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function searchCatalog($scope, $query, array $optionalArgs = [])
    {
        $request = new SearchCatalogRequest();
        $request->setScope($scope);
        $request->setQuery($query);
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        return $this->getPagedListResponse('SearchCatalog', $optionalArgs, SearchCatalogResponse::class, $request);
    }

    /**
     * Sets an access control policy for a resource. Replaces any existing
     * policy.
     *
     * Supported resources are:
     *
     * - Tag templates
     * - Entry groups
     *
     * Note: This method sets policies only within Data Catalog and can't be
     * used to manage policies in BigQuery, Pub/Sub, Dataproc Metastore, and any
     * external Google Cloud Platform resources synced with the Data Catalog.
     *
     * To call this method, you must have the following Google IAM permissions:
     *
     * - `datacatalog.tagTemplates.setIamPolicy` to set policies on tag
     * templates.
     * - `datacatalog.entryGroups.setIamPolicy` to set policies on entry groups.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $dataCatalogClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('SetIamPolicy', Policy::class, $optionalArgs, $request)->wait();
    }

    /**
     * Marks an [Entry][google.cloud.datacatalog.v1.Entry] as starred by
     * the current user. Starring information is private to each user.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $response = $dataCatalogClient->starEntry($formattedName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the entry to mark as starred.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\StarEntryResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function starEntry($name, array $optionalArgs = [])
    {
        $request = new StarEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('StarEntry', StarEntryResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets your permissions on a resource.
     *
     * Returns an empty set of permissions if the resource doesn't exist.
     *
     * Supported resources are:
     *
     * - Tag templates
     * - Entry groups
     *
     * Note: This method gets policies only within Data Catalog and can't be
     * used to get policies from BigQuery, Pub/Sub, Dataproc Metastore, and any
     * external Google Cloud Platform resources ingested into Data Catalog.
     *
     * No Google IAM permissions are required to call this method.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $dataCatalogClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions($resource, $permissions, array $optionalArgs = [])
    {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('TestIamPermissions', TestIamPermissionsResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Marks an [Entry][google.cloud.datacatalog.v1.Entry] as NOT starred by
     * the current user. Starring information is private to each user.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->entryName('[PROJECT]', '[LOCATION]', '[ENTRY_GROUP]', '[ENTRY]');
     *     $response = $dataCatalogClient->unstarEntry($formattedName);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the entry to mark as **not** starred.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\UnstarEntryResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function unstarEntry($name, array $optionalArgs = [])
    {
        $request = new UnstarEntryRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UnstarEntry', UnstarEntryResponse::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an existing entry.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `entry.name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $entry = new Entry();
     *     $response = $dataCatalogClient->updateEntry($entry);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param Entry $entry        Required. Updates for the entry. The `name` field must be set.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Names of fields whose values to overwrite on an entry.
     *
     *           If this parameter is absent or empty, all modifiable fields
     *           are overwritten. If such fields are non-required and omitted in the
     *           request body, their values are emptied.
     *
     *           You can modify only the fields listed below.
     *
     *           For entries with type `DATA_STREAM`:
     *
     *           * `schema`
     *
     *           For entries with type `FILESET`:
     *
     *           * `schema`
     *           * `display_name`
     *           * `description`
     *           * `gcs_fileset_spec`
     *           * `gcs_fileset_spec.file_patterns`
     *
     *           For entries with `user_specified_type`:
     *
     *           * `schema`
     *           * `display_name`
     *           * `description`
     *           * `user_specified_type`
     *           * `user_specified_system`
     *           * `linked_resource`
     *           * `source_system_timestamps`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\Entry
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEntry($entry, array $optionalArgs = [])
    {
        $request = new UpdateEntryRequest();
        $requestParamHeaders = [];
        $request->setEntry($entry);
        $requestParamHeaders['entry.name'] = $entry->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateEntry', Entry::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an entry group.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `entry_group.name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $entryGroup = new EntryGroup();
     *     $response = $dataCatalogClient->updateEntryGroup($entryGroup);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param EntryGroup $entryGroup   Required. Updates for the entry group. The `name` field must be set.
     * @param array      $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Names of fields whose values to overwrite on an entry group.
     *
     *           If this parameter is absent or empty, all modifiable fields
     *           are overwritten. If such fields are non-required and omitted in the
     *           request body, their values are emptied.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\EntryGroup
     *
     * @throws ApiException if the remote call fails
     */
    public function updateEntryGroup($entryGroup, array $optionalArgs = [])
    {
        $request = new UpdateEntryGroupRequest();
        $requestParamHeaders = [];
        $request->setEntryGroup($entryGroup);
        $requestParamHeaders['entry_group.name'] = $entryGroup->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateEntryGroup', EntryGroup::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates an existing tag.
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $tag = new Tag();
     *     $response = $dataCatalogClient->updateTag($tag);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param Tag   $tag          Required. The updated tag. The "name" field must be set.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Names of fields whose values to overwrite on a tag. Currently, a tag has
     *           the only modifiable field with the name `fields`.
     *
     *           In general, if this parameter is absent or empty, all modifiable fields
     *           are overwritten. If such fields are non-required and omitted in the
     *           request body, their values are emptied.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\Tag
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTag($tag, array $optionalArgs = [])
    {
        $request = new UpdateTagRequest();
        $requestParamHeaders = [];
        $request->setTag($tag);
        $requestParamHeaders['tag.name'] = $tag->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateTag', Tag::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a tag template.
     *
     * You can't update template fields with this method. These fields are
     * separate resources with their own create, update, and delete methods.
     *
     * You must enable the Data Catalog API in the project identified by
     * the `tag_template.name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $tagTemplate = new TagTemplate();
     *     $response = $dataCatalogClient->updateTagTemplate($tagTemplate);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param TagTemplate $tagTemplate  Required. The template to update. The `name` field must be set.
     * @param array       $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Names of fields whose values to overwrite on a tag template. Currently,
     *           only `display_name` and `is_publicly_readable` can be overwritten.
     *
     *           If this parameter is absent or empty, all modifiable fields
     *           are overwritten. If such fields are non-required and omitted in the
     *           request body, their values are emptied.
     *
     *           Note: Updating the `is_publicly_readable` field may require up to 12
     *           hours to take effect in search results.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\TagTemplate
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTagTemplate($tagTemplate, array $optionalArgs = [])
    {
        $request = new UpdateTagTemplateRequest();
        $requestParamHeaders = [];
        $request->setTagTemplate($tagTemplate);
        $requestParamHeaders['tag_template.name'] = $tagTemplate->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateTagTemplate', TagTemplate::class, $optionalArgs, $request)->wait();
    }

    /**
     * Updates a field in a tag template.
     *
     * You can't update the field type with this method.
     *
     * You must enable the Data Catalog API in the project
     * identified by the `name` parameter. For more information, see [Data Catalog
     * resource
     * project](https://cloud.google.com/data-catalog/docs/concepts/resource-project).
     *
     * Sample code:
     * ```
     * $dataCatalogClient = new DataCatalogClient();
     * try {
     *     $formattedName = $dataCatalogClient->tagTemplateFieldName('[PROJECT]', '[LOCATION]', '[TAG_TEMPLATE]', '[FIELD]');
     *     $tagTemplateField = new TagTemplateField();
     *     $response = $dataCatalogClient->updateTagTemplateField($formattedName, $tagTemplateField);
     * } finally {
     *     $dataCatalogClient->close();
     * }
     * ```
     *
     * @param string           $name             Required. The name of the tag template field.
     * @param TagTemplateField $tagTemplateField Required. The template to update.
     * @param array            $optionalArgs     {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. Names of fields whose values to overwrite on an individual field of a tag
     *           template. The following fields are modifiable:
     *
     *           * `display_name`
     *           * `type.enum_type`
     *           * `is_required`
     *
     *           If this parameter is absent or empty, all modifiable fields
     *           are overwritten. If such fields are non-required and omitted in the request
     *           body, their values are emptied with one exception: when updating an enum
     *           type, the provided values are merged with the existing values. Therefore,
     *           enum values can only be added, existing enum values cannot be deleted or
     *           renamed.
     *
     *           Additionally, updating a template field from optional to required is
     *           *not* allowed.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\DataCatalog\V1\TagTemplateField
     *
     * @throws ApiException if the remote call fails
     */
    public function updateTagTemplateField($name, $tagTemplateField, array $optionalArgs = [])
    {
        $request = new UpdateTagTemplateFieldRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setTagTemplateField($tagTemplateField);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('UpdateTagTemplateField', TagTemplateField::class, $optionalArgs, $request)->wait();
    }
}
