<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/featurestore_online_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;

use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\FeatureSelector;
use Google\Cloud\AIPlatform\V1\ReadFeatureValuesRequest;
use Google\Cloud\AIPlatform\V1\ReadFeatureValuesResponse;
use Google\Cloud\AIPlatform\V1\StreamingReadFeatureValuesRequest;

/**
 * Service Description: A service for serving online feature values.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $featurestoreOnlineServingServiceClient = new FeaturestoreOnlineServingServiceClient();
 * try {
 *     $formattedEntityType = $featurestoreOnlineServingServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
 *     $entityId = 'entity_id';
 *     $featureSelector = new FeatureSelector();
 *     $response = $featurestoreOnlineServingServiceClient->readFeatureValues($formattedEntityType, $entityId, $featureSelector);
 * } finally {
 *     $featurestoreOnlineServingServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class FeaturestoreOnlineServingServiceGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.aiplatform.v1.FeaturestoreOnlineServingService';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $entityTypeNameTemplate;

    private static $pathTemplateMap;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ .
                '/../resources/featurestore_online_serving_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ .
                '/../resources/featurestore_online_serving_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ .
                '/../resources/featurestore_online_serving_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/featurestore_online_serving_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getEntityTypeNameTemplate()
    {
        if (self::$entityTypeNameTemplate == null) {
            self::$entityTypeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}'
            );
        }

        return self::$entityTypeNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'entityType' => self::getEntityTypeNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entity_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     *
     * @return string The formatted entity_type resource.
     */
    public static function entityTypeName(
        $project,
        $location,
        $featurestore,
        $entityType
    ) {
        return self::getEntityTypeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - entityType: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Reads Feature values of a specific entity of an EntityType. For reading
     * feature values of multiple entities of an EntityType, please use
     * StreamingReadFeatureValues.
     *
     * Sample code:
     * ```
     * $featurestoreOnlineServingServiceClient = new FeaturestoreOnlineServingServiceClient();
     * try {
     *     $formattedEntityType = $featurestoreOnlineServingServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $entityId = 'entity_id';
     *     $featureSelector = new FeatureSelector();
     *     $response = $featurestoreOnlineServingServiceClient->readFeatureValues($formattedEntityType, $entityId, $featureSelector);
     * } finally {
     *     $featurestoreOnlineServingServiceClient->close();
     * }
     * ```
     *
     * @param string          $entityType      Required. The resource name of the EntityType for the entity being read.
     *                                         Value format:
     *                                         `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
     *                                         For example, for a machine learning model predicting user clicks on a
     *                                         website, an EntityType ID could be `user`.
     * @param string          $entityId        Required. ID for a specific entity. For example,
     *                                         for a machine learning model predicting user clicks on a website, an entity
     *                                         ID could be `user_123`.
     * @param FeatureSelector $featureSelector Required. Selector choosing Features of the target EntityType.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\AIPlatform\V1\ReadFeatureValuesResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function readFeatureValues(
        $entityType,
        $entityId,
        $featureSelector,
        array $optionalArgs = []
    ) {
        $request = new ReadFeatureValuesRequest();
        $requestParamHeaders = [];
        $request->setEntityType($entityType);
        $request->setEntityId($entityId);
        $request->setFeatureSelector($featureSelector);
        $requestParamHeaders['entity_type'] = $entityType;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'ReadFeatureValues',
            ReadFeatureValuesResponse::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Reads Feature values for multiple entities. Depending on their size, data
     * for different entities may be broken
     * up across multiple responses.
     *
     * Sample code:
     * ```
     * $featurestoreOnlineServingServiceClient = new FeaturestoreOnlineServingServiceClient();
     * try {
     *     $formattedEntityType = $featurestoreOnlineServingServiceClient->entityTypeName('[PROJECT]', '[LOCATION]', '[FEATURESTORE]', '[ENTITY_TYPE]');
     *     $entityIds = [];
     *     $featureSelector = new FeatureSelector();
     *     // Read all responses until the stream is complete
     *     $stream = $featurestoreOnlineServingServiceClient->streamingReadFeatureValues($formattedEntityType, $entityIds, $featureSelector);
     *     foreach ($stream->readAll() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $featurestoreOnlineServingServiceClient->close();
     * }
     * ```
     *
     * @param string          $entityType      Required. The resource name of the entities' type.
     *                                         Value format:
     *                                         `projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entityType}`.
     *                                         For example,
     *                                         for a machine learning model predicting user clicks on a website, an
     *                                         EntityType ID could be `user`.
     * @param string[]        $entityIds       Required. IDs of entities to read Feature values of. The maximum number of IDs is
     *                                         100. For example, for a machine learning model predicting user clicks on a
     *                                         website, an entity ID could be `user_123`.
     * @param FeatureSelector $featureSelector Required. Selector choosing Features of the target EntityType. Feature IDs will be
     *                                         deduplicated.
     * @param array           $optionalArgs    {
     *     Optional.
     *
     *     @type int $timeoutMillis
     *           Timeout to use for this call.
     * }
     *
     * @return \Google\ApiCore\ServerStream
     *
     * @throws ApiException if the remote call fails
     */
    public function streamingReadFeatureValues(
        $entityType,
        $entityIds,
        $featureSelector,
        array $optionalArgs = []
    ) {
        $request = new StreamingReadFeatureValuesRequest();
        $requestParamHeaders = [];
        $request->setEntityType($entityType);
        $request->setEntityIds($entityIds);
        $request->setFeatureSelector($featureSelector);
        $requestParamHeaders['entity_type'] = $entityType;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'StreamingReadFeatureValues',
            ReadFeatureValuesResponse::class,
            $optionalArgs,
            $request,
            Call::SERVER_STREAMING_CALL
        );
    }
}
